/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.history.FileNamesData;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import com.intellij.vcs.log.util.TroveUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexDataGetter {
    private static final Logger LOG = Logger.getInstance(IndexDataGetter.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @NotNull
    private final VcsLogPersistentIndex.IndexStorage myIndexStorage;
    @NotNull
    private final VcsLogStorage myLogStorage;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;

    public IndexDataGetter(@NotNull Project project, @NotNull Set<VirtualFile> roots, @NotNull VcsLogPersistentIndex.IndexStorage indexStorage, @NotNull VcsLogStorage logStorage, @NotNull FatalErrorHandler fatalErrorsConsumer) {
        if (project == null) {
            IndexDataGetter.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            IndexDataGetter.$$$reportNull$$$0(1);
        }
        if (indexStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(2);
        }
        if (logStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(3);
        }
        if (fatalErrorsConsumer == null) {
            IndexDataGetter.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myRoots = roots;
        this.myIndexStorage = indexStorage;
        this.myLogStorage = logStorage;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
    }

    @Nullable
    public String getFullMessage(int index) {
        return (String)this.executeAndCatch(() -> (String)this.myIndexStorage.messages.get((Object)index));
    }

    @NotNull
    public Set<FilePath> getFileNames(@NotNull FilePath path, int commit) {
        Set result2;
        VirtualFile root;
        if (path == null) {
            IndexDataGetter.$$$reportNull$$$0(5);
        }
        if (this.myRoots.contains(root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path)) && (result2 = (Set)this.executeAndCatch(() -> {
            if (path == null) {
                IndexDataGetter.$$$reportNull$$$0(32);
            }
            return this.myIndexStorage.paths.getFileNames(path, commit);
        })) != null) {
            Set set2 = result2;
            if (set2 == null) {
                IndexDataGetter.$$$reportNull$$$0(6);
            }
            return set2;
        }
        Set<FilePath> set3 = Collections.emptySet();
        if (set3 == null) {
            IndexDataGetter.$$$reportNull$$$0(7);
        }
        return set3;
    }

    @NotNull
    public FileNamesData buildFileNamesData(@NotNull FilePath path) {
        if (path == null) {
            IndexDataGetter.$$$reportNull$$$0(8);
        }
        MyFileNamesData result2 = new MyFileNamesData();
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        if (this.myRoots.contains(root)) {
            this.executeAndCatch(() -> {
                if (path == null) {
                    IndexDataGetter.$$$reportNull$$$0(31);
                }
                this.myIndexStorage.paths.iterateCommits(path, (changes, commit) -> this.executeAndCatch(() -> {
                    List parents = (List)this.myIndexStorage.parents.get((Object)commit);
                    if (parents == null) {
                        throw new CorruptedDataException("No parents for commit " + commit);
                    }
                    result2.add(commit, (FilePath)changes.first, (List)changes.second, parents);
                    return null;
                }));
                return null;
            });
        }
        MyFileNamesData myFileNamesData = result2;
        if (myFileNamesData == null) {
            IndexDataGetter.$$$reportNull$$$0(9);
        }
        return myFileNamesData;
    }

    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<T, IOException, StorageException> computable) {
        if (computable == null) {
            IndexDataGetter.$$$reportNull$$$0(10);
        }
        try {
            return (T)computable.compute();
        }
        catch (StorageException | CorruptedDataException | IOException e) {
            this.myIndexStorage.markCorrupted();
            this.myFatalErrorsConsumer.consume(this, e);
        }
        catch (RuntimeException e) {
            this.processRuntimeException(e);
        }
        return null;
    }

    @Nullable
    public List<Hash> getParents(int index) {
        try {
            List parentsIndexes = (List)this.myIndexStorage.parents.get((Object)index);
            if (parentsIndexes == null) {
                return null;
            }
            ArrayList result2 = ContainerUtil.newArrayList();
            Iterator iterator = parentsIndexes.iterator();
            while (iterator.hasNext()) {
                int parentIndex = (Integer)iterator.next();
                CommitId id = this.myLogStorage.getCommitId(parentIndex);
                if (id == null) {
                    return null;
                }
                result2.add(id.getHash());
            }
            return result2;
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return null;
        }
    }

    @NotNull
    private TIntHashSet filterUsers(@NotNull Set<VcsUser> users) {
        TIntHashSet tIntHashSet;
        if (users == null) {
            IndexDataGetter.$$$reportNull$$$0(11);
        }
        try {
            tIntHashSet = this.myIndexStorage.users.getCommitsForUsers(users);
        }
        catch (StorageException | IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
        catch (RuntimeException e) {
            this.processRuntimeException(e);
        }
        if (tIntHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(12);
        }
        return tIntHashSet;
        TIntHashSet tIntHashSet2 = new TIntHashSet();
        if (tIntHashSet2 == null) {
            IndexDataGetter.$$$reportNull$$$0(13);
        }
        return tIntHashSet2;
    }

    @NotNull
    private TIntHashSet filterPaths(@NotNull Collection<FilePath> paths) {
        TIntHashSet tIntHashSet;
        if (paths == null) {
            IndexDataGetter.$$$reportNull$$$0(14);
        }
        try {
            tIntHashSet = this.myIndexStorage.paths.getCommitsForPaths(paths);
        }
        catch (StorageException | IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
        catch (RuntimeException e) {
            this.processRuntimeException(e);
        }
        if (tIntHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(15);
        }
        return tIntHashSet;
        TIntHashSet tIntHashSet2 = new TIntHashSet();
        if (tIntHashSet2 == null) {
            IndexDataGetter.$$$reportNull$$$0(16);
        }
        return tIntHashSet2;
    }

    @NotNull
    private TIntHashSet filterMessages(@NotNull VcsLogTextFilter filter) {
        block6: {
            TIntHashSet tIntHashSet;
            if (filter == null) {
                IndexDataGetter.$$$reportNull$$$0(17);
            }
            try {
                TIntHashSet commitsForSearch;
                if (filter.isRegex() || (commitsForSearch = this.myIndexStorage.trigrams.getCommitsForSubstring(filter.getText())) == null) break block6;
                TIntHashSet result2 = new TIntHashSet();
                commitsForSearch.forEach(commit -> {
                    if (filter == null) {
                        IndexDataGetter.$$$reportNull$$$0(30);
                    }
                    try {
                        String value = (String)this.myIndexStorage.messages.get((Object)commit);
                        if (value != null && VcsLogTextFilterImpl.matches(filter, value)) {
                            result2.add(commit);
                        }
                    }
                    catch (IOException e) {
                        this.myFatalErrorsConsumer.consume(this, e);
                        return false;
                    }
                    return true;
                });
                tIntHashSet = result2;
            }
            catch (StorageException e) {
                this.myFatalErrorsConsumer.consume(this, e);
            }
            catch (RuntimeException e) {
                this.processRuntimeException(e);
            }
            if (tIntHashSet == null) {
                IndexDataGetter.$$$reportNull$$$0(18);
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = this.filter(this.myIndexStorage.messages, message -> {
            if (filter == null) {
                IndexDataGetter.$$$reportNull$$$0(29);
            }
            return VcsLogTextFilterImpl.matches(filter, message);
        });
        if (tIntHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(19);
        }
        return tIntHashSet;
    }

    @NotNull
    private <T> TIntHashSet filter(@NotNull PersistentMap<Integer, T> map2, @NotNull Condition<T> condition) {
        if (map2 == null) {
            IndexDataGetter.$$$reportNull$$$0(20);
        }
        if (condition == null) {
            IndexDataGetter.$$$reportNull$$$0(21);
        }
        TIntHashSet result2 = new TIntHashSet();
        try {
            Processor processor2 = integer -> {
                if (map2 == null) {
                    IndexDataGetter.$$$reportNull$$$0(27);
                }
                if (condition == null) {
                    IndexDataGetter.$$$reportNull$$$0(28);
                }
                try {
                    Object value = map2.get(integer);
                    if (value != null && condition.value(value)) {
                        result2.add(integer.intValue());
                    }
                }
                catch (IOException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                    return false;
                }
                return true;
            };
            if (this.myIndexStorage.messages instanceof PersistentHashMap) {
                ((PersistentHashMap)this.myIndexStorage.messages).processKeysWithExistingMapping(processor2);
            } else {
                this.myIndexStorage.messages.processKeys(processor2);
            }
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(22);
        }
        return tIntHashSet;
    }

    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters == null) {
            IndexDataGetter.$$$reportNull$$$0(23);
        }
        if (filters.isEmpty()) {
            return false;
        }
        for (VcsLogDetailsFilter filter : filters) {
            if (filter instanceof VcsLogTextFilter || filter instanceof VcsLogUserFilter || filter instanceof VcsLogStructureFilter) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Set<Integer> filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        if (detailsFilters == null) {
            IndexDataGetter.$$$reportNull$$$0(24);
        }
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilter.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        TIntHashSet filteredByMessage = null;
        if (textFilter != null) {
            filteredByMessage = this.filterMessages(textFilter);
        }
        TIntHashSet filteredByUser = null;
        if (userFilter != null) {
            HashSet users = ContainerUtil.newHashSet();
            for (VirtualFile root : this.myRoots) {
                users.addAll(userFilter.getUsers(root));
            }
            filteredByUser = this.filterUsers(users);
        }
        TIntHashSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        Set<Integer> set2 = TroveUtil.intersect(filteredByMessage, filteredByPath, filteredByUser);
        if (set2 == null) {
            IndexDataGetter.$$$reportNull$$$0(25);
        }
        return set2;
    }

    @Nullable
    public VcsUser getAuthor(int commit) {
        return (VcsUser)this.executeAndCatch(() -> this.myIndexStorage.users.getAuthorForCommit(commit));
    }

    @Nullable
    public VcsUser getCommitter(int commit) {
        return (VcsUser)this.executeAndCatch(() -> {
            Integer committer = (Integer)this.myIndexStorage.committers.get((Object)commit);
            if (committer != null) {
                return this.myIndexStorage.users.getUserById(committer);
            }
            if (this.myIndexStorage.commits.contains(commit)) {
                return this.myIndexStorage.users.getAuthorForCommit(commit);
            }
            return null;
        });
    }

    @Nullable
    public Long getAuthorTime(int commit) {
        return (Long)this.executeAndCatch(() -> {
            Pair time = (Pair)this.myIndexStorage.timestamps.get((Object)commit);
            if (time == null) {
                return null;
            }
            return (Long)time.first;
        });
    }

    @Nullable
    public Long getCommitTime(int commit) {
        return (Long)this.executeAndCatch(() -> {
            Pair time = (Pair)this.myIndexStorage.timestamps.get((Object)commit);
            if (time == null) {
                return null;
            }
            return (Long)time.second;
        });
    }

    private void processRuntimeException(@NotNull RuntimeException e) {
        if (e == null) {
            IndexDataGetter.$$$reportNull$$$0(26);
        }
        if (e instanceof ProcessCanceledException) {
            throw e;
        }
        this.myIndexStorage.markCorrupted();
        if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof StorageException)) {
            throw new RuntimeException(e);
        }
        this.myFatalErrorsConsumer.consume(this, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logStorage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorsConsumer";
                break;
            }
            case 5: 
            case 8: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "users";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 17: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsFilters";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFileNamesData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUsers";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPaths";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMessages";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileNames";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 25: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildFileNamesData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeAndCatch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterUsers";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "filterPaths";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterMessages";
                break;
            }
            case 20: 
            case 21: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canFilter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processRuntimeException";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filter$7";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterMessages$6";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterMessages$5";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildFileNamesData$4";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFileNames$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CorruptedDataException
    extends RuntimeException {
        public CorruptedDataException(@NotNull String message) {
            if (message == null) {
                CorruptedDataException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/data/index/IndexDataGetter$CorruptedDataException", "<init>"));
        }
    }

    private class MyFileNamesData
    extends FileNamesData {
        private MyFileNamesData() {
        }

        @Override
        protected FilePath getPathById(int pathId) {
            return VcsUtil.getFilePath((String)((IndexDataGetter)IndexDataGetter.this).myIndexStorage.paths.getPath(pathId));
        }
    }
}

