/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.util.graph.Graph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ShortestPathFinder<Node> {
    private final Graph<Node> myGraph;

    public ShortestPathFinder(Graph<Node> graph) {
        this.myGraph = graph;
    }

    @Nullable
    public List<Node> findPath(Node start, Node finish) {
        HashMap nextNodes = new HashMap();
        ArrayDeque<Object> queue2 = new ArrayDeque<Object>();
        queue2.addLast(finish);
        boolean found = false;
        while (!queue2.isEmpty()) {
            Object node = queue2.removeFirst();
            if (node.equals(start)) {
                found = true;
                break;
            }
            Iterator in = this.myGraph.getIn(node);
            while (in.hasNext()) {
                Object prev2 = in.next();
                if (nextNodes.containsKey(prev2)) continue;
                nextNodes.put(prev2, node);
                queue2.addLast(prev2);
            }
        }
        if (!found) {
            return null;
        }
        ArrayList<Node> path = new ArrayList<Node>();
        Object current = start;
        while (!current.equals(finish)) {
            path.add(current);
            current = nextNodes.get(current);
        }
        path.add(finish);
        return path;
    }
}

