/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.state;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.spellchecker.state.DictionaryState;
import com.intellij.spellchecker.state.DictionaryStateListener;
import com.intellij.spellchecker.state.ProjectDictionarySplitter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectDictionaryState", storages={@Storage(value="dictionaries", stateSplitter=ProjectDictionarySplitter.class)})
public class ProjectDictionaryState
implements PersistentStateComponent<ProjectDictionaryState> {
    @Property(surroundWithTag=false)
    @XCollection(elementTypes={DictionaryState.class})
    public List<DictionaryState> dictionaryStates = new ArrayList<DictionaryState>();
    private ProjectDictionary projectDictionary;
    private final EventDispatcher<DictionaryStateListener> myDictListenerEventDispatcher = EventDispatcher.create(DictionaryStateListener.class);

    @Transient
    public void setProjectDictionary(ProjectDictionary projectDictionary) {
        this.dictionaryStates.clear();
        Set<EditableDictionary> projectDictionaries = projectDictionary.getDictionaries();
        if (projectDictionaries != null) {
            for (EditableDictionary dic : projectDictionary.getDictionaries()) {
                this.dictionaryStates.add(new DictionaryState(dic));
            }
        }
    }

    @Transient
    public ProjectDictionary getProjectDictionary() {
        if (this.projectDictionary == null) {
            this.projectDictionary = new ProjectDictionary();
        }
        return this.projectDictionary;
    }

    public ProjectDictionaryState getState() {
        if (this.projectDictionary != null) {
            this.setProjectDictionary(this.projectDictionary);
        }
        return this;
    }

    public void loadState(@NotNull ProjectDictionaryState state2) {
        if (state2 == null) {
            ProjectDictionaryState.$$$reportNull$$$0(0);
        }
        if (state2 != null) {
            this.dictionaryStates = state2.dictionaryStates;
        }
        this.retrieveProjectDictionaries();
    }

    private void retrieveProjectDictionaries() {
        THashSet dictionaries = new THashSet();
        if (this.dictionaryStates != null) {
            for (DictionaryState dictionaryState : this.dictionaryStates) {
                dictionaryState.loadState(dictionaryState);
                dictionaries.add(dictionaryState.getDictionary());
            }
        }
        this.projectDictionary = new ProjectDictionary((Set<EditableDictionary>)dictionaries);
        ((DictionaryStateListener)this.myDictListenerEventDispatcher.getMulticaster()).dictChanged(this.projectDictionary);
    }

    public String toString() {
        return "ProjectDictionaryState{projectDictionary=" + this.projectDictionary + '}';
    }

    public void addProjectDictListener(DictionaryStateListener listener2) {
        this.myDictListenerEventDispatcher.addListener((EventListener)listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/spellchecker/state/ProjectDictionaryState", "loadState"));
    }
}

