/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.util.Getter;
import com.intellij.util.DocumentUtil;
import com.intellij.util.EventDispatcher;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlayModelImpl
implements InlayModel,
Disposable {
    private static final Logger LOG = Logger.getInstance(InlayModelImpl.class);
    private static final Comparator<Inlay> INLAY_COMPARATOR = Comparator.comparingInt(Inlay::getOffset).thenComparing(i -> i.isRelatedToPrecedingText()).thenComparingInt(i -> ((InlayImpl)i).myOriginalOffset);
    private final EditorImpl myEditor;
    private final EventDispatcher<InlayModel.Listener> myDispatcher;
    final List<InlayImpl> myInlaysInvalidatedOnMove;
    final RangeMarkerTree<InlayImpl> myInlayTree;
    boolean myMoveInProgress;
    private List<Inlay> myInlaysAtCaret;

    InlayModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            InlayModelImpl.$$$reportNull$$$0(0);
        }
        this.myDispatcher = EventDispatcher.create(InlayModel.Listener.class);
        this.myInlaysInvalidatedOnMove = new ArrayList<InlayImpl>();
        this.myEditor = editor;
        this.myInlayTree = new RangeMarkerTree<InlayImpl>((Document)editor.getDocument()){

            @Override
            @NotNull
            protected RangeMarkerTree.RMNode<InlayImpl> createNewNode(@NotNull InlayImpl key, int start, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                RangeMarkerTree.RMNode<InlayImpl> rMNode = new RangeMarkerTree.RMNode<InlayImpl>((RangeMarkerTree)this, key, start, end, greedyToLeft, greedyToRight, stickingToRight){

                    @Override
                    protected Getter<InlayImpl> createGetter(@NotNull InlayImpl interval) {
                        if (interval == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return interval;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interval", "com/intellij/openapi/editor/impl/InlayModelImpl$1$1", "createGetter"));
                    }
                };
                if (rMNode == null) {
                    1.$$$reportNull$$$0(1);
                }
                return rMNode;
            }

            @Override
            void fireBeforeRemoved(@NotNull InlayImpl markerEx, @NotNull @NonNls Object reason) {
                if (markerEx == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (reason == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (markerEx.myOffsetBeforeDisposal == -1) {
                    if (InlayModelImpl.this.myMoveInProgress) {
                        InlayModelImpl.this.myInlaysInvalidatedOnMove.add(markerEx);
                    } else {
                        InlayModelImpl.this.notifyRemoved(markerEx);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/editor/impl/InlayModelImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "markerEx";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reason";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createNewNode";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createNewNode";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "fireBeforeRemoved";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myEditor.getDocument().addDocumentListener(new PrioritizedInternalDocumentListener(){

            @Override
            public int getPriority() {
                return 150;
            }

            public void beforeDocumentChange(DocumentEvent event) {
                List<Inlay> inlays;
                int inlayCount;
                if (InlayModelImpl.this.myEditor.getDocument().isInBulkUpdate()) {
                    return;
                }
                int offset = event.getOffset();
                if (event.getOldLength() == 0 && offset == InlayModelImpl.this.myEditor.getCaretModel().getOffset() && (inlayCount = (inlays = InlayModelImpl.this.getInlineElementsInRange(offset, offset)).size()) > 0) {
                    VisualPosition inlaysStartPosition = InlayModelImpl.this.myEditor.offsetToVisualPosition(offset, false, false);
                    VisualPosition caretPosition = InlayModelImpl.this.myEditor.getCaretModel().getVisualPosition();
                    if (inlaysStartPosition.line == caretPosition.line && caretPosition.column >= inlaysStartPosition.column && caretPosition.column <= inlaysStartPosition.column + inlayCount) {
                        InlayModelImpl.this.myInlaysAtCaret = inlays;
                        for (int i = 0; i < inlayCount; ++i) {
                            ((InlayImpl)inlays.get(i)).setStickingToRight(i >= caretPosition.column - inlaysStartPosition.column);
                        }
                    }
                }
            }

            public void documentChanged(DocumentEvent event) {
                if (InlayModelImpl.this.myInlaysAtCaret != null) {
                    for (Inlay inlay : InlayModelImpl.this.myInlaysAtCaret) {
                        ((InlayImpl)inlay).setStickingToRight(inlay.isRelatedToPrecedingText());
                    }
                    InlayModelImpl.this.myInlaysAtCaret = null;
                }
            }

            @Override
            public void moveTextHappened(int start, int end, int base) {
                for (InlayImpl inlay : InlayModelImpl.this.myInlaysInvalidatedOnMove) {
                    InlayModelImpl.this.notifyRemoved(inlay);
                }
                InlayModelImpl.this.myInlaysInvalidatedOnMove.clear();
            }
        }, this);
    }

    void reinitSettings() {
        this.myInlayTree.processAll(inlay -> {
            inlay.updateSize();
            return true;
        });
    }

    public void dispose() {
        this.myInlayTree.dispose(this.myEditor.getDocument());
    }

    @Nullable
    public Inlay addInlineElement(int offset, boolean relatesToPrecedingText, @NotNull EditorCustomElementRenderer renderer) {
        if (renderer == null) {
            InlayModelImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocumentEx document = this.myEditor.getDocument();
        if (DocumentUtil.isInsideSurrogatePair(document, offset)) {
            return null;
        }
        offset = Math.max(0, Math.min(document.getTextLength(), offset));
        InlayImpl inlay = new InlayImpl(this.myEditor, offset, relatesToPrecedingText, renderer);
        this.notifyAdded(inlay);
        return inlay;
    }

    @NotNull
    public List<Inlay> getInlineElementsInRange(int startOffset, int endOffset) {
        ArrayList<Inlay> result2 = new ArrayList<Inlay>();
        this.myInlayTree.processOverlappingWith(startOffset, endOffset, inlay -> {
            result2.add((Inlay)inlay);
            return true;
        });
        Collections.sort(result2, INLAY_COMPARATOR);
        ArrayList<Inlay> arrayList = result2;
        if (arrayList == null) {
            InlayModelImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean hasInlineElementsInRange(int startOffset, int endOffset) {
        return !this.myInlayTree.processOverlappingWith(startOffset, endOffset, inlay -> false);
    }

    public boolean hasInlineElements() {
        return this.myInlayTree.size() > 0;
    }

    public boolean hasInlineElementAt(int offset) {
        return !this.myInlayTree.processOverlappingWith(offset, offset, inlay -> false);
    }

    public boolean hasInlineElementAt(@NotNull VisualPosition visualPosition) {
        int offset;
        int inlayCount;
        if (visualPosition == null) {
            InlayModelImpl.$$$reportNull$$$0(3);
        }
        if ((inlayCount = this.getInlineElementsInRange(offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition)), offset).size()) == 0) {
            return false;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        return visualPosition.line == inlayStartPosition.line && visualPosition.column >= inlayStartPosition.column && visualPosition.column < inlayStartPosition.column + inlayCount;
    }

    @Nullable
    public Inlay getInlineElementAt(@NotNull VisualPosition visualPosition) {
        int offset;
        List<Inlay> inlays;
        if (visualPosition == null) {
            InlayModelImpl.$$$reportNull$$$0(4);
        }
        if ((inlays = this.getInlineElementsInRange(offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition)), offset)).isEmpty()) {
            return null;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        if (visualPosition.line != inlayStartPosition.line) {
            return null;
        }
        int inlayIndex = visualPosition.column - inlayStartPosition.column;
        return inlayIndex >= 0 && inlayIndex < inlays.size() ? inlays.get(inlayIndex) : null;
    }

    @Nullable
    public Inlay getElementAt(@NotNull Point point) {
        if (point == null) {
            InlayModelImpl.$$$reportNull$$$0(5);
        }
        if (this.myInlayTree.size() == 0) {
            return null;
        }
        int offset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(point));
        List<Inlay> inlays = this.getInlineElementsInRange(offset, offset);
        if (inlays.isEmpty()) {
            return null;
        }
        VisualPosition startVisualPosition = this.myEditor.offsetToVisualPosition(offset);
        int x = this.myEditor.visualPositionToXY((VisualPosition)startVisualPosition).x;
        for (Inlay inlay : inlays) {
            int endX = x + inlay.getWidthInPixels();
            if (point.x >= x && point.x < endX) {
                return inlay;
            }
            x = endX;
        }
        return null;
    }

    public void addListener(@NotNull InlayModel.Listener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            InlayModelImpl.$$$reportNull$$$0(6);
        }
        if (disposable == null) {
            InlayModelImpl.$$$reportNull$$$0(7);
        }
        this.myDispatcher.addListener((EventListener)listener2, disposable);
    }

    private void notifyAdded(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onAdded((Inlay)inlay);
    }

    void notifyChanged(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onUpdated((Inlay)inlay);
    }

    void notifyRemoved(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onRemoved((Inlay)inlay);
    }

    public void validateState() {
        for (Inlay inlay : this.getInlineElementsInRange(0, this.myEditor.getDocument().getTextLength())) {
            LOG.assertTrue(!DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), inlay.getOffset()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/InlayModelImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualPosition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineElementsInRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addInlineElement";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasInlineElementAt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInlineElementAt";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementAt";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

