/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.text.ImmutableCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrozenDocument
implements DocumentEx {
    private final ImmutableCharSequence myText;
    @Nullable
    private volatile LineSet myLineSet;
    private final long myStamp;
    private volatile SoftReference<String> myTextString;

    /*
     * WARNING - void declaration
     */
    FrozenDocument(@NotNull ImmutableCharSequence text2, @Nullable LineSet lineSet, long stamp, @Nullable String string) {
        void textString;
        if (text2 == null) {
            FrozenDocument.$$$reportNull$$$0(0);
        }
        this.myText = text2;
        this.myLineSet = lineSet;
        this.myStamp = stamp;
        this.myTextString = textString == null ? null : new SoftReference((Object)textString);
    }

    @NotNull
    private LineSet getLineSet() {
        LineSet lineSet = this.myLineSet;
        if (lineSet == null) {
            this.myLineSet = lineSet = LineSet.createLineSet((CharSequence)this.myText);
        }
        LineSet lineSet2 = lineSet;
        if (lineSet2 == null) {
            FrozenDocument.$$$reportNull$$$0(1);
        }
        return lineSet2;
    }

    public FrozenDocument applyEvent(DocumentEvent event, int newStamp) {
        int offset = event.getOffset();
        int oldEnd = offset + event.getOldLength();
        ImmutableCharSequence newText = this.myText.delete(offset, oldEnd).insert(offset, event.getNewFragment());
        LineSet newLineSet = this.getLineSet().update((CharSequence)this.myText, offset, oldEnd, event.getNewFragment(), event.isWholeTextReplaced());
        return new FrozenDocument(newText, newLineSet, newStamp, null);
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.getLineSet().createIterator();
        if (lineIterator == null) {
            FrozenDocument.$$$reportNull$$$0(2);
        }
        return lineIterator;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            FrozenDocument.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearLineModificationFlags() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            FrozenDocument.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            FrozenDocument.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor2) {
        if (processor2 == null) {
            FrozenDocument.$$$reportNull$$$0(6);
        }
        return true;
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<? super RangeMarker> processor2) {
        if (processor2 == null) {
            FrozenDocument.$$$reportNull$$$0(7);
        }
        return true;
    }

    @NotNull
    public String getText() {
        String s = (String)SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference((Object)s);
        }
        String string = s;
        if (string == null) {
            FrozenDocument.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getText(@NotNull TextRange range2) {
        if (range2 == null) {
            FrozenDocument.$$$reportNull$$$0(9);
        }
        String string = this.myText.subSequence(range2.getStartOffset(), range2.getEndOffset()).toString();
        if (string == null) {
            FrozenDocument.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public CharSequence getCharsSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            FrozenDocument.$$$reportNull$$$0(11);
        }
        return immutableCharSequence;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            FrozenDocument.$$$reportNull$$$0(12);
        }
        return immutableCharSequence;
    }

    public int getLineCount() {
        return this.getLineSet().getLineCount();
    }

    public int getLineNumber(int offset) {
        return this.getLineSet().findLineIndex(offset);
    }

    public int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    public int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result2 = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result2 >= 0);
        return result2;
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            FrozenDocument.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException();
    }

    public void deleteString(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            FrozenDocument.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return false;
    }

    public long getModificationStamp() {
        return this.myStamp;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException();
    }

    public void setReadOnly(boolean isReadOnly) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            FrozenDocument.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    public RangeMarker getOffsetGuard(int offset) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public RangeMarker getRangeGuard(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public void startGuardedBlockChecking() {
        throw new UnsupportedOperationException();
    }

    public void stopGuardedBlockChecking() {
        throw new UnsupportedOperationException();
    }

    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            FrozenDocument.$$$reportNull$$$0(16);
        }
        throw new UnsupportedOperationException();
    }

    public int getLineSeparatorLength(int line) {
        return this.getLineSet().getSeparatorLength(line);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            FrozenDocument.$$$reportNull$$$0(17);
        }
        throw new UnsupportedOperationException();
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            FrozenDocument.$$$reportNull$$$0(18);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        if (listener2 == null) {
            FrozenDocument.$$$reportNull$$$0(19);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FrozenDocument";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FrozenDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineIterator";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsSequence";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeRangeMarker";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerRangeMarker";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkersOverlappingWith";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceString";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeGuardedBlock";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeEditReadOnlyListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

