/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.IndentSelectionAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;

public class UnindentSelectionAction
extends EditorAction {
    public UnindentSelectionAction() {
        super((EditorActionHandler)new Handler());
    }

    private static void unindentSelection(Editor editor, Project project) {
        int endIndex;
        Document document;
        int startIndex;
        int oldSelectionStart = editor.getSelectionModel().getSelectionStart();
        int oldSelectionEnd = editor.getSelectionModel().getSelectionEnd();
        if (!editor.getSelectionModel().hasSelection()) {
            oldSelectionEnd = oldSelectionStart = editor.getCaretModel().getOffset();
        }
        if ((startIndex = (document = editor.getDocument()).getLineNumber(oldSelectionStart)) == -1) {
            startIndex = document.getLineCount() - 1;
        }
        if ((endIndex = document.getLineNumber(oldSelectionEnd)) > 0 && document.getLineStartOffset(endIndex) == oldSelectionEnd && endIndex > startIndex) {
            --endIndex;
        }
        if (endIndex == -1) {
            endIndex = document.getLineCount() - 1;
        }
        if (startIndex < 0 || endIndex < 0) {
            return;
        }
        int blockIndent = CodeStyle.getIndentOptions((Project)project, (Document)document).INDENT_SIZE;
        IndentSelectionAction.doIndent(endIndex, startIndex, document, project, editor, -blockIndent);
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            UnindentSelectionAction.unindentSelection(editor, project);
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return !editor.isViewer() && !editor.isOneLineMode() && !((EditorEx)editor).isEmbeddedIntoDialogWrapper();
        }
    }
}

