/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.TreeTraversal;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReadOnlyASTNode
extends UserDataHolderBase
implements ASTNode {
    private final ReadOnlyASTNode myParent;
    private final int myIndex;

    public ReadOnlyASTNode(@Nullable ReadOnlyASTNode parent, int index) {
        this.myParent = parent;
        this.myIndex = index;
    }

    @NotNull
    public List<ASTNode> getChildList() {
        ImmutableList immutableList = ContainerUtil.immutableList((Object[])this.getChildArray());
        if (immutableList == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    protected abstract ASTNode[] getChildArray();

    public ReadOnlyASTNode getTreeParent() {
        return this.myParent;
    }

    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(1);
        }
        return (T)((PsiElement)ObjectUtils.tryCast((Object)this.getPsi(), clazz));
    }

    public ASTNode getFirstChildNode() {
        ASTNode[] kids = this.getChildArray();
        return kids.length > 0 ? kids[0] : null;
    }

    public ASTNode getLastChildNode() {
        ASTNode[] kids = this.getChildArray();
        return kids.length > 0 ? kids[kids.length - 1] : null;
    }

    public ASTNode getTreeNext() {
        ASTNode[] kids = this.getTreeParent().getChildArray();
        return kids.length > this.myIndex + 1 ? kids[this.myIndex + 1] : null;
    }

    public ASTNode getTreePrev() {
        return this.myIndex > 0 ? this.getTreeParent().getChildArray()[this.myIndex - 1] : null;
    }

    @NotNull
    public ASTNode[] getChildren(@Nullable TokenSet filter) {
        ASTNode[] kids = this.getChildArray();
        ASTNode[] aSTNodeArray = kids.length == 0 ? EMPTY_ARRAY : (ASTNode[])kids.clone();
        if (aSTNodeArray == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(2);
        }
        return aSTNodeArray;
    }

    @NotNull
    public String getText() {
        String string = this.getChars().toString();
        if (string == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean textContains(char c) {
        return StringUtil.indexOf((CharSequence)this.getChars(), (char)c) >= 0;
    }

    public int getStartOffset() {
        return this.getTextRange().getStartOffset();
    }

    public int getTextLength() {
        return this.getTextRange().getLength();
    }

    @NotNull
    public ReadOnlyASTNode clone() {
        ReadOnlyASTNode readOnlyASTNode = this;
        if (readOnlyASTNode == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(4);
        }
        return readOnlyASTNode;
    }

    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    public void addChild(@NotNull ASTNode child, @Nullable ASTNode anchorBefore) {
        if (child == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException();
    }

    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, @Nullable ASTNode anchorBefore) {
        if (leafType == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException();
    }

    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException();
    }

    public void removeRange(@NotNull ASTNode firstNodeToRemove, ASTNode firstNodeToKeep) {
        if (firstNodeToRemove == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException();
    }

    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(10);
        }
        if (newChild == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(11);
        }
        throw new UnsupportedOperationException();
    }

    public void replaceAllChildrenToChildrenOf(@NotNull ASTNode anotherParent) {
        if (anotherParent == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException();
    }

    public void addChildren(@NotNull ASTNode firstChild, ASTNode firstChildToNotAdd, ASTNode anchorBefore) {
        if (firstChild == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException();
    }

    public ASTNode copyElement() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public ASTNode findLeafElementAt(int offset) {
        if (!this.getTextRange().contains(offset)) {
            return null;
        }
        return (ASTNode)((SyntaxTraverser)SyntaxTraverser.astTraverser((ASTNode)this).expandAndFilter(n -> n.getTextRange().contains(offset))).traverse(TreeTraversal.LEAVES_DFS).first();
    }

    @Nullable
    public ASTNode findChildByType(@NotNull IElementType type) {
        if (type == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(14);
        }
        return this.findChildByType(type, null);
    }

    @Nullable
    public ASTNode findChildByType(@NotNull IElementType type, @Nullable ASTNode anchor2) {
        if (type == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(15);
        }
        boolean flag = anchor2 == null;
        for (ASTNode node : this.getChildren(null)) {
            if (!flag && node.equals(anchor2)) {
                flag = true;
            }
            if (!flag || node.getElementType() != type) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet) {
        if (typesSet == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(16);
        }
        return this.findChildByType(typesSet, null);
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, @Nullable ASTNode anchor2) {
        if (typesSet == null) {
            ReadOnlyASTNode.$$$reportNull$$$0(17);
        }
        boolean flag = anchor2 == null;
        for (ASTNode node : this.getChildren(null)) {
            if (!flag && node.equals(anchor2)) {
                flag = true;
            }
            if (!flag || !typesSet.contains(node.getElementType())) continue;
            return node;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ReadOnlyASTNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstNodeToRemove";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChild";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherParent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstChild";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildList";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ReadOnlyASTNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPsi";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLeaf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceChild";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceAllChildrenToChildrenOf";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findChildByType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

