/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNewProjectDialog
extends DialogWrapper {
    private Pair<JPanel, JBList<AnAction>> myPair;

    public AbstractNewProjectDialog() {
        super(ProjectManager.getInstance().getDefaultProject());
        this.init();
    }

    protected void init() {
        super.init();
        DialogWrapperPeer peer = this.getPeer();
        JRootPane pane = peer.getRootPane();
        if (pane != null) {
            JBDimension size = JBUI.size((int)777, (int)460);
            pane.setMinimumSize((Dimension)size);
            pane.setPreferredSize((Dimension)size);
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        DirectoryProjectGenerator[] generators = (DirectoryProjectGenerator[])Extensions.getExtensions(DirectoryProjectGenerator.EP_NAME);
        this.setTitle(generators.length == 0 ? "Create Project" : "New Project");
        DefaultActionGroup root = this.createRootStep();
        Disposer.register((Disposable)this.getDisposable(), () -> root.removeAll());
        Pair<JPanel, JBList<AnAction>> pair = FlatWelcomeFrame.createActionGroupPanel((ActionGroup)root, null, this.getDisposable());
        JPanel component = (JPanel)pair.first;
        DumbAwareAction.create(e -> this.close(1)).registerCustomShortcutSet(27, 0, (JComponent)component);
        this.myPair = pair;
        UiNotifyConnector.doWhenFirstShown((JComponent)((JComponent)this.myPair.second), () -> ScrollingUtil.ensureSelectionExists((JList)((JList)this.myPair.second)));
        FlatWelcomeFrame.installQuickSearch((JBList<AnAction>)((JBList)pair.second));
        return component;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return FlatWelcomeFrame.getPreferredFocusedComponent(this.myPair);
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            AbstractNewProjectDialog.$$$reportNull$$$0(0);
        }
        return dialogStyle;
    }

    protected abstract DefaultActionGroup createRootStep();

    protected String getHelpId() {
        return "create_new_project_dialog";
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{};
        if (actionArray == null) {
            AbstractNewProjectDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/projectWizard/AbstractNewProjectDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

