/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewPsiTreeChangeListener;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.ProblemListener;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTreeBuilder
extends BaseProjectTreeBuilder {
    public ProjectTreeBuilder(@NotNull Project project, @NotNull JTree tree, @NotNull DefaultTreeModel treeModel, @Nullable Comparator<NodeDescriptor> comparator2, @NotNull ProjectAbstractTreeStructureBase treeStructure) {
        if (project == null) {
            ProjectTreeBuilder.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            ProjectTreeBuilder.$$$reportNull$$$0(1);
        }
        if (treeModel == null) {
            ProjectTreeBuilder.$$$reportNull$$$0(2);
        }
        if (treeStructure == null) {
            ProjectTreeBuilder.$$$reportNull$$$0(3);
        }
        super(project, tree, treeModel, treeStructure, comparator2);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ProjectTreeBuilder.this.queueUpdate();
            }
        });
        connection.subscribe(BookmarksListener.TOPIC, (Object)new MyBookmarksListener());
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)this.createPsiTreeChangeListener(project), (Disposable)this);
        FileStatusManager.getInstance((Project)project).addFileStatusListener((FileStatusListener)new MyFileStatusListener(), (Disposable)this);
        CopyPasteUtil.addDefaultListener((Disposable)this, arg_0 -> ((ProjectTreeBuilder)this).addSubtreeToUpdateByElement(arg_0));
        connection.subscribe(ProblemListener.TOPIC, (Object)new MyProblemListener());
        this.setCanYieldUpdate(true);
        this.initRootNode();
    }

    protected ProjectViewPsiTreeChangeListener createPsiTreeChangeListener(Project project) {
        return new ProjectTreeBuilderPsiListener(project);
    }

    private PsiElement findPsi(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            ProjectTreeBuilder.$$$reportNull$$$0(4);
        }
        if (!vFile.isValid()) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        return vFile.isDirectory() ? psiManager.findDirectory(vFile) : psiManager.findFile(vFile);
    }

    private void updateNodesContaining(@NotNull Collection<VirtualFile> filesToRefresh, @NotNull DefaultMutableTreeNode rootNode) {
        if (filesToRefresh == null) {
            ProjectTreeBuilder.$$$reportNull$$$0(5);
        }
        if (rootNode == null) {
            ProjectTreeBuilder.$$$reportNull$$$0(6);
        }
        if (!(rootNode.getUserObject() instanceof ProjectViewNode)) {
            return;
        }
        ProjectViewNode node = (ProjectViewNode)rootNode.getUserObject();
        Collection containingFiles = null;
        for (VirtualFile virtualFile : filesToRefresh) {
            if (!virtualFile.isValid()) {
                this.addSubtreeToUpdate(rootNode);
                return;
            }
            if (!node.contains(virtualFile)) continue;
            if (containingFiles == null) {
                containingFiles = new SmartList();
            }
            containingFiles.add(virtualFile);
        }
        if (containingFiles != null) {
            this.updateNode(rootNode);
            Enumeration<TreeNode> children2 = rootNode.children();
            while (children2.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children2.nextElement();
                this.updateNodesContaining(containingFiles, child);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToRefresh";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectTreeBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findPsi";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNodesContaining";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyProblemListener
    implements ProblemListener {
        private final Alarm myUpdateProblemAlarm = new Alarm();
        private final Collection<VirtualFile> myFilesToRefresh = new THashSet();

        private MyProblemListener() {
        }

        public void problemsAppeared(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProblemListener.$$$reportNull$$$0(0);
            }
            this.queueUpdate(file2);
        }

        public void problemsDisappeared(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProblemListener.$$$reportNull$$$0(1);
            }
            this.queueUpdate(file2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queueUpdate(@NotNull VirtualFile fileToRefresh) {
            if (fileToRefresh == null) {
                MyProblemListener.$$$reportNull$$$0(2);
            }
            Collection<VirtualFile> collection = this.myFilesToRefresh;
            synchronized (collection) {
                if (this.myFilesToRefresh.add(fileToRefresh)) {
                    this.myUpdateProblemAlarm.cancelAllRequests();
                    this.myUpdateProblemAlarm.addRequest(() -> {
                        THashSet filesToRefresh;
                        if (!ProjectTreeBuilder.this.myProject.isOpen()) {
                            return;
                        }
                        Collection<VirtualFile> collection = this.myFilesToRefresh;
                        synchronized (collection) {
                            filesToRefresh = new THashSet(this.myFilesToRefresh);
                        }
                        DefaultMutableTreeNode rootNode = ProjectTreeBuilder.this.getRootNode();
                        if (rootNode != null) {
                            ProjectTreeBuilder.this.updateNodesContaining((Collection)filesToRefresh, rootNode);
                        }
                        Collection<VirtualFile> collection2 = this.myFilesToRefresh;
                        synchronized (collection2) {
                            this.myFilesToRefresh.removeAll((Collection<?>)filesToRefresh);
                        }
                    }, 200, ModalityState.NON_MODAL);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileToRefresh";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectTreeBuilder$MyProblemListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problemsAppeared";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problemsDisappeared";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "queueUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            ProjectTreeBuilder.this.queueUpdate(false);
        }

        public void fileStatusChanged(@NotNull VirtualFile vFile) {
            if (vFile == null) {
                MyFileStatusListener.$$$reportNull$$$0(0);
            }
            ProjectTreeBuilder.this.queueUpdate(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/projectView/impl/ProjectTreeBuilder$MyFileStatusListener", "fileStatusChanged"));
        }
    }

    private final class MyBookmarksListener
    implements BookmarksListener {
        private MyBookmarksListener() {
        }

        @Override
        public void bookmarkAdded(@NotNull Bookmark b) {
            if (b == null) {
                MyBookmarksListener.$$$reportNull$$$0(0);
            }
            this.updateForFile(b.getFile());
        }

        @Override
        public void bookmarkRemoved(@NotNull Bookmark b) {
            if (b == null) {
                MyBookmarksListener.$$$reportNull$$$0(1);
            }
            this.updateForFile(b.getFile());
        }

        @Override
        public void bookmarkChanged(@NotNull Bookmark b) {
            if (b == null) {
                MyBookmarksListener.$$$reportNull$$$0(2);
            }
            this.updateForFile(b.getFile());
        }

        private void updateForFile(@NotNull VirtualFile file2) {
            PsiElement element;
            if (file2 == null) {
                MyBookmarksListener.$$$reportNull$$$0(3);
            }
            if ((element = ProjectTreeBuilder.this.findPsi(file2)) != null) {
                ProjectTreeBuilder.this.queueUpdateFrom(element, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectTreeBuilder$MyBookmarksListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bookmarkAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bookmarkRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bookmarkChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateForFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class ProjectTreeBuilderPsiListener
    extends ProjectViewPsiTreeChangeListener {
        public ProjectTreeBuilderPsiListener(Project project) {
            super(project);
        }

        @Override
        protected DefaultMutableTreeNode getRootNode() {
            return ProjectTreeBuilder.this.getRootNode();
        }

        @Override
        protected AbstractTreeUpdater getUpdater() {
            return ProjectTreeBuilder.this.getUpdater();
        }

        @Override
        protected boolean isFlattenPackages() {
            AbstractTreeStructure structure = ProjectTreeBuilder.this.getTreeStructure();
            return structure instanceof AbstractProjectTreeStructure && ((AbstractProjectTreeStructure)structure).isFlattenPackages();
        }
    }
}

