/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ArrayUtil;

abstract class TabNavigationActionBase
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.TabNavigationActionBase");
    private final int myDir;

    TabNavigationActionBase(int dir) {
        LOG.assertTrue(dir == 1 || dir == -1);
        this.myDir = dir;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null || project.isDisposed()) {
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project);
        if (windowManager.isEditorComponentActive()) {
            this.doNavigate(dataContext, project);
            return;
        }
        ContentManager contentManager = (ContentManager)PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.getData(dataContext);
        if (contentManager == null) {
            return;
        }
        this.doNavigate(contentManager);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        presentation.setEnabled(false);
        if (project == null || project.isDisposed()) {
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project);
        if (windowManager.isEditorComponentActive()) {
            FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(project);
            EditorWindow currentWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
            if (currentWindow == null) {
                editorManager.getCurrentWindow();
            }
            if (currentWindow != null) {
                VirtualFile[] files2 = currentWindow.getFiles();
                presentation.setEnabled(files2.length > 1);
            }
            return;
        }
        ContentManager contentManager = (ContentManager)PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.getData(dataContext);
        presentation.setEnabled(contentManager != null && contentManager.getContentCount() > 1 && contentManager.isSingleSelection());
    }

    private void doNavigate(ContentManager contentManager) {
        if (this.myDir == -1) {
            contentManager.selectPreviousContent();
        } else {
            contentManager.selectNextContent();
        }
    }

    private void doNavigate(DataContext dataContext, Project project) {
        Object[] files2;
        int index;
        VirtualFile selectedFile;
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(project);
        EditorWindow currentWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
        if (currentWindow == null) {
            currentWindow = editorManager.getCurrentWindow();
        }
        if ((selectedFile = currentWindow.getSelectedFile()) == null) {
            selectedFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        }
        LOG.assertTrue((index = ArrayUtil.find((Object[])(files2 = currentWindow.getFiles()), (Object)selectedFile)) != -1);
        editorManager.openFile((VirtualFile)files2[(index + files2.length + this.myDir) % files2.length], true);
    }
}

