/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.FrameworkDetectionIndexListener;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FrameworkDetectionIndex
extends ScalarIndexExtension<Integer> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.detection.impl.FrameworkDetectionIndex");
    public static final ID<Integer, Void> NAME = ID.create((String)"FrameworkDetectionIndex");
    private final EventDispatcher<FrameworkDetectionIndexListener> myDispatcher = EventDispatcher.create(FrameworkDetectionIndexListener.class);

    public static FrameworkDetectionIndex getInstance() {
        return (FrameworkDetectionIndex)((Object)EXTENSION_POINT_NAME.findExtension(FrameworkDetectionIndex.class));
    }

    @NotNull
    public ID<Integer, Void> getName() {
        ID<Integer, Void> iD = NAME;
        if (iD == null) {
            FrameworkDetectionIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public void addListener(@NotNull FrameworkDetectionIndexListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            FrameworkDetectionIndex.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            FrameworkDetectionIndex.$$$reportNull$$$0(2);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @NotNull
    public DataIndexer<Integer, Void, FileContent> getIndexer() {
        final MultiMap detectors = new MultiMap();
        FrameworkDetectorRegistry registry = FrameworkDetectorRegistry.getInstance();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            detectors.putValue((Object)detector.getFileType(), (Object)Pair.create((Object)detector.createSuitableFilePattern(), (Object)registry.getDetectorId(detector)));
        }
        DataIndexer<Integer, Void, FileContent> dataIndexer = new DataIndexer<Integer, Void, FileContent>(){

            @NotNull
            public Map<Integer, Void> map(@NotNull FileContent inputData) {
                FileType fileType;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!detectors.containsKey((Object)(fileType = inputData.getFileType()))) {
                    Map<Integer, Void> map2 = Collections.emptyMap();
                    if (map2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map2;
                }
                Map<Integer, Void> result2 = null;
                for (Pair pair : detectors.get((Object)fileType)) {
                    if (!((ElementPattern)pair.getFirst()).accepts((Object)inputData)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(inputData.getFile() + " accepted by detector " + pair.getSecond());
                    }
                    if (result2 == null) {
                        result2 = new HashMap<Integer, Void>();
                    }
                    ((FrameworkDetectionIndexListener)FrameworkDetectionIndex.this.myDispatcher.getMulticaster()).fileUpdated(inputData.getFile(), (Integer)pair.getSecond());
                    result2.put((Integer)pair.getSecond(), null);
                }
                Map<Integer, Void> map3 = result2 != null ? result2 : Collections.emptyMap();
                if (map3 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return map3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/framework/detection/impl/FrameworkDetectionIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectionIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            FrameworkDetectionIndex.$$$reportNull$$$0(3);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            FrameworkDetectionIndex.$$$reportNull$$$0(4);
        }
        return enumeratorIntegerDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        HashSet<FileType> acceptedTypes = new HashSet<FileType>();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            acceptedTypes.add(detector.getFileType());
        }
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(acceptedTypes.toArray(FileType.EMPTY_ARRAY));
        if (defaultFileTypeSpecificInputFilter == null) {
            FrameworkDetectionIndex.$$$reportNull$$$0(5);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return FrameworkDetectorRegistry.getInstance().getDetectorsVersion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/FrameworkDetectionIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectionIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

