/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindUI;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.find.impl.RevealingSpaceComboboxEditor;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindDialog
extends DialogWrapper
implements FindUI {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.impl.FindDialog");
    private final FindUIHelper myHelper;
    private ComboBox myInputComboBox;
    private ComboBox myReplaceComboBox;
    private StateRestoringCheckBox myCbCaseSensitive;
    private StateRestoringCheckBox myCbPreserveCase;
    private StateRestoringCheckBox myCbWholeWordsOnly;
    private ComboBox mySearchContext;
    private StateRestoringCheckBox myCbRegularExpressions;
    private JRadioButton myRbGlobal;
    private JRadioButton myRbSelectedText;
    private JRadioButton myRbForward;
    private JRadioButton myRbBackward;
    private JRadioButton myRbFromCursor;
    private JRadioButton myRbEntireScope;
    private JRadioButton myRbProject;
    private JRadioButton myRbDirectory;
    private JRadioButton myRbModule;
    private ComboBox myModuleComboBox;
    private ComboBox myDirectoryComboBox;
    private StateRestoringCheckBox myCbWithSubdirectories;
    private JCheckBox myCbToOpenInNewTab;
    private FixedSizeButton mySelectDirectoryButton;
    private StateRestoringCheckBox myUseFileFilter;
    private ComboBox myFileFilter;
    private JCheckBox myCbToSkipResultsWhenOneUsage;
    private final Project myProject;
    private final Map<EditorTextField, DocumentListener> myComboBoxListeners = new HashMap<EditorTextField, DocumentListener>();
    private Action myFindAllAction;
    private JRadioButton myRbCustomScope;
    private ScopeChooserCombo myScopeCombo;
    protected JLabel myReplacePrompt;
    private HideableTitledPanel myScopePanel;
    private static boolean myPreviousResultsExpandedState = true;
    private static boolean myPreviewResultsTabWasSelected;
    private static final int RESULTS_PREVIEW_TAB_INDEX = 1;
    private Splitter myPreviewSplitter;
    private JBTable myResultsPreviewTable;
    private UsagePreviewPanel myUsagePreviewPanel;
    private TabbedPane myContent;
    private Alarm mySearchRescheduleOnCancellationsAlarm;
    private static final String PREVIEW_TITLE;
    private volatile ProgressIndicatorBase myResultsPreviewSearchProgress;

    public FindDialog(FindUIHelper helper) {
        super(helper.getProject(), true);
        this.myHelper = helper;
        this.myProject = this.myHelper.getProject();
        this.setTitle(this.myHelper.getTitle());
        this.setOKButtonText(FindBundle.message("find.button", new Object[0]));
        this.init();
    }

    @Override
    public void showUI() {
        if (this.haveResultsPreview()) {
            ApplicationManager.getApplication().invokeLater(this::scheduleResultsUpdate, ModalityState.any());
        }
        if (Registry.is((String)"ide.find.as.popup") && !SystemInfo.isJetBrainsJvm) {
            this.setErrorText("<font color=\"#" + ColorUtil.toHex((Color)UIUtil.getInactiveTextColor()) + "\">There is another version of this dialog in a form of lightweight popup. To use it, run the IDE with the bundled JRE.</font>");
        }
        this.show();
    }

    public void doCancelAction() {
        this.saveSettings();
        super.doCancelAction();
    }

    @Override
    public void saveSettings() {
        FindSettings.getInstance().setDefaultScopeName(this.myScopeCombo.getSelectedScopeName());
        this.applyTo(FindManager.getInstance((Project)this.myProject).getFindInProjectModel(), false);
        this.rememberResultsPreviewWasOpen();
    }

    private void rememberResultsPreviewWasOpen() {
        int selectedIndex;
        if (this.myResultsPreviewTable != null && (selectedIndex = this.myContent.getSelectedIndex()) != -1) {
            myPreviewResultsTabWasSelected = selectedIndex == 1;
        }
    }

    protected void dispose() {
        this.finishPreviousPreviewSearch();
        if (this.mySearchRescheduleOnCancellationsAlarm != null) {
            Disposer.dispose((Disposable)this.mySearchRescheduleOnCancellationsAlarm);
        }
        if (this.myUsagePreviewPanel != null) {
            Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        }
        for (Map.Entry<EditorTextField, DocumentListener> e : this.myComboBoxListeners.entrySet()) {
            e.getKey().removeDocumentListener(e.getValue());
        }
        this.myComboBoxListeners.clear();
        if (this.myScopePanel != null) {
            myPreviousResultsExpandedState = this.myScopePanel.isExpanded();
        }
        super.dispose();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myInputComboBox;
    }

    protected String getDimensionServiceKey() {
        return this.myHelper.getModel().isReplaceState() ? "replaceTextDialog" : "findTextDialog";
    }

    @NotNull
    protected Action[] createActions() {
        FindModel myModel = this.myHelper.getModel();
        if (!myModel.isMultipleFiles() && !myModel.isReplaceState() && myModel.isFindAllEnabled()) {
            Action[] actionArray = new Action[]{this.getFindAllAction(), this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
            if (actionArray == null) {
                FindDialog.$$$reportNull$$$0(0);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            FindDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    @NotNull
    private Action getFindAllAction() {
        this.myFindAllAction = new AbstractAction(FindBundle.message("find.all.button", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.doOKAction(true);
            }
        };
        if (this.myFindAllAction == null) {
            FindDialog.$$$reportNull$$$0(2);
        }
        return this.myFindAllAction;
    }

    public JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        JLabel prompt = new JLabel(FindBundle.message("find.text.to.find.label", new Object[0]));
        panel2.add((Component)prompt, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 4, 10), 0, 0));
        this.myInputComboBox = new ComboBox(300);
        this.revealWhitespaces(this.myInputComboBox);
        this.initCombobox(this.myInputComboBox);
        this.myReplaceComboBox = new ComboBox(300);
        this.revealWhitespaces(this.myReplaceComboBox);
        this.initCombobox(this.myReplaceComboBox);
        final Component editorComponent = this.myReplaceComboBox.getEditor().getEditorComponent();
        editorComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FindDialog.this.myReplaceComboBox.getEditor().selectAll();
                editorComponent.removeFocusListener(this);
            }
        });
        panel2.add((Component)this.myInputComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 4, 0), 0, 0));
        prompt.setLabelFor(this.myInputComboBox.getEditor().getEditorComponent());
        this.myReplacePrompt = new JLabel(FindBundle.message("find.replace.with.label", new Object[0]));
        panel2.add((Component)this.myReplacePrompt, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 4, 10), 0, 0));
        panel2.add((Component)this.myReplaceComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.myReplacePrompt.setLabelFor(this.myReplaceComboBox.getEditor().getEditorComponent());
        return panel2;
    }

    private void revealWhitespaces(@NotNull ComboBox comboBox) {
        if (comboBox == null) {
            FindDialog.$$$reportNull$$$0(3);
        }
        RevealingSpaceComboboxEditor comboBoxEditor = new RevealingSpaceComboboxEditor(this.myProject, comboBox);
        comboBox.setEditor((ComboBoxEditor)comboBoxEditor);
        comboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)comboBoxEditor));
    }

    private void initCombobox(final @NotNull ComboBox comboBox) {
        if (comboBox == null) {
            FindDialog.$$$reportNull$$$0(4);
        }
        comboBox.setEditable(true);
        comboBox.setMaximumRowCount(8);
        comboBox.addActionListener(__ -> this.validateFindButton());
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof EditorTextField) {
            EditorTextField etf = (EditorTextField)((Object)editorComponent);
            DocumentListener listener2 = new DocumentListener(){

                public void documentChanged(com.intellij.openapi.editor.event.DocumentEvent e) {
                    FindDialog.this.handleComboBoxValueChanged(comboBox);
                }
            };
            etf.addDocumentListener(listener2);
            this.myComboBoxListeners.put(etf, listener2);
        } else if (editorComponent instanceof JTextComponent) {
            javax.swing.text.Document document = ((JTextComponent)editorComponent).getDocument();
            DocumentAdapter documentAdapter = new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    FindDialog.this.handleAnyComboBoxValueChanged(comboBox);
                }
            };
            document.addDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
            Disposer.register((Disposable)this.myDisposable, () -> document.removeDocumentListener((javax.swing.event.DocumentListener)documentAdapter));
        } else assert (false);
        if (!this.myHelper.getModel().isReplaceState()) {
            this.makeResultsPreviewActionOverride((JComboBox)comboBox, KeyStroke.getKeyStroke(38, 0), "choosePrevious", () -> {
                int row = this.myResultsPreviewTable.getSelectedRow();
                if (row > 0) {
                    this.myResultsPreviewTable.setRowSelectionInterval(row - 1, row - 1);
                }
                TableUtil.scrollSelectionToVisible((JTable)this.myResultsPreviewTable);
            });
            this.makeResultsPreviewActionOverride((JComboBox)comboBox, KeyStroke.getKeyStroke(40, 0), "chooseNext", () -> {
                int row = this.myResultsPreviewTable.getSelectedRow();
                if (row >= -1 && row + 1 < this.myResultsPreviewTable.getRowCount()) {
                    this.myResultsPreviewTable.setRowSelectionInterval(row + 1, row + 1);
                    TableUtil.scrollSelectionToVisible((JTable)this.myResultsPreviewTable);
                }
            });
            this.makeResultsPreviewActionOverride((JComboBox)comboBox, KeyStroke.getKeyStroke(33, 0), "scrollUp", () -> ScrollingUtil.movePageUp((JTable)this.myResultsPreviewTable));
            this.makeResultsPreviewActionOverride((JComboBox)comboBox, KeyStroke.getKeyStroke(34, 0), "scrollDown", () -> ScrollingUtil.movePageDown((JTable)this.myResultsPreviewTable));
            final AnAction action = new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    if (FindDialog.this.isResultsPreviewTabActive()) {
                        FindDialog.this.navigateToSelectedUsage(FindDialog.this.myResultsPreviewTable);
                    }
                }
            };
            action.registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)comboBox, this.myDisposable);
            new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    if (!FindDialog.this.isResultsPreviewTabActive() || FindDialog.this.myResultsPreviewTable.getSelectedRowCount() == 0) {
                        FindDialog.this.doOKAction();
                    } else {
                        action.actionPerformed(e);
                    }
                }
            }.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)comboBox, this.myDisposable);
        }
    }

    private boolean isResultsPreviewTabActive() {
        return this.myResultsPreviewTable != null && this.myContent.getSelectedIndex() == 1;
    }

    private void makeResultsPreviewActionOverride(final JComboBox component, KeyStroke keyStroke, String newActionKey, final Runnable newAction) {
        InputMap inputMap = component.getInputMap(1);
        Object action = inputMap.get(keyStroke);
        inputMap.put(keyStroke, newActionKey);
        final Action previousAction2 = action != null ? component.getActionMap().get(action) : null;
        component.getActionMap().put(newActionKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FindDialog.this.isResultsPreviewTabActive() && !component.isPopupVisible()) {
                    newAction.run();
                    return;
                }
                if (previousAction2 != null) {
                    previousAction2.actionPerformed(e);
                }
            }
        });
    }

    private void handleComboBoxValueChanged(@NotNull ComboBox comboBox) {
        Object item;
        if (comboBox == null) {
            FindDialog.$$$reportNull$$$0(5);
        }
        if ((item = comboBox.getEditor().getItem()) != null && !item.equals(comboBox.getSelectedItem())) {
            comboBox.setSelectedItem(item);
        }
        this.handleAnyComboBoxValueChanged(comboBox);
    }

    private void handleAnyComboBoxValueChanged(@NotNull ComboBox comboBox) {
        if (comboBox == null) {
            FindDialog.$$$reportNull$$$0(6);
        }
        if (comboBox != this.myReplaceComboBox) {
            this.scheduleResultsUpdate();
        }
        this.validateFindButton();
    }

    private void findSettingsChanged() {
        if (this.haveResultsPreview()) {
            Document document;
            ProgressIndicatorBase progressIndicatorWhenSearchStarted;
            final ModalityState state2 = ModalityState.current();
            if (state2 == ModalityState.NON_MODAL) {
                return;
            }
            this.finishPreviousPreviewSearch();
            this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
            final FindModel findModel = this.myHelper.getModel().clone();
            this.applyTo(findModel, false);
            ValidationInfo result2 = this.getValidationInfo(findModel);
            this.myResultsPreviewSearchProgress = progressIndicatorWhenSearchStarted = new ProgressIndicatorBase();
            final DefaultTableModel model = new DefaultTableModel(){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            final LinkedHashSet<VirtualFile> filesToScanInitially = new LinkedHashSet<VirtualFile>();
            if (this.myHelper.myPreviousModel != null && this.myHelper.myPreviousModel.getStringToFind().length() < findModel.getStringToFind().length()) {
                DefaultTableModel previousModel = (DefaultTableModel)this.myResultsPreviewTable.getModel();
                int len = previousModel.getRowCount();
                for (int i = 0; i < len; ++i) {
                    UsageInfo2UsageAdapter usage = (UsageInfo2UsageAdapter)previousModel.getValueAt(i, 0);
                    VirtualFile file2 = usage.getFile();
                    if (file2 == null) continue;
                    filesToScanInitially.add(file2);
                }
            }
            this.myHelper.myPreviousModel = findModel;
            model.addColumn("Usages");
            this.myResultsPreviewTable.setModel((TableModel)model);
            if (result2 != null) {
                this.myResultsPreviewTable.getEmptyText().setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
                this.myContent.setTitleAt(1, PREVIEW_TITLE);
                return;
            }
            GlobalSearchScope scope = GlobalSearchScopeUtil.toGlobalSearchScope(FindInProjectUtil.getScopeFromModel(this.myProject, findModel), this.myProject);
            this.myResultsPreviewTable.getColumnModel().getColumn(0).setCellRenderer(new UsageTableCellRenderer(false, true, scope));
            this.myResultsPreviewTable.getEmptyText().setText("Searching...");
            this.myContent.setTitleAt(1, PREVIEW_TITLE);
            Component component = this.myInputComboBox.getEditor().getEditorComponent();
            if (component instanceof EditorTextField && (document = ((EditorTextField)((Object)component)).getDocument()) != null) {
                PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            }
            final AtomicInteger resultsCount = new AtomicInteger();
            final AtomicInteger resultsFilesCount = new AtomicInteger();
            ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myResultsPreviewSearchProgress, new ReadTask(){

                @Override
                @Nullable
                public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                    boolean succeeded;
                    if (indicator == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(FindSettings.getInstance().isShowResultsInSeparateView(), findModel);
                    boolean showPanelIfOnlyOneUsage = !FindSettings.getInstance().isSkipResultsWithOneUsage();
                    FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(FindDialog.this.myProject, showPanelIfOnlyOneUsage, presentation);
                    ThreadLocal lastUsageFileRef = new ThreadLocal();
                    FindInProjectUtil.findUsages(findModel, FindDialog.this.myProject, processPresentation, filesToScanInitially, (Processor<UsageInfo>)((Processor)info -> {
                        if (this.isCancelled()) {
                            return false;
                        }
                        Usage usage = (Usage)UsageInfo2UsageAdapter.CONVERTER.fun(info);
                        usage.getPresentation().getIcon();
                        VirtualFile file2 = (VirtualFile)lastUsageFileRef.get();
                        VirtualFile usageFile = info.getVirtualFile();
                        if (file2 == null || !file2.equals(usageFile)) {
                            resultsFilesCount.incrementAndGet();
                            lastUsageFileRef.set(usageFile);
                        }
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (this.isCancelled()) {
                                return;
                            }
                            model.addRow(new Object[]{usage});
                        }, state2);
                        return resultsCount.incrementAndGet() < ShowUsagesAction.getUsagesPageSize();
                    }));
                    boolean bl = succeeded = !progressIndicatorWhenSearchStarted.isCanceled();
                    if (succeeded) {
                        return new ReadTask.Continuation(() -> {
                            if (!this.isCancelled()) {
                                int occurrences = resultsCount.get();
                                int filesWithOccurrences = resultsFilesCount.get();
                                if (occurrences == 0) {
                                    FindDialog.this.myResultsPreviewTable.getEmptyText().setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
                                }
                                boolean foundAllUsages = occurrences < ShowUsagesAction.getUsagesPageSize();
                                FindDialog.this.myContent.setTitleAt(1, PREVIEW_TITLE + " (" + (foundAllUsages ? Integer.valueOf(occurrences) : occurrences + "+") + UIBundle.message((String)"message.matches", (Object[])new Object[]{occurrences}) + " in " + (foundAllUsages ? Integer.valueOf(filesWithOccurrences) : filesWithOccurrences + "+") + UIBundle.message((String)"message.files", (Object[])new Object[]{filesWithOccurrences}) + ")");
                            }
                        }, state2);
                    }
                    return null;
                }

                boolean isCancelled() {
                    return progressIndicatorWhenSearchStarted != FindDialog.this.myResultsPreviewSearchProgress || FindDialog.this.myResultsPreviewSearchProgress.isCanceled();
                }

                @Override
                public void onCanceled(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        9.$$$reportNull$$$0(1);
                    }
                    if (FindDialog.this.isShowing() && progressIndicatorWhenSearchStarted == FindDialog.this.myResultsPreviewSearchProgress) {
                        FindDialog.this.scheduleResultsUpdate();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "indicator";
                    objectArray2[1] = "com/intellij/find/impl/FindDialog$9";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "performInReadAction";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onCanceled";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private void scheduleResultsUpdate() {
        Alarm alarm = this.mySearchRescheduleOnCancellationsAlarm;
        if (alarm == null || alarm.isDisposed()) {
            return;
        }
        alarm.cancelAllRequests();
        alarm.addRequest(() -> TransactionGuard.submitTransaction((Disposable)this.myDisposable, this::findSettingsChanged), 100);
    }

    private void finishPreviousPreviewSearch() {
        if (this.myResultsPreviewSearchProgress != null && !this.myResultsPreviewSearchProgress.isCanceled()) {
            this.myResultsPreviewSearchProgress.cancel();
        }
    }

    private void validateFindButton() {
        boolean okStatus = this.myHelper.canSearchThisString() || this.myRbDirectory != null && this.myRbDirectory.isSelected() && StringUtil.isEmpty((String)this.getDirectory());
        this.setOKStatus(okStatus);
    }

    private void setOKStatus(boolean value) {
        this.setOKActionEnabled(value);
        if (this.myFindAllAction != null) {
            this.myFindAllAction.setEnabled(value);
        }
    }

    public JComponent createCenterPanel() {
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        JPanel topOptionsPanel = new JPanel();
        topOptionsPanel.setLayout(new GridLayout(1, 2, 10, 0));
        topOptionsPanel.add(this.createFindOptionsPanel());
        optionsPanel.add((Component)topOptionsPanel, gbConstraints);
        JPanel resultsOptionPanel = null;
        if (this.myHelper.getModel().isMultipleFiles()) {
            optionsPanel.add((Component)this.createGlobalScopePanel(), gbConstraints);
            gbConstraints.weightx = 1.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.fill = 2;
            gbConstraints.gridwidth = 0;
            optionsPanel.add((Component)this.createFilterPanel(), gbConstraints);
            this.myCbToSkipResultsWhenOneUsage = FindDialog.createCheckbox(this.myHelper.isSkipResultsWithOneUsage(), FindBundle.message("find.options.skip.results.tab.with.one.occurrence.checkbox", new Object[0]));
            this.myCbToSkipResultsWhenOneUsage.addActionListener(e -> this.myHelper.setSkipResultsWithOneUsage(this.myCbToSkipResultsWhenOneUsage.isSelected()));
            resultsOptionPanel = this.createResultsOptionPanel(optionsPanel, gbConstraints);
            resultsOptionPanel.add(this.myCbToSkipResultsWhenOneUsage);
            this.myCbToSkipResultsWhenOneUsage.setVisible(!this.myHelper.isReplaceState());
            if (this.haveResultsPreview()) {
                JBTable table = new JBTable(){

                    public Dimension getPreferredSize() {
                        return new Dimension(FindDialog.this.myInputComboBox.getWidth(), super.getPreferredSize().height);
                    }
                };
                table.setShowColumns(false);
                table.setShowGrid(false);
                table.setIntercellSpacing((Dimension)JBUI.emptySize());
                new NavigateToSourceListener().installOn((Component)table);
                Splitter previewSplitter = new Splitter(true, 0.5f, 0.1f, 0.9f);
                this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, new UsageViewPresentation(), true);
                this.myUsagePreviewPanel.setBorder(IdeBorderFactory.createBorder());
                this.registerNavigateToSourceShortcutOnComponent(table, (JComponent)this.myUsagePreviewPanel);
                this.myResultsPreviewTable = table;
                new TableSpeedSearch((JTable)table, (Convertor<Object, String>)((Convertor)o -> ((UsageInfo2UsageAdapter)o).getFile().getName()));
                this.myResultsPreviewTable.getSelectionModel().addListSelectionListener(e -> {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    int index = this.myResultsPreviewTable.getSelectionModel().getLeadSelectionIndex();
                    if (index != -1) {
                        UsageInfo usageInfo = ((UsageInfo2UsageAdapter)this.myResultsPreviewTable.getModel().getValueAt(index, 0)).getUsageInfo();
                        this.myUsagePreviewPanel.updateLayout(usageInfo.isValid() ? Collections.singletonList(usageInfo) : null);
                        VirtualFile file2 = usageInfo.getVirtualFile();
                        this.myUsagePreviewPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)(file2 != null ? file2.getPath() : ""), (boolean)false));
                    } else {
                        this.myUsagePreviewPanel.updateLayout(null);
                        this.myUsagePreviewPanel.setBorder(IdeBorderFactory.createBorder());
                    }
                });
                this.mySearchRescheduleOnCancellationsAlarm = new Alarm();
                previewSplitter.setFirstComponent((JComponent)new JBScrollPane((Component)this.myResultsPreviewTable));
                previewSplitter.setSecondComponent(this.myUsagePreviewPanel.createComponent());
                this.myPreviewSplitter = previewSplitter;
            }
        } else {
            JPanel leftOptionsPanel = new JPanel();
            leftOptionsPanel.setLayout(new GridLayout(3, 1, 0, 4));
            leftOptionsPanel.add(this.createDirectionPanel());
            leftOptionsPanel.add(this.createOriginPanel());
            leftOptionsPanel.add(this.createScopePanel());
            topOptionsPanel.add(leftOptionsPanel);
        }
        if (this.myHelper.getModel().isOpenInNewTabVisible()) {
            this.myCbToOpenInNewTab = new JCheckBox(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0]));
            this.myCbToOpenInNewTab.setFocusable(false);
            this.myCbToOpenInNewTab.setSelected(this.myHelper.isUseSeparateView());
            this.myCbToOpenInNewTab.setEnabled(this.myHelper.getModel().isOpenInNewTabEnabled());
            this.myCbToOpenInNewTab.addActionListener(e -> this.myHelper.setUseSeparateView(this.myCbToOpenInNewTab.isSelected()));
            if (resultsOptionPanel == null) {
                resultsOptionPanel = this.createResultsOptionPanel(optionsPanel, gbConstraints);
            }
            resultsOptionPanel.add(this.myCbToOpenInNewTab);
        }
        if (this.myPreviewSplitter != null) {
            JBTabsPaneImpl pane = new JBTabsPaneImpl(this.myProject, 1, this.myDisposable);
            pane.insertTab("Options", null, optionsPanel, null, 0);
            pane.insertTab(PREVIEW_TITLE, null, (Component)this.myPreviewSplitter, null, 1);
            this.myContent = pane;
            DumbAwareAction anAction = DumbAwareAction.create(e -> {
                int selectedIndex = this.myContent.getSelectedIndex();
                this.myContent.setSelectedIndex(1 - selectedIndex);
            });
            ShortcutSet shortcutSet = ActionManager.getInstance().getAction("Switcher").getShortcutSet();
            anAction.registerCustomShortcutSet(shortcutSet, (JComponent)this.getRootPane(), this.myDisposable);
            if (myPreviewResultsTabWasSelected) {
                this.myContent.setSelectedIndex(1);
            }
            return pane.getComponent();
        }
        return optionsPanel;
    }

    private boolean haveResultsPreview() {
        return Registry.is((String)"ide.find.show.preview") && this.myHelper.getModel().isMultipleFiles();
    }

    private JPanel createResultsOptionPanel(JPanel optionsPanel, GridBagConstraints gbConstraints) {
        JPanel resultsOptionPanel = new JPanel();
        resultsOptionPanel.setLayout(new BoxLayout(resultsOptionPanel, 1));
        this.myScopePanel = new HideableTitledPanel(FindBundle.message("results.options.group", new Object[0]), resultsOptionPanel, myPreviousResultsExpandedState);
        optionsPanel.add((Component)this.myScopePanel, gbConstraints);
        return resultsOptionPanel;
    }

    @NotNull
    private JComponent createFilterPanel() {
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BorderLayout());
        filterPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.filter.file.name.group", new Object[0]), (boolean)true));
        this.myFileFilter = new ComboBox(100);
        this.initCombobox(this.myFileFilter);
        this.myUseFileFilter = FindDialog.createCheckbox(FindBundle.message("find.filter.file.mask.checkbox", new Object[0]));
        filterPanel.add((Component)this.myUseFileFilter, "West");
        filterPanel.add((Component)this.myFileFilter, "Center");
        FindDialog.initFileFilter((JComboBox)this.myFileFilter, this.myUseFileFilter);
        this.myUseFileFilter.addActionListener(__ -> {
            this.scheduleResultsUpdate();
            this.validateFindButton();
        });
        JPanel jPanel = filterPanel;
        if (jPanel == null) {
            FindDialog.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    public static void initFileFilter(@NotNull JComboBox fileFilter, @NotNull JCheckBox useFileFilter) {
        if (fileFilter == null) {
            FindDialog.$$$reportNull$$$0(8);
        }
        if (useFileFilter == null) {
            FindDialog.$$$reportNull$$$0(9);
        }
        fileFilter.setEditable(true);
        String[] fileMasks = FindSettings.getInstance().getRecentFileMasks();
        for (int i = fileMasks.length - 1; i >= 0; --i) {
            fileFilter.addItem(fileMasks[i]);
        }
        fileFilter.setEnabled(false);
        useFileFilter.addActionListener(__ -> {
            if (useFileFilter == null) {
                FindDialog.$$$reportNull$$$0(31);
            }
            if (fileFilter == null) {
                FindDialog.$$$reportNull$$$0(32);
            }
            if (useFileFilter.isSelected()) {
                fileFilter.setEnabled(true);
                fileFilter.getEditor().selectAll();
                fileFilter.getEditor().getEditorComponent().requestFocusInWindow();
            } else {
                fileFilter.setEnabled(false);
            }
        });
    }

    public void doOKAction() {
        this.doOKAction(false);
    }

    private void doOKAction(boolean findAll) {
        FindModel validateModel = this.myHelper.getModel().clone();
        this.applyTo(validateModel, findAll);
        ValidationInfo validationInfo = this.getValidationInfo(validateModel);
        if (validationInfo == null) {
            this.myHelper.getModel().copyFrom(validateModel);
            this.rememberResultsPreviewWasOpen();
            super.doOKAction();
            this.myHelper.doOKAction();
        } else {
            String message = validationInfo.message;
            Messages.showMessageDialog((Project)this.myProject, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        }
    }

    @Nullable(value="null means OK")
    private ValidationInfo getValidationInfo(@NotNull FindModel model) {
        String mask;
        VirtualFile directory2;
        if (model == null) {
            FindDialog.$$$reportNull$$$0(10);
        }
        if (this.myRbDirectory != null && this.myRbDirectory.isEnabled() && this.myRbDirectory.isSelected() && (directory2 = FindInProjectUtil.getDirectory(model)) == null) {
            return new ValidationInfo(FindBundle.message("find.directory.not.found.error", this.getDirectory()), (JComponent)this.myDirectoryComboBox);
        }
        if (!this.myHelper.canSearchThisString()) {
            return new ValidationInfo(FindBundle.message("find.empty.search.text.error", new Object[0]), (JComponent)this.myInputComboBox);
        }
        if (this.myCbRegularExpressions != null && this.myCbRegularExpressions.isSelected() && this.myCbRegularExpressions.isEnabled()) {
            String toFind = this.getStringToFind();
            try {
                boolean isCaseSensitive = this.myCbCaseSensitive != null && this.myCbCaseSensitive.isSelected() && this.myCbCaseSensitive.isEnabled();
                Pattern pattern = Pattern.compile(toFind, isCaseSensitive ? 8 : 10);
                if (pattern.matcher("").matches() && !toFind.endsWith("$") && !toFind.startsWith("^")) {
                    return new ValidationInfo(FindBundle.message("find.empty.match.regular.expression.error", new Object[0]), (JComponent)this.myInputComboBox);
                }
            }
            catch (PatternSyntaxException e) {
                return new ValidationInfo(FindBundle.message("find.invalid.regular.expression.error", toFind, e.getDescription()), (JComponent)this.myInputComboBox);
            }
        }
        if ((mask = this.getFileTypeMask()) != null) {
            if (mask.isEmpty()) {
                return new ValidationInfo(FindBundle.message("find.filter.empty.file.mask.error", new Object[0]), (JComponent)this.myFileFilter);
            }
            if (mask.contains(";")) {
                return new ValidationInfo("File masks should be comma-separated", (JComponent)this.myFileFilter);
            }
            try {
                FindInProjectUtil.createFileMaskCondition(mask);
            }
            catch (PatternSyntaxException ex) {
                return new ValidationInfo(FindBundle.message("find.filter.invalid.file.mask.error", mask), (JComponent)this.myFileFilter);
            }
        }
        return null;
    }

    protected ValidationInfo doValidate() {
        FindModel validateModel = this.myHelper.getModel().clone();
        this.applyTo(validateModel, false);
        ValidationInfo result2 = this.getValidationInfo(validateModel);
        this.setOKStatus(result2 == null);
        return result2;
    }

    public void doHelpAction() {
        FindModel myModel = this.myHelper.getModel();
        String id = myModel.isReplaceState() ? (myModel.isMultipleFiles() ? "reference.dialogs.findinpath" : "find.replaceOptions") : (myModel.isMultipleFiles() ? "reference.dialogs.findinpath" : "find.findOptions");
        HelpManager.getInstance().invokeHelp(id);
    }

    @NotNull
    private JPanel createFindOptionsPanel() {
        JPanel findOptionsPanel = new JPanel();
        findOptionsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.options.group", new Object[0]), (boolean)true));
        findOptionsPanel.setLayout(new BoxLayout(findOptionsPanel, 1));
        this.myCbCaseSensitive = FindDialog.createCheckbox(FindBundle.message("find.options.case.sensitive", new Object[0]));
        findOptionsPanel.add(this.myCbCaseSensitive);
        ItemListener liveResultsPreviewUpdateListener = __ -> this.scheduleResultsUpdate();
        this.myCbCaseSensitive.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbPreserveCase = FindDialog.createCheckbox(FindBundle.message("find.options.replace.preserve.case", new Object[0]));
        this.myCbPreserveCase.addItemListener(liveResultsPreviewUpdateListener);
        findOptionsPanel.add(this.myCbPreserveCase);
        this.myCbPreserveCase.setVisible(this.myHelper.isReplaceState());
        this.myCbWholeWordsOnly = FindDialog.createCheckbox(FindBundle.message("find.options.whole.words.only", new Object[0]));
        this.myCbWholeWordsOnly.addItemListener(liveResultsPreviewUpdateListener);
        findOptionsPanel.add(this.myCbWholeWordsOnly);
        this.myCbRegularExpressions = FindDialog.createCheckbox(FindBundle.message("find.options.regular.expressions", new Object[0]));
        this.myCbRegularExpressions.addItemListener(liveResultsPreviewUpdateListener);
        JPanel regExPanel = new JPanel();
        regExPanel.setAlignmentX(0.0f);
        regExPanel.setLayout(new BoxLayout(regExPanel, 0));
        regExPanel.add(this.myCbRegularExpressions);
        regExPanel.add((Component)RegExHelpPopup.createRegExLink("[Help]", regExPanel, LOG));
        findOptionsPanel.add(regExPanel);
        this.mySearchContext = new ComboBox(new Object[]{FindDialog.getPresentableName(FindModel.SearchContext.ANY), FindDialog.getPresentableName(FindModel.SearchContext.IN_COMMENTS), FindDialog.getPresentableName(FindModel.SearchContext.IN_STRING_LITERALS), FindDialog.getPresentableName(FindModel.SearchContext.EXCEPT_COMMENTS), FindDialog.getPresentableName(FindModel.SearchContext.EXCEPT_STRING_LITERALS), FindDialog.getPresentableName(FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS)});
        this.mySearchContext.addActionListener(__ -> this.scheduleResultsUpdate());
        JPanel searchContextPanel = new JPanel(new BorderLayout());
        searchContextPanel.setAlignmentX(0.0f);
        JLabel searchContextLabel = new JLabel(FindBundle.message("find.context.combo.label", new Object[0]));
        searchContextLabel.setLabelFor((Component)this.mySearchContext);
        JPanel panel2 = new JPanel();
        panel2.setAlignmentX(0.0f);
        panel2.add(searchContextLabel);
        searchContextPanel.add((Component)panel2, "West");
        panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.mySearchContext, "North");
        searchContextPanel.add((Component)panel2, "Center");
        findOptionsPanel.add(searchContextPanel);
        ActionListener actionListener = __ -> this.updateControls();
        this.myCbRegularExpressions.addActionListener(actionListener);
        this.myCbRegularExpressions.addItemListener(__ -> this.setupRegExpSetting());
        this.myCbCaseSensitive.addActionListener(actionListener);
        this.myCbPreserveCase.addActionListener(actionListener);
        JPanel jPanel = findOptionsPanel;
        if (jPanel == null) {
            FindDialog.$$$reportNull$$$0(11);
        }
        return jPanel;
    }

    public static String getPresentableName(@NotNull FindModel.SearchContext searchContext) {
        if (searchContext == null) {
            FindDialog.$$$reportNull$$$0(12);
        }
        String messageKey = null;
        if (searchContext == FindModel.SearchContext.ANY) {
            messageKey = "find.context.anywhere.scope.label";
        } else if (searchContext == FindModel.SearchContext.EXCEPT_COMMENTS) {
            messageKey = "find.context.except.comments.scope.label";
        } else if (searchContext == FindModel.SearchContext.EXCEPT_STRING_LITERALS) {
            messageKey = "find.context.except.literals.scope.label";
        } else if (searchContext == FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS) {
            messageKey = "find.context.except.comments.and.literals.scope.label";
        } else if (searchContext == FindModel.SearchContext.IN_COMMENTS) {
            messageKey = "find.context.in.comments.scope.label";
        } else if (searchContext == FindModel.SearchContext.IN_STRING_LITERALS) {
            messageKey = "find.context.in.literals.scope.label";
        }
        return messageKey != null ? FindBundle.message(messageKey, new Object[0]) : searchContext.toString();
    }

    @NotNull
    static FindModel.SearchContext parseSearchContext(String presentableName) {
        FindModel.SearchContext searchContext = FindModel.SearchContext.ANY;
        if (FindBundle.message("find.context.in.literals.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.IN_STRING_LITERALS;
        } else if (FindBundle.message("find.context.in.comments.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.IN_COMMENTS;
        } else if (FindBundle.message("find.context.except.comments.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.EXCEPT_COMMENTS;
        } else if (FindBundle.message("find.context.except.literals.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.EXCEPT_STRING_LITERALS;
        } else if (FindBundle.message("find.context.except.comments.and.literals.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS;
        }
        FindModel.SearchContext searchContext2 = searchContext;
        if (searchContext2 == null) {
            FindDialog.$$$reportNull$$$0(13);
        }
        return searchContext2;
    }

    @NotNull
    static String getSearchContextName(FindModel model) {
        String searchContext = FindBundle.message("find.context.anywhere.scope.label", new Object[0]);
        if (model.isInCommentsOnly()) {
            searchContext = FindBundle.message("find.context.in.comments.scope.label", new Object[0]);
        } else if (model.isInStringLiteralsOnly()) {
            searchContext = FindBundle.message("find.context.in.literals.scope.label", new Object[0]);
        } else if (model.isExceptStringLiterals()) {
            searchContext = FindBundle.message("find.context.except.literals.scope.label", new Object[0]);
        } else if (model.isExceptComments()) {
            searchContext = FindBundle.message("find.context.except.comments.scope.label", new Object[0]);
        } else if (model.isExceptCommentsAndStringLiterals()) {
            searchContext = FindBundle.message("find.context.except.comments.and.literals.scope.label", new Object[0]);
        }
        String string = searchContext;
        if (string == null) {
            FindDialog.$$$reportNull$$$0(14);
        }
        return string;
    }

    private void setupRegExpSetting() {
        this.updateFileTypeForEditorComponent(this.myInputComboBox);
        if (this.myReplaceComboBox != null) {
            this.updateFileTypeForEditorComponent(this.myReplaceComboBox);
        }
    }

    private void updateFileTypeForEditorComponent(@NotNull ComboBox inputComboBox) {
        Component editorComponent;
        if (inputComboBox == null) {
            FindDialog.$$$reportNull$$$0(15);
        }
        if ((editorComponent = inputComboBox.getEditor().getEditorComponent()) instanceof EditorTextField) {
            LanguageFileType regexpFileType;
            Language regexpLanguage;
            boolean isRegexp = this.myCbRegularExpressions.isSelectedWhenSelectable();
            PlainTextFileType fileType = PlainTextFileType.INSTANCE;
            if (isRegexp && (regexpLanguage = Language.findLanguageByID((String)"RegExp")) != null && (regexpFileType = regexpLanguage.getAssociatedFileType()) != null) {
                fileType = regexpFileType;
            }
            String fileName = isRegexp ? "a.regexp" : "a.txt";
            PsiFile file2 = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, (FileType)fileType, (CharSequence)((EditorTextField)((Object)editorComponent)).getText(), -1L, true);
            ((EditorTextField)((Object)editorComponent)).setNewDocumentAndFileType((FileType)fileType, PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2));
        }
    }

    private void updateControls() {
        if (this.myCbRegularExpressions.isSelected()) {
            this.myCbWholeWordsOnly.makeUnselectable(false);
        } else {
            this.myCbWholeWordsOnly.makeSelectable();
        }
        if (this.myHelper.isReplaceState()) {
            if (this.myCbRegularExpressions.isSelected() || this.myCbCaseSensitive.isSelected()) {
                this.myCbPreserveCase.makeUnselectable(false);
            } else {
                this.myCbPreserveCase.makeSelectable();
            }
            if (this.myCbPreserveCase.isSelected()) {
                this.myCbRegularExpressions.makeUnselectable(false);
                this.myCbCaseSensitive.makeUnselectable(false);
            } else {
                this.myCbRegularExpressions.makeSelectable();
                this.myCbCaseSensitive.makeSelectable();
            }
        }
        if (!this.myHelper.getModel().isMultipleFiles()) {
            this.myRbFromCursor.setEnabled(this.myRbGlobal.isSelected());
            this.myRbEntireScope.setEnabled(this.myRbGlobal.isSelected());
        }
    }

    @NotNull
    private JPanel createDirectionPanel() {
        JPanel directionPanel = new JPanel();
        directionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.direction.group", new Object[0]), (boolean)true));
        directionPanel.setLayout(new BoxLayout(directionPanel, 1));
        this.myRbForward = new JRadioButton(FindBundle.message("find.direction.forward.radio", new Object[0]), true);
        directionPanel.add(this.myRbForward);
        this.myRbBackward = new JRadioButton(FindBundle.message("find.direction.backward.radio", new Object[0]));
        directionPanel.add(this.myRbBackward);
        ButtonGroup bgDirection = new ButtonGroup();
        bgDirection.add(this.myRbForward);
        bgDirection.add(this.myRbBackward);
        JPanel jPanel = directionPanel;
        if (jPanel == null) {
            FindDialog.$$$reportNull$$$0(16);
        }
        return jPanel;
    }

    @NotNull
    private JComponent createGlobalScopePanel() {
        JPanel scopePanel = new JPanel();
        scopePanel.setLayout(new GridBagLayout());
        scopePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.scope.group", new Object[0]), (boolean)true));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 3;
        gbConstraints.weightx = 1.0;
        boolean canAttach = ProjectAttachProcessor.canAttachToProject();
        this.myRbProject = new JRadioButton(canAttach ? FindBundle.message("find.scope.all.projects.radio", new Object[0]) : FindBundle.message("find.scope.whole.project.radio", new Object[0]), true);
        scopePanel.add((Component)this.myRbProject, gbConstraints);
        ItemListener resultsPreviewUpdateListener = __ -> this.scheduleResultsUpdate();
        this.myRbProject.addItemListener(resultsPreviewUpdateListener);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        this.myRbModule = new JRadioButton(canAttach ? FindBundle.message("find.scope.project.radio", new Object[0]) : FindBundle.message("find.scope.module.radio", new Object[0]), false);
        scopePanel.add((Component)this.myRbModule, gbConstraints);
        this.myRbModule.addItemListener(resultsPreviewUpdateListener);
        gbConstraints.gridx = 1;
        gbConstraints.gridwidth = 2;
        gbConstraints.weightx = 1.0;
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        Object[] names = new String[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            names[i] = modules[i].getName();
        }
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        this.myModuleComboBox = new ComboBox(names);
        this.myModuleComboBox.addActionListener(__ -> this.scheduleResultsUpdate());
        scopePanel.add((Component)this.myModuleComboBox, gbConstraints);
        if (modules.length == 1) {
            this.myModuleComboBox.setVisible(false);
            this.myRbModule.setVisible(false);
        }
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        this.myRbDirectory = new JRadioButton(FindBundle.message("find.scope.directory.radio", new Object[0]), false);
        scopePanel.add((Component)this.myRbDirectory, gbConstraints);
        this.myRbDirectory.addItemListener(resultsPreviewUpdateListener);
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        this.myDirectoryComboBox = new ComboBox(200);
        Component editorComponent = this.myDirectoryComboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField field = (JTextField)editorComponent;
            field.setColumns(40);
        }
        this.initCombobox(this.myDirectoryComboBox);
        this.myDirectoryComboBox.setSwingPopup(false);
        this.myDirectoryComboBox.addActionListener(__ -> this.scheduleResultsUpdate());
        scopePanel.add((Component)this.myDirectoryComboBox, gbConstraints);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 2;
        this.mySelectDirectoryButton = new FixedSizeButton((JComponent)this.myDirectoryComboBox);
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)this.mySelectDirectoryButton, (JComponent)this.myDirectoryComboBox);
        this.mySelectDirectoryButton.setMargin(new Insets(0, 0, 0, 0));
        scopePanel.add((Component)this.mySelectDirectoryButton, gbConstraints);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 3;
        gbConstraints.insets = new Insets(0, 16, 0, 0);
        this.myCbWithSubdirectories = FindDialog.createCheckbox(true, FindBundle.message("find.scope.directory.recursive.checkbox", new Object[0]));
        this.myCbWithSubdirectories.setSelected(true);
        this.myCbWithSubdirectories.addItemListener(resultsPreviewUpdateListener);
        scopePanel.add((Component)this.myCbWithSubdirectories, gbConstraints);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.myRbCustomScope = new JRadioButton(FindBundle.message("find.scope.custom.radio", new Object[0]), false);
        scopePanel.add((Component)this.myRbCustomScope, gbConstraints);
        ++gbConstraints.gridx;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 2;
        this.myScopeCombo = new ScopeChooserCombo();
        this.myScopeCombo.init(this.myProject, true, true, FindSettings.getInstance().getDefaultScopeName(), new Condition<ScopeDescriptor>(){
            private final String moduleFilesScopeName;
            {
                String moduleScopeName = PsiBundle.message((String)"search.scope.module", (Object[])new Object[]{""});
                int ind = moduleScopeName.indexOf(32);
                this.moduleFilesScopeName = moduleScopeName.substring(0, ind + 1);
            }

            public boolean value(ScopeDescriptor descriptor2) {
                String display = descriptor2.getDisplay();
                return !display.startsWith(this.moduleFilesScopeName);
            }
        });
        this.myScopeCombo.getComboBox().addActionListener(__ -> this.scheduleResultsUpdate());
        this.myRbCustomScope.addItemListener(resultsPreviewUpdateListener);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeCombo);
        scopePanel.add((Component)((Object)this.myScopeCombo), gbConstraints);
        ButtonGroup bgScope = new ButtonGroup();
        bgScope.add(this.myRbProject);
        bgScope.add(this.myRbModule);
        bgScope.add(this.myRbDirectory);
        bgScope.add(this.myRbCustomScope);
        this.myRbProject.addActionListener(__ -> {
            this.validateScopeControls();
            this.validateFindButton();
        });
        this.myRbCustomScope.addActionListener(__ -> {
            this.validateScopeControls();
            this.validateFindButton();
            this.myScopeCombo.getComboBox().requestFocusInWindow();
        });
        this.myRbDirectory.addActionListener(__ -> {
            this.validateScopeControls();
            this.validateFindButton();
            this.myDirectoryComboBox.getEditor().getEditorComponent().requestFocusInWindow();
        });
        this.myRbModule.addActionListener(__ -> {
            this.validateScopeControls();
            this.validateFindButton();
            this.myModuleComboBox.requestFocusInWindow();
        });
        this.mySelectDirectoryButton.addActionListener(__ -> {
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)this.myProject, null, files2 -> this.myDirectoryComboBox.setSelectedItem((Object)((VirtualFile)files2.get(0)).getPresentableUrl()));
        });
        JPanel jPanel = scopePanel;
        if (jPanel == null) {
            FindDialog.$$$reportNull$$$0(17);
        }
        return jPanel;
    }

    @NotNull
    private static StateRestoringCheckBox createCheckbox(@NotNull String message) {
        if (message == null) {
            FindDialog.$$$reportNull$$$0(18);
        }
        StateRestoringCheckBox cb = new StateRestoringCheckBox(message);
        cb.setFocusable(false);
        StateRestoringCheckBox stateRestoringCheckBox = cb;
        if (stateRestoringCheckBox == null) {
            FindDialog.$$$reportNull$$$0(19);
        }
        return stateRestoringCheckBox;
    }

    @NotNull
    private static StateRestoringCheckBox createCheckbox(boolean selected, @NotNull String message) {
        if (message == null) {
            FindDialog.$$$reportNull$$$0(20);
        }
        StateRestoringCheckBox cb = new StateRestoringCheckBox(message, selected);
        cb.setFocusable(false);
        StateRestoringCheckBox stateRestoringCheckBox = cb;
        if (stateRestoringCheckBox == null) {
            FindDialog.$$$reportNull$$$0(21);
        }
        return stateRestoringCheckBox;
    }

    private void validateScopeControls() {
        if (this.myRbDirectory.isSelected()) {
            this.myCbWithSubdirectories.makeSelectable();
        } else {
            this.myCbWithSubdirectories.makeUnselectable(this.myCbWithSubdirectories.isSelected());
        }
        this.myDirectoryComboBox.setEnabled(this.myRbDirectory.isSelected());
        this.mySelectDirectoryButton.setEnabled(this.myRbDirectory.isSelected());
        this.myModuleComboBox.setEnabled(this.myRbModule.isSelected());
        this.myScopeCombo.setEnabled(this.myRbCustomScope.isSelected());
    }

    @NotNull
    private JPanel createScopePanel() {
        JPanel scopePanel = new JPanel();
        scopePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.scope.group", new Object[0]), (boolean)true));
        scopePanel.setLayout(new BoxLayout(scopePanel, 1));
        this.myRbGlobal = new JRadioButton(FindBundle.message("find.scope.global.radio", new Object[0]), true);
        scopePanel.add(this.myRbGlobal);
        this.myRbSelectedText = new JRadioButton(FindBundle.message("find.scope.selected.text.radio", new Object[0]));
        scopePanel.add(this.myRbSelectedText);
        ButtonGroup bgScope = new ButtonGroup();
        bgScope.add(this.myRbGlobal);
        bgScope.add(this.myRbSelectedText);
        ActionListener actionListener = __ -> this.updateControls();
        this.myRbGlobal.addActionListener(actionListener);
        this.myRbSelectedText.addActionListener(actionListener);
        JPanel jPanel = scopePanel;
        if (jPanel == null) {
            FindDialog.$$$reportNull$$$0(22);
        }
        return jPanel;
    }

    @NotNull
    private JPanel createOriginPanel() {
        JPanel originPanel = new JPanel();
        originPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.origin.group", new Object[0]), (boolean)true));
        originPanel.setLayout(new BoxLayout(originPanel, 1));
        this.myRbFromCursor = new JRadioButton(FindBundle.message("find.origin.from.cursor.radio", new Object[0]), true);
        originPanel.add(this.myRbFromCursor);
        this.myRbEntireScope = new JRadioButton(FindBundle.message("find.origin.entire.scope.radio", new Object[0]));
        originPanel.add(this.myRbEntireScope);
        ButtonGroup bgOrigin = new ButtonGroup();
        bgOrigin.add(this.myRbFromCursor);
        bgOrigin.add(this.myRbEntireScope);
        JPanel jPanel = originPanel;
        if (jPanel == null) {
            FindDialog.$$$reportNull$$$0(23);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public String getStringToFind() {
        String string = (String)this.myInputComboBox.getEditor().getItem();
        String string2 = string == null ? "" : string;
        if (string2 == null) {
            FindDialog.$$$reportNull$$$0(24);
        }
        return string2;
    }

    @NotNull
    private String getStringToReplace() {
        String item = (String)this.myReplaceComboBox.getEditor().getItem();
        String string = item == null ? "" : item;
        if (string == null) {
            FindDialog.$$$reportNull$$$0(25);
        }
        return string;
    }

    private String getDirectory() {
        return (String)this.myDirectoryComboBox.getEditor().getItem();
    }

    private static void setStringsToComboBox(@NotNull String[] strings, @NotNull ComboBox<String> combo, String selected) {
        if (strings == null) {
            FindDialog.$$$reportNull$$$0(26);
        }
        if (combo == null) {
            FindDialog.$$$reportNull$$$0(27);
        }
        if (combo.getItemCount() > 0) {
            combo.removeAllItems();
        }
        if (selected != null && selected.indexOf(10) < 0) {
            strings = (String[])ArrayUtil.remove((Object[])strings, (Object)selected);
            if (!selected.isEmpty()) {
                strings = (String[])ArrayUtil.append((Object[])strings, (Object)selected);
            }
        }
        for (int i = strings.length - 1; i >= 0; --i) {
            combo.addItem((Object)strings[i]);
        }
    }

    private void setDirectories(@NotNull List<String> strings, String directoryName) {
        if (strings == null) {
            FindDialog.$$$reportNull$$$0(28);
        }
        if (this.myDirectoryComboBox.getItemCount() > 0) {
            this.myReplaceComboBox.removeAllItems();
        }
        int ignoredIdx = -1;
        if (directoryName != null && !directoryName.isEmpty()) {
            ignoredIdx = strings.indexOf(directoryName);
            this.myDirectoryComboBox.addItem((Object)directoryName);
        }
        for (int i = strings.size() - 1; i >= 0; --i) {
            if (i == ignoredIdx) continue;
            this.myDirectoryComboBox.addItem((Object)strings.get(i));
        }
        if (this.myDirectoryComboBox.getItemCount() == 0) {
            this.myDirectoryComboBox.addItem((Object)"");
        }
    }

    private void applyTo(@NotNull FindModel model, boolean findAll) {
        if (model == null) {
            FindDialog.$$$reportNull$$$0(29);
        }
        model.setCaseSensitive(this.myCbCaseSensitive.isSelected());
        if (model.isReplaceState()) {
            model.setPreserveCase(this.myCbPreserveCase.isSelected());
        }
        model.setWholeWordsOnly(this.myCbWholeWordsOnly.isSelected());
        String selectedSearchContextInUi = (String)this.mySearchContext.getSelectedItem();
        FindModel.SearchContext searchContext = FindDialog.parseSearchContext(selectedSearchContextInUi);
        model.setSearchContext(searchContext);
        model.setRegularExpressions(this.myCbRegularExpressions.isSelected());
        String stringToFind = this.getStringToFind();
        model.setStringToFind(stringToFind);
        if (model.isReplaceState()) {
            model.setPromptOnReplace(true);
            model.setReplaceAll(false);
            String stringToReplace = this.getStringToReplace();
            model.setStringToReplace(StringUtil.convertLineSeparators((String)stringToReplace));
        }
        if (!model.isMultipleFiles()) {
            model.setForward(this.myRbForward.isSelected());
            model.setFromCursor(this.myRbFromCursor.isSelected());
            model.setGlobal(this.myRbGlobal.isSelected());
        } else {
            if (this.myCbToOpenInNewTab != null) {
                model.setOpenInNewTab(this.myCbToOpenInNewTab.isSelected());
            }
            model.setProjectScope(this.myRbProject.isSelected());
            model.setDirectoryName(null);
            model.setModuleName(null);
            model.setCustomScopeName(null);
            model.setCustomScope(null);
            model.setCustomScope(false);
            if (this.myRbDirectory.isSelected()) {
                String directory2 = this.getDirectory();
                model.setDirectoryName(directory2 == null ? "" : directory2);
                model.setWithSubdirectories(this.myCbWithSubdirectories.isSelected());
            } else if (this.myRbModule.isSelected()) {
                model.setModuleName((String)this.myModuleComboBox.getSelectedItem());
            } else if (this.myRbCustomScope.isSelected()) {
                SearchScope selectedScope = this.myScopeCombo.getSelectedScope();
                String customScopeName = selectedScope == null ? null : selectedScope.getDisplayName();
                model.setCustomScopeName(customScopeName);
                model.setCustomScope(selectedScope);
                model.setCustomScope(true);
            }
        }
        model.setFindAll(findAll);
        String mask = this.getFileTypeMask();
        model.setFileFilter(mask);
    }

    @Override
    @Nullable
    public String getFileTypeMask() {
        String mask = null;
        if (this.myUseFileFilter != null && this.myUseFileFilter.isSelected()) {
            mask = (String)this.myFileFilter.getEditor().getItem();
        }
        return mask;
    }

    @Override
    public void initByModel() {
        FindModel myModel = this.myHelper.getModel();
        this.myCbCaseSensitive.setSelected(myModel.isCaseSensitive());
        this.myCbWholeWordsOnly.setSelected(myModel.isWholeWordsOnly());
        String searchContext = FindDialog.getSearchContextName(myModel);
        this.mySearchContext.setSelectedItem((Object)searchContext);
        this.myCbRegularExpressions.setSelected(myModel.isRegularExpressions());
        if (myModel.isMultipleFiles()) {
            Module module2;
            VirtualFile dir;
            String dirName = myModel.getDirectoryName();
            this.setDirectories(FindInProjectSettings.getInstance(this.myProject).getRecentDirectories(), dirName);
            if (!StringUtil.isEmptyOrSpaces((String)dirName) && (dir = LocalFileSystem.getInstance().findFileByPath(dirName)) != null && (module2 = ModuleUtilCore.findModuleForFile((VirtualFile)dir, (Project)this.myProject)) != null) {
                this.myModuleComboBox.setSelectedItem((Object)module2.getName());
            }
            if (myModel.isCustomScope()) {
                this.myRbCustomScope.setSelected(true);
                this.myScopeCombo.setEnabled(true);
                this.myCbWithSubdirectories.setEnabled(false);
                this.myDirectoryComboBox.setEnabled(false);
                this.mySelectDirectoryButton.setEnabled(false);
                this.myModuleComboBox.setEnabled(false);
            } else if (myModel.isProjectScope()) {
                this.myRbProject.setSelected(true);
                this.myCbWithSubdirectories.setEnabled(false);
                this.myDirectoryComboBox.setEnabled(false);
                this.mySelectDirectoryButton.setEnabled(false);
                this.myModuleComboBox.setEnabled(false);
                this.myScopeCombo.setEnabled(false);
            } else if (dirName != null) {
                this.myRbDirectory.setSelected(true);
                this.myCbWithSubdirectories.setEnabled(true);
                this.myDirectoryComboBox.setEnabled(true);
                this.mySelectDirectoryButton.setEnabled(true);
                this.myModuleComboBox.setEnabled(false);
                this.myScopeCombo.setEnabled(false);
            } else if (myModel.getModuleName() != null) {
                this.myRbModule.setSelected(true);
                this.myCbWithSubdirectories.setEnabled(false);
                this.myDirectoryComboBox.setEnabled(false);
                this.mySelectDirectoryButton.setEnabled(false);
                this.myModuleComboBox.setEnabled(true);
                this.myModuleComboBox.setSelectedItem((Object)myModel.getModuleName());
                this.myScopeCombo.setEnabled(false);
                this.myRbModule.setVisible(true);
                this.myModuleComboBox.setVisible(true);
            } else assert (false) : myModel;
            this.myCbWithSubdirectories.setSelected(myModel.isWithSubdirectories());
            if (myModel.getFileFilter() != null && !myModel.getFileFilter().isEmpty()) {
                this.myFileFilter.setSelectedItem((Object)myModel.getFileFilter());
                this.myFileFilter.setEnabled(true);
                this.myUseFileFilter.setSelected(true);
            }
        } else {
            if (myModel.isForward()) {
                this.myRbForward.setSelected(true);
            } else {
                this.myRbBackward.setSelected(true);
            }
            if (myModel.isFromCursor()) {
                this.myRbFromCursor.setSelected(true);
            } else {
                this.myRbEntireScope.setSelected(true);
            }
            if (myModel.isGlobal()) {
                this.myRbGlobal.setSelected(true);
            } else {
                this.myRbSelectedText.setSelected(true);
            }
        }
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance(this.myProject);
        FindDialog.setStringsToComboBox(findInProjectSettings.getRecentFindStrings(), (ComboBox<String>)this.myInputComboBox, myModel.getStringToFind());
        if (myModel.isReplaceState()) {
            this.myCbPreserveCase.setSelected(myModel.isPreserveCase());
            FindDialog.setStringsToComboBox(findInProjectSettings.getRecentReplaceStrings(), (ComboBox<String>)this.myReplaceComboBox, myModel.getStringToReplace());
        }
        this.updateControls();
        boolean isReplaceState = myModel.isReplaceState();
        this.myReplacePrompt.setVisible(isReplaceState);
        this.myReplaceComboBox.setVisible(isReplaceState);
        if (this.myCbToSkipResultsWhenOneUsage != null) {
            this.myCbToSkipResultsWhenOneUsage.setVisible(!isReplaceState);
        }
        this.myCbPreserveCase.setVisible(isReplaceState);
        this.setTitle(this.myHelper.getTitle());
        this.validateFindButton();
    }

    private void navigateToSelectedUsage(JBTable source) {
        int[] rows = source.getSelectedRows();
        List navigations = null;
        for (int row : rows) {
            Object valueAt = source.getModel().getValueAt(row, 0);
            if (!(valueAt instanceof Usage)) continue;
            if (navigations == null) {
                navigations = new SmartList();
            }
            Usage at = (Usage)valueAt;
            navigations.add(at);
        }
        if (navigations != null) {
            this.doCancelAction();
            ((Usage)navigations.get(0)).navigate(true);
            for (int i = 1; i < navigations.size(); ++i) {
                ((Usage)navigations.get(i)).highlightInEditor();
            }
        }
    }

    protected void registerNavigateToSourceShortcutOnComponent(final @NotNull JBTable c, JComponent component) {
        if (c == null) {
            FindDialog.$$$reportNull$$$0(30);
        }
        AnAction anAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                FindDialog.this.navigateToSelectedUsage(c);
            }
        };
        anAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), component, this.myDisposable);
    }

    static {
        PREVIEW_TITLE = UIBundle.message((String)"tool.window.name.preview", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindDialog";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 8: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFilter";
                break;
            }
            case 9: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useFileFilter";
                break;
            }
            case 10: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputComboBox";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindAllAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilterPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFindOptionsPanel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSearchContext";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchContextName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectionPanel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createGlobalScopePanel";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckbox";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopePanel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createOriginPanel";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToFind";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToReplace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "revealWhitespaces";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initCombobox";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleComboBoxValueChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleAnyComboBoxValueChanged";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initFileFilter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValidationInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateFileTypeForEditorComponent";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createCheckbox";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setStringsToComboBox";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setDirectories";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "registerNavigateToSourceShortcutOnComponent";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initFileFilter$13";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NavigateToSourceListener
    extends DoubleClickListener {
        private NavigateToSourceListener() {
        }

        protected boolean onDoubleClick(MouseEvent event) {
            Object source = event.getSource();
            if (!(source instanceof JBTable)) {
                return false;
            }
            FindDialog.this.navigateToSelectedUsage((JBTable)source);
            return true;
        }

        public void installOn(final @NotNull Component c) {
            if (c == null) {
                NavigateToSourceListener.$$$reportNull$$$0(0);
            }
            super.installOn(c);
            if (c instanceof JBTable) {
                String key = "navigate.to.usage";
                JComponent component = (JComponent)c;
                component.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), key);
                component.getActionMap().put(key, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FindDialog.this.navigateToSelectedUsage((JBTable)c);
                    }
                });
                FindDialog.this.registerNavigateToSourceShortcutOnComponent((JBTable)c, component);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/find/impl/FindDialog$NavigateToSourceListener", "installOn"));
        }
    }

    static class UsageTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private final ColoredTableCellRenderer myUsageRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (value instanceof UsageInfo2UsageAdapter) {
                    if (!((UsageInfo2UsageAdapter)value).isValid()) {
                        myUsageRenderer.append(" " + UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    }
                    TextChunk[] text2 = ((UsageInfo2UsageAdapter)value).getPresentation().getText();
                    for (int i = 1; i < text2.length; ++i) {
                        TextChunk textChunk = text2[i];
                        SimpleTextAttributes attributes = this.getAttributes(textChunk);
                        myUsageRenderer.append(textChunk.getText(), attributes);
                    }
                }
                this.setBorder(null);
            }

            @NotNull
            private SimpleTextAttributes getAttributes(@NotNull TextChunk textChunk) {
                if (textChunk == null) {
                    1.$$$reportNull$$$0(0);
                }
                SimpleTextAttributes at = textChunk.getSimpleAttributesIgnoreBackground();
                if (myUseBold) {
                    SimpleTextAttributes simpleTextAttributes = at;
                    if (simpleTextAttributes == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return simpleTextAttributes;
                }
                boolean highlighted = textChunk.getType() != null || at.getFontStyle() == 1;
                SimpleTextAttributes simpleTextAttributes = highlighted ? new SimpleTextAttributes(null, at.getFgColor(), at.getWaveColor(), at.getStyle() & 0xFFFFFFFE | 0x40) : at;
                if (simpleTextAttributes == null) {
                    1.$$$reportNull$$$0(2);
                }
                return simpleTextAttributes;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "textChunk";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/impl/FindDialog$UsageTableCellRenderer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/impl/FindDialog$UsageTableCellRenderer$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAttributes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getAttributes";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        private final ColoredTableCellRenderer myFileAndLineNumber = new ColoredTableCellRenderer(){
            private final SimpleTextAttributes REPEATED_FILE_ATTRIBUTES = new SimpleTextAttributes(0, (Color)new JBColor(0xCCCCCC, 0x5E5E5E));
            private final SimpleTextAttributes ORDINAL_ATTRIBUTES = new SimpleTextAttributes(0, (Color)new JBColor(0x999999, 0x999999));

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (value instanceof UsageInfo2UsageAdapter) {
                    UsageInfo2UsageAdapter usageAdapter = (UsageInfo2UsageAdapter)value;
                    TextChunk[] text2 = usageAdapter.getPresentation().getText();
                    VirtualFile file2 = usageAdapter.getFile();
                    String uniqueVirtualFilePath = this.getFilePath(usageAdapter);
                    VirtualFile prevFile = this.findPrevFile(table, row, column);
                    SimpleTextAttributes attributes = Comparing.equal((Object)file2, (Object)prevFile) ? this.REPEATED_FILE_ATTRIBUTES : this.ORDINAL_ATTRIBUTES;
                    this.append(uniqueVirtualFilePath, attributes);
                    if (text2.length > 0) {
                        this.append(" " + text2[0].getText(), this.ORDINAL_ATTRIBUTES);
                    }
                }
                this.setBorder(null);
            }

            @NotNull
            private String getFilePath(@NotNull UsageInfo2UsageAdapter ua) {
                if (ua == null) {
                    2.$$$reportNull$$$0(0);
                }
                String uniquePath = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(ua.getUsageInfo().getProject(), ua.getFile(), myScope);
                String string = myOmitFileExtension ? FileUtilRt.getNameWithoutExtension((String)uniquePath) : uniquePath;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            private VirtualFile findPrevFile(@NotNull JTable table, int row, int column) {
                if (table == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (row <= 0) {
                    return null;
                }
                Object prev2 = table.getValueAt(row - 1, column);
                return prev2 instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)prev2).getFile() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ua";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/impl/FindDialog$UsageTableCellRenderer$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/impl/FindDialog$UsageTableCellRenderer$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFilePath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getFilePath";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "findPrevFile";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        private static final int MARGIN = 2;
        private final boolean myOmitFileExtension;
        private final boolean myUseBold;
        private final GlobalSearchScope myScope;

        UsageTableCellRenderer(boolean omitFileExtension, boolean useBold, GlobalSearchScope scope) {
            this.myOmitFileExtension = omitFileExtension;
            this.myUseBold = useBold;
            this.myScope = scope;
            this.setLayout(new BorderLayout());
            this.add((Component)this.myUsageRenderer, "Center");
            this.add((Component)this.myFileAndLineNumber, "East");
            this.setBorder((Border)JBUI.Borders.empty((int)2, (int)2, (int)2, (int)0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myUsageRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.myFileAndLineNumber.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBackground(this.myUsageRenderer.getBackground());
            if (!isSelected && value instanceof UsageInfo2UsageAdapter) {
                UsageInfo2UsageAdapter usageAdapter = (UsageInfo2UsageAdapter)value;
                Project project = usageAdapter.getUsageInfo().getProject();
                Color color = VfsPresentationUtil.getFileBackgroundColor(project, usageAdapter.getFile());
                this.setBackground(color);
                this.myUsageRenderer.setBackground(color);
                this.myFileAndLineNumber.setBackground(color);
            }
            return this;
        }
    }
}

