/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.ui.TestsConsoleBuilderImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.StoringPropertyContainer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.DumbAwareToggleBooleanProperty;
import com.intellij.util.config.Storage;
import com.intellij.util.config.ToggleBooleanProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestConsoleProperties
extends StoringPropertyContainer
implements Disposable {
    public static final BooleanProperty SCROLL_TO_STACK_TRACE = new BooleanProperty("scrollToStackTrace", false);
    public static final BooleanProperty SORT_ALPHABETICALLY = new BooleanProperty("sortTestsAlphabetically", false);
    public static final BooleanProperty SORT_BY_DURATION = new BooleanProperty("sortTestsByDuration", false);
    public static final BooleanProperty SELECT_FIRST_DEFECT = new BooleanProperty("selectFirtsDefect", false);
    public static final BooleanProperty TRACK_RUNNING_TEST = new BooleanProperty("trackRunningTest", true);
    public static final BooleanProperty HIDE_IGNORED_TEST = new BooleanProperty("hideIgnoredTests", false);
    public static final BooleanProperty HIDE_PASSED_TESTS = new BooleanProperty("hidePassedTests", true);
    public static final BooleanProperty SCROLL_TO_SOURCE = new BooleanProperty("scrollToSource", false);
    public static final BooleanProperty OPEN_FAILURE_LINE = new BooleanProperty("openFailureLine", true);
    public static final BooleanProperty TRACK_CODE_COVERAGE = new BooleanProperty("trackCodeCoverage", false);
    public static final BooleanProperty SHOW_STATISTICS = new BooleanProperty("showStatistics", false);
    public static final BooleanProperty SHOW_INLINE_STATISTICS = new BooleanProperty("showInlineStatistics", true);
    public static final BooleanProperty INCLUDE_NON_STARTED_IN_RERUN_FAILED = new BooleanProperty("includeNonStarted", true);
    public static final BooleanProperty HIDE_SUCCESSFUL_CONFIG = new BooleanProperty("hideConfig", false);
    private final Project myProject;
    private final Executor myExecutor;
    private ConsoleView myConsole;
    private boolean myUsePredefinedMessageFilter;
    private GlobalSearchScope myScope;
    private boolean myPreservePresentableName;
    protected final Map<AbstractProperty, List<TestFrameworkPropertyListener>> myListeners;

    public TestConsoleProperties(@NotNull Storage storage2, Project project, Executor executor) {
        if (storage2 == null) {
            TestConsoleProperties.$$$reportNull$$$0(0);
        }
        super(storage2);
        this.myUsePredefinedMessageFilter = true;
        this.myPreservePresentableName = false;
        this.myListeners = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myExecutor = executor;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public GlobalSearchScope getScope() {
        if (this.myScope == null) {
            this.myScope = this.initScope();
        }
        GlobalSearchScope globalSearchScope = this.myScope;
        if (globalSearchScope == null) {
            TestConsoleProperties.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    protected GlobalSearchScope initScope() {
        RunProfile configuration = this.getConfiguration();
        if (!(configuration instanceof ModuleRunProfile)) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                TestConsoleProperties.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        Module[] modules = ((ModuleRunProfile)configuration).getModules();
        if (modules.length == 0) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                TestConsoleProperties.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        GlobalSearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
        for (Module each : modules) {
            scope = scope.uniteWith(GlobalSearchScope.moduleRuntimeScope((Module)each, (boolean)true));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            TestConsoleProperties.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    public boolean isPreservePresentableName() {
        return this.myPreservePresentableName;
    }

    public void setPreservePresentableName(boolean preservePresentableName) {
        this.myPreservePresentableName = preservePresentableName;
    }

    public <T> void addListener(@NotNull AbstractProperty<T> property, @NotNull TestFrameworkPropertyListener<T> listener2) {
        ArrayList listeners;
        if (property == null) {
            TestConsoleProperties.$$$reportNull$$$0(5);
        }
        if (listener2 == null) {
            TestConsoleProperties.$$$reportNull$$$0(6);
        }
        if ((listeners = this.myListeners.get(property)) == null) {
            listeners = ContainerUtil.newArrayList();
            this.myListeners.put(property, listeners);
        }
        listeners.add(listener2);
    }

    public <T> void addListenerAndSendValue(@NotNull AbstractProperty<T> property, @NotNull TestFrameworkPropertyListener<T> listener2) {
        if (property == null) {
            TestConsoleProperties.$$$reportNull$$$0(7);
        }
        if (listener2 == null) {
            TestConsoleProperties.$$$reportNull$$$0(8);
        }
        this.addListener(property, listener2);
        listener2.onChanged(property.get((AbstractProperty.AbstractPropertyContainer)this));
    }

    public <T> void removeListener(@NotNull AbstractProperty<T> property, @NotNull TestFrameworkPropertyListener listener2) {
        List<TestFrameworkPropertyListener> listeners;
        if (property == null) {
            TestConsoleProperties.$$$reportNull$$$0(9);
        }
        if (listener2 == null) {
            TestConsoleProperties.$$$reportNull$$$0(10);
        }
        if ((listeners = this.myListeners.get(property)) != null) {
            listeners.remove(listener2);
        }
    }

    public Executor getExecutor() {
        return this.myExecutor;
    }

    public boolean isDebug() {
        return this.myExecutor.getId() == DefaultDebugExecutor.EXECUTOR_ID;
    }

    public boolean isPaused() {
        XDebugSession debuggerSession = XDebuggerManager.getInstance((Project)this.myProject).getDebugSession(this.getConsole());
        return debuggerSession != null && debuggerSession.isPaused();
    }

    @Override
    protected <T> void onPropertyChanged(@NotNull AbstractProperty<T> property, T value) {
        List<TestFrameworkPropertyListener> listeners;
        if (property == null) {
            TestConsoleProperties.$$$reportNull$$$0(11);
        }
        if ((listeners = this.myListeners.get(property)) != null) {
            for (Object o : listeners.toArray()) {
                TestFrameworkPropertyListener listener2 = (TestFrameworkPropertyListener)o;
                listener2.onChanged(value);
            }
        }
    }

    public void setConsole(ConsoleView console) {
        this.myConsole = console;
    }

    public void dispose() {
        this.myListeners.clear();
    }

    public abstract RunProfile getConfiguration();

    public boolean isEditable() {
        return false;
    }

    protected ExecutionConsole getConsole() {
        return this.myConsole;
    }

    @NotNull
    public ConsoleView createConsole() {
        ConsoleView consoleView = new TestsConsoleBuilderImpl(this.getProject(), this.getScope(), !this.isEditable(), this.isUsePredefinedMessageFilter()).getConsole();
        if (consoleView == null) {
            TestConsoleProperties.$$$reportNull$$$0(12);
        }
        return consoleView;
    }

    public boolean isUsePredefinedMessageFilter() {
        return this.myUsePredefinedMessageFilter;
    }

    public void setUsePredefinedMessageFilter(boolean usePredefinedMessageFilter) {
        this.myUsePredefinedMessageFilter = usePredefinedMessageFilter;
    }

    public void appendAdditionalActions(DefaultActionGroup actionGroup, JComponent parent, TestConsoleProperties target2) {
    }

    @Nullable
    protected AnAction createImportAction() {
        return null;
    }

    @NotNull
    protected ToggleBooleanProperty createIncludeNonStartedInRerun(TestConsoleProperties target2) {
        String text2 = ExecutionBundle.message((String)"junit.runing.info.include.non.started.in.rerun.failed.action.name", (Object[])new Object[0]);
        DumbAwareToggleBooleanProperty dumbAwareToggleBooleanProperty = new DumbAwareToggleBooleanProperty(text2, null, null, (AbstractProperty.AbstractPropertyContainer)target2, INCLUDE_NON_STARTED_IN_RERUN_FAILED);
        if (dumbAwareToggleBooleanProperty == null) {
            TestConsoleProperties.$$$reportNull$$$0(13);
        }
        return dumbAwareToggleBooleanProperty;
    }

    @NotNull
    protected ToggleBooleanProperty createHideSuccessfulConfig(TestConsoleProperties target2) {
        String text2 = ExecutionBundle.message((String)"junit.runing.info.hide.successful.config.action.name", (Object[])new Object[0]);
        this.setIfUndefined((AbstractProperty<Boolean>)HIDE_SUCCESSFUL_CONFIG, true);
        DumbAwareToggleBooleanProperty dumbAwareToggleBooleanProperty = new DumbAwareToggleBooleanProperty(text2, null, null, (AbstractProperty.AbstractPropertyContainer)target2, HIDE_SUCCESSFUL_CONFIG);
        if (dumbAwareToggleBooleanProperty == null) {
            TestConsoleProperties.$$$reportNull$$$0(14);
        }
        return dumbAwareToggleBooleanProperty;
    }

    @JdkConstants.TreeSelectionMode
    public int getSelectionMode() {
        return 1;
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        ExecutionTarget executionTarget = DefaultExecutionTarget.INSTANCE;
        if (executionTarget == null) {
            TestConsoleProperties.$$$reportNull$$$0(15);
        }
        return executionTarget;
    }

    @NotNull
    public String getWindowId() {
        String string = this.isDebug() ? ToolWindowId.DEBUG : ToolWindowId.RUN;
        if (string == null) {
            TestConsoleProperties.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/TestConsoleProperties";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/TestConsoleProperties";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createIncludeNonStartedInRerun";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createHideSuccessfulConfig";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionTarget";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addListenerAndSendValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onPropertyChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

