/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeRequestImpl
extends TextMergeRequest {
    @Nullable
    private final Project myProject;
    @NotNull
    private final DocumentContent myOutput;
    @NotNull
    private final List<DocumentContent> myContents;
    @NotNull
    private final CharSequence myOriginalContent;
    @Nullable
    private final String myTitle;
    @NotNull
    private final List<String> myTitles;
    @Nullable
    private final Consumer<MergeResult> myApplyCallback;

    public TextMergeRequestImpl(@Nullable Project project, @NotNull DocumentContent output, @NotNull CharSequence originalContent, @NotNull List<DocumentContent> contents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) {
        if (output == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(0);
        }
        if (originalContent == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(1);
        }
        if (contents == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(2);
        }
        if (contentTitles == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(3);
        }
        assert (contents.size() == 3);
        assert (contentTitles.size() == 3);
        this.myProject = project;
        this.myOutput = output;
        this.myOriginalContent = originalContent;
        this.myContents = contents;
        this.myTitles = contentTitles;
        this.myTitle = title;
        this.myApplyCallback = applyCallback;
        this.onAssigned(true);
    }

    @NotNull
    public DocumentContent getOutputContent() {
        DocumentContent documentContent = this.myOutput;
        if (documentContent == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(4);
        }
        return documentContent;
    }

    @NotNull
    public List<DocumentContent> getContents() {
        List<DocumentContent> list2 = this.myContents;
        if (list2 == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public List<String> getContentTitles() {
        List<String> list2 = this.myTitles;
        if (list2 == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyResult(@NotNull MergeResult result2) {
        if (result2 == null) {
            TextMergeRequestImpl.$$$reportNull$$$0(7);
        }
        try {
            CharSequence applyContent;
            switch (result2) {
                case CANCEL: {
                    applyContent = this.myOriginalContent;
                    break;
                }
                case LEFT: {
                    CharSequence leftContent = ((DocumentContent)ThreeSide.LEFT.select(this.getContents())).getDocument().getImmutableCharSequence();
                    applyContent = StringUtil.convertLineSeparators((String)leftContent.toString());
                    break;
                }
                case RIGHT: {
                    CharSequence rightContent = ((DocumentContent)ThreeSide.RIGHT.select(this.getContents())).getDocument().getImmutableCharSequence();
                    applyContent = StringUtil.convertLineSeparators((String)rightContent.toString());
                    break;
                }
                case RESOLVED: {
                    applyContent = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(result2.toString());
                }
            }
            if (applyContent != null) {
                DiffUtil.executeWriteCommand(this.myOutput.getDocument(), this.myProject, null, () -> this.myOutput.getDocument().setText(applyContent));
            }
            if (this.myApplyCallback != null) {
                this.myApplyCallback.consume((Object)result2);
            }
        }
        finally {
            this.onAssigned(false);
        }
    }

    private void onAssigned(boolean assigned) {
        this.myOutput.onAssigned(assigned);
        for (DocumentContent content : this.myContents) {
            content.onAssigned(assigned);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalContent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTitles";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/requests/TextMergeRequestImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/requests/TextMergeRequestImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTitles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

