/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.KeePassCredentialStore;
import com.intellij.credentialStore.MacOsKeychainLibraryKt;
import com.intellij.credentialStore.PasswordSafeConfigurableKt;
import com.intellij.credentialStore.PasswordSafeConfigurableUi;
import com.intellij.credentialStore.PasswordSafeConfigurableUi$WhenMappings;
import com.intellij.credentialStore.PasswordSafeConfigurableUi$getComponent$;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImplKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import com.intellij.util.text.StringKt;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\b\u0010\u001e\u001a\u00020\u0014H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lcom/intellij/credentialStore/PasswordSafeSettings;", "()V", "inKeePass", "Ljavax/swing/JRadioButton;", "inKeychain", "<set-?>", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "keePassDbFile", "getKeePassDbFile", "()Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "setKeePassDbFile", "(Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;)V", "keePassDbFile$delegate", "Lkotlin/properties/ReadWriteProperty;", "keePassMasterPassword", "Lcom/intellij/ui/components/JBPasswordField;", "modeToRow", "Lgnu/trove/THashMap;", "Lcom/intellij/credentialStore/ProviderType;", "Lcom/intellij/ui/layout/Row;", "rememberPasswordsUntilClosing", "apply", "", "settings", "getComponent", "Ljavax/swing/JPanel;", "getCurrentDbFile", "Ljava/nio/file/Path;", "getProviderType", "isModified", "", "reset", "updateEnabledState", "intellij.platform.credentialStore"})
public final class PasswordSafeConfigurableUi
implements ConfigurableUi<PasswordSafeSettings> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final JRadioButton inKeychain = ComponentsKt.RadioButton("In native Keychain");
    private final JRadioButton inKeePass = ComponentsKt.RadioButton("In KeePass");
    private final JBPasswordField keePassMasterPassword = new JBPasswordField();
    private final ReadWriteProperty keePassDbFile$delegate = Delegates.INSTANCE.notNull();
    private final JRadioButton rememberPasswordsUntilClosing = ComponentsKt.RadioButton("Do not save, forget passwords after restart");
    private final THashMap<ProviderType, Row> modeToRow = new THashMap();

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PasswordSafeConfigurableUi.class), "keePassDbFile", "getKeePassDbFile()Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;"))};
    }

    private final TextFieldWithHistoryWithBrowseButton getKeePassDbFile() {
        return (TextFieldWithHistoryWithBrowseButton)this.keePassDbFile$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setKeePassDbFile(TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton) {
        this.keePassDbFile$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)textFieldWithHistoryWithBrowseButton);
    }

    public void reset(@NotNull PasswordSafeSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        switch (PasswordSafeConfigurableUi$WhenMappings.$EnumSwitchMapping$0[settings.getProviderType().ordinal()]) {
            case 1: {
                this.rememberPasswordsUntilClosing.setSelected(true);
                break;
            }
            case 2: {
                this.inKeychain.setSelected(true);
                break;
            }
            case 3: {
                this.inKeePass.setSelected(true);
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown provider type: " + (Object)((Object)settings.getProviderType()));
            }
        }
        PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
        if (passwordSafe == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.passwordSafe.impl.PasswordSafeImpl");
        }
        CredentialStore currentProvider = ((PasswordSafeImpl)passwordSafe).getCurrentProvider$intellij_platform_credentialStore();
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = this.getKeePassDbFile();
        String string = settings.getState().keepassDb;
        if (string == null) {
            string = currentProvider instanceof KeePassCredentialStore ? ((Object)((KeePassCredentialStore)currentProvider).getDbFile$intellij_platform_credentialStore()).toString() : PasswordSafeConfigurableKt.getDefaultKeePassDbFilePath();
        }
        textFieldWithHistoryWithBrowseButton.setText(string);
        this.updateEnabledState();
    }

    public boolean isModified(@NotNull PasswordSafeSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        if (this.getProviderType() != settings.getProviderType()) {
            return true;
        }
        if (this.getProviderType() == ProviderType.KEEPASS) {
            Object object = ComponentsKt.getChars((JPasswordField)this.keePassMasterPassword);
            if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                return true;
            }
            Path path = this.getCurrentDbFile();
            if (path != null) {
                Object it = object = path;
                PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
                if (passwordSafe == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.passwordSafe.impl.PasswordSafeImpl");
                }
                PasswordSafeImpl passwordSafe2 = (PasswordSafeImpl)passwordSafe;
                CredentialStore credentialStore = passwordSafe2.getCurrentProvider$intellij_platform_credentialStore();
                if (credentialStore == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.credentialStore.KeePassCredentialStore");
                }
                if (Intrinsics.areEqual((Object)((KeePassCredentialStore)credentialStore).getDbFile$intellij_platform_credentialStore(), (Object)it) ^ true) {
                    return true;
                }
            }
        }
        return false;
    }

    public void apply(@NotNull PasswordSafeSettings settings) {
        CredentialStore newProvider;
        byte[] masterPassword;
        byte[] byArray;
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        ProviderType providerType = this.getProviderType();
        PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
        if (passwordSafe == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.passwordSafe.impl.PasswordSafeImpl");
        }
        PasswordSafeImpl passwordSafe2 = (PasswordSafeImpl)passwordSafe;
        CredentialStore provider = passwordSafe2.getCurrentProvider$intellij_platform_credentialStore();
        String string = StringKt.nullize((String)String.valueOf(ComponentsKt.getChars((JPasswordField)this.keePassMasterPassword)), (boolean)true);
        if (string != null) {
            object2 = string;
            object = Charsets.UTF_8;
            String string2 = object2;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string2.getBytes((Charset)object);
            byArray = byArray2;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        } else {
            byArray = masterPassword = null;
        }
        if (settings.getProviderType() != providerType) {
            switch (PasswordSafeConfigurableUi$WhenMappings.$EnumSwitchMapping$1[providerType.ordinal()]) {
                case 1: {
                    if (provider instanceof KeePassCredentialStore) {
                        ((KeePassCredentialStore)provider).setMemoryOnly(true);
                        ((KeePassCredentialStore)provider).deleteFileStorage();
                        break;
                    }
                    provider = new KeePassCredentialStore(null, null, true, null, null, 27, null);
                    break;
                }
                case 2: {
                    CredentialStore credentialStore = provider;
                    if (!(credentialStore instanceof KeePassCredentialStore)) {
                        credentialStore = null;
                    }
                    provider = (CredentialStore)PasswordSafeImplKt.createPersistentCredentialStore$default((KeePassCredentialStore)credentialStore, false, 2, null);
                    break;
                }
                case 3: {
                    object2 = this.getCurrentDbFile();
                    object = masterPassword;
                    provider = new KeePassCredentialStore(null, null, false, (Path)object2, (byte[])object, 7, null);
                    break;
                }
            }
        }
        if ((newProvider = provider) == passwordSafe2.getCurrentProvider$intellij_platform_credentialStore() && newProvider instanceof KeePassCredentialStore) {
            if (masterPassword != null) {
                ((KeePassCredentialStore)newProvider).setMasterPassword(masterPassword);
            }
            Path path = this.getCurrentDbFile();
            if (path != null) {
                Object it = object = path;
                ((KeePassCredentialStore)newProvider).setDbFile$intellij_platform_credentialStore((Path)it);
            }
        }
        settings.setProviderType(providerType);
        settings.getState().keepassDb = newProvider instanceof KeePassCredentialStore ? ((Object)((KeePassCredentialStore)newProvider).getDbFile$intellij_platform_credentialStore()).toString() : (String)null;
        passwordSafe2.setCurrentProvider$intellij_platform_credentialStore(newProvider);
    }

    @Nullable
    public final Path getCurrentDbFile() {
        Path path;
        String string;
        String string2 = this.getKeePassDbFile().getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"keePassDbFile.text");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string4 = StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (boolean)false, (int)1, null);
        if (string4 != null) {
            String it = string = string4;
            path = Paths.get(it, new String[0]);
        } else {
            path = null;
        }
        return path;
    }

    private final void updateEnabledState() {
        block0: {
            Row row = (Row)this.modeToRow.get((Object)ProviderType.KEEPASS);
            if (row == null) break block0;
            row.setSubRowsEnabled(this.getProviderType() == ProviderType.KEEPASS);
        }
    }

    @NotNull
    public JPanel getComponent() {
        Row row$iv;
        CCFlags[] this_$iv;
        Row row$iv2;
        CCFlags[] row$iv3;
        Row $receiver;
        Object label$iv;
        Object this_$iv2;
        Row row$iv4;
        LayoutBuilder builder$iv;
        LayoutBuilder $receiver2;
        PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
        if (passwordSafe == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.passwordSafe.impl.PasswordSafeImpl");
        }
        PasswordSafeImpl passwordSafe2 = (PasswordSafeImpl)passwordSafe;
        this.keePassMasterPassword.setPasswordIsStored(true);
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        LayoutBuilder this_$iv3 = $receiver2 = (builder$iv = LayoutImplKt.createLayoutBuilder(!ArraysKt.contains((Object[])constraints$iv, (Object)((Object)LCFlags.disableMagic))));
        JLabel label$iv2 = null;
        boolean separated$iv = false;
        Row $receiver3 = row$iv4 = this_$iv3.getBuilder().newRow(label$iv2, this_$iv3.getButtonGroup(), separated$iv);
        Row.label$default($receiver3, "Save passwords:", 0, null, null, false, 30, null);
        this_$iv3 = $receiver2;
        ButtonGroup group$iv = new ButtonGroup();
        LayoutBuilder $receiver4 = new LayoutBuilder(this_$iv3.getBuilder(), group$iv);
        if (SystemInfo.isLinux || MacOsKeychainLibraryKt.isMacOsCredentialStoreSupported()) {
            Row row$iv5;
            this_$iv2 = $receiver4;
            label$iv = null;
            boolean separated$iv2 = false;
            $receiver = row$iv5 = ((LayoutBuilder)this_$iv2).getBuilder().newRow((JLabel)label$iv, ((LayoutBuilder)this_$iv2).getButtonGroup(), separated$iv2);
            Cell.invoke$default($receiver, this.inKeychain, new CCFlags[0], 0, null, null, 14, null);
        }
        this_$iv2 = (Map)this.modeToRow;
        label$iv = ProviderType.KEEPASS;
        Object this_$iv4 = $receiver4;
        JLabel label$iv3 = null;
        boolean separated$iv3 = false;
        CCFlags[] $receiver5 = row$iv3 = ((LayoutBuilder)this_$iv4).getBuilder().newRow(label$iv3, ((LayoutBuilder)this_$iv4).getButtonGroup(), separated$iv3);
        Cell.invoke$default((Cell)$receiver5, this.inKeePass, new CCFlags[0], 0, null, null, 14, null);
        CCFlags[] cCFlagsArray = $receiver5;
        String label$iv4 = "Database:";
        Row $receiver6 = row$iv2 = this_$iv.createRow(label$iv4);
        CCFlags[] fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withFileFilter((Condition)getComponent.1.3.2.1.fileChooserDescriptor.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor2, (String)"fileChooserDescriptor");
        this.setKeePassDbFile(Cell.textFieldWithBrowseButton$default($receiver6, "KeePass Database File", null, null, (FileChooserDescriptor)fileChooserDescriptor2, null, getComponent.1.3.2.1.1.INSTANCE, 22, null));
        $receiver6.gearButton(new AnAction("Clear", $receiver4, this, passwordSafe2){
            final /* synthetic */ LayoutBuilder receiver$0$inlined;
            final /* synthetic */ PasswordSafeConfigurableUi this$0;
            final /* synthetic */ PasswordSafeImpl $passwordSafe$inlined;
            {
                this.this$0 = passwordSafeConfigurableUi;
                this.$passwordSafe$inlined = passwordSafeImpl;
                this.receiver$0$inlined = layoutBuilder;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                MessageDialogBuilder messageDialogBuilder = MessageDialogBuilder.yesNo((String)"Clear Passwords", (String)"Are you sure want to remove all passwords?").yesText("Remove Passwords");
                Intrinsics.checkExpressionValueIsNotNull((Object)messageDialogBuilder, (String)"MessageDialogBuilder.yes\u2026sText(\"Remove Passwords\")");
                if (((MessageDialogBuilder.YesNo)messageDialogBuilder).isYes()) {
                    this.$passwordSafe$inlined.clearPasswords();
                }
            }
        }, new AnAction((FileChooserDescriptor)fileChooserDescriptor2, "Import", $receiver4, this, passwordSafe2){
            final /* synthetic */ LayoutBuilder receiver$0$inlined;
            final /* synthetic */ FileChooserDescriptor $fileChooserDescriptor;
            final /* synthetic */ PasswordSafeConfigurableUi this$0;
            final /* synthetic */ PasswordSafeImpl $passwordSafe$inlined;
            {
                this.$fileChooserDescriptor = $captured_local_variable$1;
                this.this$0 = passwordSafeConfigurableUi;
                this.$passwordSafe$inlined = passwordSafeImpl;
                this.receiver$0$inlined = layoutBuilder;
                super($super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                FileChooserDescriptor fileChooserDescriptor2 = this.$fileChooserDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor2, (String)"fileChooserDescriptor");
                this.receiver$0$inlined.chooseFile(fileChooserDescriptor2, event, (Function1<? super VirtualFile, Unit>)((Function1)new Function1<VirtualFile, Unit>(this, event){
                    final /* synthetic */ getComponent$$inlined$panel$lambda$2 this$0;
                    final /* synthetic */ AnActionEvent $event;
                    {
                        this.this$0 = var1_1;
                        this.$event = anActionEvent;
                        super(1);
                    }

                    public final void invoke(@NotNull VirtualFile it) {
                        block9: {
                            String string;
                            String string2;
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            Path wantedDbFile = Paths.get(PasswordSafeConfigurableKt.access$normalizeSelectedFile(it), new String[0]);
                            Path dbFile = this.this$0.this$0.getCurrentDbFile();
                            if (!(Intrinsics.areEqual((Object)dbFile, (Object)wantedDbFile) ^ true)) break block9;
                            Object object = this.$event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.awt.Component");
                            }
                            Component contextComponent = (Component)object;
                            String string3 = Messages.showInputDialog((Component)contextComponent, (String)"Master Password:", (String)"Specify Master Password", null);
                            if (string3 != null) {
                                String string4 = string2 = string3;
                                if (string4 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                            } else {
                                string = null;
                            }
                            String string5 = StringKt.nullize$default(string, (boolean)false, (int)1, null);
                            if (string5 != null) {
                                block8: {
                                    String masterPassword = string2 = string5;
                                    try {
                                        KeePassCredentialStore keePassCredentialStore;
                                        Files.copy(wantedDbFile, dbFile, StandardCopyOption.REPLACE_EXISTING);
                                        Object object2 = masterPassword;
                                        boolean bl = false;
                                        Path path = null;
                                        Map map2 = null;
                                        KeePassCredentialStore keePassCredentialStore2 = keePassCredentialStore;
                                        KeePassCredentialStore keePassCredentialStore3 = keePassCredentialStore;
                                        PasswordSafeImpl passwordSafeImpl = this.this$0.$passwordSafe$inlined;
                                        Object object3 = Charsets.UTF_8;
                                        String string6 = object2;
                                        if (string6 == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                        }
                                        byte[] byArray = string6.getBytes((Charset)object3);
                                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                                        byte[] byArray2 = byArray;
                                        object2 = this.this$0.this$0.getCurrentDbFile();
                                        object3 = byArray2;
                                        keePassCredentialStore2(map2, path, bl, (Path)object2, (byte[])object3, 7, null);
                                        passwordSafeImpl.setCurrentProvider$intellij_platform_credentialStore(keePassCredentialStore3);
                                    }
                                    catch (Exception e) {
                                        CredentialStoreKt.getLOG().error((Throwable)e);
                                        if (!Intrinsics.areEqual((Object)e.getMessage(), (Object)"Inconsistent stream bytes")) break block8;
                                        Messages.showMessageDialog((Component)contextComponent, (String)(Intrinsics.areEqual((Object)e.getMessage(), (Object)"Inconsistent stream bytes") ? "Password is not correct" : "Internal error"), (String)"Cannot Import", (Icon)Messages.getErrorIcon());
                                    }
                                }
                                PasswordSafeConfigurableUi.access$getKeePassMasterPassword$p(this.this$0.this$0).setText("");
                            }
                        }
                    }
                }));
            }
        });
        this_$iv = $receiver5;
        label$iv4 = "Master Password:";
        $receiver6 = row$iv2 = this_$iv.createRow(label$iv4);
        fileChooserDescriptor2 = new CCFlags[]{};
        GrowPolicy growPolicy = null;
        int n = 0;
        String string = SystemInfo.isWindows ? null : "Stored using weak encryption. It is recommended to store on encrypted volume for additional security.";
        Cell.invoke$default($receiver6, (JComponent)this.keePassMasterPassword, fileChooserDescriptor2, n, growPolicy, string, 6, null);
        this_$iv4 = row$iv3;
        this_$iv2.put(label$iv, this_$iv4);
        this_$iv2 = $receiver4;
        label$iv = null;
        boolean separated$iv4 = false;
        $receiver = row$iv = ((LayoutBuilder)this_$iv2).getBuilder().newRow((JLabel)label$iv, ((LayoutBuilder)this_$iv2).getButtonGroup(), separated$iv4);
        String comment = null;
        CredentialStore currentProvider = passwordSafe2.getCurrentProvider$intellij_platform_credentialStore();
        if (currentProvider instanceof KeePassCredentialStore && !((KeePassCredentialStore)currentProvider).getMemoryOnly()) {
            comment = "Existing KeePass file will be removed.";
        }
        cCFlagsArray = new CCFlags[]{};
        GrowPolicy growPolicy2 = null;
        int n2 = 0;
        String string2 = comment;
        Cell.invoke$default($receiver, this.rememberPasswordsUntilClosing, cCFlagsArray, n2, growPolicy2, string2, 6, null);
        ActionListener listener$iv = new ActionListener(this, passwordSafe2){
            final /* synthetic */ PasswordSafeConfigurableUi this$0;
            final /* synthetic */ PasswordSafeImpl $passwordSafe$inlined;
            {
                this.this$0 = passwordSafeConfigurableUi;
                this.$passwordSafe$inlined = passwordSafeImpl;
            }

            public final void actionPerformed(ActionEvent it) {
                PasswordSafeConfigurableUi.access$updateEnabledState(this.this$0);
            }
        };
        Enumeration<AbstractButton> enumeration = group$iv.getElements();
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"group.elements");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            AbstractButton button$iv = (AbstractButton)iterator.next();
            button$iv.addActionListener(listener$iv);
        }
        JPanel panel$iv = ComponentsKt.Panel(title$iv, null);
        builder$iv.getBuilder().build(panel$iv, constraints$iv);
        return panel$iv;
    }

    private final ProviderType getProviderType() {
        return this.rememberPasswordsUntilClosing.isSelected() ? ProviderType.MEMORY_ONLY : (this.inKeePass.isSelected() ? ProviderType.KEEPASS : ProviderType.KEYCHAIN);
    }

    public static final /* synthetic */ void access$updateEnabledState(PasswordSafeConfigurableUi $this) {
        $this.updateEnabledState();
    }

    @NotNull
    public static final /* synthetic */ JBPasswordField access$getKeePassMasterPassword$p(PasswordSafeConfigurableUi $this) {
        return $this.keePassMasterPassword;
    }
}

