/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeContentChangedHandler;
import com.intellij.configurationStore.SchemeDataHolderImpl;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.SchemeManagerImplKt;
import com.intellij.configurationStore.StoreAwareProjectManager;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.SchemeChangeEvent;
import com.intellij.configurationStore.schemeManager.SchemeFileTracker;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0004%&'(B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0016J\"\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J \u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0002J\u001b\u0010 \u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeFileTracker;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "schemeManager", "Lcom/intellij/configurationStore/SchemeManagerImpl;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/configurationStore/SchemeManagerImpl;Lcom/intellij/openapi/project/Project;)V", "projectManager", "Lcom/intellij/configurationStore/StoreAwareProjectManager;", "getProjectManager", "()Lcom/intellij/configurationStore/StoreAwareProjectManager;", "projectManager$delegate", "Lkotlin/Lazy;", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "callSchemeContentChangedIfSupported", "", "changedScheme", "fileName", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findExternalizableSchemeByFileName", "isMy", "isMyDirectory", "parent", "readSchemeFromFile", "schemes", "reload", "", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "reload$intellij_platform_configurationStore_impl", "schemeCreatedExternally", "AddScheme", "RemoveAllSchemes", "RemoveScheme", "UpdateScheme", "intellij.platform.configurationStore.impl"})
public final class SchemeFileTracker
implements BulkFileListener {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy projectManager$delegate;
    private final SchemeManagerImpl<Object, Object> schemeManager;
    private final Project project;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SchemeFileTracker.class), "projectManager", "getProjectManager()Lcom/intellij/configurationStore/StoreAwareProjectManager;"))};
    }

    private final boolean isMy(VirtualFile file2) {
        CharSequence charSequence = file2.getNameSequence();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"file.nameSequence");
        return this.schemeManager.canRead(charSequence);
    }

    private final boolean isMyDirectory(VirtualFile parent) {
        VirtualFile virtualFile = this.schemeManager.getCachedVirtualDirectory$intellij_platform_configurationStore_impl();
        VirtualFile it = virtualFile;
        return it == null ? Intrinsics.areEqual((Object)PathKt.getSystemIndependentPath((Path)this.schemeManager.getIoDirectory$intellij_platform_configurationStore_impl()), (Object)parent.getPath()) : Intrinsics.areEqual((Object)it, (Object)parent);
    }

    private final Object findExternalizableSchemeByFileName(String fileName) {
        Object v2;
        block1: {
            Iterable $receiver$iv = (Iterable)this.schemeManager.getSchemes$intellij_platform_configurationStore_impl();
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                StringBuilder stringBuilder = new StringBuilder();
                Object t = it;
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"it");
                if (!Intrinsics.areEqual((Object)fileName, (Object)stringBuilder.append(this.schemeManager.getFileName$intellij_platform_configurationStore_impl(t)).append(this.schemeManager.getSchemeExtension$intellij_platform_configurationStore_impl()).toString())) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private final StoreAwareProjectManager getProjectManager() {
        Lazy lazy = this.projectManager$delegate;
        SchemeFileTracker schemeFileTracker = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (StoreAwareProjectManager)((Object)lazy.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object readSchemeFromFile(VirtualFile file2, List<Object> schemes) {
        String string = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        String fileName = string;
        if (file2.isDirectory() || !this.schemeManager.canRead(fileName)) {
            return null;
        }
        try {
            Object object;
            String it = fileName;
            Closeable closeable = file2.getInputStream();
            Throwable throwable = null;
            try {
                InputStream it2;
                InputStream inputStream = it2 = (InputStream)closeable;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it");
                object = SchemeManagerImpl.loadScheme$intellij_platform_configurationStore_impl$default(this.schemeManager, fileName, inputStream, schemes, null, 8, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return object;
        }
        catch (Throwable e$iv) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme " + fileName, e$iv);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void reload$intellij_platform_configurationStore_impl(@NotNull Collection<? extends SchemeChangeEvent> events) {
        void newActiveScheme;
        Intrinsics.checkParameterIsNotNull(events, (String)"events");
        Object oldActiveScheme = this.schemeManager.getActiveScheme();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        SchemeProcessor processor2 = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl();
        Iterator<? extends SchemeChangeEvent> iterator = events.iterator();
        while (iterator.hasNext()) {
            Object newScheme;
            Function0<Boolean> isNewActiveScheme$;
            Object object;
            Object it;
            String fileName;
            VirtualFile file2;
            SchemeChangeEvent event;
            SchemeChangeEvent schemeChangeEvent;
            SchemeChangeEvent $receiver = schemeChangeEvent = (event = iterator.next());
            $receiver.execute(this);
            if (!(event instanceof UpdateScheme) || !(file2 = ((UpdateScheme)event).getFile()).isValid()) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2.getName(), (String)"file.name");
            Object changedScheme = this.findExternalizableSchemeByFileName(fileName);
            if (this.callSchemeContentChangedIfSupported(changedScheme, fileName, file2)) continue;
            if (changedScheme != null) {
                Object object2;
                it = object2;
                this.schemeManager.removeScheme(it);
                processor2.onSchemeDeleted(it);
            }
            if (this.readSchemeFromFile(file2, (List)this.schemeManager.getSchemes$intellij_platform_configurationStore_impl()) != null) {
                Object it2 = it;
                processor2.initScheme(it2);
                processor2.onSchemeAdded(it2);
                object = it2;
            } else {
                object = null;
            }
            if (!(isNewActiveScheme$ = new Function0<Boolean>(this, (Ref.ObjectRef)newActiveScheme, oldActiveScheme, newScheme = object, processor2, changedScheme){
                final /* synthetic */ SchemeFileTracker this$0;
                final /* synthetic */ Ref.ObjectRef $newActiveScheme;
                final /* synthetic */ Object $oldActiveScheme;
                final /* synthetic */ Object $newScheme;
                final /* synthetic */ SchemeProcessor $processor;
                final /* synthetic */ Object $changedScheme;

                public final boolean invoke() {
                    if (this.$newActiveScheme.element != null) {
                        return false;
                    }
                    if (this.$oldActiveScheme == null) {
                        return this.$newScheme != null && Intrinsics.areEqual((Object)SchemeFileTracker.access$getSchemeManager$p(this.this$0).getCurrentPendingSchemeName$intellij_platform_configurationStore_impl(), (Object)this.$processor.getSchemeKey(this.$newScheme));
                    }
                    return this.$changedScheme == this.$oldActiveScheme;
                }
                {
                    this.this$0 = schemeFileTracker;
                    this.$newActiveScheme = objectRef;
                    this.$oldActiveScheme = object;
                    this.$newScheme = object2;
                    this.$processor = schemeProcessor;
                    this.$changedScheme = object3;
                    super(0);
                }
            }).invoke()) continue;
            newActiveScheme.element = newScheme;
        }
        if (newActiveScheme.element != null) {
            this.schemeManager.setActiveScheme$intellij_platform_configurationStore_impl(newActiveScheme.element);
            processor2.onCurrentSchemeSwitched(oldActiveScheme, newActiveScheme.element);
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkParameterIsNotNull(events, (String)"events");
        Function1<SchemeChangeEvent, Unit> registerChange$ = new Function1<SchemeChangeEvent, Unit>(this){
            final /* synthetic */ SchemeFileTracker this$0;

            public final void invoke(@NotNull SchemeChangeEvent schemeEvent) {
                Intrinsics.checkParameterIsNotNull((Object)schemeEvent, (String)"schemeEvent");
                if (SchemeFileTracker.access$getProject$p(this.this$0) == null) {
                    this.this$0.reload$intellij_platform_configurationStore_impl(CollectionsKt.listOf((Object)schemeEvent));
                } else {
                    SchemeFileTracker.access$getProjectManager$p(this.this$0).registerChangedScheme$intellij_platform_configurationStore_impl(schemeEvent, this.this$0, SchemeFileTracker.access$getProject$p(this.this$0));
                }
            }
            {
                this.this$0 = schemeFileTracker;
                super(1);
            }
        };
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent.getRequestor() instanceof SchemeManagerImpl) continue;
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFileContentChangeEvent) {
                VirtualFile virtualFile = ((VFileContentChangeEvent)vFileEvent).getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                String string = virtualFile.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.file.name");
                if (!this.schemeManager.canRead(string)) continue;
                VirtualFile virtualFile2 = ((VFileContentChangeEvent)vFileEvent).getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"event.file");
                VirtualFile virtualFile3 = virtualFile2.getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"event.file.parent");
                if (!this.isMyDirectory(virtualFile3)) continue;
                VirtualFile virtualFile4 = ((VFileContentChangeEvent)vFileEvent).getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"event.file");
                registerChange$.invoke((SchemeChangeEvent)new UpdateScheme(virtualFile4));
                continue;
            }
            if (vFileEvent2 instanceof VFileCreateEvent) {
                String string = ((VFileCreateEvent)vFileEvent).getChildName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.childName");
                if (this.schemeManager.canRead(string)) {
                    VirtualFile virtualFile = ((VFileCreateEvent)vFileEvent).getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.parent");
                    if (!this.isMyDirectory(virtualFile)) continue;
                    if (((VFileCreateEvent)vFileEvent).getFile() != null) {
                        VirtualFile virtualFile5;
                        VirtualFile it;
                        VirtualFile virtualFile6 = it = virtualFile5;
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile6, (String)"it");
                        registerChange$.invoke((SchemeChangeEvent)new AddScheme(virtualFile6));
                    }
                    continue;
                }
                VirtualFile virtualFile = ((VFileCreateEvent)vFileEvent).getFile();
                if (virtualFile == null) continue;
                if (!virtualFile.isDirectory()) continue;
                VirtualFile dir = this.schemeManager.getVirtualDirectory$intellij_platform_configurationStore_impl();
                if (!Intrinsics.areEqual((Object)((VFileCreateEvent)vFileEvent).getFile(), (Object)dir)) continue;
                VirtualFile virtualFile7 = dir;
                if (virtualFile7 == null) {
                    Intrinsics.throwNpe();
                }
                VirtualFile[] virtualFileArray = virtualFile7.getChildren();
                int n = virtualFileArray.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile file2;
                    VirtualFile virtualFile8 = file2 = virtualFileArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile8, (String)"file");
                    if (!this.isMy(virtualFile8)) continue;
                    registerChange$.invoke((SchemeChangeEvent)new AddScheme(file2));
                }
                continue;
            }
            if (!(vFileEvent2 instanceof VFileDeleteEvent)) continue;
            VirtualFile virtualFile = ((VFileDeleteEvent)vFileEvent).getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
            if (virtualFile.isDirectory()) {
                if (!Intrinsics.areEqual((Object)((VFileDeleteEvent)vFileEvent).getFile(), (Object)this.schemeManager.getVirtualDirectory$intellij_platform_configurationStore_impl())) continue;
                registerChange$.invoke((SchemeChangeEvent)new RemoveAllSchemes());
                continue;
            }
            VirtualFile virtualFile9 = ((VFileDeleteEvent)vFileEvent).getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile9, (String)"event.file");
            if (!this.isMy(virtualFile9)) continue;
            VirtualFile virtualFile10 = ((VFileDeleteEvent)vFileEvent).getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile10, (String)"event.file");
            VirtualFile virtualFile11 = virtualFile10.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile11, (String)"event.file.parent");
            if (!this.isMyDirectory(virtualFile11)) continue;
            VirtualFile virtualFile12 = ((VFileDeleteEvent)vFileEvent).getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile12, (String)"event.file");
            String string = virtualFile12.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.file.name");
            registerChange$.invoke((SchemeChangeEvent)new RemoveScheme(string));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean callSchemeContentChangedIfSupported(Object changedScheme, String fileName, VirtualFile file2) {
        if (changedScheme == null || !(this.schemeManager.getProcessor$intellij_platform_configurationStore_impl() instanceof SchemeContentChangedHandler) || !(this.schemeManager.getProcessor$intellij_platform_configurationStore_impl() instanceof LazySchemeProcessor)) {
            return false;
        }
        ExternalInfo externalInfo = (ExternalInfo)this.schemeManager.getSchemeToInfo$intellij_platform_configurationStore_impl().get(changedScheme);
        if (externalInfo == null) {
            return false;
        }
        ExternalInfo externalInfo2 = externalInfo;
        try {
            void parser;
            String it = fileName;
            byte[] byArray = file2.contentsToByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"file.contentsToByteArray()");
            byte[] bytes = byArray;
            boolean isOldSchemeNaming$iv = this.schemeManager.isOldSchemeNaming$intellij_platform_configurationStore_impl();
            MXParser parser$iv = new MXParser();
            Object object = bytes;
            MXParser mXParser = parser$iv;
            Closeable closeable = new ByteArrayInputStream((byte[])object);
            object = closeable;
            Charset charset = Charsets.UTF_8;
            closeable = new InputStreamReader((InputStream)object, charset);
            mXParser.setInput((Reader)closeable);
            XmlPullParser xmlPullParser = (XmlPullParser)parser$iv;
            String name = SchemeLoaderKt.access$preload(isOldSchemeNaming$iv, parser$iv);
            Function attributeProvider2 = new Function<String, String>((XmlPullParser)parser){
                final /* synthetic */ XmlPullParser $parser;

                public final String apply(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$parser.getAttributeValue(null, it);
                }
                {
                    this.$parser = xmlPullParser;
                }
            };
            String string = name;
            if (string == null) {
                LazySchemeProcessor lazySchemeProcessor = (LazySchemeProcessor)this.schemeManager.getProcessor$intellij_platform_configurationStore_impl();
                String string2 = FileUtilRt.getNameWithoutExtension((String)fileName);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtilRt.getNameWithoutExtension(fileName)");
                string = lazySchemeProcessor.getSchemeKey(attributeProvider2, string2);
            }
            if (string == null) {
                throw (Throwable)SchemeManagerImplKt.nameIsMissed(bytes);
            }
            String schemeName = string;
            SchemeDataHolderImpl dataHolder = new SchemeDataHolderImpl(this.schemeManager.getProcessor$intellij_platform_configurationStore_impl(), bytes, externalInfo2);
            SchemeProcessor schemeProcessor = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl();
            if (schemeProcessor == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.SchemeContentChangedHandler<kotlin.Any>");
            }
            ((SchemeContentChangedHandler)((Object)schemeProcessor)).schemeContentChanged(changedScheme, schemeName, dataHolder);
            return true;
        }
        catch (Throwable e$iv) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme " + fileName, e$iv);
            return false;
        }
    }

    private final void schemeCreatedExternally(VirtualFile file2) {
        SmartList newSchemes = new SmartList();
        Object readScheme = this.readSchemeFromFile(file2, (List)newSchemes);
        if (readScheme != null) {
            String readSchemeKey = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(readScheme);
            Object existingScheme = this.schemeManager.findSchemeByName(readSchemeKey);
            if (existingScheme != null && this.schemeManager.getSchemeListManager$intellij_platform_configurationStore_impl().getReadOnlyExternalizableSchemes().get(this.schemeManager.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(existingScheme)) != existingScheme) {
                ComponentStoreImplKt.getLOG().warn("Ignore incorrect VFS create scheme event: schema " + readSchemeKey + " is already exists");
                return;
            }
            this.schemeManager.getSchemes$intellij_platform_configurationStore_impl().addAll((Collection)newSchemes);
            this.schemeManager.getProcessor$intellij_platform_configurationStore_impl().initScheme(readScheme);
            this.schemeManager.getProcessor$intellij_platform_configurationStore_impl().onSchemeAdded(readScheme);
        }
    }

    public SchemeFileTracker(@NotNull SchemeManagerImpl<Object, Object> schemeManager2, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull(schemeManager2, (String)"schemeManager");
        this.schemeManager = schemeManager2;
        this.project = project;
        this.projectManager$delegate = LazyKt.lazy((Function0)projectManager.2.INSTANCE);
    }

    @Nullable
    public static final /* synthetic */ Project access$getProject$p(SchemeFileTracker $this) {
        return $this.project;
    }

    @NotNull
    public static final /* synthetic */ StoreAwareProjectManager access$getProjectManager$p(SchemeFileTracker $this) {
        return $this.getProjectManager();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeFileTracker$RemoveAllSchemes;", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "()V", "execute", "", "Lcom/intellij/configurationStore/schemeManager/SchemeFileTracker;", "intellij.platform.configurationStore.impl"})
    private static final class RemoveAllSchemes
    implements SchemeChangeEvent {
        @Override
        public void execute(@NotNull SchemeFileTracker $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            $receiver.schemeManager.setCachedVirtualDirectory$intellij_platform_configurationStore_impl(null);
            $receiver.schemeManager.removeExternalizableSchemes$intellij_platform_configurationStore_impl();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeFileTracker$RemoveScheme;", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "fileName", "", "(Ljava/lang/String;)V", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "execute", "", "Lcom/intellij/configurationStore/schemeManager/SchemeFileTracker;", "intellij.platform.configurationStore.impl"})
    private static final class RemoveScheme
    implements SchemeChangeEvent {
        private final String fileName;

        @Override
        public void execute(@NotNull SchemeFileTracker $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Object scheme2 = $receiver.findExternalizableSchemeByFileName(this.fileName);
            if (scheme2 != null) {
                $receiver.schemeManager.removeScheme(scheme2);
                $receiver.schemeManager.getProcessor$intellij_platform_configurationStore_impl().onSchemeDeleted(scheme2);
            }
        }

        public RemoveScheme(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            this.fileName = fileName;
        }

        private final String component1() {
            return this.fileName;
        }

        @NotNull
        public final RemoveScheme copy(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            return new RemoveScheme(fileName);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ RemoveScheme copy$default(RemoveScheme removeScheme2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = removeScheme2.fileName;
            }
            return removeScheme2.copy(string);
        }

        public String toString() {
            return "RemoveScheme(fileName=" + this.fileName + ")";
        }

        public int hashCode() {
            String string = this.fileName;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RemoveScheme)) break block3;
                    RemoveScheme removeScheme2 = (RemoveScheme)object;
                    if (!Intrinsics.areEqual((Object)this.fileName, (Object)removeScheme2.fileName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeFileTracker$AddScheme;", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "execute", "", "Lcom/intellij/configurationStore/schemeManager/SchemeFileTracker;", "intellij.platform.configurationStore.impl"})
    private static final class AddScheme
    implements SchemeChangeEvent {
        private final VirtualFile file;

        @Override
        public void execute(@NotNull SchemeFileTracker $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            if (this.file.isValid()) {
                $receiver.schemeCreatedExternally(this.file);
            }
        }

        public AddScheme(@NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            this.file = file2;
        }

        private final VirtualFile component1() {
            return this.file;
        }

        @NotNull
        public final AddScheme copy(@NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            return new AddScheme(file2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ AddScheme copy$default(AddScheme addScheme, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = addScheme.file;
            }
            return addScheme.copy(virtualFile);
        }

        public String toString() {
            return "AddScheme(file=" + this.file + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile = this.file;
            return virtualFile != null ? virtualFile.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AddScheme)) break block3;
                    AddScheme addScheme = (AddScheme)object;
                    if (!Intrinsics.areEqual((Object)this.file, (Object)addScheme.file)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeFileTracker$UpdateScheme;", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "execute", "", "Lcom/intellij/configurationStore/schemeManager/SchemeFileTracker;", "intellij.platform.configurationStore.impl"})
    private static final class UpdateScheme
    implements SchemeChangeEvent {
        @NotNull
        private final VirtualFile file;

        @Override
        public void execute(@NotNull SchemeFileTracker $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public UpdateScheme(@NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            this.file = file2;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        @NotNull
        public final UpdateScheme copy(@NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            return new UpdateScheme(file2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ UpdateScheme copy$default(UpdateScheme updateScheme, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = updateScheme.file;
            }
            return updateScheme.copy(virtualFile);
        }

        public String toString() {
            return "UpdateScheme(file=" + this.file + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile = this.file;
            return virtualFile != null ? virtualFile.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UpdateScheme)) break block3;
                    UpdateScheme updateScheme = (UpdateScheme)object;
                    if (!Intrinsics.areEqual((Object)this.file, (Object)updateScheme.file)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

