/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.IndentTransferableData;
import com.intellij.codeInsight.editorActions.PreserveIndentOnPasteBean;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CopyPasteIndentProcessor
extends CopyPastePostProcessor<IndentTransferableData> {
    @Override
    @NotNull
    public List<IndentTransferableData> collectTransferableData(PsiFile file2, Editor editor, int[] startOffsets, int[] endOffsets) {
        if (!CopyPasteIndentProcessor.acceptFileType(file2.getFileType())) {
            List<IndentTransferableData> list2 = Collections.emptyList();
            if (list2 == null) {
                CopyPasteIndentProcessor.$$$reportNull$$$0(0);
            }
            return list2;
        }
        List<IndentTransferableData> list3 = Collections.singletonList(new IndentTransferableData(editor.getCaretModel().getOffset()));
        if (list3 == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(1);
        }
        return list3;
    }

    private static boolean acceptFileType(FileType fileType) {
        for (PreserveIndentOnPasteBean bean : (PreserveIndentOnPasteBean[])Extensions.getExtensions(PreserveIndentOnPasteBean.EP_NAME)) {
            if (!fileType.getName().equals(bean.fileType)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<IndentTransferableData> extractTransferableData(Transferable content) {
        IndentTransferableData indentData = new IndentTransferableData(-1);
        try {
            Object transferData;
            DataFlavor flavor = IndentTransferableData.getDataFlavorStatic();
            if (flavor != null && (transferData = content.getTransferData(flavor)) instanceof IndentTransferableData) {
                indentData = (IndentTransferableData)transferData;
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        List<IndentTransferableData> list2 = Collections.singletonList(indentData);
        if (list2 == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    public void processTransferableData(final Project project, final Editor editor, final RangeMarker bounds, final int caretOffset, final Ref<Boolean> indented, List<IndentTransferableData> values) {
        if (!CodeInsightSettings.getInstance().INDENT_TO_CARET_ON_PASTE) {
            return;
        }
        assert (values.size() == 1);
        if (values.get(0).getOffset() == caretOffset) {
            return;
        }
        final Document document = editor.getDocument();
        final PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null || !CopyPasteIndentProcessor.acceptFileType(psiFile.getFileType())) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                final boolean useTabs = CodeStyle.getSettings((PsiFile)psiFile).useTabCharacter(psiFile.getFileType());
                CharFilter NOT_INDENT_FILTER = new CharFilter(){

                    public boolean accept(char ch) {
                        return useTabs ? ch != '\t' : ch != ' ';
                    }
                };
                String pastedText = document.getText(TextRange.create((Segment)bounds));
                int startLine = document.getLineNumber(bounds.getStartOffset());
                int endLine = document.getLineNumber(bounds.getEndOffset());
                int fromIndent = StringUtil.findFirst((CharSequence)pastedText, (CharFilter)NOT_INDENT_FILTER);
                if (fromIndent < 0) {
                    fromIndent = 0;
                }
                String initialText = document.getText(TextRange.create((int)0, (int)bounds.getStartOffset())) + document.getText(TextRange.create((int)bounds.getEndOffset(), (int)document.getTextLength()));
                int toIndent = 0;
                if (initialText.length() > 0) {
                    DocumentImpl initialDocument = new DocumentImpl(initialText);
                    int lineNumber = initialDocument.getTextLength() > caretOffset ? initialDocument.getLineNumber(caretOffset) : initialDocument.getLineCount() - 1;
                    int offset = CopyPasteIndentProcessor.getLineStartSafeOffset(initialDocument, lineNumber);
                    if (bounds.getStartOffset() == offset) {
                        String toString = initialDocument.getText(TextRange.create((int)offset, (int)initialDocument.getLineEndOffset(lineNumber)));
                        toIndent = StringUtil.findFirst((CharSequence)toString, (CharFilter)NOT_INDENT_FILTER);
                        if (toIndent < 0 && StringUtil.isEmptyOrSpaces((String)toString)) {
                            toIndent = toString.length();
                        } else if ((toIndent < 0 || toString.startsWith("\n")) && initialText.length() >= caretOffset) {
                            toIndent = caretOffset - offset;
                        }
                    } else {
                        if (this.isNotApplicable(initialDocument, offset)) {
                            return;
                        }
                        ++startLine;
                        toIndent = Math.abs(bounds.getStartOffset() - offset);
                    }
                }
                int indent = toIndent - fromIndent;
                if (useTabs) {
                    indent *= CodeStyle.getSettings((PsiFile)psiFile).getTabSize(psiFile.getFileType());
                }
                if (!StringUtil.startsWithWhitespace((String)pastedText) && !StringUtil.endsWithLineBreak((CharSequence)pastedText) && StringUtil.splitByLines((String)pastedText).length <= 1) {
                    return;
                }
                if (pastedText.endsWith("\n")) {
                    --endLine;
                }
                for (int i = startLine; i <= endLine; ++i) {
                    EditorActionUtil.indentLine(project, editor, i, indent);
                }
                indented.set((Object)Boolean.TRUE);
            }

            private boolean isNotApplicable(DocumentImpl initialDocument, int offset) {
                return caretOffset < initialDocument.getTextLength() && !StringUtil.isEmptyOrSpaces((String)initialDocument.getText(TextRange.create((int)offset, (int)caretOffset)));
            }
        });
    }

    private static int getLineStartSafeOffset(Document document, int line) {
        if (line >= document.getLineCount()) {
            return document.getTextLength();
        }
        return document.getLineStartOffset(line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInsight/editorActions/CopyPasteIndentProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

