/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.encoding;

import com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReference;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlEncodingReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReferenceProvider");
    @NonNls
    private static final String CHARSET_PREFIX = "charset=";

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            XmlEncodingReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            XmlEncodingReferenceProvider.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(element instanceof XmlAttributeValue);
        XmlAttributeValue value = (XmlAttributeValue)element;
        PsiReference[] psiReferenceArray = new PsiReference[]{new XmlEncodingReference(value, value.getValue(), XmlEncodingReferenceProvider.xmlAttributeValueRange(value), 0)};
        if (psiReferenceArray == null) {
            XmlEncodingReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    protected static TextRange xmlAttributeValueRange(XmlAttributeValue xmlAttributeValue) {
        ASTNode valueNode = XmlChildRole.ATTRIBUTE_VALUE_VALUE_FINDER.findChild(xmlAttributeValue.getNode());
        XmlAttributeValue toHighlight = valueNode == null ? xmlAttributeValue : valueNode.getPsi();
        TextRange childRange = toHighlight.getTextRange();
        TextRange range2 = xmlAttributeValue.getTextRange();
        return childRange.shiftRight(-range2.getStartOffset());
    }

    public static PsiReference[] extractFromContentAttribute(XmlAttributeValue value) {
        String text2 = value.getValue();
        int start = text2.indexOf(CHARSET_PREFIX);
        if (start != -1) {
            int end = text2.indexOf(59, start += CHARSET_PREFIX.length());
            if (end == -1) {
                end = text2.length();
            }
            String charsetName = text2.substring(start, end);
            TextRange textRange = new TextRange(start, end).shiftRight(XmlEncodingReferenceProvider.xmlAttributeValueRange(value).getStartOffset());
            return new PsiReference[]{new XmlEncodingReference(value, charsetName, textRange, 0)};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

