/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSettingsListener;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesModel
implements SchemesModel<CodeStyleScheme> {
    private final List<CodeStyleScheme> mySchemes = new ArrayList<CodeStyleScheme>();
    private CodeStyleScheme mySelectedScheme;
    private final CodeStyleScheme myProjectScheme;
    private final CodeStyleScheme myDefault;
    private final Map<CodeStyleScheme, CodeStyleSettings> mySettingsToClone = new HashMap<CodeStyleScheme, CodeStyleSettings>();
    private final EventDispatcher<CodeStyleSettingsListener> myDispatcher = EventDispatcher.create(CodeStyleSettingsListener.class);
    private final Project myProject;
    private boolean myUiEventsEnabled = true;

    public CodeStyleSchemesModel(Project project) {
        this.myProject = project;
        this.myProjectScheme = new ProjectScheme();
        this.myDefault = CodeStyleSchemes.getInstance().getDefaultScheme();
        this.reset();
    }

    public void selectScheme(CodeStyleScheme selected, @Nullable Object source) {
        if (this.mySelectedScheme != selected) {
            this.mySelectedScheme = selected;
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(source);
        }
    }

    public void addScheme(CodeStyleScheme newScheme, boolean changeSelection) {
        this.mySchemes.add(newScheme);
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (changeSelection) {
            this.selectScheme(newScheme, this);
        }
    }

    @Override
    public void removeScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(0);
        }
        this.mySchemes.remove(scheme2);
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (this.mySelectedScheme == scheme2) {
            this.selectScheme(this.myDefault, this);
        }
    }

    @NotNull
    public CodeStyleSettings getCloneSettings(CodeStyleScheme scheme2) {
        if (!this.mySettingsToClone.containsKey(scheme2)) {
            this.mySettingsToClone.put(scheme2, ModelSettings.createFrom(scheme2.getCodeStyleSettings()));
        }
        CodeStyleSettings codeStyleSettings = this.mySettingsToClone.get(scheme2);
        if (codeStyleSettings == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(1);
        }
        return codeStyleSettings;
    }

    public CodeStyleScheme getSelectedScheme() {
        return this.mySelectedScheme;
    }

    public void addListener(CodeStyleSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public List<CodeStyleScheme> getSchemes() {
        return Collections.unmodifiableList(this.mySchemes);
    }

    public void reset() {
        this.mySchemes.clear();
        ContainerUtil.addAll(this.mySchemes, CodeStyleSchemesImpl.getSchemeManager().getAllSchemes());
        this.mySchemes.add(this.myProjectScheme);
        this.updateClonedSettings();
        this.mySelectedScheme = this.getProjectSettings().USE_PER_PROJECT_SETTINGS ? this.myProjectScheme : CodeStyleSchemes.getInstance().findPreferredScheme(this.getProjectSettings().PREFERRED_PROJECT_CODE_STYLE);
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(this);
    }

    private void updateClonedSettings() {
        Iterator<CodeStyleScheme> schemeIterator = this.mySettingsToClone.keySet().iterator();
        while (schemeIterator.hasNext()) {
            CodeStyleScheme scheme2 = schemeIterator.next();
            if (this.mySchemes.contains(scheme2)) continue;
            schemeIterator.remove();
        }
        for (CodeStyleScheme scheme2 : this.mySchemes) {
            CodeStyleSettings current = scheme2.getCodeStyleSettings();
            CodeStyleSettings clonedSettings = this.getCloneSettings(scheme2);
            clonedSettings.copyFrom(current);
        }
    }

    public boolean isUsePerProjectSettings() {
        return this.mySelectedScheme instanceof ProjectScheme;
    }

    private CodeStyleSettingsManager getProjectSettings() {
        return CodeStyleSettingsManager.getInstance((Project)this.myProject);
    }

    public boolean isSchemeListModified() {
        CodeStyleSchemes schemes = CodeStyleSchemes.getInstance();
        if (this.getProjectSettings().USE_PER_PROJECT_SETTINGS != this.isProjectScheme(this.mySelectedScheme)) {
            return true;
        }
        if (!this.isProjectScheme(this.mySelectedScheme) && this.getSelectedScheme() != schemes.findPreferredScheme(this.getProjectSettings().PREFERRED_PROJECT_CODE_STYLE)) {
            return true;
        }
        HashSet<CodeStyleScheme> configuredSchemesSet = new HashSet<CodeStyleScheme>(this.getIdeSchemes());
        return !configuredSchemesSet.equals(new THashSet(CodeStyleSchemesImpl.getSchemeManager().getAllSchemes()));
    }

    public void apply() {
        this.commitClonedSettings();
        this.commitProjectSettings();
        CodeStyleSchemesImpl.getSchemeManager().setSchemes(this.getIdeSchemes(), this.mySelectedScheme instanceof ProjectScheme ? null : this.mySelectedScheme, null);
    }

    private void commitProjectSettings() {
        CodeStyleSettingsManager projectSettingsManager = this.getProjectSettings();
        projectSettingsManager.USE_PER_PROJECT_SETTINGS = this.isProjectScheme(this.mySelectedScheme);
        projectSettingsManager.PREFERRED_PROJECT_CODE_STYLE = this.mySelectedScheme instanceof ProjectScheme ? null : this.mySelectedScheme.getName();
        projectSettingsManager.setMainProjectCodeStyle(this.myProjectScheme.getCodeStyleSettings());
    }

    private void commitClonedSettings() {
        for (CodeStyleScheme scheme2 : this.mySettingsToClone.keySet()) {
            if (scheme2 instanceof ProjectScheme) continue;
            scheme2.getCodeStyleSettings().copyFrom(this.mySettingsToClone.get(scheme2));
        }
    }

    @NotNull
    private List<CodeStyleScheme> getIdeSchemes() {
        List<CodeStyleScheme> list2 = this.mySchemes.stream().filter(scheme2 -> !(scheme2 instanceof ProjectScheme)).collect(Collectors.toList());
        if (list2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Deprecated
    public static boolean cannotBeModified(CodeStyleScheme currentScheme) {
        return false;
    }

    public void fireBeforeCurrentSettingsChanged() {
        if (this.myUiEventsEnabled) {
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).beforeCurrentSettingsChanged();
        }
    }

    public void fireSchemeChanged(CodeStyleScheme scheme2) {
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(scheme2);
    }

    public void fireSchemeListChanged() {
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
    }

    public void fireAfterCurrentSettingsChanged() {
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).afterCurrentSettingsChanged();
    }

    public void copyToProject(CodeStyleScheme selectedScheme) {
        this.myProjectScheme.getCodeStyleSettings().copyFrom(selectedScheme.getCodeStyleSettings());
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this.myProjectScheme);
        this.commitProjectSettings();
        this.selectScheme(this.myProjectScheme, this);
    }

    public CodeStyleScheme exportProjectScheme(@NotNull String name) {
        if (name == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(3);
        }
        CodeStyleScheme newScheme = this.createNewScheme(name, this.myProjectScheme);
        ((CodeStyleSchemeImpl)newScheme).setCodeStyleSettings(this.getCloneSettings(this.myProjectScheme).clone());
        this.addScheme(newScheme, false);
        return newScheme;
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        boolean isProjectScheme = this.isProjectScheme(parentScheme);
        return new CodeStyleSchemeImpl(SchemeNameGenerator.getUniqueName(preferredName, (Scheme)parentScheme, name -> this.containsScheme((String)name, isProjectScheme)), false, parentScheme);
    }

    @Nullable
    private CodeStyleScheme findSchemeByName(String name, boolean isProjectScheme) {
        for (CodeStyleScheme scheme2 : this.mySchemes) {
            if (isProjectScheme != this.isProjectScheme(scheme2) || !name.equals(scheme2.getName())) continue;
            return scheme2;
        }
        return null;
    }

    public CodeStyleScheme getProjectScheme() {
        return this.myProjectScheme;
    }

    @Override
    public boolean canDuplicateScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(4);
        }
        return !this.isProjectScheme(scheme2);
    }

    @Override
    public boolean canResetScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(5);
        }
        return scheme2.isDefault();
    }

    @Override
    public boolean canDeleteScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(6);
        }
        return !this.isProjectScheme(scheme2) && !scheme2.isDefault();
    }

    @Override
    public boolean isProjectScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(7);
        }
        return scheme2 instanceof ProjectScheme;
    }

    @Override
    public boolean canRenameScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(8);
        }
        return this.canDeleteScheme(scheme2);
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean isProjectScheme) {
        if (name == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(9);
        }
        return this.findSchemeByName(name, isProjectScheme) != null;
    }

    @Override
    public boolean differsFromDefault(@NotNull CodeStyleScheme scheme2) {
        CodeStyleSettings clonedSettings;
        CodeStyleSettings defaults;
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(10);
        }
        return !(defaults = CodeStyleSettings.getDefaults()).equals((Object)(clonedSettings = this.getCloneSettings(scheme2)));
    }

    public List<CodeStyleScheme> getAllSortedSchemes() {
        ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>(this.getSchemes());
        Collections.sort(schemes, (s1, s2) -> {
            if (this.isProjectScheme((CodeStyleScheme)s1)) {
                return -1;
            }
            if (this.isProjectScheme((CodeStyleScheme)s2)) {
                return 1;
            }
            if (s1.isDefault()) {
                return -1;
            }
            if (s2.isDefault()) {
                return 1;
            }
            return s1.getName().compareToIgnoreCase(s2.getName());
        });
        return schemes;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void restoreDefaults(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            CodeStyleSchemesModel.$$$reportNull$$$0(11);
        }
        if (this.canResetScheme(scheme2)) {
            CodeStyleSettings currSettings = this.getCloneSettings(scheme2);
            currSettings.copyFrom(CodeStyleSettings.getDefaults());
            this.myUiEventsEnabled = false;
            try {
                ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).settingsChanged(currSettings);
            }
            finally {
                this.myUiEventsEnabled = true;
            }
        }
    }

    public boolean containsModifiedCodeStyleSettings() {
        for (CodeStyleScheme scheme2 : this.mySchemes) {
            CodeStyleSettings originalSettings = scheme2.getCodeStyleSettings();
            CodeStyleSettings currentSettings = this.mySettingsToClone.get(scheme2);
            if (currentSettings == null || originalSettings.equals((Object)currentSettings)) continue;
            return true;
        }
        return false;
    }

    public void setUiEventsEnabled(boolean enabled) {
        this.myUiEventsEnabled = enabled;
    }

    public boolean isUiEventsEnabled() {
        return this.myUiEventsEnabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/CodeStyleSchemesModel";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloneSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeSchemes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeScheme";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exportProjectScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canDuplicateScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canResetScheme";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteScheme";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isProjectScheme";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canRenameScheme";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "differsFromDefault";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "restoreDefaults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ModelSettings
    extends CodeStyleSettings {
        private volatile boolean myLocked;

        public static ModelSettings createFrom(@NotNull CodeStyleSettings settings) {
            if (settings == null) {
                ModelSettings.$$$reportNull$$$0(0);
            }
            ModelSettings modelSettings = new ModelSettings();
            modelSettings.copyFrom(settings);
            return modelSettings;
        }

        public void doWithLockedSettings(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                ModelSettings.$$$reportNull$$$0(1);
            }
            this.myLocked = true;
            runnable2.run();
            this.myLocked = false;
        }

        public boolean isLocked() {
            return this.myLocked;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesModel$ModelSettings";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFrom";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doWithLockedSettings";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ProjectScheme
    extends CodeStyleSchemeImpl {
        public ProjectScheme() {
            super("Project", false, CodeStyleSchemes.getInstance().getDefaultScheme());
            CodeStyleSettings perProjectSettings = CodeStyleSchemesModel.this.getProjectSettings().getMainProjectCodeStyle();
            if (perProjectSettings != null) {
                this.setCodeStyleSettings(perProjectSettings);
            }
        }
    }
}

