/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySignature {
    private static final String UNION_PREFIX = "Union[";
    private final String myFile;
    private final String myFunctionName;
    private NamedParameter myReturnType;
    private final List<NamedParameter> myArgs;

    public PySignature(@NotNull String file, @NotNull String name) {
        if (file == null) {
            PySignature.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PySignature.$$$reportNull$$$0(1);
        }
        this.myReturnType = null;
        this.myArgs = Lists.newArrayList();
        this.myFile = file;
        this.myFunctionName = name;
    }

    @Nullable
    public String getArgTypeQualifiedName(@NotNull String name) {
        if (name == null) {
            PySignature.$$$reportNull$$$0(2);
        }
        for (NamedParameter param : this.myArgs) {
            if (!name.equals(param.getName())) continue;
            return param.getTypeQualifiedName();
        }
        return null;
    }

    @NotNull
    public String getFile() {
        String string = this.myFile;
        if (string == null) {
            PySignature.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFunctionName() {
        String string = this.myFunctionName;
        if (string == null) {
            PySignature.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public List<NamedParameter> getArgs() {
        List<NamedParameter> list = this.myArgs;
        if (list == null) {
            PySignature.$$$reportNull$$$0(5);
        }
        return list;
    }

    public NamedParameter getReturnType() {
        return this.myReturnType;
    }

    public PySignature addReturnType(@Nullable String returnType) {
        if (StringUtil.isNotEmpty((String)returnType)) {
            if (this.myReturnType != null) {
                this.myReturnType.addType(returnType);
            } else {
                this.myReturnType = new NamedParameter("", returnType);
            }
        }
        return this;
    }

    @NotNull
    public PySignature addAllArgs(@NotNull PySignature signature) {
        if (signature == null) {
            PySignature.$$$reportNull$$$0(6);
        }
        for (NamedParameter param : signature.getArgs()) {
            NamedParameter ourParam = this.getArgForName(param.getName());
            if (ourParam != null) {
                ourParam.addTypes(param.getTypesList());
                continue;
            }
            this.addArgument(param);
        }
        PySignature pySignature = this;
        if (pySignature == null) {
            PySignature.$$$reportNull$$$0(7);
        }
        return pySignature;
    }

    @Nullable
    private NamedParameter getArgForName(String name) {
        for (NamedParameter param : this.myArgs) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    @Nullable
    public String getReturnTypeQualifiedName() {
        return this.myReturnType != null ? this.myReturnType.getTypeQualifiedName() : null;
    }

    public PySignature addArgument(String name, String type) {
        return this.addArgument(new NamedParameter(name, type));
    }

    public PySignature addArgument(NamedParameter argument) {
        this.myArgs.add(argument);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PySignature";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PySignature";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getArgTypeQualifiedName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAllArgs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NamedParameter {
        private final String myName;
        private final List<String> myTypes;

        private NamedParameter(@NotNull String name, @NotNull String type) {
            if (name == null) {
                NamedParameter.$$$reportNull$$$0(0);
            }
            if (type == null) {
                NamedParameter.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myTypes = NamedParameter.parseTypes(type);
        }

        @NotNull
        private static List<String> parseTypes(@NotNull String type) {
            if (type == null) {
                NamedParameter.$$$reportNull$$$0(2);
            }
            if (type.startsWith(PySignature.UNION_PREFIX) && type.endsWith("]")) {
                ArrayList arrayList = Lists.newArrayList((Object[])type.substring(PySignature.UNION_PREFIX.length(), type.length() - 1).split("\\s*,\\s*"));
                if (arrayList == null) {
                    NamedParameter.$$$reportNull$$$0(3);
                }
                return arrayList;
            }
            Object[] parts = type.split(" or ");
            ArrayList arrayList = Lists.newArrayList((Object[])parts);
            if (arrayList == null) {
                NamedParameter.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        public String getName() {
            return this.myName;
        }

        public String getTypeQualifiedName() {
            if (this.myTypes.size() == 1) {
                return NamedParameter.noneTypeToNone(this.myTypes.get(0));
            }
            return PySignature.UNION_PREFIX + StringUtil.join(this.myTypes, NamedParameter::noneTypeToNone, (String)", ") + "]";
        }

        @Nullable
        private static String noneTypeToNone(@Nullable String type) {
            return "NoneType".equals(type) ? "None" : type;
        }

        public void addType(String type) {
            if (!this.myTypes.contains(type)) {
                this.myTypes.add(type);
            }
        }

        public void addTypes(List<String> newTypes) {
            for (String type : newTypes) {
                this.addType(type);
            }
        }

        public List<String> getTypesList() {
            return this.myTypes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PySignature$NamedParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PySignature$NamedParameter";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parseTypes";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

