/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.plantuml.project3.TaskCode;

public class TaskCodeSimpleOrder
implements Comparator<TaskCode> {
    private final List<TaskCode> order;
    private final int hierarchySize;

    public TaskCodeSimpleOrder(Collection<TaskCode> order, int hierarchySize) {
        this.order = new ArrayList<TaskCode>(order);
        this.hierarchySize = hierarchySize;
        for (TaskCode code : order) {
            if (code.getHierarchySize() == hierarchySize) continue;
            throw new IllegalArgumentException();
        }
    }

    @Override
    public int compare(TaskCode code1, TaskCode code2) {
        if (code1.getHierarchySize() < this.hierarchySize) {
            throw new IllegalArgumentException();
        }
        if (code2.getHierarchySize() < this.hierarchySize) {
            throw new IllegalArgumentException();
        }
        code1 = code1.truncateHierarchy(this.hierarchySize);
        code2 = code2.truncateHierarchy(this.hierarchySize);
        int idx1 = this.order.indexOf(code1);
        int idx2 = this.order.indexOf(code2);
        return idx1 - idx2;
    }
}

