/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitUsagesTriggerCollector;
import git4idea.actions.GitAbstractRebaseAction;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.branch.GitNewBranchOptions;
import git4idea.config.GitVcsSettings;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.ui.branch.GitRefDialog;
import git4idea.validators.GitNewBranchNameValidator;
import icons.DvcsImplIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBranchPopupActions {
    private final Project myProject;
    private final GitRepository myRepository;

    GitBranchPopupActions(Project project, GitRepository repository) {
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions() {
        return this.createActions(null, "", false);
    }

    ActionGroup createActions(@Nullable DefaultActionGroup toInsert, @NotNull String repoInfo, boolean firstLevelGroup) {
        if (repoInfo == null) {
            GitBranchPopupActions.$$$reportNull$$$0(0);
        }
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        List<GitRepository> repositoryList = Collections.singletonList(this.myRepository);
        if (this.myRepository.isRebaseInProgress()) {
            GitRebaseSpec rebaseSpec = GitRepositoryManager.getInstance(this.myProject).getOngoingRebaseSpec();
            popupGroup.addAll(rebaseSpec != null && GitBranchPopupActions.isSpecForRepo(rebaseSpec, this.myRepository) ? GitBranchPopupActions.getRebaseActions() : GitBranchPopupActions.createPerRepoRebaseActions(this.myRepository));
        }
        popupGroup.addAction((AnAction)new GitNewBranchAction(this.myProject, repositoryList));
        popupGroup.addAction((AnAction)new CheckoutRevisionActions(this.myProject, repositoryList));
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator("Local Branches" + repoInfo);
        GitLocalBranch currentBranch = this.myRepository.getCurrentBranch();
        GitBranchesCollection branchesCollection = this.myRepository.getBranches();
        List localBranchActions = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(branchesCollection.getLocalBranches()).filter(branch -> !branch.equals(currentBranch))).map(GitReference::getName).sorted(StringUtil::naturalCompare)).map(localName -> new LocalBranchActions(this.myProject, repositoryList, (String)localName, this.myRepository)).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR)).toList();
        int topShownBranches = BranchActionUtil.getNumOfTopShownBranches((List)localBranchActions);
        if (currentBranch != null) {
            localBranchActions.add(0, new CurrentBranchActions(this.myProject, repositoryList, currentBranch.getName(), this.myRepository));
            ++topShownBranches;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (DefaultActionGroup)popupGroup, (List)localBranchActions, (int)topShownBranches, (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllLocals" : null), (boolean)firstLevelGroup);
        popupGroup.addSeparator("Remote Branches" + repoInfo);
        List remoteBranchActions = ((StreamEx)StreamEx.of(branchesCollection.getRemoteBranches()).map(GitReference::getName).sorted(StringUtil::naturalCompare)).map(remoteName -> new RemoteBranchActions(this.myProject, repositoryList, (String)remoteName, this.myRepository)).toList();
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (DefaultActionGroup)popupGroup, (List)ContainerUtil.sorted((Collection)remoteBranchActions, (Comparator)BranchActionUtil.FAVORITE_BRANCH_COMPARATOR), (int)BranchActionUtil.getNumOfTopShownBranches((List)remoteBranchActions), (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllRemotes" : null));
        return popupGroup;
    }

    private static boolean isSpecForRepo(@NotNull GitRebaseSpec spec, @NotNull GitRepository repository) {
        Collection<GitRepository> repositoriesFromSpec;
        if (spec == null) {
            GitBranchPopupActions.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            GitBranchPopupActions.$$$reportNull$$$0(2);
        }
        return (repositoriesFromSpec = spec.getAllRepositories()).size() == 1 && repository.equals(ContainerUtil.getFirstItem(repositoriesFromSpec));
    }

    @NotNull
    private static List<AnAction> createPerRepoRebaseActions(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchPopupActions.$$$reportNull$$$0(3);
        }
        List<AnAction> list = Arrays.asList(GitBranchPopupActions.createRepositoryRebaseAction("Git.Rebase.Abort", repository), GitBranchPopupActions.createRepositoryRebaseAction("Git.Rebase.Continue", repository), GitBranchPopupActions.createRepositoryRebaseAction("Git.Rebase.Skip", repository));
        if (list == null) {
            GitBranchPopupActions.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    static List<AnAction> getRebaseActions() {
        ActionManager actionManager = ActionManager.getInstance();
        List<AnAction> list = Arrays.asList(actionManager.getAction("Git.Rebase.Abort"), actionManager.getAction("Git.Rebase.Continue"), actionManager.getAction("Git.Rebase.Skip"));
        if (list == null) {
            GitBranchPopupActions.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static AnAction createRepositoryRebaseAction(@NotNull String rebaseActionId, final @NotNull GitRepository repository) {
        if (rebaseActionId == null) {
            GitBranchPopupActions.$$$reportNull$$$0(6);
        }
        if (repository == null) {
            GitBranchPopupActions.$$$reportNull$$$0(7);
        }
        final GitAbstractRebaseAction rebaseAction = (GitAbstractRebaseAction)((Object)ObjectUtils.notNull((Object)((Object)((GitAbstractRebaseAction)ActionManager.getInstance().getAction(rebaseActionId)))));
        DumbAwareAction repositoryAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(repository.isRebaseInProgress());
            }

            public void actionPerformed(AnActionEvent e) {
                rebaseAction.performInBackground(repository);
            }
        };
        repositoryAction.getTemplatePresentation().copyFrom(rebaseAction.getTemplatePresentation());
        DumbAwareAction dumbAwareAction = repositoryAction;
        if (dumbAwareAction == null) {
            GitBranchPopupActions.$$$reportNull$$$0(8);
        }
        return dumbAwareAction;
    }

    @NotNull
    private static String getCurrentBranchPresentation(@NotNull Collection<GitRepository> repositories) {
        Set currentBranches;
        if (repositories == null) {
            GitBranchPopupActions.$$$reportNull$$$0(9);
        }
        if ((currentBranches = ContainerUtil.map2Set(repositories, repo -> (String)ObjectUtils.notNull((Object)repo.getCurrentBranchName(), (Object)DvcsUtil.getShortHash((String)((String)ObjectUtils.notNull((Object)repo.getCurrentRevision())))))).size() == 1) {
            String string = GitBranchPopupActions.getBranchPresentation((String)currentBranches.iterator().next());
            if (string == null) {
                GitBranchPopupActions.$$$reportNull$$$0(10);
            }
            return string;
        }
        if ("current branch" == null) {
            GitBranchPopupActions.$$$reportNull$$$0(11);
        }
        return "current branch";
    }

    @NotNull
    private static String getBranchPresentation(@NotNull String branch) {
        if (branch == null) {
            GitBranchPopupActions.$$$reportNull$$$0(12);
        }
        String string = String.format("'%s'", branch);
        if (string == null) {
            GitBranchPopupActions.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseActionId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPerRepoRebaseActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRebaseActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRepositoryRebaseAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranchPresentation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSpecForRepo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPerRepoRebaseActions";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRepositoryRebaseAction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchPresentation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBranchPresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class TagActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myTagName;
        private final GitRepository mySelectedRepository;

        TagActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String tagName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                TagActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                TagActions.$$$reportNull$$$0(1);
            }
            if (tagName == null) {
                TagActions.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                TagActions.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myRepositories = repositories;
            this.myTagName = tagName;
            this.mySelectedRepository = selectedRepository;
            this.getTemplatePresentation().setText(tagName, false);
            this.setIcons(EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new DeleteTagAction(this.myProject, this.myRepositories, this.myTagName)};
            if (anActionArray == null) {
                TagActions.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRepository";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$TagActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$TagActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class DeleteTagAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myTagName;

            DeleteTagAction(Project project, List<GitRepository> repositories, String tagName) {
                super("Delete");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myTagName = tagName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteTag(this.myTagName, this.myRepositories);
                GitUsagesTriggerCollector.reportUsage(this.myProject, "git.tag.delete.local");
            }
        }
    }

    private static class CheckoutWithRebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;

        public CheckoutWithRebaseAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                CheckoutWithRebaseAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                CheckoutWithRebaseAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CheckoutWithRebaseAction.$$$reportNull$$$0(2);
            }
            super("Checkout with Rebase", String.format("Checkout %s, and rebase it onto %s in one step (like `git rebase HEAD %s`)", GitBranchPopupActions.getBranchPresentation(branchName), GitBranchPopupActions.getCurrentBranchPresentation(repositories), branchName), null);
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.rebaseOnCurrent(this.myRepositories, this.myBranchName);
            GitUsagesTriggerCollector.reportUsage(this.myProject, "git.branch.checkout.with.rebase");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "branchName";
                    break;
                }
            }
            objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$CheckoutWithRebaseAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;

        public RebaseAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                RebaseAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                RebaseAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                RebaseAction.$$$reportNull$$$0(2);
            }
            super("Rebase Current onto Selected", RebaseAction.getDescription(branchName, repositories), null);
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.rebase(this.myRepositories, this.myBranchName);
            GitUsagesTriggerCollector.reportUsage(this.myProject, "git.branch.rebase");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RebaseAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            e.getPresentation().setEnabled(ContainerUtil.and(this.myRepositories, GitRepository::isOnBranch));
        }

        @NotNull
        private static String getDescription(@NotNull String selectedBranch, @NotNull Collection<GitRepository> repositories) {
            if (selectedBranch == null) {
                RebaseAction.$$$reportNull$$$0(4);
            }
            if (repositories == null) {
                RebaseAction.$$$reportNull$$$0(5);
            }
            String string = ContainerUtil.and(repositories, GitRepository::isOnBranch) ? String.format("Rebase %s onto %s", GitBranchPopupActions.getCurrentBranchPresentation(repositories), GitBranchPopupActions.getBranchPresentation(selectedBranch)) : "Rebase is not possible in the detached HEAD state";
            if (string == null) {
                RebaseAction.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedBranch";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$RebaseAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RebaseAction";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MergeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        private final boolean myLocalBranch;

        public MergeAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, boolean localBranch) {
            if (project == null) {
                MergeAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                MergeAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                MergeAction.$$$reportNull$$$0(2);
            }
            super("Merge into Current", String.format("Merge %s into %s", GitBranchPopupActions.getBranchPresentation(branchName), GitBranchPopupActions.getCurrentBranchPresentation(repositories)), null);
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.myLocalBranch = localBranch;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.merge(this.myBranchName, this.deleteOnMerge(), this.myRepositories);
            GitUsagesTriggerCollector.reportUsage(this.myProject, "git.branch.merge");
        }

        private GitBrancher.DeleteOnMergeOption deleteOnMerge() {
            if (this.myLocalBranch && !this.myBranchName.equals("master")) {
                return GitBrancher.DeleteOnMergeOption.PROPOSE;
            }
            return GitBrancher.DeleteOnMergeOption.NOTHING;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "branchName";
                    break;
                }
            }
            objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$MergeAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CompareAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        private final GitRepository mySelectedRepository;

        public CompareAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                CompareAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                CompareAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CompareAction.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                CompareAction.$$$reportNull$$$0(3);
            }
            super("Compare With...");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.compare(this.myBranchName, this.myRepositories, this.mySelectedRepository);
            GitUsagesTriggerCollector.reportUsage(this.myProject, "git.branch.compare");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedRepository";
                    break;
                }
            }
            objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$CompareAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class RemoteBranchActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        @NotNull
        private final GitBranchManager myGitBranchManager;

        RemoteBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                RemoteBranchActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                RemoteBranchActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                RemoteBranchActions.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                RemoteBranchActions.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)ServiceManager.getService((Project)project, GitBranchManager.class));
            this.getTemplatePresentation().setText(this.myBranchName, false);
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.REMOTE, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.REMOTE, this.myRepositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName, this.isFavorite());
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new CheckoutRemoteBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new CompareAction(this.myProject, this.myRepositories, this.myBranchName, this.mySelectedRepository), new Separator(), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, false), new Separator(), new RemoteDeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                RemoteBranchActions.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRepository";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class RemoteDeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            RemoteDeleteAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(2);
                }
                super("Delete");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteRemoteBranch(this.myBranchName, this.myRepositories);
                GitUsagesTriggerCollector.reportUsage(this.myProject, "git.branch.delete.remote");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "branchName";
                        break;
                    }
                }
                objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$RemoteDeleteAction";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        static class CheckoutRemoteBranchAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myRemoteBranchName;

            public CheckoutRemoteBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String remoteBranchName) {
                if (project == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(1);
                }
                if (remoteBranchName == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(2);
                }
                super("Checkout As...");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myRemoteBranchName = remoteBranchName;
            }

            public void actionPerformed(AnActionEvent e) {
                String name = Messages.showInputDialog((Project)this.myProject, (String)"New branch name:", (String)"Checkout Remote Branch", null, (String)this.guessBranchName(), (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (name != null) {
                    GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                    brancher.checkoutNewBranchStartingFrom(name, this.myRemoteBranchName, this.myRepositories, null);
                    GitUsagesTriggerCollector.reportUsage(this.myProject, "git.branch.checkout.remote");
                }
            }

            private String guessBranchName() {
                int slashPosition = this.myRemoteBranchName.indexOf("/");
                return this.myRemoteBranchName.substring(slashPosition + 1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "remoteBranchName";
                        break;
                    }
                }
                objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$CheckoutRemoteBranchAction";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    static class CurrentBranchActions
    extends LocalBranchActions {
        CurrentBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                CurrentBranchActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                CurrentBranchActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CurrentBranchActions.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                CurrentBranchActions.$$$reportNull$$$0(3);
            }
            super(project, repositories, branchName, selectedRepository);
            this.setIcons(DvcsImplIcons.CurrentBranchFavoriteLabel, DvcsImplIcons.CurrentBranchLabel, AllIcons.Vcs.FavoriteOnHover, AllIcons.Vcs.NotFavoriteOnHover);
        }

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new LocalBranchActions.RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                CurrentBranchActions.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRepository";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$CurrentBranchActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$CurrentBranchActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class LocalBranchActions
    extends BranchActionGroup
    implements PopupElementWithAdditionalInfo {
        protected final Project myProject;
        protected final List<GitRepository> myRepositories;
        protected final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        private final GitBranchManager myGitBranchManager;
        @NotNull
        private final GitVcsSettings myGitVcsSettings;
        @NotNull
        private final GitBranchIncomingOutgoingManager myIncomingOutgoingManager;

        LocalBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                LocalBranchActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                LocalBranchActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                LocalBranchActions.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                LocalBranchActions.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)ServiceManager.getService((Project)project, GitBranchManager.class));
            this.myGitVcsSettings = GitVcsSettings.getInstance(this.myProject);
            this.myIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.myProject);
            this.getTemplatePresentation().setText(this.calcBranchText(), false);
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.LOCAL, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        @NotNull
        private String calcBranchText() {
            String string = this.myBranchName;
            if (string == null) {
                LocalBranchActions.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        List<GitRepository> getRepositories() {
            List<GitRepository> list = this.myRepositories;
            if (list == null) {
                LocalBranchActions.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        public String getBranchName() {
            String string = this.myBranchName;
            if (string == null) {
                LocalBranchActions.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new CheckoutAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new CompareAction(this.myProject, this.myRepositories, this.myBranchName, this.mySelectedRepository), new Separator(), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, true), new Separator(), new RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName), new DeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                LocalBranchActions.$$$reportNull$$$0(7);
            }
            return anActionArray;
        }

        @Nullable
        public String getInfoText() {
            return new GitMultiRootBranchConfig(this.myRepositories).getTrackedBranch(this.myBranchName);
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.LOCAL, this.chooseRepo(), this.myBranchName, this.isFavorite());
        }

        @Nullable
        private GitRepository chooseRepo() {
            return this.myRepositories.size() > 1 ? null : this.mySelectedRepository;
        }

        public boolean hasIncomingCommits() {
            return this.myGitVcsSettings.shouldUpdateBranchInfo() && this.myIncomingOutgoingManager.hasIncomingFor(this.chooseRepo(), this.myBranchName);
        }

        public boolean hasOutgoingCommits() {
            return this.myGitVcsSettings.shouldUpdateBranchInfo() && this.myIncomingOutgoingManager.hasOutgoingFor(this.chooseRepo(), this.myBranchName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRepository";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcBranchText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRepositories";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranchName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class DeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            DeleteAction(Project project, List<GitRepository> repositories, String branchName) {
                super("Delete");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteBranch(this.myBranchName, this.myRepositories);
                GitUsagesTriggerCollector.reportUsage(this.myProject, "git.branch.delete.local");
            }
        }

        private static class RenameBranchAction
        extends DumbAwareAction {
            @NotNull
            private final Project myProject;
            @NotNull
            private final List<GitRepository> myRepositories;
            @NotNull
            private final String myCurrentBranchName;

            public RenameBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String currentBranchName) {
                if (project == null) {
                    RenameBranchAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    RenameBranchAction.$$$reportNull$$$0(1);
                }
                if (currentBranchName == null) {
                    RenameBranchAction.$$$reportNull$$$0(2);
                }
                super("Rename...");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myCurrentBranchName = currentBranchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                String newName;
                if (e == null) {
                    RenameBranchAction.$$$reportNull$$$0(3);
                }
                if ((newName = Messages.showInputDialog((Project)this.myProject, (String)("New name for the branch '" + this.myCurrentBranchName + "':"), (String)("Rename Branch " + this.myCurrentBranchName), null, (String)this.myCurrentBranchName, (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories))) != null) {
                    GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                    brancher.renameBranch(this.myCurrentBranchName, newName, this.myRepositories);
                    GitUsagesTriggerCollector.reportUsage(this.myProject, "git.branch.rename");
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    RenameBranchAction.$$$reportNull$$$0(4);
                }
                if (this.myRepositories.stream().anyMatch(Repository::isFresh)) {
                    e.getPresentation().setEnabled(false);
                    e.getPresentation().setDescription("Renaming branch is not possible before the first commit");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentBranchName";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$RenameBranchAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class CheckoutAsNewBranch
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            CheckoutAsNewBranch(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    CheckoutAsNewBranch.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    CheckoutAsNewBranch.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    CheckoutAsNewBranch.$$$reportNull$$$0(2);
                }
                super("Checkout As...");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                String name = Messages.showInputDialog((Project)this.myProject, (String)"New branch name:", (String)("Checkout New Branch From " + this.myBranchName), null, (String)"", (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (name != null) {
                    GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                    brancher.checkoutNewBranchStartingFrom(name, this.myBranchName, this.myRepositories, null);
                }
                GitUsagesTriggerCollector.reportUsage(this.myProject, "git.checkout.as.new.branch");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "branchName";
                        break;
                    }
                }
                objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$CheckoutAsNewBranch";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        static class CheckoutAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            CheckoutAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    CheckoutAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    CheckoutAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    CheckoutAction.$$$reportNull$$$0(2);
                }
                super("Checkout");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.checkout(this.myBranchName, false, this.myRepositories, null);
                GitUsagesTriggerCollector.reportUsage(this.myProject, "git.branch.checkout.local");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "branchName";
                        break;
                    }
                }
                objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$CheckoutAction";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class CheckoutRevisionActions
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;

        CheckoutRevisionActions(Project project, List<GitRepository> repositories) {
            super("Checkout Tag or Revision...");
            this.myProject = project;
            this.myRepositories = repositories;
        }

        public void actionPerformed(AnActionEvent e) {
            GitRefDialog dialog = new GitRefDialog(this.myProject, this.myRepositories, "Checkout", "Enter reference (branch, tag) name or commit hash:");
            if (dialog.showAndGet()) {
                String reference = dialog.getReference();
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.checkout(reference, true, this.myRepositories, null);
                GitUsagesTriggerCollector.reportUsage(this.myProject, "git.branch.checkout.revision");
            }
        }

        public void update(AnActionEvent e) {
            boolean isFresh = ContainerUtil.and(this.myRepositories, repository -> repository.isFresh());
            if (isFresh) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription("Checkout is not possible before the first commit");
            }
        }
    }

    public static class GitNewBranchAction
    extends NewBranchAction<GitRepository> {
        public GitNewBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories) {
            if (project == null) {
                GitNewBranchAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                GitNewBranchAction.$$$reportNull$$$0(1);
            }
            super(project, repositories);
        }

        public void actionPerformed(AnActionEvent e) {
            GitNewBranchOptions options = GitBranchUtil.getNewBranchNameFromUser(this.myProject, this.myRepositories, "Create New Branch", null);
            if (options != null) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                if (options.shouldCheckout()) {
                    GitUsagesTriggerCollector.reportUsage(this.myProject, "git.branch.create.new");
                    brancher.checkoutNewBranch(options.getName(), this.myRepositories);
                } else {
                    GitUsagesTriggerCollector.reportUsage(this.myProject, "git.branch.create.new.nocheckout");
                    brancher.createBranch(options.getName(), StreamEx.of((Collection)this.myRepositories).toMap(position -> "HEAD"));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
            }
            objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$GitNewBranchAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

