/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.EmptyListIterator;
import com.intellij.util.containers.Stack;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerUtilRt {
    private static final int ARRAY_COPY_THRESHOLD = 20;

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        HashMap hashMap = new HashMap();
        if (hashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            ContainerUtilRt.$$$reportNull$$$0(1);
        }
        HashMap<? extends K, ? extends V> hashMap = new HashMap<K, V>(map);
        if (hashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull List<K> keys, @NotNull List<V> values) {
        if (keys == null) {
            ContainerUtilRt.$$$reportNull$$$0(3);
        }
        if (values == null) {
            ContainerUtilRt.$$$reportNull$$$0(4);
        }
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException(keys + " should have same length as " + values);
        }
        Map<K, V> map = ContainerUtilRt.newHashMap(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        Map<K, V> map2 = map;
        if (map2 == null) {
            ContainerUtilRt.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<K, ? extends V> first, Pair<K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtilRt.$$$reportNull$$$0(6);
        }
        if (entries == null) {
            ContainerUtilRt.$$$reportNull$$$0(7);
        }
        Map<K, V> map = ContainerUtilRt.newHashMap(entries.length + 1);
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map<K, V> map2 = map;
        if (map2 == null) {
            ContainerUtilRt.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        HashMap hashMap = new HashMap(initialCapacity);
        if (hashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        TreeMap treeMap = new TreeMap();
        if (treeMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(10);
        }
        return treeMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap(@NotNull Map<K, V> map) {
        if (map == null) {
            ContainerUtilRt.$$$reportNull$$$0(11);
        }
        TreeMap<K, V> treeMap = new TreeMap<K, V>(map);
        if (treeMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(12);
        }
        return treeMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (linkedHashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(13);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int capacity) {
        LinkedHashMap linkedHashMap = new LinkedHashMap(capacity);
        if (linkedHashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Map<K, V> map) {
        if (map == null) {
            ContainerUtilRt.$$$reportNull$$$0(15);
        }
        LinkedHashMap<K, V> linkedHashMap = new LinkedHashMap<K, V>(map);
        if (linkedHashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(16);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<K, ? extends V> first, @NotNull Pair<K, ? extends V>[] entries) {
        if (first == null) {
            ContainerUtilRt.$$$reportNull$$$0(17);
        }
        if (entries == null) {
            ContainerUtilRt.$$$reportNull$$$0(18);
        }
        LinkedHashMap<K, V> map = ContainerUtilRt.newLinkedHashMap();
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map.put(pair.getFirst(), pair.getSecond());
        }
        LinkedHashMap<K, V> linkedHashMap = map;
        if (linkedHashMap == null) {
            ContainerUtilRt.$$$reportNull$$$0(19);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        LinkedList linkedList = new LinkedList();
        if (linkedList == null) {
            ContainerUtilRt.$$$reportNull$$$0(20);
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(21);
        }
        LinkedList<T> list = ContainerUtilRt.newLinkedList();
        Collections.addAll(list, elements);
        LinkedList<T> linkedList = list;
        if (linkedList == null) {
            ContainerUtilRt.$$$reportNull$$$0(22);
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(23);
        }
        LinkedList<T> linkedList = ContainerUtilRt.copy(ContainerUtilRt.<T>newLinkedList(), elements);
        if (linkedList == null) {
            ContainerUtilRt.$$$reportNull$$$0(24);
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = new ArrayList();
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(26);
        }
        ArrayList<T> list = ContainerUtilRt.newArrayListWithCapacity(elements.length);
        Collections.addAll(list, elements);
        ArrayList<T> arrayList = list;
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(28);
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            ArrayList arrayList = new ArrayList(collection);
            if (arrayList == null) {
                ContainerUtilRt.$$$reportNull$$$0(29);
            }
            return arrayList;
        }
        ArrayList<T> arrayList = ContainerUtilRt.copy(ContainerUtilRt.<T>newArrayList(), elements);
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = new ArrayList(size);
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    private static <T, C extends Collection<T>> C copy(@NotNull C collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(32);
        }
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(33);
        }
        for (T element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtilRt.$$$reportNull$$$0(34);
        }
        return c;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet() {
        HashSet hashSet = new HashSet();
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(35);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(int initialCapacity) {
        HashSet hashSet = new HashSet(initialCapacity);
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(36);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(37);
        }
        HashSet<T> hashSet = new HashSet<T>(Arrays.asList(elements));
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(38);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(39);
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            HashSet hashSet = new HashSet(collection);
            if (hashSet == null) {
                ContainerUtilRt.$$$reportNull$$$0(40);
            }
            return hashSet;
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(elements.iterator());
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(41);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator) {
        if (iterator == null) {
            ContainerUtilRt.$$$reportNull$$$0(42);
        }
        HashSet<T> set = ContainerUtilRt.newHashSet();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(43);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (linkedHashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(44);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(45);
        }
        LinkedHashSet<T> linkedHashSet = ContainerUtilRt.newLinkedHashSet(Arrays.asList(elements));
        if (linkedHashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(46);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(47);
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            LinkedHashSet linkedHashSet = new LinkedHashSet(collection);
            if (linkedHashSet == null) {
                ContainerUtilRt.$$$reportNull$$$0(48);
            }
            return linkedHashSet;
        }
        LinkedHashSet<T> linkedHashSet = ContainerUtilRt.copy(ContainerUtilRt.<T>newLinkedHashSet(), elements);
        if (linkedHashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(49);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet() {
        TreeSet treeSet = new TreeSet();
        if (treeSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(50);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(T ... elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(51);
        }
        TreeSet<T> set = ContainerUtilRt.newTreeSet();
        Collections.addAll(set, elements);
        TreeSet<T> treeSet = set;
        if (treeSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(52);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(53);
        }
        TreeSet<T> treeSet = ContainerUtilRt.copy(ContainerUtilRt.<T>newTreeSet(), elements);
        if (treeSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(54);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@Nullable Comparator<? super T> comparator) {
        TreeSet<? super T> treeSet = new TreeSet<T>(comparator);
        if (treeSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(55);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack() {
        Stack stack = new Stack();
        if (stack == null) {
            ContainerUtilRt.$$$reportNull$$$0(56);
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack(@NotNull Collection<T> elements) {
        if (elements == null) {
            ContainerUtilRt.$$$reportNull$$$0(57);
        }
        Stack<T> stack = new Stack<T>(elements);
        if (stack == null) {
            ContainerUtilRt.$$$reportNull$$$0(58);
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack(T ... initial) {
        if (initial == null) {
            ContainerUtilRt.$$$reportNull$$$0(59);
        }
        Stack<T> stack = new Stack<T>(Arrays.asList(initial));
        if (stack == null) {
            ContainerUtilRt.$$$reportNull$$$0(60);
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        EmptyList emptyList = EmptyList.INSTANCE;
        if (emptyList == null) {
            ContainerUtilRt.$$$reportNull$$$0(61);
        }
        return emptyList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        CopyOnWriteArrayList<T> copyOnWriteArrayList = new CopyOnWriteArrayList<T>(ContainerUtilRt.<T>emptyList());
        if (copyOnWriteArrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(62);
        }
        return copyOnWriteArrayList;
    }

    @Deprecated
    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<T> result) {
        if (result == null) {
            ContainerUtilRt.$$$reportNull$$$0(63);
        }
        if (element != null) {
            result.add(element);
        }
    }

    public static <T> void addIfNotNull(@NotNull Collection<T> result, @Nullable T element) {
        if (result == null) {
            ContainerUtilRt.$$$reportNull$$$0(64);
        }
        if (element != null) {
            result.add(element);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull T[] array, @NotNull Function<T, V> mapper) {
        if (array == null) {
            ContainerUtilRt.$$$reportNull$$$0(65);
        }
        if (mapper == null) {
            ContainerUtilRt.$$$reportNull$$$0(66);
        }
        List<V> list = ContainerUtilRt.map2List(Arrays.asList(array), mapper);
        if (list == null) {
            ContainerUtilRt.$$$reportNull$$$0(67);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(68);
        }
        if (mapper == null) {
            ContainerUtilRt.$$$reportNull$$$0(69);
        }
        if (collection.isEmpty()) {
            List<T> list = ContainerUtilRt.emptyList();
            if (list == null) {
                ContainerUtilRt.$$$reportNull$$$0(70);
            }
            return list;
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        ArrayList<V> arrayList = list;
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(71);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> List<Pair<K, V>> map2List(@NotNull Map<K, V> map) {
        if (map == null) {
            ContainerUtilRt.$$$reportNull$$$0(72);
        }
        if (map.isEmpty()) {
            List<Pair<K, V>> list = ContainerUtilRt.emptyList();
            if (list == null) {
                ContainerUtilRt.$$$reportNull$$$0(73);
            }
            return list;
        }
        ArrayList<Pair<K, V>> result = new ArrayList<Pair<K, V>>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.add(Pair.create(entry.getKey(), entry.getValue()));
        }
        ArrayList<Pair<K, V>> arrayList = result;
        if (arrayList == null) {
            ContainerUtilRt.$$$reportNull$$$0(74);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(75);
        }
        if (mapper == null) {
            ContainerUtilRt.$$$reportNull$$$0(76);
        }
        Set<V> set = ContainerUtilRt.map2Set(Arrays.asList(collection), mapper);
        if (set == null) {
            ContainerUtilRt.$$$reportNull$$$0(77);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(78);
        }
        if (mapper == null) {
            ContainerUtilRt.$$$reportNull$$$0(79);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtilRt.$$$reportNull$$$0(80);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            ContainerUtilRt.$$$reportNull$$$0(81);
        }
        return hashSet;
    }

    @NotNull
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        int length;
        if (collection == null) {
            ContainerUtilRt.$$$reportNull$$$0(82);
        }
        if (array == null) {
            ContainerUtilRt.$$$reportNull$$$0(83);
        }
        if ((length = array.length) < 20 && array.length >= collection.size()) {
            for (int i = 0; i < collection.size(); ++i) {
                array[i] = collection.get(i);
            }
            if (array == null) {
                ContainerUtilRt.$$$reportNull$$$0(84);
            }
            return array;
        }
        T[] TArray = collection.toArray(array);
        if (TArray == null) {
            ContainerUtilRt.$$$reportNull$$$0(85);
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull T[] sample) {
        int size;
        if (c == null) {
            ContainerUtilRt.$$$reportNull$$$0(86);
        }
        if (sample == null) {
            ContainerUtilRt.$$$reportNull$$$0(87);
        }
        if ((size = c.size()) == sample.length && size < 20) {
            int i = 0;
            for (T t : c) {
                sample[i++] = t;
            }
            if (sample == null) {
                ContainerUtilRt.$$$reportNull$$$0(88);
            }
            return sample;
        }
        T[] TArray = c.toArray(sample);
        if (TArray == null) {
            ContainerUtilRt.$$$reportNull$$$0(89);
        }
        return TArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 47: 
            case 51: 
            case 53: 
            case 57: 
            case 59: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 72: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 86: 
            case 87: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 47: 
            case 51: 
            case 53: 
            case 57: 
            case 59: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 72: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 86: 
            case 87: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ContainerUtilRt";
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 33: 
            case 37: 
            case 39: 
            case 45: 
            case 47: 
            case 51: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 32: 
            case 68: 
            case 75: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 65: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 66: 
            case 69: 
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 47: 
            case 51: 
            case 53: 
            case 57: 
            case 59: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 72: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ContainerUtilRt";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeMap";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayListWithCapacity";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 44: 
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 50: 
            case 52: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeSet";
                break;
            }
            case 56: 
            case 58: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "newStack";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyCOWList";
                break;
            }
            case 67: 
            case 70: 
            case 71: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 77: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 84: 
            case 85: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newTreeMap";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 37: 
            case 39: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 51: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "newTreeSet";
                break;
            }
            case 57: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "newStack";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 75: 
            case 76: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 82: 
            case 83: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 42: 
            case 45: 
            case 47: 
            case 51: 
            case 53: 
            case 57: 
            case 59: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 72: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 86: 
            case 87: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final EmptyList INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                EmptyList.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public <E> E[] toArray(@NotNull E[] a) {
            if (a == null) {
                EmptyList.$$$reportNull$$$0(1);
            }
            if (a.length != 0) {
                a[0] = null;
            }
            if (a == null) {
                EmptyList.$$$reportNull$$$0(2);
            }
            return a;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                EmptyList.$$$reportNull$$$0(3);
            }
            return emptyIterator;
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            EmptyListIterator emptyListIterator = EmptyListIterator.getInstance();
            if (emptyListIterator == null) {
                EmptyList.$$$reportNull$$$0(4);
            }
            return emptyListIterator;
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            if (c == null) {
                EmptyList.$$$reportNull$$$0(5);
            }
            return c.isEmpty();
        }

        @Override
        @Contract(pure=true)
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Contract(pure=true)
        public boolean equals(Object o) {
            return o instanceof List && ((List)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtilRt$EmptyList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtilRt$EmptyList";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "listIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "containsAll";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

