/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.contour;

import com.projity.datatype.DurationFormat;
import com.projity.pm.assignment.contour.AbstractContourBucket;
import com.projity.pm.assignment.contour.PersonalContourBucket;
import com.projity.pm.time.MutableInterval;
import java.util.ArrayList;
import java.util.LinkedList;

public abstract class AbstractContour
implements Cloneable {
    protected AbstractContourBucket[] contourBuckets = null;
    protected double maxUnits = 0.0;

    public abstract int getType();

    public abstract boolean isPersonal();

    public abstract long calcTotalWork(long var1);

    public AbstractContour adjustDuration(long l, long l2) {
        return this;
    }

    public AbstractContour adjustUnits(double d, long l) {
        return this;
    }

    public AbstractContour contourAdjustWork(double d, long l) {
        return this;
    }

    public AbstractContourBucket[] getContourBuckets() {
        return this.contourBuckets;
    }

    public abstract String getName();

    public int numBuckets() {
        if (this.contourBuckets == null) {
            return 0;
        }
        return this.contourBuckets.length;
    }

    private long calcSumBucketDuration(long l, boolean bl) {
        long l2 = 0L;
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            if (this.contourBuckets[i] == null) {
                System.out.println(this.toString(l));
            }
            if (bl && this.contourBuckets[i].getUnits() == 0.0) continue;
            l2 += this.contourBuckets[i].getBucketDuration(l);
        }
        return l2;
    }

    public long calcTotalBucketDuration(long l) {
        return this.calcSumBucketDuration(l, false);
    }

    public long calcWorkingBucketDuration(long l) {
        return this.calcSumBucketDuration(l, true);
    }

    protected double calcMaxUnits() {
        double d = 0.0;
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            if (this.contourBuckets[i] == null) continue;
            d = Math.max(d, this.contourBuckets[i].getUnits());
        }
        return d;
    }

    public ArrayList toArrayList() {
        if (this.contourBuckets == null) {
            return null;
        }
        ArrayList<AbstractContourBucket> arrayList = new ArrayList<AbstractContourBucket>(this.contourBuckets.length);
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            arrayList.add(this.contourBuckets[i]);
        }
        return arrayList;
    }

    public double getMaxUnits() {
        return this.maxUnits;
    }

    public AbstractContour(AbstractContourBucket[] abstractContourBucketArray) {
        this.contourBuckets = abstractContourBucketArray;
        this.maxUnits = this.calcMaxUnits();
    }

    public LinkedList bucketsBetweenDurations(long l, long l2, long l3) {
        LinkedList<PersonalContourBucket> linkedList = new LinkedList<PersonalContourBucket>();
        AbstractContourBucket abstractContourBucket = null;
        long l4 = 0L;
        long l5 = 0L;
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            abstractContourBucket = this.contourBuckets[i];
            l5 = l4;
            if ((l4 += abstractContourBucket.getBucketDuration(l3)) <= l) continue;
            if (l5 >= l2) break;
            long l6 = Math.min(l2, l4) - Math.max(l, l5);
            linkedList.add(PersonalContourBucket.getInstance(l6, abstractContourBucket.getUnits()));
        }
        return linkedList;
    }

    public String toString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.contourBuckets == null) {
            return null;
        }
        for (int i = 0; i < this.contourBuckets.length; ++i) {
            stringBuffer.append("bucket[" + i + "]");
            if (this.contourBuckets[i] == null) {
                stringBuffer.append(" NULL!");
                continue;
            }
            stringBuffer.append(" duration=" + DurationFormat.format(this.contourBuckets[i].getBucketDuration(l)) + " units " + this.contourBuckets[i].getUnits() + "\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(0L);
    }

    public abstract AbstractContour extend(long var1, long var3);

    public abstract AbstractContour extendBefore(long var1, long var3);

    public abstract MutableInterval getRangeThatIntervalCanBeMoved(long var1, long var3);

    public AbstractContour removeFillerAfter(long l) {
        return this;
    }

    public long extractDelay() {
        return 0L;
    }

    public Object clone() {
        try {
            AbstractContour abstractContour = (AbstractContour)super.clone();
            if (this.contourBuckets != null) {
                abstractContour.contourBuckets = new AbstractContourBucket[this.contourBuckets.length];
                for (int i = 0; i < this.contourBuckets.length; ++i) {
                    abstractContour.contourBuckets[i] = (AbstractContourBucket)this.contourBuckets[i].clone();
                }
            }
            return abstractContour;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public double getLastBucketUnits() {
        return this.contourBuckets[this.contourBuckets.length - 1].getUnits();
    }
}

