/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.transform;

import com.projity.field.InvalidFormulaException;
import com.projity.grouping.core.transform.CommonTransform;
import com.projity.strings.Messages;
import com.projity.util.Environment;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Transformer;

public abstract class CommonTransformFactory
extends CommonTransform {
    protected String id = null;
    protected String name = null;
    protected String formulaText = null;
    protected boolean showSummary = true;
    protected boolean showEmptyLines = true;
    protected boolean showEndEmptyLines = true;
    protected String definition = null;
    protected String arguments = null;
    protected Transformer composition = null;
    protected boolean server;
    protected boolean showEmptySummaries = true;
    protected boolean showAssignments = true;
    protected boolean preserveHierarchy = true;

    public abstract CommonTransform getTransform() throws InvalidFormulaException;

    public CommonTransform getTransformFromDefinition() throws InvalidFormulaException {
        if (this.definition != null) {
            try {
                return (CommonTransform)Class.forName(this.definition).getConstructor(String.class).newInstance(this.arguments);
            }
            catch (Exception exception) {
                throw new InvalidFormulaException(exception);
            }
        }
        return null;
    }

    public String getFormulaText() {
        return this.formulaText;
    }

    public void setFormulaText(String string) {
        this.formulaText = string;
    }

    @Override
    public boolean isShowSummary() {
        return this.showSummary;
    }

    @Override
    public void setShowSummary(boolean bl) {
        this.showSummary = bl;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String string) {
        this.arguments = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
        if (this.name == null) {
            this.setName(Messages.getString(string));
        }
    }

    public void setNameId(String string) {
        this.name = Messages.getString(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public boolean isShowEmptyLines() {
        return this.showEmptyLines;
    }

    @Override
    public void setShowEmptyLines(boolean bl) {
        this.showEmptyLines = bl;
    }

    @Override
    public boolean isShowEndEmptyLines() {
        return this.showEndEmptyLines;
    }

    @Override
    public void setShowEndEmptyLines(boolean bl) {
        this.showEndEmptyLines = bl;
    }

    @Override
    public boolean isShowEmptySummaries() {
        return this.showEmptySummaries;
    }

    @Override
    public void setShowEmptySummaries(boolean bl) {
        this.showEmptySummaries = bl;
    }

    @Override
    public boolean isShowAssignments() {
        return this.showAssignments;
    }

    @Override
    public void setShowAssignments(boolean bl) {
        this.showAssignments = bl;
    }

    @Override
    public boolean isPreserveHierarchy() {
        return this.preserveHierarchy;
    }

    @Override
    public void setPreserveHierarchy(boolean bl) {
        this.preserveHierarchy = bl;
    }

    @Override
    public boolean isServer() {
        return this.server;
    }

    @Override
    public void setServer(boolean bl) {
        this.server = bl;
    }

    @Override
    public Transformer getComposition() {
        return this.composition;
    }

    @Override
    public void setComposition(Transformer transformer) {
        this.composition = transformer;
    }

    protected void setProperties(CommonTransform commonTransform) throws InvalidFormulaException {
        commonTransform.setShowEmptyLines(this.isShowEmptyLines());
        commonTransform.setShowEndEmptyLines(this.isShowEndEmptyLines());
        commonTransform.setShowSummary(this.isShowSummary());
        commonTransform.setShowEmptySummaries(this.isShowEmptySummaries());
        commonTransform.setShowAssignments(this.isShowAssignments());
        commonTransform.setPreserveHierarchy(this.isPreserveHierarchy());
        if (this.subTransforms != null) {
            ArrayList<CommonTransform> arrayList = new ArrayList<CommonTransform>();
            Iterator iterator = this.subTransforms.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((CommonTransformFactory)iterator.next()).getTransform());
            }
            commonTransform.setSubTransforms(arrayList);
        }
        commonTransform.setParameters(this.getParameters());
        commonTransform.setParametersMap(this.getParametersMap());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void setRedefinitionCallBack(Closure closure) {
    }

    public void addFactory(CommonTransformFactory commonTransformFactory) {
        if (commonTransformFactory.isServer() && Environment.getStandAlone()) {
            return;
        }
        if (this.subTransforms == null) {
            this.subTransforms = new ArrayList();
        }
        this.subTransforms.add(commonTransformFactory);
    }
}

