/*
 * Decompiled with CFR 0.152.
 */
package lucee.cli;

import java.io.File;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import lucee.cli.CLIInvoker;
import lucee.cli.servlet.ServletConfigImpl;
import lucee.cli.servlet.ServletContextImpl;
import lucee.loader.engine.CFMLEngine;
import lucee.loader.engine.CFMLEngineFactory;

public class CLIInvokerImpl
implements CLIInvoker {
    private final ServletConfigImpl servletConfig;
    private final CFMLEngine engine;
    private long lastAccess;

    public CLIInvokerImpl(File root, String servletName) throws ServletException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        HashMap<String, String> initParams = new HashMap<String, String>();
        String param = System.getProperty("lucee.cli.config");
        if (param != null && !param.isEmpty()) {
            initParams.put("lucee-web-directory", new File(param, "lucee-web").getAbsolutePath());
            initParams.put("lucee-server-directory", new File(param).getAbsolutePath());
        } else {
            initParams.put("lucee-server-directory", new File(root, "WEB-INF").getAbsolutePath());
        }
        ServletContextImpl servletContext = new ServletContextImpl(root, attributes, initParams, 1, 0);
        this.servletConfig = new ServletConfigImpl(servletContext, servletName);
        this.engine = CFMLEngineFactory.getInstance(this.servletConfig);
        servletContext.setLogger(this.engine.getCFMLEngineFactory().getLogger());
    }

    @Override
    public void invoke(Map<String, String> config) throws RemoteException {
        try {
            this.engine.cli(config, this.servletConfig);
            this.lastAccess = System.currentTimeMillis();
        }
        catch (Throwable t) {
            throw new RemoteException("failed to call CFML Engine", t);
        }
    }

    public long lastAccess() {
        return this.lastAccess;
    }
}

