/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ext;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.ext.JRubyAckedQueueExt;
import org.logstash.ext.JRubyAbstractQueueWriteClientExt;
import org.logstash.ext.JrubyEventExtLibrary;

@JRubyClass(name={"AckedWriteClient"})
public final class JrubyAckedWriteClientExt
extends JRubyAbstractQueueWriteClientExt {
    private JRubyAckedQueueExt queue;
    private AtomicBoolean closed = new AtomicBoolean();

    @JRubyMethod(meta=true, required=2)
    public static JrubyAckedWriteClientExt create(ThreadContext context, IRubyObject recv, IRubyObject queue, IRubyObject closed) {
        return new JrubyAckedWriteClientExt(context.runtime, RubyUtil.ACKED_WRITE_CLIENT_CLASS, (JRubyAckedQueueExt)((Object)queue.toJava(JRubyAckedQueueExt.class)), (AtomicBoolean)closed.toJava(AtomicBoolean.class));
    }

    public static JrubyAckedWriteClientExt create(JRubyAckedQueueExt queue, AtomicBoolean closed) {
        return new JrubyAckedWriteClientExt(RubyUtil.RUBY, RubyUtil.ACKED_WRITE_CLIENT_CLASS, queue, closed);
    }

    public JrubyAckedWriteClientExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    private JrubyAckedWriteClientExt(Ruby runtime, RubyClass metaClass, JRubyAckedQueueExt queue, AtomicBoolean closed) {
        super(runtime, metaClass);
        this.queue = queue;
        this.closed = closed;
    }

    @Override
    protected JRubyAbstractQueueWriteClientExt doPush(ThreadContext context, JrubyEventExtLibrary.RubyEvent event) {
        this.ensureOpen();
        this.queue.rubyWrite(context, event.getEvent());
        return this;
    }

    @Override
    protected JRubyAbstractQueueWriteClientExt doPushBatch(ThreadContext context, Collection<JrubyEventExtLibrary.RubyEvent> batch) {
        this.ensureOpen();
        for (IRubyObject iRubyObject : batch) {
            this.queue.rubyWrite(context, ((JrubyEventExtLibrary.RubyEvent)iRubyObject).getEvent());
        }
        return this;
    }

    private void ensureOpen() {
        if (this.closed.get()) {
            throw new IllegalStateException("Tried to write to a closed queue.");
        }
    }
}

