/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.logstash.ObjectMappers;
import org.logstash.ackedqueue.Queueable;

@JsonSerialize(using=ObjectMappers.TimestampSerializer.class)
@JsonDeserialize(using=ObjectMappers.TimestampDeserializer.class)
public final class Timestamp
implements Comparable<Timestamp>,
Queueable {
    private final DateTime time;
    private static final DateTimeFormatter iso8601Formatter = ISODateTimeFormat.dateTime();
    private static final LocalDateTime JAN_1_1970 = new LocalDateTime(1970, 1, 1, 0, 0);
    private static final Chronology UTC_CHRONOLOGY = ISOChronology.getInstance((DateTimeZone)DateTimeZone.UTC);

    public Timestamp() {
        this.time = new DateTime(UTC_CHRONOLOGY);
    }

    public Timestamp(String iso8601) {
        this.time = ISODateTimeFormat.dateTimeParser().parseDateTime(iso8601).toDateTime(UTC_CHRONOLOGY);
    }

    public Timestamp(long epoch_milliseconds) {
        this.time = new DateTime(epoch_milliseconds, UTC_CHRONOLOGY);
    }

    public Timestamp(Date date) {
        this.time = new DateTime((Object)date, UTC_CHRONOLOGY);
    }

    public Timestamp(DateTime date) {
        this.time = date.toDateTime(UTC_CHRONOLOGY);
    }

    public DateTime getTime() {
        return this.time;
    }

    public static Timestamp now() {
        return new Timestamp();
    }

    public String toString() {
        return iso8601Formatter.print((ReadableInstant)this.time);
    }

    public long usec() {
        return new Duration((ReadableInstant)JAN_1_1970.toDateTime(DateTimeZone.UTC), (ReadableInstant)this.time).getMillis() % 1000L * 1000L;
    }

    @Override
    public int compareTo(Timestamp other) {
        return this.time.compareTo((ReadableInstant)other.time);
    }

    public boolean equals(Object other) {
        return other instanceof Timestamp && this.time.equals((Object)((Timestamp)other).time);
    }

    @Override
    public byte[] serialize() {
        return this.toString().getBytes();
    }
}

