/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class CompositeWritableBuffer
implements WritableBuffer {
    private final WritableBuffer _first;
    private final WritableBuffer _second;

    public CompositeWritableBuffer(WritableBuffer first, WritableBuffer second) {
        this._first = first;
        this._second = second;
    }

    @Override
    public void put(byte b) {
        (this._first.hasRemaining() ? this._first : this._second).put(b);
    }

    @Override
    public void putFloat(float f) {
        this.putInt(Float.floatToRawIntBits(f));
    }

    @Override
    public void putDouble(double d) {
        this.putLong(Double.doubleToRawLongBits(d));
    }

    @Override
    public void putShort(short s) {
        int remaining = this._first.remaining();
        if (remaining >= 2) {
            this._first.putShort(s);
        } else if (remaining == 0) {
            this._second.putShort(s);
        } else {
            ByteBuffer wrap = ByteBuffer.wrap(new byte[2]);
            wrap.putShort(s);
            wrap.flip();
            this.put(wrap);
        }
    }

    @Override
    public void putInt(int i) {
        int remaining = this._first.remaining();
        if (remaining >= 4) {
            this._first.putInt(i);
        } else if (remaining == 0) {
            this._second.putInt(i);
        } else {
            ByteBuffer wrap = ByteBuffer.wrap(new byte[4]);
            wrap.putInt(i);
            wrap.flip();
            this.put(wrap);
        }
    }

    @Override
    public void putLong(long l) {
        int remaining = this._first.remaining();
        if (remaining >= 8) {
            this._first.putLong(l);
        } else if (remaining == 0) {
            this._second.putLong(l);
        } else {
            ByteBuffer wrap = ByteBuffer.wrap(new byte[8]);
            wrap.putLong(l);
            wrap.flip();
            this.put(wrap);
        }
    }

    @Override
    public boolean hasRemaining() {
        return this._first.hasRemaining() || this._second.hasRemaining();
    }

    @Override
    public int remaining() {
        return this._first.remaining() + this._second.remaining();
    }

    @Override
    public int position() {
        return this._first.position() + this._second.position();
    }

    @Override
    public int limit() {
        return this._first.limit() + this._second.limit();
    }

    @Override
    public void position(int position) {
        int first_limit = this._first.limit();
        if (position <= first_limit) {
            this._first.position(position);
            this._second.position(0);
        } else {
            this._first.position(first_limit);
            this._second.position(position - first_limit);
        }
    }

    @Override
    public void put(byte[] src, int offset, int length) {
        int firstRemaining = this._first.remaining();
        if (firstRemaining > 0) {
            if (firstRemaining >= length) {
                this._first.put(src, offset, length);
                return;
            }
            this._first.put(src, offset, firstRemaining);
        }
        this._second.put(src, offset + firstRemaining, length - firstRemaining);
    }

    @Override
    public void put(ByteBuffer payload) {
        int firstRemaining = this._first.remaining();
        if (firstRemaining > 0) {
            if (firstRemaining >= payload.remaining()) {
                this._first.put(payload);
                return;
            }
            int limit = payload.limit();
            payload.limit(payload.position() + firstRemaining);
            this._first.put(payload);
            payload.limit(limit);
        }
        this._second.put(payload);
    }

    public String toString() {
        return this._first.toString() + " + " + this._second.toString();
    }

    @Override
    public void put(ReadableBuffer payload) {
        int firstRemaining = this._first.remaining();
        if (firstRemaining > 0) {
            if (firstRemaining >= payload.remaining()) {
                this._first.put(payload);
                return;
            }
            int limit = payload.limit();
            payload.limit(payload.position() + firstRemaining);
            this._first.put(payload);
            payload.limit(limit);
        }
        this._second.put(payload);
    }
}

