/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.EventHubException;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ClientEntity {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ClientEntity.class);
    protected final Executor executor;
    private final String clientId;
    private final Object syncClose;
    private final ClientEntity parent;
    private CompletableFuture<Void> closeTask;
    private boolean isClosing;
    private boolean isClosed;

    protected ClientEntity(String clientId, ClientEntity parent, Executor executor) {
        this.clientId = clientId;
        this.parent = parent;
        this.executor = executor;
        this.syncClose = new Object();
    }

    protected abstract CompletableFuture<Void> onClose();

    public String getClientId() {
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getIsClosed() {
        boolean isParentClosed = this.parent != null && this.parent.getIsClosed();
        Object object = this.syncClose;
        synchronized (object) {
            return isParentClosed || this.isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getIsClosingOrClosed() {
        boolean isParentClosingOrClosed = this.parent != null && this.parent.getIsClosingOrClosed();
        Object object = this.syncClose;
        synchronized (object) {
            return isParentClosingOrClosed || this.isClosing || this.isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setClosed() {
        Object object = this.syncClose;
        synchronized (object) {
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CompletableFuture<Void> close() {
        Object object = this.syncClose;
        synchronized (object) {
            if (this.isClosed || this.isClosing) {
                return this.closeTask == null ? CompletableFuture.completedFuture(null) : this.closeTask;
            }
            this.isClosing = true;
        }
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info("close: clientId[" + this.clientId + "]");
        }
        this.closeTask = this.onClose().thenRunAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ClientEntity.this.syncClose;
                synchronized (object) {
                    ClientEntity.this.isClosing = false;
                    ClientEntity.this.isClosed = true;
                }
            }
        }, this.executor);
        return this.closeTask;
    }

    public final void closeSync() throws EventHubException {
        try {
            this.close().get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof EventHubException) {
                throw (EventHubException)throwable;
            }
            throw new RuntimeException(throwable != null ? throwable : exception);
        }
    }

    protected final void throwIfClosed() {
        if (this.getIsClosingOrClosed()) {
            throw new IllegalStateException(String.format(Locale.US, "Operation not allowed after the %s instance is Closed.", this.getClass().getName()), this.getLastKnownError());
        }
    }

    protected Exception getLastKnownError() {
        return null;
    }
}

