/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import nokogiri.HtmlSaxParserContext;
import nokogiri.XmlSaxParserContext;
import nokogiri.XmlSaxPushParser;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.ClosedStreamException;
import nokogiri.internals.NokogiriBlockingQueueInputStream;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.ParserContext;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Nokogiri::HTML::SAX::PushParser"})
public class HtmlSaxPushParser
extends RubyObject {
    ParserContext.Options options;
    IRubyObject saxParser;
    NokogiriBlockingQueueInputStream stream;
    private ParserTask parserTask = null;
    private FutureTask<HtmlSaxParserContext> futureTask = null;
    private ExecutorService executor = null;
    private transient IRubyObject parse_options;

    public HtmlSaxPushParser(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public void finalize() {
        try {
            this.terminateImpl();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JRubyMethod
    public IRubyObject initialize_native(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        this.options = new ParserContext.Options(0L);
        this.saxParser = iRubyObject;
        return this;
    }

    private IRubyObject parse_options(ThreadContext threadContext) {
        if (this.parse_options == null) {
            this.parse_options = RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)threadContext.runtime.getClassFromPath("Nokogiri::XML::ParseOptions"), (String)"new");
        }
        return this.parse_options;
    }

    @JRubyMethod(name={"options"})
    public IRubyObject getOptions(ThreadContext threadContext) {
        return RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.parse_options(threadContext), (String)"options");
    }

    @JRubyMethod(name={"options="})
    public IRubyObject setOptions(ThreadContext threadContext, IRubyObject iRubyObject) {
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.parse_options(threadContext), (String)"options=", (IRubyObject)iRubyObject);
        this.options = new ParserContext.Options(iRubyObject.convertToInteger().getLongValue());
        return this.getOptions(threadContext);
    }

    @JRubyMethod
    public IRubyObject native_write(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            this.initialize_task(threadContext);
        }
        catch (IOException iOException) {
            throw threadContext.getRuntime().newRuntimeError(iOException.getMessage());
        }
        ByteArrayInputStream byteArrayInputStream = NokogiriHelpers.stringBytesToStream(iRubyObject);
        if (byteArrayInputStream == null) {
            this.terminateTask(threadContext.runtime);
            throw new RaiseException((RubyException)XmlSyntaxError.createHTMLSyntaxError(threadContext.runtime));
        }
        int n = this.parserTask.getErrorCount();
        if (iRubyObject2.isTrue()) {
            IRubyObject iRubyObject3 = RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this, (String)"document");
            RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject3, (String)"end_document");
            this.terminateTask(threadContext.runtime);
        } else {
            try {
                Future<Void> future = this.stream.addChunk(byteArrayInputStream);
                future.get();
            }
            catch (ClosedStreamException closedStreamException) {
            }
            catch (Exception exception) {
                throw threadContext.runtime.newRuntimeError(exception.getMessage());
            }
        }
        if (!this.options.recover && this.parserTask.getErrorCount() > n) {
            this.terminateTask(threadContext.runtime);
            throw this.parserTask.getLastError();
        }
        return this;
    }

    private void initialize_task(ThreadContext threadContext) throws IOException {
        if (this.futureTask == null || this.stream == null) {
            this.stream = new NokogiriBlockingQueueInputStream();
            assert (this.saxParser != null) : "saxParser null";
            this.parserTask = new ParserTask(threadContext, this.saxParser, (InputStream)this.stream);
            this.futureTask = new FutureTask<XmlSaxParserContext>(this.parserTask);
            this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setName("HtmlSaxPushParser");
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.executor.submit(this.futureTask);
        }
    }

    private void terminateTask(Ruby ruby) {
        if (this.executor == null) {
            return;
        }
        try {
            this.terminateImpl();
        }
        catch (InterruptedException interruptedException) {
            throw ruby.newRuntimeError(interruptedException.toString());
        }
        catch (Exception exception) {
            throw ruby.newRuntimeError(exception.toString());
        }
    }

    private synchronized void terminateImpl() throws InterruptedException, ExecutionException {
        XmlSaxPushParser.terminateExecution(this.executor, this.stream, this.futureTask);
        this.executor = null;
        this.stream = null;
        this.futureTask = null;
    }

    private static HtmlSaxParserContext parse(Ruby ruby, InputStream inputStream) {
        RubyClass rubyClass = NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::HTML::SAX::ParserContext");
        return HtmlSaxParserContext.parse_stream(ruby, rubyClass, inputStream);
    }

    static class ParserTask
    extends XmlSaxPushParser.ParserTask {
        private ParserTask(ThreadContext threadContext, IRubyObject iRubyObject, InputStream inputStream) {
            super(threadContext, iRubyObject, HtmlSaxPushParser.parse(threadContext.runtime, inputStream), inputStream);
        }

        @Override
        public HtmlSaxParserContext call() throws Exception {
            return (HtmlSaxParserContext)super.call();
        }
    }
}

