/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util.registry;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openoffice.xmerge.util.registry.ConverterInfo;
import org.openoffice.xmerge.util.registry.RegistryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterInfoReader {
    private static final String TAG_CONVERTER = "converter";
    private static final String ATTRIB_OFFICE_TYPE = "type";
    private static final String ATTRIB_VERSION = "version";
    private static final String TAG_NAME = "converter-display-name";
    private static final String TAG_DESC = "converter-description";
    private static final String TAG_VENDOR = "converter-vendor";
    private static final String TAG_CLASS_IMPL = "converter-class-impl";
    private static final String TAG_TARGET = "converter-target";
    private static final String ATTRIB_DEVICE_TYPE = "type";
    private static final String TAG_XSLT_DESERIAL = "converter-xslt-deserialize";
    private static final String TAG_XSLT_SERIAL = "converter-xslt-serialize";
    private final String jarfilename;
    private final Document document;
    private final ArrayList<ConverterInfo> converterInfoList = new ArrayList();

    public ConverterInfoReader(String string, boolean bl) throws IOException, ParserConfigurationException, SAXException, RegistryException {
        this.jarfilename = string;
        URL uRL = new URL("jar:" + string + "!/META-INF/converter.xml");
        JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
        JarEntry jarEntry = jarURLConnection.getJarEntry();
        JarFile jarFile = jarURLConnection.getJarFile();
        if (jarFile == null || jarEntry == null) {
            throw new IOException("Missing jar entry");
        }
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        InputSource inputSource = new InputSource(inputStream);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        if (bl) {
            System.out.println("Validating xml...");
            documentBuilderFactory.setValidating(true);
        }
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(inputSource);
        this.parseDocument();
    }

    private void parseDocument() throws RegistryException {
        NodeList nodeList = this.document.getElementsByTagName(TAG_CONVERTER);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.parseConverterNode((Element)node);
        }
    }

    private void parseConverterNode(Element element) throws RegistryException {
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = element.getAttribute("type");
        if (string9.length() != 0) {
            string = string9;
        }
        if ((string9 = element.getAttribute(ATTRIB_VERSION)).length() != 0) {
            string4 = string9;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string10 = element2.getTagName();
            if (TAG_NAME.equalsIgnoreCase(string10)) {
                string2 = this.getTextValue(element2);
                continue;
            }
            if (TAG_DESC.equalsIgnoreCase(string10)) {
                string3 = this.getTextValue(element2);
                continue;
            }
            if (TAG_VENDOR.equalsIgnoreCase(string10)) {
                string5 = this.getTextValue(element2);
                continue;
            }
            if (TAG_XSLT_SERIAL.equalsIgnoreCase(string10)) {
                string7 = this.getTextValue(element2);
                continue;
            }
            if (TAG_XSLT_DESERIAL.equalsIgnoreCase(string10)) {
                string8 = this.getTextValue(element2);
                continue;
            }
            if (TAG_CLASS_IMPL.equalsIgnoreCase(string10)) {
                string6 = this.getTextValue(element2);
                continue;
            }
            if (!TAG_TARGET.equalsIgnoreCase(string10) || (string9 = element2.getAttribute("type")).length() == 0) continue;
            arrayList.add(string9);
        }
        ConverterInfo converterInfo = string7 == null || string8 == null ? new ConverterInfo(this.jarfilename, string, arrayList, string2, string3, string4, string5, string6) : new ConverterInfo(this.jarfilename, string, arrayList, string2, string3, string4, string5, string6, string7, string8);
        this.converterInfoList.add(converterInfo);
    }

    private String getTextValue(Element element) {
        NodeList nodeList = element.getChildNodes();
        String string = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            string = node.getNodeValue().trim();
            break;
        }
        return string;
    }

    public Iterator<ConverterInfo> getConverterInfoEnumeration() {
        return this.converterInfoList.iterator();
    }
}

