"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var common_1 = require("../common");
var mixins = require("./mixins");
var ref = require("./valueref");
function encodeEntry(model, fixedShape) {
    var config = model.config, width = model.width, height = model.height;
    return tslib_1.__assign({}, mixins.baseEncodeEntry(model, { size: 'include', orient: 'ignore' }), mixins.pointPosition('x', model, ref.mid(width)), mixins.pointPosition('y', model, ref.mid(height)), mixins.nonPosition('size', model), shapeMixins(model, config, fixedShape));
}
function shapeMixins(model, config, fixedShape) {
    if (fixedShape) {
        return { shape: { value: fixedShape } };
    }
    return mixins.nonPosition('shape', model, { defaultValue: common_1.getMarkConfig('shape', model.markDef, config) });
}
exports.shapeMixins = shapeMixins;
exports.point = {
    vgMark: 'symbol',
    encodeEntry: function (model) {
        return encodeEntry(model);
    }
};
exports.circle = {
    vgMark: 'symbol',
    encodeEntry: function (model) {
        return encodeEntry(model, 'circle');
    }
};
exports.square = {
    vgMark: 'symbol',
    encodeEntry: function (model) {
        return encodeEntry(model, 'square');
    }
};
//# sourceMappingURL=data:application/json;base64,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