/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class CBPropertyFileReader {
    private String propFileName = null;
    private Properties properties = null;

    public CBPropertyFileReader(String propFileName) throws IOException {
        this.propFileName = propFileName;
        File propFile = new File(propFileName);
        this.loadPropertyFile(propFile);
    }

    public CBPropertyFileReader(File propFile) throws IOException {
        if (propFile == null || !propFile.exists()) {
            throw new IOException("File does not exist.");
        }
        this.propFileName = propFile.getAbsolutePath();
        this.loadPropertyFile(propFile);
    }

    private void loadPropertyFile(File propFile) throws IOException {
        if (!propFile.exists()) {
            throw new IOException("Cannot find the properties file: " + this.propFileName);
        }
        this.properties = new Properties();
        this.properties.load(new FileInputStream(propFile));
    }

    public String getValue(String key) {
        return this.properties.getProperty(key);
    }

    public String getPropFileName() {
        return this.propFileName;
    }

    public void setPropFileName(String propFileName) {
        this.propFileName = propFileName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

