/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.GraphicsEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.CertificateAmendment;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Platform;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WinRegistry;
import org.openstreetmap.josm.tools.WindowsShortcut;

public class PlatformHookWindows
implements PlatformHook {
    private static final byte[] INSECURE_PUBLIC_KEY = new byte[]{48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -107, -107, -120, -124, -56, -39, 107, -59, -38, 11, 105, -65, -4, 126, -71, -106, 44, -21, -113, -68, 110, 64, -26, -30, -4, -15, 127, 115, -89, -99, -34, -57, -120, 87, 81, -124, -19, -106, -5, -31, 56, -17, 8, 43, -13, -57, -61, 93, -2, -7, 81, -26, 41, -4, -27, 13, -95, 13, -88, -76, -82, 38, 24, 25, 77, 108, 12, 59, 18, -70, -68, 95, 50, -77, -66, -99, 23, 13, 77, 47, 26, 72, -73, -84, -9, 26, 67, 1, -105, -12, -8, 76, -69, 106, -68, 51, -31, 115, 30, -122, -5, 46, -79, 99, 117, -123, -36, -126, 108, 40, -15, -29, -112, 99, -99, 61, 72, -118, -116, 71, -30, 16, 11, -17, -111, -108, -80, 108, 76, -128, 118, 3, -31, -74, -112, -121, -39, -82, -12, -114, -32, -97, -25, 58, 44, 47, 33, -44, 70, -70, -107, 112, -87, 91, 32, 42, -6, 82, 62, -99, -39, -17, 40, -59, -47, 96, -119, 104, 110, 127, -41, -98, -119, 76, -21, 77, -46, -58, -12, 45, 2, 93, -38, -34, 51, -2, -63, 126, -34, 79, 31, -101, 110, 111, 15, 102, 113, 25, -23, 67, 60, -125, 10, 15, 40, 33, -56, 56, -45, 78, 72, -33, -44, -103, -75, -58, -115, -44, -63, 105, 88, 121, -126, 50, -126, -44, -122, -30, 4, 8, 99, -121, -16, 42, -10, -20, 62, 81, 15, -38, -76, 103, 25, 94, 22, 2, -97, -15, 25, 12, 62, -72, 4, 73, 7, 83, 2, 3, 1, 0, 1};
    private static final String WINDOWS_ROOT = "Windows-ROOT";
    private static final String CURRENT_VERSION = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion";
    private String oSBuildNumber;

    @Override
    public Platform getPlatform() {
        return Platform.WINDOWS;
    }

    @Override
    public void afterPrefStartupHook() {
        this.extendFontconfig("fontconfig.properties.src");
    }

    @Override
    public void startupHook(PlatformHook.JavaExpirationCallback callback) {
        this.checkExpiredJava(callback);
    }

    @Override
    public void openUrl(String url) throws IOException {
        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
    }

    @Override
    public void initSystemShortcuts() {
        Shortcut.registerSystemShortcut("system:duplicate", I18n.tr("reserved", new Object[0]), 68, 128);
        Shortcut.registerSystemShortcut("system:reset", I18n.tr("reserved", new Object[0]), 127, 640).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-01", I18n.tr("reserved", new Object[0]), 154, 576).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-02", I18n.tr("reserved", new Object[0]), 144, 576).setAutomatic();
        Shortcut.registerSystemShortcut("system:copy", I18n.tr("reserved", new Object[0]), 67, 128);
        Shortcut.registerSystemShortcut("system:cut", I18n.tr("reserved", new Object[0]), 88, 128);
        Shortcut.registerSystemShortcut("system:paste", I18n.tr("reserved", new Object[0]), 86, 128);
        Shortcut.registerSystemShortcut("system:undo", I18n.tr("reserved", new Object[0]), 90, 128);
        Shortcut.registerSystemShortcut("system:redo", I18n.tr("reserved", new Object[0]), 89, 128);
        Shortcut.registerSystemShortcut("system:movefocusright", I18n.tr("reserved", new Object[0]), 39, 128);
        Shortcut.registerSystemShortcut("system:movefocusleft", I18n.tr("reserved", new Object[0]), 37, 128);
        Shortcut.registerSystemShortcut("system:movefocusdown", I18n.tr("reserved", new Object[0]), 40, 128);
        Shortcut.registerSystemShortcut("system:movefocusup", I18n.tr("reserved", new Object[0]), 38, 128);
        Shortcut.registerSystemShortcut("system:selectall", I18n.tr("reserved", new Object[0]), 65, 128);
        Shortcut.registerSystemShortcut("microsoft-reserved-31", I18n.tr("reserved", new Object[0]), 10, 512).setAutomatic();
        Shortcut.registerSystemShortcut("system:exit", I18n.tr("reserved", new Object[0]), 115, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-33", I18n.tr("reserved", new Object[0]), 32, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-35", I18n.tr("reserved", new Object[0]), 9, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-36", I18n.tr("reserved", new Object[0]), 9, 640).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-39", I18n.tr("reserved", new Object[0]), 27, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-42", I18n.tr("reserved", new Object[0]), 121, 64);
        Shortcut.registerSystemShortcut("microsoft-reserved-43", I18n.tr("reserved", new Object[0]), 27, 128).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-50", I18n.tr("reserved", new Object[0]), 27, 192).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-51", I18n.tr("reserved", new Object[0]), 16, 512).setAutomatic();
        Shortcut.registerSystemShortcut("microsoft-reserved-52", I18n.tr("reserved", new Object[0]), 16, 128).setAutomatic();
    }

    @Override
    public String getDefaultStyle() {
        return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    }

    @Override
    public boolean rename(File from, File to) {
        if (to.exists()) {
            Utils.deleteFile(to);
        }
        return from.renameTo(to);
    }

    @Override
    public String getOSDescription() {
        return Utils.strip(Utils.getSystemProperty("os.name")) + ' ' + (Utils.getSystemEnv("ProgramFiles(x86)") == null ? "32" : "64") + "-Bit";
    }

    public static String getProductName() throws IllegalAccessException, InvocationTargetException {
        return WinRegistry.readString(-2147483646, CURRENT_VERSION, "ProductName");
    }

    public static String getReleaseId() throws IllegalAccessException, InvocationTargetException {
        return WinRegistry.readString(-2147483646, CURRENT_VERSION, "ReleaseId");
    }

    public static String getCurrentBuild() throws IllegalAccessException, InvocationTargetException {
        return WinRegistry.readString(-2147483646, CURRENT_VERSION, "CurrentBuild");
    }

    private static String buildOSBuildNumber() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(PlatformHookWindows.getProductName());
            String releaseId = PlatformHookWindows.getReleaseId();
            if (releaseId != null) {
                sb.append(' ').append(releaseId);
            }
            sb.append(" (").append(PlatformHookWindows.getCurrentBuild()).append(')');
        }
        catch (NoClassDefFoundError | ReflectiveOperationException | JosmRuntimeException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to get Windows build number", e);
            Logging.debug(e);
        }
        return sb.toString();
    }

    @Override
    public String getOSBuildNumber() {
        if (this.oSBuildNumber == null) {
            this.oSBuildNumber = PlatformHookWindows.buildOSBuildNumber();
        }
        return this.oSBuildNumber;
    }

    public static KeyStore getRootKeystore() throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        KeyStore ks = KeyStore.getInstance(WINDOWS_ROOT);
        ks.load(null, null);
        return ks;
    }

    public static void removeInsecureCertificates() throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        PublicKey insecurePubKey = null;
        try {
            insecurePubKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(INSECURE_PUBLIC_KEY));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            Logging.error(e);
            return;
        }
        KeyStore ks = PlatformHookWindows.getRootKeystore();
        Enumeration<String> en = ks.aliases();
        ArrayList<String> insecureCertificates = new ArrayList<String>();
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            try {
                ks.getCertificate(alias).verify(insecurePubKey);
                insecureCertificates.add(alias);
            }
            catch (InvalidKeyException | NoSuchProviderException | SignatureException e) {
                Logging.trace(alias + " --> " + e.getClass().getName());
                Logging.trace(e);
            }
        }
        if (!insecureCertificates.isEmpty()) {
            StringBuilder message = new StringBuilder("<html>");
            message.append(I18n.tr("A previous version of JOSM has installed a custom certificate in order to provide HTTPS support for Remote Control:", new Object[0])).append("<br><ul>");
            for (String alias : insecureCertificates) {
                message.append("<li>").append(alias).append("</li>");
            }
            message.append("</ul>").append(I18n.tr("It appears it could be an important <b>security risk</b>.<br><br>You are now going to be prompted by Windows to remove this insecure certificate.<br>For your own safety, <b>please click Yes</b> in next dialog.", new Object[0])).append("</html>");
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), message.toString(), I18n.tr("Warning", new Object[0]), 2);
            for (String alias : insecureCertificates) {
                Logging.warn(I18n.tr("Removing insecure certificate from {0} keystore: {1}", WINDOWS_ROOT, alias));
                try {
                    ks.deleteEntry(alias);
                }
                catch (KeyStoreException e) {
                    Logging.log(Logging.LEVEL_ERROR, I18n.tr("Unable to remove insecure certificate from keystore: {0}", e.getMessage()), e);
                }
            }
        }
    }

    @Override
    public boolean setupHttpsCertificate(String entryAlias, KeyStore.TrustedCertificateEntry trustedCert) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = PlatformHookWindows.getRootKeystore();
        try {
            String alias = ks.getCertificateAlias(trustedCert.getTrustedCertificate());
            if (alias != null) {
                Logging.debug(I18n.tr("JOSM localhost certificate found in {0} keystore: {1}", WINDOWS_ROOT, alias));
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logging.log(Logging.LEVEL_ERROR, "JDK-8172244 occurred. Abort HTTPS setup", e);
            return false;
        }
        if (!GraphicsEnvironment.isHeadless()) {
            StringBuilder message = new StringBuilder("<html>");
            message.append(I18n.tr("Remote Control is configured to provide HTTPS support.<br>This requires to add a custom certificate generated by JOSM to the Windows Root CA store.<br><br>You are now going to be prompted by Windows to confirm this operation.<br>To enable proper HTTPS support, <b>please click Yes</b> in next dialog.<br><br>If unsure, you can also click No then disable HTTPS support in Remote Control preferences.", new Object[0])).append("</html>");
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), message.toString(), I18n.tr("HTTPS support in Remote Control", new Object[0]), 1);
        }
        Logging.info(I18n.tr("Adding JOSM localhost certificate to {0} keystore", WINDOWS_ROOT));
        ks.setEntry(entryAlias, trustedCert, null);
        return true;
    }

    @Override
    public X509Certificate getX509Certificate(CertificateAmendment.NativeCertAmend certAmend) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Logging.trace(PlatformHookWindows.webRequest(certAmend.getWebSite()));
        KeyStore ks = PlatformHookWindows.getRootKeystore();
        Certificate result = ks.getCertificate(certAmend.getWinAlias());
        if (result instanceof X509Certificate) {
            return (X509Certificate)result;
        }
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            result = ks.getCertificate(aliases.nextElement());
            if (!(result instanceof X509Certificate) || !certAmend.getSha256().equalsIgnoreCase(Utils.toHexString(md.digest(result.getEncoded())))) continue;
            return (X509Certificate)result;
        }
        return null;
    }

    @Override
    public File getDefaultCacheDirectory() {
        String p = Utils.getSystemEnv("LOCALAPPDATA");
        if (p == null || p.isEmpty()) {
            p = Utils.getSystemEnv("APPDATA");
        }
        return new File(new File(p, Preferences.getJOSMDirectoryBaseName()), "cache");
    }

    @Override
    public File getDefaultPrefDirectory() {
        return new File(Utils.getSystemEnv("APPDATA"), Preferences.getJOSMDirectoryBaseName());
    }

    @Override
    public File getDefaultUserDataDirectory() {
        return Config.getDirs().getPreferencesDirectory(false);
    }

    protected void extendFontconfig(String templateFileName) {
        String customFontconfigFile = Config.getPref().get("fontconfig.properties", null);
        if (customFontconfigFile != null) {
            Utils.updateSystemProperty("sun.awt.fontconfig", customFontconfigFile);
            return;
        }
        if (!Config.getPref().getBoolean("font.extended-unicode", true)) {
            return;
        }
        String javaLibPath = Utils.getSystemProperty("java.home") + File.separator + "lib";
        Path templateFile = FileSystems.getDefault().getPath(javaLibPath, templateFileName);
        String templatePath = templateFile.toString();
        if (templatePath.startsWith("null") || !Files.isReadable(templateFile)) {
            Logging.warn("extended font config - unable to find font config template file {0}", templatePath);
            return;
        }
        try (InputStream fis = Files.newInputStream(templateFile, new OpenOption[0]);){
            Properties props = new Properties();
            props.load(fis);
            byte[] content = Files.readAllBytes(templateFile);
            File cachePath = Config.getDirs().getCacheDirectory(true);
            Path fontconfigFile = cachePath.toPath().resolve("fontconfig.properties");
            OutputStream os = Files.newOutputStream(fontconfigFile, new OpenOption[0]);
            os.write(content);
            try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));){
                String prevValue;
                String value;
                String key;
                List<FontEntry> extrasPref = StructUtils.getListOfStructs(Config.getPref(), "font.extended-unicode.extra-items", this.getAdditionalFonts(), FontEntry.class);
                ArrayList<FontEntry> extras = new ArrayList<FontEntry>();
                w.append("\n\n# Added by JOSM to extend unicode coverage of Java font support:\n\n");
                ArrayList<String> allCharSubsets = new ArrayList<String>();
                for (FontEntry entry : extrasPref) {
                    Collection<String> fontsAvail = this.getInstalledFonts();
                    if (fontsAvail != null && fontsAvail.contains(entry.file.toUpperCase(Locale.ENGLISH))) {
                        if (!allCharSubsets.contains(entry.charset)) {
                            allCharSubsets.add(entry.charset);
                            extras.add(entry);
                            continue;
                        }
                        Logging.trace("extended font config - already registered font for charset ''{0}'' - skipping ''{1}''", entry.charset, entry.name);
                        continue;
                    }
                    Logging.trace("extended font config - Font ''{0}'' not found on system - skipping", entry.name);
                }
                for (FontEntry entry : extras) {
                    allCharSubsets.add(entry.charset);
                    if ("".equals(entry.name)) continue;
                    key = "allfonts." + entry.charset;
                    value = entry.name;
                    prevValue = props.getProperty(key);
                    if (prevValue != null && !prevValue.equals(value)) {
                        Logging.warn("extended font config - overriding ''{0}={1}'' with ''{2}''", key, prevValue, value);
                    }
                    w.append(key + '=' + value + '\n');
                }
                w.append('\n');
                for (FontEntry entry : extras) {
                    if ("".equals(entry.name) || "".equals(entry.file)) continue;
                    key = "filename." + entry.name.replace(' ', '_');
                    value = entry.file;
                    prevValue = props.getProperty(key);
                    if (prevValue != null && !prevValue.equals(value)) {
                        Logging.warn("extended font config - overriding ''{0}={1}'' with ''{2}''", key, prevValue, value);
                    }
                    w.append(key + '=' + value + '\n');
                }
                w.append('\n');
                String fallback = props.getProperty("sequence.fallback");
                if (fallback != null) {
                    w.append("sequence.fallback=" + fallback + ',' + Utils.join(",", allCharSubsets) + '\n');
                } else {
                    w.append("sequence.fallback=" + Utils.join(",", allCharSubsets) + '\n');
                }
            }
            Utils.updateSystemProperty("sun.awt.fontconfig", fontconfigFile.toString());
        }
        catch (IOException | InvalidPathException ex) {
            Logging.error(ex);
        }
    }

    protected Collection<String> getInstalledFonts() {
        ArrayList<String> fontsAvail = new ArrayList<String>();
        Path fontPath = FileSystems.getDefault().getPath(Utils.getSystemEnv("SYSTEMROOT"), "Fonts");
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(fontPath);){
            for (Path p : ds) {
                Path filename = p.getFileName();
                if (filename == null) continue;
                fontsAvail.add(filename.toString().toUpperCase(Locale.ENGLISH));
            }
            fontsAvail.add("");
        }
        catch (IOException | DirectoryIteratorException ex) {
            Logging.log(Logging.LEVEL_ERROR, ex);
            Logging.warn("extended font config - failed to load available Fonts");
            fontsAvail = null;
        }
        return fontsAvail;
    }

    protected Collection<FontEntry> getAdditionalFonts() {
        ArrayList<FontEntry> def = new ArrayList<FontEntry>(33);
        def.add(new FontEntry("devanagari", "", ""));
        def.add(new FontEntry("historic", "Segoe UI Historic", "SEGUIHIS.TTF"));
        def.add(new FontEntry("javanese", "Javanese Text", "JAVATEXT.TTF"));
        def.add(new FontEntry("leelawadee", "Leelawadee", "LEELAWAD.TTF"));
        def.add(new FontEntry("malgun", "Malgun Gothic", "MALGUN.TTF"));
        def.add(new FontEntry("myanmar", "Myanmar Text", "MMRTEXT.TTF"));
        def.add(new FontEntry("nirmala", "Nirmala UI", "NIRMALA.TTF"));
        def.add(new FontEntry("segoeui", "Segoe UI", "SEGOEUI.TTF"));
        def.add(new FontEntry("emoji", "Segoe UI Emoji", "SEGUIEMJ.TTF"));
        def.add(new FontEntry("nko_tifinagh_vai_osmanya", "Ebrima", "EBRIMA.TTF"));
        def.add(new FontEntry("khmer1", "Khmer UI", "KHMERUI.TTF"));
        def.add(new FontEntry("lao1", "Lao UI", "LAOUI.TTF"));
        def.add(new FontEntry("tai_le", "Microsoft Tai Le", "TAILE.TTF"));
        def.add(new FontEntry("new_tai_lue", "Microsoft New Tai Lue", "NTHAILU.TTF"));
        def.add(new FontEntry("ethiopic", "Nyala", "NYALA.TTF"));
        def.add(new FontEntry("tibetan", "Microsoft Himalaya", "HIMALAYA.TTF"));
        def.add(new FontEntry("cherokee", "Plantagenet Cherokee", "PLANTC.TTF"));
        def.add(new FontEntry("unified_canadian", "Euphemia", "EUPHEMIA.TTF"));
        def.add(new FontEntry("khmer2", "DaunPenh", "DAUNPENH.TTF"));
        def.add(new FontEntry("khmer3", "MoolBoran", "MOOLBOR.TTF"));
        def.add(new FontEntry("lao_thai", "DokChampa", "DOKCHAMP.TTF"));
        def.add(new FontEntry("mongolian", "Mongolian Baiti", "MONBAITI.TTF"));
        def.add(new FontEntry("oriya", "Kalinga", "KALINGA.TTF"));
        def.add(new FontEntry("sinhala", "Iskoola Pota", "ISKPOTA.TTF"));
        def.add(new FontEntry("yi", "Yi Baiti", "MSYI.TTF"));
        def.add(new FontEntry("gujarati", "Shruti", "SHRUTI.TTF"));
        def.add(new FontEntry("kannada", "Tunga", "TUNGA.TTF"));
        def.add(new FontEntry("gurmukhi", "Raavi", "RAAVI.TTF"));
        def.add(new FontEntry("telugu", "Gautami", "GAUTAMI.TTF"));
        def.add(new FontEntry("bengali", "Vrinda", "VRINDA.TTF"));
        def.add(new FontEntry("syriac", "Estrangelo Edessa", "ESTRE.TTF"));
        def.add(new FontEntry("thaana", "MV Boli", "MVBOLI.TTF"));
        def.add(new FontEntry("malayalam", "Kartika", "KARTIKA.TTF"));
        def.add(new FontEntry("tamil", "Latha", "LATHA.TTF"));
        def.add(new FontEntry("arialuni", "Arial Unicode MS", "ARIALUNI.TTF"));
        return def;
    }

    public static boolean isDotNet45Installed() {
        try {
            Matcher m;
            String version = WinRegistry.readString(-2147483646, "SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v4\\Full", "Version");
            if (version != null && (m = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+.*)?").matcher(version)).matches()) {
                int maj = Integer.parseInt(m.group(1));
                int min = Integer.parseInt(m.group(2));
                return maj == 4 && min >= 5 || maj > 4;
            }
        }
        catch (IllegalAccessException | NumberFormatException | InvocationTargetException e) {
            Logging.error(e);
        }
        return false;
    }

    public static int getPowerShellVersion() {
        try {
            return Integer.parseInt(Utils.execOutput(Arrays.asList("powershell", "-Command", "$PSVersionTable.PSVersion.Major"), 2L, TimeUnit.SECONDS));
        }
        catch (ExecutionException e) {
            Logging.debug(e);
            return -1;
        }
        catch (IOException | InterruptedException | NumberFormatException e) {
            Logging.error(e);
            return -1;
        }
    }

    public static String webRequest(String uri) throws IOException {
        if (PlatformHookWindows.isDotNet45Installed() && PlatformHookWindows.getPowerShellVersion() >= 3) {
            try {
                return Utils.execOutput(Arrays.asList("powershell", "-Command", "[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12;[System.Net.WebRequest]::Create('" + uri + "').GetResponse()"), 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                Logging.error(e);
            }
        }
        return null;
    }

    @Override
    public File resolveFileLink(File file) {
        if (file.getName().endsWith(".lnk")) {
            try {
                return new File(new WindowsShortcut(file).getRealFilename());
            }
            catch (IOException | ParseException e) {
                Logging.error(e);
            }
        }
        return file;
    }

    @Override
    public Collection<String> getPossiblePreferenceDirs() {
        HashSet<String> locations = new HashSet<String>();
        String appdata = Utils.getSystemEnv("APPDATA");
        if (appdata != null && Utils.getSystemEnv("ALLUSERSPROFILE") != null && appdata.lastIndexOf(File.separator) != -1) {
            appdata = appdata.substring(appdata.lastIndexOf(File.separator));
            locations.add(new File(new File(Utils.getSystemEnv("ALLUSERSPROFILE"), appdata), "JOSM").getPath());
        }
        return locations;
    }

    public static class FontEntry {
        @StructUtils.StructEntry
        public String charset;
        @StructUtils.StructEntry
        @StructUtils.WriteExplicitly
        public String name = "";
        @StructUtils.StructEntry
        @StructUtils.WriteExplicitly
        public String file = "";

        public FontEntry() {
        }

        public FontEntry(String charset, String name, String file) {
            this.charset = charset;
            this.name = name;
            this.file = file;
        }
    }
}

