/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import sun.jvm.hotspot.CommandProcessor;
import sun.jvm.hotspot.HotSpotAgent;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.compiler.OopMapSet;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.ParallelScavengeHeap;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.interpreter.InterpreterCodelet;
import sun.jvm.hotspot.memory.GenCollectedHeap;
import sun.jvm.hotspot.oops.HeapVisitor;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.ObjectHistogram;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VFrame;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.ui.AnnotatedMemoryPanel;
import sun.jvm.hotspot.ui.Annotation;
import sun.jvm.hotspot.ui.CommandProcessorPanel;
import sun.jvm.hotspot.ui.DeadlockDetectionPanel;
import sun.jvm.hotspot.ui.DebuggerConsolePanel;
import sun.jvm.hotspot.ui.FindByQueryPanel;
import sun.jvm.hotspot.ui.FindInCodeCachePanel;
import sun.jvm.hotspot.ui.FindInHeapPanel;
import sun.jvm.hotspot.ui.FindPanel;
import sun.jvm.hotspot.ui.GraphicsUtilities;
import sun.jvm.hotspot.ui.HeapParametersPanel;
import sun.jvm.hotspot.ui.Inspector;
import sun.jvm.hotspot.ui.JavaStackTracePanel;
import sun.jvm.hotspot.ui.JavaThreadsPanel;
import sun.jvm.hotspot.ui.MemoryViewer;
import sun.jvm.hotspot.ui.MonitorCacheDumpPanel;
import sun.jvm.hotspot.ui.ObjectHistogramPanel;
import sun.jvm.hotspot.ui.ObjectListPanel;
import sun.jvm.hotspot.ui.ProgressBarPanel;
import sun.jvm.hotspot.ui.SAListener;
import sun.jvm.hotspot.ui.SAPanel;
import sun.jvm.hotspot.ui.SysPropsPanel;
import sun.jvm.hotspot.ui.ThreadInfoPanel;
import sun.jvm.hotspot.ui.VMFlagsPanel;
import sun.jvm.hotspot.ui.VMVersionInfoPanel;
import sun.jvm.hotspot.ui.classbrowser.ClassBrowserPanel;
import sun.jvm.hotspot.ui.classbrowser.CodeViewerPanel;
import sun.jvm.hotspot.ui.classbrowser.HTMLGenerator;
import sun.jvm.hotspot.ui.tree.OopTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.SimpleTreeNode;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.FindObjectByType;
import sun.jvm.hotspot.utilities.HeapProgressThunk;
import sun.jvm.hotspot.utilities.LivenessPathList;
import sun.jvm.hotspot.utilities.ProgressiveHeapVisitor;
import sun.jvm.hotspot.utilities.ReversePtrsAnalysis;
import sun.jvm.hotspot.utilities.SystemDictionaryHelper;
import sun.jvm.hotspot.utilities.WorkerThread;

public class HSDB
implements ObjectHistogramPanel.Listener,
SAListener {
    private HotSpotAgent agent;
    private JVMDebugger jvmDebugger;
    private JDesktopPane desktop;
    private boolean attached;
    private boolean argError;
    private JFrame frame;
    private List attachMenuItems;
    private List detachMenuItems;
    private JMenu toolsMenu;
    private JMenuItem showDbgConsoleMenuItem;
    private JMenuItem computeRevPtrsMenuItem;
    private JInternalFrame attachWaitDialog;
    private JInternalFrame threadsFrame;
    private JInternalFrame consoleFrame;
    private WorkerThread workerThread;
    private String pidText;
    private int pid;
    private String execPath;
    private String coreFilename;

    public static void main(String[] args) {
        new HSDB(args).run();
    }

    private void doUsage() {
        System.out.println("Usage:  java HSDB [[pid] | [path-to-java-executable [path-to-corefile]] | help ]");
        System.out.println("           pid:                     attach to the process whose id is 'pid'");
        System.out.println("           path-to-java-executable: Debug a core file produced by this program");
        System.out.println("           path-to-corefile:        Debug this corefile.  The default is 'core'");
        System.out.println("        If no arguments are specified, you can select what to do from the GUI.\n");
        HotSpotAgent.showUsage();
        this.argError = true;
    }

    public HSDB(JVMDebugger d) {
        this.jvmDebugger = d;
    }

    private HSDB(String[] args) {
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                if (args[0].equals("help") || args[0].equals("-help")) {
                    this.doUsage();
                }
                try {
                    int unused = Integer.parseInt(args[0]);
                    this.pidText = args[0];
                }
                catch (NumberFormatException e) {
                    this.execPath = args[0];
                    this.coreFilename = "core";
                }
                break;
            }
            case 2: {
                this.execPath = args[0];
                this.coreFilename = args[1];
                break;
            }
            default: {
                System.out.println("HSDB Error: Too many options specified");
                this.doUsage();
            }
        }
    }

    protected void closeUI() {
        this.workerThread.shutdown();
        this.frame.dispose();
    }

    public void run() {
        if (this.argError) {
            return;
        }
        this.agent = new HotSpotAgent();
        this.workerThread = new WorkerThread();
        this.attachMenuItems = new ArrayList();
        this.detachMenuItems = new ArrayList();
        this.frame = new JFrame("HSDB - HotSpot Debugger");
        this.frame.setSize(800, 600);
        this.frame.setDefaultCloseOperation(2);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        JMenuItem item = HSDB.createMenuItem("Attach to HotSpot process...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showAttachDialog();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        item.setMnemonic(65);
        menu.add(item);
        this.attachMenuItems.add(item);
        item = HSDB.createMenuItem("Open HotSpot core file...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showOpenCoreFileDialog();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        item.setMnemonic(79);
        menu.add(item);
        this.attachMenuItems.add(item);
        item = HSDB.createMenuItem("Connect to debug server...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showConnectDialog();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        item.setMnemonic(83);
        menu.add(item);
        this.attachMenuItems.add(item);
        item = HSDB.createMenuItem("Detach", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.detach();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        item.setMnemonic(83);
        menu.add(item);
        this.detachMenuItems.add(item);
        this.setMenuItemsEnabled(this.detachMenuItems, false);
        menu.addSeparator();
        item = HSDB.createMenuItem("Exit", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.closeUI();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        item.setMnemonic(88);
        menu.add(item);
        menuBar.add(menu);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic(84);
        item = HSDB.createMenuItem("Class Browser", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showClassBrowser();
            }
        });
        item.setMnemonic(66);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Code Viewer", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showCodeViewer();
            }
        });
        item.setMnemonic(67);
        this.toolsMenu.add(item);
        this.computeRevPtrsMenuItem = item = HSDB.createMenuItem("Compute Reverse Ptrs", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.fireComputeReversePtrs();
            }
        });
        item.setMnemonic(77);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Deadlock Detection", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showDeadlockDetectionPanel();
            }
        });
        item.setMnemonic(68);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Find Object by Query", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showFindByQueryPanel();
            }
        });
        item.setMnemonic(81);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Find Pointer", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showFindPanel();
            }
        });
        item.setMnemonic(80);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Find Value In Heap", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showFindInHeapPanel();
            }
        });
        item.setMnemonic(86);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Find Value In Code Cache", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showFindInCodeCachePanel();
            }
        });
        item.setMnemonic(65);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Heap Parameters", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showHeapParametersPanel();
            }
        });
        item.setMnemonic(72);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Inspector", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showInspector(null);
            }
        });
        item.setMnemonic(82);
        item.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Memory Viewer", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showMemoryViewer();
            }
        });
        item.setMnemonic(77);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Monitor Cache Dump", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showMonitorCacheDumpPanel();
            }
        });
        item.setMnemonic(68);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Object Histogram", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showObjectHistogram();
            }
        });
        item.setMnemonic(79);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Show System Properties", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showSystemProperties();
            }
        });
        item.setMnemonic(83);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Show VM Version", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showVMVersion();
            }
        });
        item.setMnemonic(77);
        this.toolsMenu.add(item);
        item = HSDB.createMenuItem("Show -XX flags", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showCommandLineFlags();
            }
        });
        item.setMnemonic(88);
        this.toolsMenu.add(item);
        this.toolsMenu.setEnabled(false);
        menuBar.add(this.toolsMenu);
        JMenu windowsMenu = new JMenu("Windows");
        windowsMenu.setMnemonic(87);
        item = HSDB.createMenuItem("Console", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showConsole();
            }
        });
        item.setMnemonic(67);
        windowsMenu.add(item);
        this.showDbgConsoleMenuItem = HSDB.createMenuItem("Debugger Console", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HSDB.this.showDebuggerConsole();
            }
        });
        this.showDbgConsoleMenuItem.setMnemonic(68);
        windowsMenu.add(this.showDbgConsoleMenuItem);
        this.showDbgConsoleMenuItem.setEnabled(false);
        menuBar.add(windowsMenu);
        this.frame.setJMenuBar(menuBar);
        this.desktop = new JDesktopPane();
        this.frame.getContentPane().add(this.desktop);
        GraphicsUtilities.reshapeToAspectRatio(this.frame, 1.3333334f, 0.75f, Toolkit.getDefaultToolkit().getScreenSize());
        GraphicsUtilities.centerInContainer(this.frame, Toolkit.getDefaultToolkit().getScreenSize());
        this.frame.setVisible(true);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                HSDB.this.detachDebugger();
            }
        });
        if (this.jvmDebugger != null) {
            this.attach(this.jvmDebugger);
        } else if (this.pidText != null) {
            this.attach(this.pidText);
        } else if (this.execPath != null) {
            this.attach(this.execPath, this.coreFilename);
        }
    }

    private void showAttachDialog() {
        this.setMenuItemsEnabled(this.attachMenuItems, false);
        final JInternalFrame attachDialog = new JInternalFrame("Attach to HotSpot process");
        attachDialog.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        attachDialog.setBackground(panel.getBackground());
        panel.add(new JLabel("Enter process ID:"));
        final JTextField pidTextField = new JTextField(10);
        ActionListener attacher = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                attachDialog.setVisible(false);
                HSDB.this.desktop.remove(attachDialog);
                HSDB.this.workerThread.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HSDB.this.attach(pidTextField.getText());
                    }
                });
            }
        };
        pidTextField.addActionListener(attacher);
        panel.add(pidTextField);
        attachDialog.getContentPane().add((Component)panel, "North");
        Box vbox = Box.createVerticalBox();
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JTextArea ta = new JTextArea("Enter the process ID of a currently-running HotSpot process. On Solaris and most Unix operating systems, this can be determined by typing \"ps -u <your username> | grep java\"; the process ID is the first number which appears on the resulting line. On Windows, the process ID is present in the Task Manager, which can be brought up while logged on to the desktop by pressing Ctrl-Alt-Delete.");
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setEditable(false);
        ta.setBackground(panel.getBackground());
        panel.add(ta);
        vbox.add(panel);
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createGlue());
        JButton button = new JButton("OK");
        button.addActionListener(attacher);
        hbox.add(button);
        hbox.add(Box.createHorizontalStrut(20));
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                attachDialog.setVisible(false);
                HSDB.this.desktop.remove(attachDialog);
                HSDB.this.setMenuItemsEnabled(HSDB.this.attachMenuItems, true);
            }
        });
        hbox.add(button);
        hbox.add(Box.createGlue());
        panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(hbox);
        vbox.add(panel);
        attachDialog.getContentPane().add((Component)vbox, "South");
        this.desktop.add(attachDialog);
        attachDialog.setSize(400, 300);
        GraphicsUtilities.centerInContainer(attachDialog);
        attachDialog.show();
        pidTextField.requestFocus();
    }

    private void showOpenCoreFileDialog() {
        this.setMenuItemsEnabled(this.attachMenuItems, false);
        final JInternalFrame dialog = new JInternalFrame("Open Core File");
        dialog.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        dialog.setBackground(panel.getBackground());
        Box hbox = Box.createHorizontalBox();
        Box vbox = Box.createVerticalBox();
        vbox.add(new JLabel("Path to core file:"));
        vbox.add(new JLabel("Path to Java executable:"));
        hbox.add(vbox);
        vbox = Box.createVerticalBox();
        final JTextField corePathField = new JTextField(40);
        final JTextField execPathField = new JTextField(40);
        vbox.add(corePathField);
        vbox.add(execPathField);
        hbox.add(vbox);
        JButton browseCorePath = new JButton("Browse ..");
        JButton browseExecPath = new JButton("Browse ..");
        browseCorePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(new File("."));
                int retVal = fileChooser.showOpenDialog(dialog);
                if (retVal == 0) {
                    corePathField.setText(fileChooser.getSelectedFile().getPath());
                }
            }
        });
        browseExecPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(new File("."));
                int retVal = fileChooser.showOpenDialog(dialog);
                if (retVal == 0) {
                    execPathField.setText(fileChooser.getSelectedFile().getPath());
                }
            }
        });
        vbox = Box.createVerticalBox();
        vbox.add(browseCorePath);
        vbox.add(browseExecPath);
        hbox.add(vbox);
        panel.add(hbox);
        dialog.getContentPane().add((Component)panel, "North");
        ActionListener attacher = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                HSDB.this.desktop.remove(dialog);
                HSDB.this.workerThread.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HSDB.this.attach(execPathField.getText(), corePathField.getText());
                    }
                });
            }
        };
        corePathField.addActionListener(attacher);
        execPathField.addActionListener(attacher);
        vbox = Box.createVerticalBox();
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JTextArea ta = new JTextArea("Enter the full path names to the core file from a HotSpot process and the Java executable from which it came. The latter is typically located in the JDK/JRE directory under the directory jre/bin/<arch>/native_threads.");
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setEditable(false);
        ta.setBackground(panel.getBackground());
        panel.add(ta);
        vbox.add(panel);
        hbox = Box.createHorizontalBox();
        hbox.add(Box.createGlue());
        JButton button = new JButton("OK");
        button.addActionListener(attacher);
        hbox.add(button);
        hbox.add(Box.createHorizontalStrut(20));
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                HSDB.this.desktop.remove(dialog);
                HSDB.this.setMenuItemsEnabled(HSDB.this.attachMenuItems, true);
            }
        });
        hbox.add(button);
        hbox.add(Box.createGlue());
        panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(hbox);
        vbox.add(panel);
        dialog.getContentPane().add((Component)vbox, "South");
        this.desktop.add(dialog);
        dialog.setSize(500, 300);
        GraphicsUtilities.centerInContainer(dialog);
        dialog.show();
        corePathField.requestFocus();
    }

    private void showConnectDialog() {
        this.setMenuItemsEnabled(this.attachMenuItems, false);
        final JInternalFrame dialog = new JInternalFrame("Connect to HotSpot Debug Server");
        dialog.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        dialog.setBackground(panel.getBackground());
        panel.add(new JLabel("Enter machine name:"));
        final JTextField pidTextField = new JTextField(40);
        ActionListener attacher = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                HSDB.this.desktop.remove(dialog);
                HSDB.this.workerThread.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HSDB.this.connect(pidTextField.getText());
                    }
                });
            }
        };
        pidTextField.addActionListener(attacher);
        panel.add(pidTextField);
        dialog.getContentPane().add((Component)panel, "North");
        Box vbox = Box.createVerticalBox();
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JTextArea ta = new JTextArea("Enter the name of a machine on which the HotSpot \"Debug Server\" is running and is attached to a process or core file.");
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setEditable(false);
        ta.setBackground(panel.getBackground());
        panel.add(ta);
        vbox.add(panel);
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createGlue());
        JButton button = new JButton("OK");
        button.addActionListener(attacher);
        hbox.add(button);
        hbox.add(Box.createHorizontalStrut(20));
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                HSDB.this.desktop.remove(dialog);
                HSDB.this.setMenuItemsEnabled(HSDB.this.attachMenuItems, true);
            }
        });
        hbox.add(button);
        hbox.add(Box.createGlue());
        panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(hbox);
        vbox.add(panel);
        dialog.getContentPane().add((Component)vbox, "South");
        this.desktop.add(dialog);
        dialog.setSize(400, 300);
        GraphicsUtilities.centerInContainer(dialog);
        dialog.show();
        pidTextField.requestFocus();
    }

    @Override
    public void showThreadOopInspector(JavaThread thread) {
        this.showInspector(new OopTreeNodeAdapter(thread.getThreadObj(), null));
    }

    @Override
    public void showInspector(SimpleTreeNode adapter) {
        this.showPanel("Inspector", new Inspector(adapter), 1.0f, 0.65f);
    }

    @Override
    public void showLiveness(Oop oop, LivenessPathList liveness) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream tty = new PrintStream(bos);
        int numPaths = liveness.size();
        for (int i = 0; i < numPaths; ++i) {
            tty.println("Path " + (i + 1) + " of " + numPaths + ":");
            liveness.get(i).printOn(tty);
        }
        JTextArea ta = new JTextArea(bos.toString());
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setEditable(false);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(ta);
        panel.add((Component)scroller, "Center");
        bos = new ByteArrayOutputStream();
        tty = new PrintStream(bos);
        tty.print("Liveness result for ");
        Oop.printOopValueOn(oop, tty);
        JInternalFrame frame = new JInternalFrame(bos.toString());
        frame.setResizable(true);
        frame.setClosable(true);
        frame.setIconifiable(true);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        this.desktop.add(frame);
        GraphicsUtilities.reshapeToAspectRatio(frame, 2.5f, 0.5f, frame.getParent().getSize());
        frame.show();
    }

    private void fireComputeReversePtrs() {
        if (VM.getVM().getRevPtrs() != null) {
            this.computeRevPtrsMenuItem.setEnabled(false);
            return;
        }
        this.workerThread.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HeapProgress progress = new HeapProgress("Reverse Pointers Analysis");
                try {
                    ReversePtrsAnalysis analysis = new ReversePtrsAnalysis();
                    analysis.setHeapProgressThunk(progress);
                    analysis.run();
                    HSDB.this.computeRevPtrsMenuItem.setEnabled(false);
                }
                catch (OutOfMemoryError e) {
                    final String errMsg = HSDB.this.formatMessage(e.toString(), 80);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showInternalMessageDialog(HSDB.this.desktop, "Error computing reverse pointers:" + errMsg, "Error", 2);
                        }
                    });
                }
                finally {
                    progress.heapIterationComplete();
                }
            }
        });
    }

    @Override
    public void showThreadStackMemory(final JavaThread thread) {
        Address sp;
        Address starting;
        JavaVFrame vframe = HSDB.getLastJavaVFrame(thread);
        if (vframe == null) {
            JOptionPane.showInternalMessageDialog(this.desktop, "Thread \"" + thread.getThreadName() + "\" has no Java frames on its stack", "Show Stack Memory", 1);
            return;
        }
        JInternalFrame stackFrame = new JInternalFrame("Stack Memory for " + thread.getThreadName());
        stackFrame.getContentPane().setLayout(new BorderLayout());
        stackFrame.setResizable(true);
        stackFrame.setClosable(true);
        stackFrame.setIconifiable(true);
        final long addressSize = this.agent.getTypeDataBase().getAddressSize();
        boolean is64Bit = addressSize == 8L;
        Frame tmpFrame = thread.getCurrentFrameGuess();
        Address maxSP = starting = (sp = tmpFrame.getSP());
        Address minSP = starting;
        RegisterMap tmpMap = thread.newRegisterMap(false);
        while (tmpFrame != null && !tmpFrame.isFirstFrame()) {
            if ((tmpFrame = tmpFrame.sender(tmpMap)) == null || (sp = tmpFrame.getSP()) == null) continue;
            maxSP = AddressOps.max(maxSP, sp);
            minSP = AddressOps.min(minSP, sp);
        }
        AnnotatedMemoryPanel annoMemPanel = new AnnotatedMemoryPanel(this.agent.getDebugger(), is64Bit, starting, minSP.addOffsetTo(-8192L), maxSP.addOffsetTo(8192L));
        stackFrame.getContentPane().add((Component)annoMemPanel, "Center");
        this.desktop.add(stackFrame);
        GraphicsUtilities.reshapeToAspectRatio(stackFrame, 1.3333334f, 0.85f, stackFrame.getParent().getSize());
        stackFrame.show();
        this.workerThread.invokeLater(new StackWalker(vframe, annoMemPanel){

            @Override
            public void run() {
                Address startAddr = null;
                HashMap<Frame, SignalInfo> interruptedFrameMap = new HashMap<Frame, SignalInfo>();
                RegisterMap tmpMap = thread.newRegisterMap(false);
                for (Frame tmpFrame = thread.getCurrentFrameGuess(); tmpFrame != null && !tmpFrame.isFirstFrame(); tmpFrame = tmpFrame.sender(tmpMap)) {
                    if (!tmpFrame.isSignalHandlerFrameDbg()) continue;
                    Frame interruptedFrame = tmpFrame.sender(tmpMap);
                    SignalInfo info = new SignalInfo();
                    info.sigNum = tmpFrame.getSignalNumberDbg();
                    info.sigName = tmpFrame.getSignalNameDbg();
                    interruptedFrameMap.put(interruptedFrame, info);
                }
                while (this.vf != null) {
                    SignalInfo sigInfo;
                    CodeBlob cb;
                    OopMapSet maps;
                    String anno = null;
                    JavaVFrame curVFrame = this.vf;
                    Frame curFrame = curVFrame.getFrame();
                    Method interpreterFrameMethod = null;
                    if (curVFrame.isInterpretedFrame()) {
                        anno = "Interpreted frame";
                    } else {
                        anno = "Compiled frame";
                        if (curVFrame.isDeoptimized()) {
                            anno = anno + " (deoptimized)";
                        }
                    }
                    if (curVFrame.mayBeImpreciseDbg()) {
                        anno = anno + "; information may be imprecise";
                    }
                    if (curVFrame.isInterpretedFrame()) {
                        InterpreterCodelet codelet = VM.getVM().getInterpreter().getCodeletContaining(curFrame.getPC());
                        String description = null;
                        if (codelet != null) {
                            description = codelet.getDescription();
                        }
                        anno = description == null ? anno + "\n(Unknown interpreter codelet)" : anno + "\nExecuting in codelet \"" + description + "\" at PC = " + curFrame.getPC();
                    } else if (curVFrame.isCompiledFrame()) {
                        anno = anno + "\nExecuting at PC = " + curFrame.getPC();
                    }
                    if (startAddr == null) {
                        startAddr = curFrame.getSP();
                    }
                    boolean shouldSkipOopMaps = false;
                    if (curVFrame.isCompiledFrame() && ((maps = (cb = VM.getVM().getCodeCache().findBlob(curFrame.getPC())).getOopMaps()) == null || maps.getSize() == 0L)) {
                        shouldSkipOopMaps = true;
                    }
                    if ((sigInfo = (SignalInfo)interruptedFrameMap.get(curFrame)) != null) {
                        anno = anno + "\n*** INTERRUPTED BY SIGNAL " + Integer.toString(sigInfo.sigNum) + " (" + sigInfo.sigName + ")";
                    }
                    JavaVFrame nextVFrame = curVFrame;
                    Frame nextFrame = curFrame;
                    do {
                        curVFrame = nextVFrame;
                        curFrame = nextFrame;
                        try {
                            Method method = curVFrame.getMethod();
                            if (interpreterFrameMethod == null && curVFrame.isInterpretedFrame()) {
                                interpreterFrameMethod = method;
                            }
                            int bci = curVFrame.getBCI();
                            String lineNumberAnno = "";
                            if (method.hasLineNumberTable()) {
                                lineNumberAnno = bci == -1 || bci >= 0 && (long)bci < method.getCodeSize() ? ", line " + method.getLineNumberFromBCI(bci) : " (INVALID BCI)";
                            }
                            anno = anno + "\n" + method.getMethodHolder().getName().asString() + "." + method.getName().asString() + method.getSignature().asString() + "\n@bci " + bci + lineNumberAnno;
                        }
                        catch (Exception e) {
                            anno = anno + "\n(ERROR while iterating vframes for frame " + curFrame + ")";
                        }
                        nextVFrame = curVFrame.javaSender();
                        if (nextVFrame == null) continue;
                        nextFrame = nextVFrame.getFrame();
                    } while (nextVFrame != null && nextFrame.equals(curFrame));
                    if (shouldSkipOopMaps) {
                        anno = anno + "\nNOTE: null or empty OopMapSet found for this CodeBlob";
                    }
                    if (curFrame.getFP() != null) {
                        this.annoPanel.addAnnotation(new Annotation(curFrame.getSP(), curFrame.getFP(), anno));
                    } else if (VM.getVM().getCPU().equals("x86") || VM.getVM().getCPU().equals("amd64")) {
                        CodeBlob cb2 = VM.getVM().getCodeCache().findBlob(curFrame.getPC());
                        Address sp = curFrame.getSP();
                        if (Assert.ASSERTS_ENABLED) {
                            Assert.that(cb2.getFrameSize() > 0L, "CodeBlob must have non-zero frame size");
                        }
                        this.annoPanel.addAnnotation(new Annotation(sp, sp.addOffsetTo(cb2.getFrameSize()), anno));
                    } else {
                        Assert.that(VM.getVM().getCPU().equals("ia64"), "only ia64 should reach here");
                    }
                    if (curFrame.isInterpretedFrame()) {
                        this.annoPanel.addAnnotation(new Annotation(curFrame.addressOfInterpreterFrameExpressionStack(), curFrame.addressOfInterpreterFrameTOS(), "Interpreter expression stack"));
                        Address monBegin = curFrame.interpreterFrameMonitorBegin().address();
                        Address monEnd = curFrame.interpreterFrameMonitorEnd().address();
                        if (!monBegin.equals(monEnd)) {
                            this.annoPanel.addAnnotation(new Annotation(monBegin, monEnd, "BasicObjectLocks"));
                        }
                        if (interpreterFrameMethod != null) {
                            int offset = 1;
                            this.annoPanel.addAnnotation(new Annotation(curFrame.addressOfInterpreterFrameLocal(offset), curFrame.addressOfInterpreterFrameLocal((int)interpreterFrameMethod.getMaxLocals() + offset), "Interpreter locals area for frame with SP = " + curFrame.getSP()));
                        }
                        String methodAnno = "Interpreter frame Method*";
                        if (interpreterFrameMethod == null) {
                            methodAnno = methodAnno + " (BAD OOP)";
                        }
                        Address a = curFrame.addressOfInterpreterFrameMethod();
                        this.annoPanel.addAnnotation(new Annotation(a, a.addOffsetTo(addressSize), methodAnno));
                        a = curFrame.addressOfInterpreterFrameCPCache();
                        this.annoPanel.addAnnotation(new Annotation(a, a.addOffsetTo(addressSize), "Interpreter constant pool cache"));
                    }
                    RegisterMap rm = (RegisterMap)this.vf.getRegisterMap().clone();
                    if (!shouldSkipOopMaps) {
                        try {
                            curFrame.oopsDo(new AddressVisitor(){

                                @Override
                                public void visitAddress(Address addr) {
                                    if (Assert.ASSERTS_ENABLED) {
                                        Assert.that(addr.andWithMask(VM.getVM().getAddressSize() - 1L) == null, "Address " + addr + "should have been aligned");
                                    }
                                    OopHandle handle = addr.getOopHandleAt(0L);
                                    this.addAnnotation(addr, handle);
                                }

                                @Override
                                public void visitCompOopAddress(Address addr) {
                                    if (Assert.ASSERTS_ENABLED) {
                                        Assert.that(addr.andWithMask(VM.getVM().getAddressSize() - 1L) == null, "Address " + addr + "should have been aligned");
                                    }
                                    OopHandle handle = addr.getCompOopHandleAt(0L);
                                    this.addAnnotation(addr, handle);
                                }

                                public void addAnnotation(Address addr, OopHandle handle) {
                                    String anno = "null oop";
                                    if (handle != null) {
                                        CollectedHeap heap;
                                        CollectedHeap collHeap = VM.getVM().getUniverse().heap();
                                        boolean bad = true;
                                        anno = "BAD OOP";
                                        if (collHeap instanceof GenCollectedHeap) {
                                            heap = (GenCollectedHeap)collHeap;
                                            for (int i = 0; i < ((GenCollectedHeap)heap).nGens(); ++i) {
                                                if (!((GenCollectedHeap)heap).getGen(i).isIn(handle)) continue;
                                                anno = i == 0 ? "NewGen " : (i == 1 ? "OldGen " : "Gen " + i + " ");
                                                bad = false;
                                                break;
                                            }
                                        } else if (collHeap instanceof ParallelScavengeHeap) {
                                            heap = (ParallelScavengeHeap)collHeap;
                                            if (((ParallelScavengeHeap)heap).youngGen().isIn(handle)) {
                                                anno = "PSYoungGen ";
                                                bad = false;
                                            } else if (((ParallelScavengeHeap)heap).oldGen().isIn(handle)) {
                                                anno = "PSOldGen ";
                                                bad = false;
                                            }
                                        } else {
                                            anno = "[Unknown generation] ";
                                            bad = false;
                                        }
                                        if (!bad) {
                                            try {
                                                Oop oop = VM.getVM().getObjectHeap().newOop(handle);
                                                if (oop instanceof Instance) {
                                                    anno = anno + oop.getKlass().getName().asString();
                                                } else {
                                                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                                                    Oop.printOopValueOn(oop, new PrintStream(bos));
                                                    anno = anno + bos.toString();
                                                }
                                            }
                                            catch (AddressException e) {
                                                anno = anno + "CORRUPT OOP";
                                            }
                                            catch (NullPointerException e) {
                                                anno = anno + "CORRUPT OOP (null pointer)";
                                            }
                                        }
                                    }
                                    annoPanel.addAnnotation(new Annotation(addr, addr.addOffsetTo(addressSize), anno));
                                }
                            }, rm);
                        }
                        catch (Exception e) {
                            System.err.println("Error while performing oopsDo for frame " + curFrame);
                            e.printStackTrace();
                        }
                    }
                    this.vf = nextVFrame;
                }
                this.annoPanel.makeVisible(startAddr);
                this.annoPanel.repaint();
            }
        });
    }

    private void attach(JVMDebugger d) {
        this.attached = true;
        this.showThreadsDialog();
    }

    private void attach(String pidText) {
        try {
            this.pidText = pidText;
            this.pid = Integer.parseInt(pidText);
        }
        catch (NumberFormatException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HSDB.this.setMenuItemsEnabled(HSDB.this.attachMenuItems, true);
                    JOptionPane.showInternalMessageDialog(HSDB.this.desktop, "Unable to parse process ID \"" + HSDB.this.pidText + "\".\nPlease enter a number.", "Parse error", 2);
                }
            });
            return;
        }
        Runnable remover = new Runnable(){

            @Override
            public void run() {
                HSDB.this.attachWaitDialog.setVisible(false);
                HSDB.this.desktop.remove(HSDB.this.attachWaitDialog);
                HSDB.this.attachWaitDialog = null;
            }
        };
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane pane = new JOptionPane("Attaching to process " + HSDB.this.pid + ", please wait...", 1);
                    pane.setOptions(new Object[0]);
                    HSDB.this.attachWaitDialog = pane.createInternalFrame(HSDB.this.desktop, "Attaching to Process");
                    HSDB.this.attachWaitDialog.show();
                }
            });
            this.agent.attach(this.pid);
            if (this.agent.getDebugger().hasConsole()) {
                this.showDbgConsoleMenuItem.setEnabled(true);
            }
            this.attached = true;
            SwingUtilities.invokeLater(remover);
        }
        catch (DebuggerException e) {
            SwingUtilities.invokeLater(remover);
            final String errMsg = this.formatMessage(e.getMessage(), 80);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HSDB.this.setMenuItemsEnabled(HSDB.this.attachMenuItems, true);
                    JOptionPane.showInternalMessageDialog(HSDB.this.desktop, "Unable to connect to process ID " + HSDB.this.pid + ":\n\n" + errMsg, "Unable to Connect", 2);
                }
            });
            this.agent.detach();
            return;
        }
        this.showThreadsDialog();
    }

    private void attach(String executablePath, final String corePath) {
        Runnable remover = new Runnable(){

            @Override
            public void run() {
                HSDB.this.attachWaitDialog.setVisible(false);
                HSDB.this.desktop.remove(HSDB.this.attachWaitDialog);
                HSDB.this.attachWaitDialog = null;
            }
        };
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane pane = new JOptionPane("Opening core file, please wait...", 1);
                    pane.setOptions(new Object[0]);
                    HSDB.this.attachWaitDialog = pane.createInternalFrame(HSDB.this.desktop, "Opening Core File");
                    HSDB.this.attachWaitDialog.show();
                }
            });
            this.agent.attach(executablePath, corePath);
            if (this.agent.getDebugger().hasConsole()) {
                this.showDbgConsoleMenuItem.setEnabled(true);
            }
            this.attached = true;
            SwingUtilities.invokeLater(remover);
        }
        catch (DebuggerException e) {
            SwingUtilities.invokeLater(remover);
            final String errMsg = this.formatMessage(e.getMessage(), 80);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HSDB.this.setMenuItemsEnabled(HSDB.this.attachMenuItems, true);
                    JOptionPane.showInternalMessageDialog(HSDB.this.desktop, "Unable to open core file\n" + corePath + ":\n\n" + errMsg, "Unable to Open Core File", 2);
                }
            });
            this.agent.detach();
            return;
        }
        this.showThreadsDialog();
    }

    private void connect(final String remoteMachineName) {
        Runnable remover = new Runnable(){

            @Override
            public void run() {
                HSDB.this.attachWaitDialog.setVisible(false);
                HSDB.this.desktop.remove(HSDB.this.attachWaitDialog);
                HSDB.this.attachWaitDialog = null;
            }
        };
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane pane = new JOptionPane("Connecting to debug server, please wait...", 1);
                    pane.setOptions(new Object[0]);
                    HSDB.this.attachWaitDialog = pane.createInternalFrame(HSDB.this.desktop, "Connecting to Debug Server");
                    HSDB.this.attachWaitDialog.show();
                }
            });
            this.agent.attach(remoteMachineName);
            if (this.agent.getDebugger().hasConsole()) {
                this.showDbgConsoleMenuItem.setEnabled(true);
            }
            this.attached = true;
            SwingUtilities.invokeLater(remover);
        }
        catch (DebuggerException e) {
            SwingUtilities.invokeLater(remover);
            final String errMsg = this.formatMessage(e.getMessage(), 80);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HSDB.this.setMenuItemsEnabled(HSDB.this.attachMenuItems, true);
                    JOptionPane.showInternalMessageDialog(HSDB.this.desktop, "Unable to connect to machine \"" + remoteMachineName + "\":\n\n" + errMsg, "Unable to Connect", 2);
                }
            });
            this.agent.detach();
            return;
        }
        this.showThreadsDialog();
    }

    private void detachDebugger() {
        if (!this.attached) {
            return;
        }
        this.agent.detach();
        this.attached = false;
    }

    private void detach() {
        this.detachDebugger();
        this.attachWaitDialog = null;
        this.threadsFrame = null;
        this.consoleFrame = null;
        this.setMenuItemsEnabled(this.attachMenuItems, true);
        this.setMenuItemsEnabled(this.detachMenuItems, false);
        this.toolsMenu.setEnabled(false);
        this.showDbgConsoleMenuItem.setEnabled(false);
        this.desktop.removeAll();
        this.desktop.invalidate();
        this.desktop.validate();
        this.desktop.repaint();
    }

    private void showThreadsDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HSDB.this.threadsFrame = new JInternalFrame("Java Threads");
                HSDB.this.threadsFrame.setResizable(true);
                HSDB.this.threadsFrame.setIconifiable(true);
                JavaThreadsPanel threadsPanel = new JavaThreadsPanel();
                threadsPanel.addPanelListener(HSDB.this);
                HSDB.this.threadsFrame.getContentPane().add(threadsPanel);
                HSDB.this.threadsFrame.setSize(500, 300);
                HSDB.this.threadsFrame.pack();
                HSDB.this.desktop.add(HSDB.this.threadsFrame);
                GraphicsUtilities.moveToInContainer(HSDB.this.threadsFrame, 0.75f, 0.25f, 0, 20);
                HSDB.this.threadsFrame.show();
                HSDB.this.setMenuItemsEnabled(HSDB.this.attachMenuItems, false);
                HSDB.this.setMenuItemsEnabled(HSDB.this.detachMenuItems, true);
                HSDB.this.toolsMenu.setEnabled(true);
                VM.registerVMInitializedObserver(new Observer(){

                    @Override
                    public void update(Observable o, Object data) {
                        HSDB.this.computeRevPtrsMenuItem.setEnabled(true);
                    }
                });
            }
        });
    }

    private void showObjectHistogram() {
        ObjectHistogram histo = new ObjectHistogram();
        ObjectHistogramCleanupThunk cleanup = new ObjectHistogramCleanupThunk(histo);
        this.doHeapIteration("Object Histogram", "Generating histogram...", histo, cleanup);
    }

    @Override
    public void showObjectsOfType(Klass type) {
        FindObjectByType finder = new FindObjectByType(type);
        FindObjectByTypeCleanupThunk cleanup = new FindObjectByTypeCleanupThunk(finder);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        type.printValueOn(new PrintStream(bos));
        String typeName = bos.toString();
        this.doHeapIteration("Show Objects Of Type", "Finding instances of \"" + typeName + "\"", finder, cleanup);
    }

    private void showDebuggerConsole() {
        if (this.consoleFrame == null) {
            this.consoleFrame = new JInternalFrame("Debugger Console");
            this.consoleFrame.setResizable(true);
            this.consoleFrame.setClosable(true);
            this.consoleFrame.setIconifiable(true);
            this.consoleFrame.getContentPane().setLayout(new BorderLayout());
            this.consoleFrame.getContentPane().add((Component)new DebuggerConsolePanel(this.agent.getDebugger()), "Center");
            GraphicsUtilities.reshapeToAspectRatio(this.consoleFrame, 5.0f, 0.9f, this.desktop.getSize());
        }
        if (this.consoleFrame.getParent() == null) {
            this.desktop.add(this.consoleFrame);
        }
        this.consoleFrame.setVisible(true);
        this.consoleFrame.show();
        this.consoleFrame.getContentPane().getComponent(0).requestFocus();
    }

    private void showConsole() {
        CommandProcessor.DebuggerInterface di = new CommandProcessor.DebuggerInterface(){

            @Override
            public HotSpotAgent getAgent() {
                return HSDB.this.agent;
            }

            @Override
            public boolean isAttached() {
                return HSDB.this.attached;
            }

            @Override
            public void attach(String pid) {
                this.attach(pid);
            }

            @Override
            public void attach(String java, String core) {
            }

            @Override
            public void detach() {
                HSDB.this.detachDebugger();
            }

            @Override
            public void reattach() {
                if (HSDB.this.attached) {
                    HSDB.this.detachDebugger();
                }
                if (HSDB.this.pidText != null) {
                    this.attach(HSDB.this.pidText);
                } else {
                    this.attach(HSDB.this.execPath, HSDB.this.coreFilename);
                }
            }
        };
        this.showPanel("Command Line", new CommandProcessorPanel(new CommandProcessor(di, null, null, null)));
    }

    private void showFindByQueryPanel() {
        this.showPanel("Find Object by Query", new FindByQueryPanel());
    }

    private void showFindPanel() {
        this.showPanel("Find Pointer", new FindPanel());
    }

    private void showFindInHeapPanel() {
        this.showPanel("Find Address In Heap", new FindInHeapPanel());
    }

    private void showFindInCodeCachePanel() {
        this.showPanel("Find Address In Code Cache", new FindInCodeCachePanel());
    }

    private void showHeapParametersPanel() {
        this.showPanel("Heap Parameters", new HeapParametersPanel());
    }

    @Override
    public void showThreadInfo(JavaThread thread) {
        this.showPanel("Info for " + thread.getThreadName(), new ThreadInfoPanel(thread));
    }

    @Override
    public void showJavaStackTrace(JavaThread thread) {
        JavaStackTracePanel jstp = new JavaStackTracePanel();
        this.showPanel("Java stack trace for " + thread.getThreadName(), jstp);
        jstp.setJavaThread(thread);
    }

    private void showDeadlockDetectionPanel() {
        this.showPanel("Deadlock Detection", new DeadlockDetectionPanel());
    }

    private void showMonitorCacheDumpPanel() {
        this.showPanel("Monitor Cache Dump", new MonitorCacheDumpPanel());
    }

    public void showClassBrowser() {
        final JInternalFrame progressFrame = new JInternalFrame("Class Browser");
        progressFrame.setResizable(true);
        progressFrame.setClosable(true);
        progressFrame.setIconifiable(true);
        progressFrame.getContentPane().setLayout(new BorderLayout());
        ProgressBarPanel bar = new ProgressBarPanel("Generating class list ..");
        bar.setIndeterminate(true);
        progressFrame.getContentPane().add((Component)bar, "Center");
        this.desktop.add(progressFrame);
        progressFrame.pack();
        GraphicsUtilities.centerInContainer(progressFrame);
        progressFrame.show();
        this.workerThread.invokeLater(new Runnable(){

            @Override
            public void run() {
                HTMLGenerator htmlGen = new HTMLGenerator();
                InstanceKlass[] klasses = SystemDictionaryHelper.getAllInstanceKlasses();
                final String htmlText = htmlGen.genHTMLForKlassNames(klasses);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JInternalFrame cbFrame = new JInternalFrame("Class Browser");
                        cbFrame.getContentPane().setLayout(new BorderLayout());
                        cbFrame.setResizable(true);
                        cbFrame.setClosable(true);
                        cbFrame.setIconifiable(true);
                        ClassBrowserPanel cbPanel = new ClassBrowserPanel();
                        cbFrame.getContentPane().add((Component)cbPanel, "Center");
                        HSDB.this.desktop.remove(progressFrame);
                        HSDB.this.desktop.repaint();
                        HSDB.this.desktop.add(cbFrame);
                        GraphicsUtilities.reshapeToAspectRatio(cbFrame, 1.25f, 0.85f, cbFrame.getParent().getSize());
                        cbFrame.show();
                        cbPanel.setClassesText(htmlText);
                    }
                });
            }
        });
    }

    public void showCodeViewer() {
        this.showPanel("Code Viewer", new CodeViewerPanel(), 1.25f, 0.85f);
    }

    @Override
    public void showCodeViewer(final Address address) {
        final CodeViewerPanel panel = new CodeViewerPanel();
        this.showPanel("Code Viewer", panel, 1.25f, 0.85f);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                panel.viewAddress(address);
            }
        });
    }

    public void showMemoryViewer() {
        this.showPanel("Memory Viewer", new MemoryViewer(this.agent.getDebugger(), this.agent.getTypeDataBase().getAddressSize() == 8L));
    }

    public void showCommandLineFlags() {
        this.showPanel("Command Line Flags", new VMFlagsPanel());
    }

    public void showVMVersion() {
        this.showPanel("VM Version Info", new VMVersionInfoPanel());
    }

    public void showSystemProperties() {
        this.showPanel("System Properties", new SysPropsPanel());
    }

    private void showPanel(String name, JPanel panel) {
        this.showPanel(name, panel, 1.6666666f, 0.4f);
    }

    private void showPanel(String name, JPanel panel, float aspectRatio, float fillRatio) {
        JInternalFrame frame = new JInternalFrame(name);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.setResizable(true);
        frame.setClosable(true);
        frame.setIconifiable(true);
        frame.setMaximizable(true);
        frame.getContentPane().add((Component)panel, "Center");
        this.desktop.add(frame);
        GraphicsUtilities.reshapeToAspectRatio(frame, aspectRatio, fillRatio, frame.getParent().getSize());
        GraphicsUtilities.randomLocation(frame);
        frame.show();
        if (panel instanceof SAPanel) {
            ((SAPanel)panel).addPanelListener(this);
        }
    }

    private void doHeapIteration(String frameTitle, String progressBarText, HeapVisitor visitor, CleanupThunk cleanup) {
        ObjectHistogram histo = new ObjectHistogram();
        HeapProgress progress = new HeapProgress(frameTitle, progressBarText, cleanup);
        ProgressiveHeapVisitor progVisitor = new ProgressiveHeapVisitor(visitor, progress);
        this.workerThread.invokeLater(new VisitHeap(progVisitor));
    }

    private static JavaVFrame getLastJavaVFrame(JavaThread cur) {
        VFrame vf;
        RegisterMap regMap = cur.newRegisterMap(true);
        Frame f = cur.getCurrentFrameGuess();
        if (f == null) {
            return null;
        }
        boolean imprecise = true;
        if (f.isInterpretedFrame() && !f.isInterpretedFrameValid()) {
            System.err.println("Correcting for invalid interpreter frame");
            f = f.sender(regMap);
            imprecise = false;
        }
        if ((vf = VFrame.newVFrame(f, regMap, cur, true, imprecise)) == null) {
            System.err.println(" (Unable to create vframe for topmost frame guess)");
            return null;
        }
        if (vf.isJavaFrame()) {
            return (JavaVFrame)vf;
        }
        return vf.javaSender();
    }

    private static void dumpStack(JavaThread cur) {
        RegisterMap regMap = cur.newRegisterMap(true);
        Frame f = cur.getCurrentFrameGuess();
        PrintStream tty = System.err;
        while (f != null) {
            tty.print("Found ");
            if (f.isInterpretedFrame()) {
                tty.print("interpreted");
            } else if (f.isCompiledFrame()) {
                tty.print("compiled");
            } else if (f.isEntryFrame()) {
                tty.print("entry");
            } else if (f.isNativeFrame()) {
                tty.print("native");
            } else if (f.isRuntimeFrame()) {
                tty.print("runtime");
            } else {
                tty.print("external");
            }
            tty.print(" frame with PC = " + f.getPC() + ", SP = " + f.getSP() + ", FP = " + f.getFP());
            if (f.isSignalHandlerFrameDbg()) {
                tty.print(" (SIGNAL HANDLER)");
            }
            tty.println();
            if (!f.isFirstFrame()) {
                f = f.sender(regMap);
                continue;
            }
            f = null;
        }
    }

    private static JMenuItem createMenuItem(String name, ActionListener l) {
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(l);
        return item;
    }

    private String formatMessage(String message, int charsPerLine) {
        StringBuffer buf = new StringBuffer(message.length());
        StringTokenizer tokenizer = new StringTokenizer(message);
        int curLineLength = 0;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (curLineLength + tok.length() > charsPerLine) {
                buf.append('\n');
                curLineLength = 0;
            } else if (curLineLength != 0) {
                buf.append(' ');
                ++curLineLength;
            }
            buf.append(tok);
            curLineLength += tok.length();
        }
        return buf.toString();
    }

    private void setMenuItemsEnabled(List items, boolean enabled) {
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            ((JMenuItem)iter.next()).setEnabled(enabled);
        }
    }

    class VisitHeap
    implements Runnable {
        HeapVisitor visitor;

        VisitHeap(HeapVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public void run() {
            VM.getVM().getObjectHeap().iterate(this.visitor);
        }
    }

    class HeapProgress
    implements HeapProgressThunk {
        private JInternalFrame frame;
        private ProgressBarPanel bar;
        private String windowTitle;
        private String progressBarTitle;
        private CleanupThunk cleanup;

        HeapProgress(String windowTitle) {
            this(windowTitle, "Percentage of heap visited", null);
        }

        HeapProgress(String windowTitle, String progressBarTitle) {
            this(windowTitle, progressBarTitle, null);
        }

        HeapProgress(String windowTitle, String progressBarTitle, CleanupThunk cleanup) {
            this.windowTitle = windowTitle;
            this.progressBarTitle = progressBarTitle;
            this.cleanup = cleanup;
        }

        @Override
        public void heapIterationFractionUpdate(final double fractionOfHeapVisited) {
            if (this.frame == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HeapProgress.this.frame = new JInternalFrame(HeapProgress.this.windowTitle);
                        HeapProgress.this.frame.setResizable(true);
                        HeapProgress.this.frame.setIconifiable(true);
                        HeapProgress.this.frame.getContentPane().setLayout(new BorderLayout());
                        HeapProgress.this.bar = new ProgressBarPanel(HeapProgress.this.progressBarTitle);
                        HeapProgress.this.frame.getContentPane().add((Component)HeapProgress.this.bar, "Center");
                        HSDB.this.desktop.add(HeapProgress.this.frame);
                        HeapProgress.this.frame.pack();
                        GraphicsUtilities.constrainToSize(HeapProgress.this.frame, HeapProgress.this.frame.getParent().getSize());
                        GraphicsUtilities.centerInContainer(HeapProgress.this.frame);
                        HeapProgress.this.frame.show();
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HeapProgress.this.bar.setValue(fractionOfHeapVisited);
                }
            });
        }

        @Override
        public void heapIterationComplete() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HSDB.this.desktop.remove(HeapProgress.this.frame);
                    HSDB.this.desktop.repaint();
                    if (VM.getVM().getRevPtrs() != null) {
                        HSDB.this.computeRevPtrsMenuItem.setEnabled(false);
                    }
                }
            });
            if (this.cleanup != null) {
                this.cleanup.heapIterationComplete();
            }
        }
    }

    static interface CleanupThunk {
        public void heapIterationComplete();
    }

    class FindObjectByTypeCleanupThunk
    implements CleanupThunk {
        FindObjectByType finder;

        FindObjectByTypeCleanupThunk(FindObjectByType finder) {
            this.finder = finder;
        }

        @Override
        public void heapIterationComplete() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JInternalFrame finderFrame = new JInternalFrame("Show Objects of Type");
                    finderFrame.getContentPane().setLayout(new BorderLayout());
                    finderFrame.setResizable(true);
                    finderFrame.setClosable(true);
                    finderFrame.setIconifiable(true);
                    ObjectListPanel panel = new ObjectListPanel(FindObjectByTypeCleanupThunk.this.finder.getResults(), new HeapProgress("Reverse Pointers Analysis"));
                    panel.addPanelListener(HSDB.this);
                    finderFrame.getContentPane().add(panel);
                    HSDB.this.desktop.add(finderFrame);
                    GraphicsUtilities.reshapeToAspectRatio(finderFrame, 1.3333334f, 0.6f, finderFrame.getParent().getSize());
                    GraphicsUtilities.centerInContainer(finderFrame);
                    finderFrame.show();
                }
            });
        }
    }

    class ObjectHistogramCleanupThunk
    implements CleanupThunk {
        ObjectHistogram histo;

        ObjectHistogramCleanupThunk(ObjectHistogram histo) {
            this.histo = histo;
        }

        @Override
        public void heapIterationComplete() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JInternalFrame histoFrame = new JInternalFrame("Object Histogram");
                    histoFrame.setResizable(true);
                    histoFrame.setClosable(true);
                    histoFrame.setIconifiable(true);
                    histoFrame.getContentPane().setLayout(new BorderLayout());
                    ObjectHistogramPanel panel = new ObjectHistogramPanel(ObjectHistogramCleanupThunk.this.histo);
                    panel.addPanelListener(HSDB.this);
                    histoFrame.getContentPane().add(panel);
                    HSDB.this.desktop.add(histoFrame);
                    GraphicsUtilities.reshapeToAspectRatio(histoFrame, 1.3333334f, 0.6f, histoFrame.getParent().getSize());
                    GraphicsUtilities.centerInContainer(histoFrame);
                    histoFrame.show();
                }
            });
        }
    }

    abstract class StackWalker
    implements Runnable {
        protected JavaVFrame vf;
        protected AnnotatedMemoryPanel annoPanel;

        StackWalker(JavaVFrame vf, AnnotatedMemoryPanel annoPanel) {
            this.vf = vf;
            this.annoPanel = annoPanel;
        }
    }

    class SignalInfo {
        public int sigNum;
        public String sigName;

        SignalInfo() {
        }
    }
}

