#!/bin/sh
export PATH='/usr/obj/ports/hs-dbus-0.10.13/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: dbus
version: 0.10.13
id: dbus-0.10.13-IUelLsOGWpyBGcXH63C8d4
key: dbus-0.10.13-IUelLsOGWpyBGcXH63C8d4
license: GPL-3
maintainer: Andrey Sverdlichenko <blaze@ruddy.ru>, John Millikin <john@john-millikin.com>
stability: experimental
homepage: https://github.com/rblaze/haskell-dbus#readme
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <john@john-millikin.com>
exposed: True
indefinite: False
exposed-modules:
    DBus DBus.Client DBus.Internal.Address DBus.Internal.Message
    DBus.Internal.Types DBus.Internal.Wire DBus.Introspection
    DBus.Socket DBus.Transport
abi: bca5a500976e6458e8f315fd7a9188d8
trusted: False
import-dirs: /usr/local/lib/ghc/dbus-0.10.13
library-dirs: /usr/local/lib/ghc/dbus-0.10.13
              /usr/local/lib/x86_64-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-dbus-0.10.13
hs-libraries: HSdbus-0.10.13-IUelLsOGWpyBGcXH63C8d4
depends:
    base-4.10.1.0 bytestring-0.10.8.2
    cereal-0.4.1.0-J7JNgMSSYgsLRU6KWtlHY0 containers-0.5.10.2
    libxml-sax-0.7.5-CWwwLs2Cpr07R9NPn064CX
    network-2.6.2.1-EN7QebdZTnQLy4O4vi1CmV
    parsec-3.1.9-444fzLM2idQ5vByZuGIOJ
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We
    text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ transformers-0.5.2.0
    unix-2.7.2.2 vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4
    xml-types-0.3.6-KBWVauU3pnf3clHxqFFRXL
abi-depends: base-4.10.1.0=3319c96bc0bdd0e7df6bb89e8bc8756b
             bytestring-0.10.8.2=bad4023def214da3b9be582a43b5e246
             cereal-0.4.1.0-J7JNgMSSYgsLRU6KWtlHY0=deddd7b0afb980d47efd111660754447
             containers-0.5.10.2=e77159590adf51c7ff6e1b02e6e4795b
             libxml-sax-0.7.5-CWwwLs2Cpr07R9NPn064CX=b85ad879cbc7bec851167127079afa23
             network-2.6.2.1-EN7QebdZTnQLy4O4vi1CmV=1e391bce62287578e3a86dbbea151616
             parsec-3.1.9-444fzLM2idQ5vByZuGIOJ=355b0baaf01dc31d4083e3a8f8b08b8a
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=4819d31d5d376f5c2c0823f5be807b6a
             text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ=052ad072c066fd2117f49783bd48d75c
             transformers-0.5.2.0=e04579c0363c9229351d1a0b394bf2d5
             unix-2.7.2.2=f8a24ef0cf0016c9c8621b46363d690a
             vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=8e272bd04e12991dddf8fcbfa1687d93
             xml-types-0.3.6-KBWVauU3pnf3clHxqFFRXL=8b074783732a8c48356cd50404ba1a79
haddock-interfaces: /usr/local/share/doc/hs-dbus-0.10.13/html/dbus.haddock
haddock-html: /usr/local/share/doc/hs-dbus-0.10.13/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

