#!/bin/sh
export PATH='/usr/obj/ports/hs-cryptohash-0.7.10/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: cryptohash
version: 0.7.10
id: cryptohash-0.7.10-HcwvxMqpgmiAmodT7Z0qKE
key: cryptohash-0.7.10-HcwvxMqpgmiAmodT7Z0qKE
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
homepage: http://github.com/vincenthz/hs-cryptohash
synopsis: collection of crypto hashes, fast, pure and practical
description:
    A collection of crypto hashes, with a practical incremental and one-pass, pure APIs,
    with performance close to the fastest implementations available in others languages.
    .
    The implementations are made in C with a haskell FFI wrapper that hide the C implementation.
category: Data, Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
indefinite: False
exposed-modules:
    Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
    Crypto.Hash.RIPEMD160 Crypto.Hash.SHA1 Crypto.Hash.SHA224
    Crypto.Hash.SHA256 Crypto.Hash.SHA3 Crypto.Hash.SHA384
    Crypto.Hash.SHA512 Crypto.Hash.SHA512t Crypto.Hash.Skein256
    Crypto.Hash.Skein512 Crypto.Hash.Tiger Crypto.Hash.Whirlpool
    Crypto.MAC.HMAC
abi: c88bb057bb9ab612d6b6a0c87caf7490
trusted: False
import-dirs: /usr/local/lib/ghc/cryptohash-0.7.10
library-dirs: /usr/local/lib/ghc/cryptohash-0.7.10
              /usr/local/lib/x86_64-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-cryptohash-0.7.10
hs-libraries: HScryptohash-0.7.10-HcwvxMqpgmiAmodT7Z0qKE
depends:
    base-4.10.1.0 bytestring-0.10.8.2
    crypto-api-0.13.2-HdoaNKgPjwIDvahrsdJlLG
    tagged-0.7.3-JOGLvm4jfLWGOxvLgFJbwZ
    cereal-0.4.1.0-J7JNgMSSYgsLRU6KWtlHY0
abi-depends: base-4.10.1.0=3319c96bc0bdd0e7df6bb89e8bc8756b
             bytestring-0.10.8.2=bad4023def214da3b9be582a43b5e246
             crypto-api-0.13.2-HdoaNKgPjwIDvahrsdJlLG=852c982feea6569c971825a0918bbc21
             tagged-0.7.3-JOGLvm4jfLWGOxvLgFJbwZ=346783e3b549dcc770d007b4abe1edfa
             cereal-0.4.1.0-J7JNgMSSYgsLRU6KWtlHY0=deddd7b0afb980d47efd111660754447
haddock-interfaces: /usr/local/share/doc/hs-cryptohash-0.7.10/html/cryptohash.haddock
haddock-html: /usr/local/share/doc/hs-cryptohash-0.7.10/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

