/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Component;
import java.beans.PropertyVetoException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.UIManager;
import javax.swing.plaf.DesktopPaneUI;

public class JDesktopPane
extends JLayeredPane
implements Accessible {
    private static final long serialVersionUID = 766333777224038726L;
    public static final int LIVE_DRAG_MODE = 0;
    public static final int OUTLINE_DRAG_MODE = 1;
    private transient JInternalFrame selectedFrame;
    transient DesktopManager desktopManager;
    private transient int dragMode = 0;
    private boolean clientDragModeSet = false;

    public JDesktopPane() {
        this.setLayout(null);
        this.updateUI();
    }

    public DesktopPaneUI getUI() {
        return (DesktopPaneUI)this.ui;
    }

    public void setUI(DesktopPaneUI ui) {
        super.setUI(ui);
    }

    public void setDragMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Drag mode not valid.");
        }
        this.clientDragModeSet = true;
        if (mode == 1) {
            mode = 0;
        }
        this.dragMode = mode;
    }

    public int getDragMode() {
        return this.dragMode;
    }

    public DesktopManager getDesktopManager() {
        return this.desktopManager;
    }

    public void setDesktopManager(DesktopManager manager) {
        this.desktopManager = manager;
    }

    public void updateUI() {
        this.setUI((DesktopPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "DesktopPaneUI";
    }

    public JInternalFrame[] getAllFrames() {
        return JDesktopPane.getFramesFromComponents(this.getComponents());
    }

    public JInternalFrame getSelectedFrame() {
        return this.selectedFrame;
    }

    public void setSelectedFrame(JInternalFrame frame) {
        if (this.selectedFrame != null) {
            try {
                this.selectedFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        this.selectedFrame = null;
        try {
            if (frame != null) {
                frame.setSelected(true);
            }
            this.selectedFrame = frame;
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public JInternalFrame[] getAllFramesInLayer(int layer) {
        return JDesktopPane.getFramesFromComponents(this.getComponentsInLayer(layer));
    }

    public boolean isOpaque() {
        return true;
    }

    protected String paramString() {
        String superParamStr = super.paramString();
        CPStringBuilder sb = new CPStringBuilder();
        sb.append(",isOptimizedDrawingPossible=");
        sb.append(this.isOptimizedDrawingEnabled());
        sb.append(",desktopManager=");
        if (this.desktopManager != null) {
            sb.append(this.desktopManager);
        }
        return String.valueOf(superParamStr) + sb.toString();
    }

    private static JInternalFrame[] getFramesFromComponents(Component[] components) {
        int count = 0;
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof JInternalFrame) {
                ++count;
            }
            ++i;
        }
        JInternalFrame[] value = new JInternalFrame[count];
        int i2 = 0;
        int j = 0;
        while (i2 < components.length && j != count) {
            if (components[i2] instanceof JInternalFrame) {
                value[j++] = (JInternalFrame)components[i2];
            }
            ++i2;
        }
        return value;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDesktopPane();
        }
        return this.accessibleContext;
    }

    void setUIProperty(String propertyName, Object value) {
        if (propertyName.equals("dragMode")) {
            if (!this.clientDragModeSet) {
                this.setDragMode((Integer)value);
                this.clientDragModeSet = false;
            }
        } else {
            super.setUIProperty(propertyName, value);
        }
    }

    protected class AccessibleJDesktopPane
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = 6079388927946077570L;

        protected AccessibleJDesktopPane() {
            super(JDesktopPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DESKTOP_PANE;
        }
    }
}

