/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.script.FilterScript;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class PainlessExecuteAction
extends Action<Request, Response, RequestBuilder> {
    static final PainlessExecuteAction INSTANCE = new PainlessExecuteAction();
    private static final String NAME = "cluster:admin/scripts/painless/execute";

    private PainlessExecuteAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public Response newResponse() {
        return new Response();
    }

    static class RestAction
    extends BaseRestHandler {
        RestAction(Settings settings, RestController controller) {
            super(settings);
            controller.registerHandler(RestRequest.Method.GET, "/_scripts/painless/_execute", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.POST, "/_scripts/painless/_execute", (RestHandler)this);
        }

        public String getName() {
            return "_scripts_painless_execute";
        }

        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
            Request request = Request.parse(restRequest.contentOrSourceParamParser());
            return channel -> client.executeLocally((GenericAction)INSTANCE, (ActionRequest)request, (ActionListener)new RestBuilderListener<Response>(channel){

                public RestResponse buildResponse(Response response, XContentBuilder builder) throws Exception {
                    response.toXContent(builder, ToXContent.EMPTY_PARAMS);
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
        }
    }

    public static class TransportAction
    extends TransportSingleShardAction<Request, Response> {
        private final ScriptService scriptService;
        private final IndicesService indicesServices;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService, ClusterService clusterService, IndicesService indicesServices) {
            super(settings, PainlessExecuteAction.NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, "management");
            this.scriptService = scriptService;
            this.indicesServices = indicesServices;
        }

        protected Response newResponse() {
            return new Response();
        }

        protected ClusterBlockException checkRequestBlock(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            if (request.concreteIndex() != null) {
                return super.checkRequestBlock(state, request);
            }
            return null;
        }

        protected boolean resolveIndex(Request request) {
            return request.contextSetup != null && request.contextSetup.getIndex() != null;
        }

        protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            if (request.concreteIndex() == null) {
                return null;
            }
            return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
        }

        protected Response shardOperation(Request request, ShardId shardId) throws IOException {
            IndexService indexService;
            if (request.contextSetup != null && request.contextSetup.getIndex() != null) {
                String indexExpression;
                IndicesOptions indicesOptions;
                ClusterState clusterState = this.clusterService.state();
                Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(clusterState, indicesOptions = IndicesOptions.strictSingleIndexNoExpandForbidClosed(), new String[]{indexExpression = request.contextSetup.index});
                if (concreteIndices.length != 1) {
                    throw new IllegalArgumentException("[" + indexExpression + "] does not resolve to a single index");
                }
                Index concreteIndex = concreteIndices[0];
                indexService = this.indicesServices.indexServiceSafe(concreteIndex);
            } else {
                indexService = null;
            }
            return TransportAction.innerShardOperation(request, this.scriptService, indexService);
        }

        static Response innerShardOperation(Request request, ScriptService scriptService, IndexService indexService) throws IOException {
            ScriptContext scriptContext = request.context;
            if (scriptContext == PainlessTestScript.CONTEXT) {
                PainlessTestScript.Factory factory = (PainlessTestScript.Factory)scriptService.compile(request.script, PainlessTestScript.CONTEXT);
                PainlessTestScript painlessTestScript = factory.newInstance(request.script.getParams());
                String result = Objects.toString(painlessTestScript.execute());
                return new Response(result);
            }
            if (scriptContext == FilterScript.CONTEXT) {
                return TransportAction.prepareRamIndex(request, (CheckedBiFunction<QueryShardContext, LeafReaderContext, Response, IOException>)((CheckedBiFunction)(context, leafReaderContext) -> {
                    FilterScript.Factory factory = (FilterScript.Factory)scriptService.compile(request.script, FilterScript.CONTEXT);
                    FilterScript.LeafFactory leafFactory = factory.newFactory(request.getScript().getParams(), context.lookup());
                    FilterScript filterScript = leafFactory.newInstance(leafReaderContext);
                    filterScript.setDocument(0);
                    boolean result = filterScript.execute();
                    return new Response(result);
                }), indexService);
            }
            if (scriptContext == ScoreScript.CONTEXT) {
                return TransportAction.prepareRamIndex(request, (CheckedBiFunction<QueryShardContext, LeafReaderContext, Response, IOException>)((CheckedBiFunction)(context, leafReaderContext) -> {
                    ScoreScript.Factory factory = (ScoreScript.Factory)scriptService.compile(request.script, ScoreScript.CONTEXT);
                    ScoreScript.LeafFactory leafFactory = factory.newFactory(request.getScript().getParams(), context.lookup());
                    ScoreScript scoreScript = leafFactory.newInstance(leafReaderContext);
                    scoreScript.setDocument(0);
                    if (request.contextSetup.query != null) {
                        Query luceneQuery = request.contextSetup.query.rewrite((QueryRewriteContext)context).toQuery(context);
                        IndexSearcher indexSearcher = new IndexSearcher((IndexReader)leafReaderContext.reader());
                        luceneQuery = indexSearcher.rewrite(luceneQuery);
                        Weight weight = indexSearcher.createWeight(luceneQuery, true, 1.0f);
                        Scorer scorer = weight.scorer((LeafReaderContext)indexSearcher.getIndexReader().leaves().get(0));
                        int docID = scorer.iterator().nextDoc();
                        assert (docID == scorer.docID());
                        scoreScript.setScorer(scorer);
                    }
                    double result = scoreScript.execute();
                    return new Response(result);
                }), indexService);
            }
            throw new UnsupportedOperationException("unsupported context [" + scriptContext.name + "]");
        }

        /*
         * Exception decompiling
         */
        private static Response prepareRamIndex(Request request, CheckedBiFunction<QueryShardContext, LeafReaderContext, Response, IOException> handler, IndexService indexService) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ long lambda$prepareRamIndex$2(long absoluteStartMillis) {
            return absoluteStartMillis;
        }

        private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
            if (x0 != null) {
                try {
                    x1.close();
                }
                catch (Throwable throwable) {
                    x0.addSuppressed(throwable);
                }
            } else {
                x1.close();
            }
        }
    }

    public static abstract class PainlessTestScript {
        private final Map<String, Object> params;
        public static final String[] PARAMETERS = new String[0];
        public static final ScriptContext<Factory> CONTEXT = new ScriptContext("painless_test", Factory.class);

        public PainlessTestScript(Map<String, Object> params) {
            this.params = params;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public abstract Object execute();

        public static interface Factory {
            public PainlessTestScript newInstance(Map<String, Object> var1);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private Object result;

        Response() {
        }

        Response(Object result) {
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.result = in.readGenericValue();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeGenericValue(this.result);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("result", this.result);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.result, response.result);
        }

        public int hashCode() {
            return Objects.hash(this.result);
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends SingleShardRequest<Request>
    implements ToXContent {
        private static final ParseField SCRIPT_FIELD = new ParseField("script", new String[0]);
        private static final ParseField CONTEXT_FIELD = new ParseField("context", new String[0]);
        private static final ParseField CONTEXT_SETUP_FIELD = new ParseField("context_setup", new String[0]);
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("painless_execute_request", args -> new Request((Script)args[0], (String)args[1], (ContextSetup)args[2]));
        static final Map<String, ScriptContext<?>> SUPPORTED_CONTEXTS;
        private Script script;
        private ScriptContext<?> context = PainlessTestScript.CONTEXT;
        private ContextSetup contextSetup;

        static ScriptContext<?> fromScriptContextName(String name) {
            ScriptContext<?> scriptContext = SUPPORTED_CONTEXTS.get(name);
            if (scriptContext == null) {
                throw new UnsupportedOperationException("unsupported script context name [" + name + "]");
            }
            return scriptContext;
        }

        static Request parse(XContentParser parser) throws IOException {
            return (Request)((Object)PARSER.parse(parser, null));
        }

        Request(Script script, String scriptContextName, ContextSetup setup) {
            this.script = Objects.requireNonNull(script);
            if (scriptContextName != null) {
                this.context = Request.fromScriptContextName(scriptContextName);
            }
            if (setup != null) {
                this.contextSetup = setup;
                this.index(this.contextSetup.index);
            }
        }

        Request() {
        }

        public Script getScript() {
            return this.script;
        }

        public ScriptContext<?> getContext() {
            return this.context;
        }

        public ContextSetup getContextSetup() {
            return this.contextSetup;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.script.getType() != ScriptType.INLINE) {
                validationException = ValidateActions.addValidationError((String)"only inline scripts are supported", validationException);
            }
            if (Request.needDocumentAndIndex(this.context)) {
                if (this.contextSetup.index == null) {
                    validationException = ValidateActions.addValidationError((String)"index is a required parameter for current context", (ActionRequestValidationException)validationException);
                }
                if (this.contextSetup.document == null) {
                    validationException = ValidateActions.addValidationError((String)"document is a required parameter for current context", (ActionRequestValidationException)validationException);
                }
            }
            return validationException;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.script = new Script(in);
            if (in.getVersion().before(Version.V_6_4_0)) {
                byte scriptContextId = in.readByte();
                assert (scriptContextId == 0);
            } else {
                this.context = Request.fromScriptContextName(in.readString());
                this.contextSetup = (ContextSetup)in.readOptionalWriteable(ContextSetup::new);
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.script.writeTo(out);
            if (out.getVersion().before(Version.V_6_4_0)) {
                out.writeByte((byte)0);
            } else {
                out.writeString(this.context.name);
                out.writeOptionalWriteable((Writeable)this.contextSetup);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(SCRIPT_FIELD.getPreferredName(), (ToXContent)this.script);
            builder.field(CONTEXT_FIELD.getPreferredName(), this.context.name);
            if (this.contextSetup != null) {
                builder.field(CONTEXT_SETUP_FIELD.getPreferredName(), (ToXContent)this.contextSetup);
            }
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.script, request.script) && Objects.equals(this.context, request.context) && Objects.equals(this.contextSetup, request.contextSetup);
        }

        public int hashCode() {
            return Objects.hash(this.script, this.context, this.contextSetup);
        }

        public String toString() {
            return "Request{script=" + this.script + "context=" + this.context + ", contextSetup=" + this.contextSetup + '}';
        }

        static boolean needDocumentAndIndex(ScriptContext<?> scriptContext) {
            return scriptContext == FilterScript.CONTEXT || scriptContext == ScoreScript.CONTEXT;
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Script.parse((XContentParser)p), SCRIPT_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), CONTEXT_FIELD);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ContextSetup::parse, CONTEXT_SETUP_FIELD);
            HashMap<String, Object> supportedContexts = new HashMap<String, Object>();
            supportedContexts.put("painless_test", PainlessTestScript.CONTEXT);
            supportedContexts.put("filter", FilterScript.CONTEXT);
            supportedContexts.put("score", ScoreScript.CONTEXT);
            SUPPORTED_CONTEXTS = Collections.unmodifiableMap(supportedContexts);
        }

        static class ContextSetup
        implements Writeable,
        ToXContentObject {
            private static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
            private static final ParseField DOCUMENT_FIELD = new ParseField("document", new String[0]);
            private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
            private static final ConstructingObjectParser<ContextSetup, Void> PARSER = new ConstructingObjectParser("execute_script_context", args -> new ContextSetup((String)args[0], (BytesReference)args[1], (QueryBuilder)args[2]));
            private final String index;
            private final BytesReference document;
            private final QueryBuilder query;
            private XContentType xContentType;

            static ContextSetup parse(XContentParser parser, Void context) throws IOException {
                ContextSetup contextSetup = (ContextSetup)PARSER.parse(parser, null);
                contextSetup.setXContentType(parser.contentType());
                return contextSetup;
            }

            ContextSetup(String index, BytesReference document, QueryBuilder query) {
                this.index = index;
                this.document = document;
                this.query = query;
            }

            ContextSetup(StreamInput in) throws IOException {
                this.index = in.readOptionalString();
                this.document = in.readOptionalBytesReference();
                String xContentType = in.readOptionalString();
                if (xContentType != null) {
                    this.xContentType = XContentType.fromMediaType((String)xContentType);
                }
                this.query = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
            }

            public String getIndex() {
                return this.index;
            }

            public BytesReference getDocument() {
                return this.document;
            }

            public QueryBuilder getQuery() {
                return this.query;
            }

            public XContentType getXContentType() {
                return this.xContentType;
            }

            public void setXContentType(XContentType xContentType) {
                this.xContentType = xContentType;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ContextSetup that = (ContextSetup)o;
                return Objects.equals(this.index, that.index) && Objects.equals(this.document, that.document) && Objects.equals(this.query, that.query);
            }

            public int hashCode() {
                return Objects.hash(this.index, this.document, this.query);
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeOptionalString(this.index);
                out.writeOptionalBytesReference(this.document);
                out.writeOptionalString(this.xContentType != null ? this.xContentType.mediaType() : null);
                out.writeOptionalNamedWriteable((NamedWriteable)this.query);
            }

            public String toString() {
                return "ContextSetup{, index='" + this.index + '\'' + ", document=" + this.document + ", query=" + this.query + ", xContentType=" + this.xContentType + '}';
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                if (this.index != null) {
                    builder.field(INDEX_FIELD.getPreferredName(), this.index);
                }
                if (this.document != null) {
                    builder.field(DOCUMENT_FIELD.getPreferredName());
                    try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)this.document, (XContentType)this.xContentType);){
                        builder.generator().copyCurrentStructure(parser);
                    }
                }
                if (this.query != null) {
                    builder.field(QUERY_FIELD.getPreferredName(), (ToXContent)this.query);
                }
                builder.endObject();
                return builder;
            }

            static /* synthetic */ XContentType access$500(ContextSetup x0) {
                return x0.xContentType;
            }

            static {
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEX_FIELD);
                PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                    XContentBuilder b = XContentBuilder.builder((XContent)p.contentType().xContent());
                    Throwable throwable = null;
                    try {
                        b.copyCurrentStructure(p);
                        BytesReference bytesReference = BytesReference.bytes((XContentBuilder)b);
                        return bytesReference;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (b != null) {
                            ContextSetup.$closeResource(throwable, (AutoCloseable)b);
                        }
                    }
                }, DOCUMENT_FIELD);
                PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)p), QUERY_FIELD);
            }
        }
    }
}

