/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ExponentiallyWeightedMovingAverage;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.node.AdaptiveSelectionStats;

public final class ResponseCollectorService
extends AbstractComponent
implements ClusterStateListener {
    private static final double ALPHA = 0.3;
    private final ConcurrentMap<String, NodeStatistics> nodeIdToStats = ConcurrentCollections.newConcurrentMap();

    public ResponseCollectorService(Settings settings, ClusterService clusterService) {
        super(settings);
        clusterService.addListener(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.nodesRemoved()) {
            for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                this.removeNode(removedNode.getId());
            }
        }
    }

    void removeNode(String nodeId) {
        this.nodeIdToStats.remove(nodeId);
    }

    public void addNodeStatistics(String nodeId, int queueSize, long responseTimeNanos, long avgServiceTimeNanos) {
        this.nodeIdToStats.compute(nodeId, (id, ns) -> {
            if (ns == null) {
                ExponentiallyWeightedMovingAverage queueEWMA = new ExponentiallyWeightedMovingAverage(0.3, queueSize);
                ExponentiallyWeightedMovingAverage responseEWMA = new ExponentiallyWeightedMovingAverage(0.3, responseTimeNanos);
                return new NodeStatistics(nodeId, queueEWMA, responseEWMA, avgServiceTimeNanos);
            }
            ns.queueSize.addValue(queueSize);
            ns.responseTime.addValue(responseTimeNanos);
            ns.serviceTime = avgServiceTimeNanos;
            return ns;
        });
    }

    public Map<String, ComputedNodeStats> getAllNodeStatistics() {
        int clientNum = this.nodeIdToStats.size();
        HashMap<String, ComputedNodeStats> nodeStats = new HashMap<String, ComputedNodeStats>(this.nodeIdToStats.size());
        this.nodeIdToStats.forEach((k, v) -> nodeStats.put((String)k, new ComputedNodeStats(clientNum, (NodeStatistics)v)));
        return nodeStats;
    }

    public AdaptiveSelectionStats getAdaptiveStats(Map<String, Long> clientSearchConnections) {
        return new AdaptiveSelectionStats(clientSearchConnections, this.getAllNodeStatistics());
    }

    public Optional<ComputedNodeStats> getNodeStatistics(String nodeId) {
        int clientNum = this.nodeIdToStats.size();
        return Optional.ofNullable((NodeStatistics)this.nodeIdToStats.get(nodeId)).map(ns -> new ComputedNodeStats(clientNum, (NodeStatistics)ns));
    }

    private static class NodeStatistics {
        final String nodeId;
        final ExponentiallyWeightedMovingAverage queueSize;
        final ExponentiallyWeightedMovingAverage responseTime;
        double serviceTime;

        NodeStatistics(String nodeId, ExponentiallyWeightedMovingAverage queueSizeEWMA, ExponentiallyWeightedMovingAverage responseTimeEWMA, double serviceTimeEWMA) {
            this.nodeId = nodeId;
            this.queueSize = queueSizeEWMA;
            this.responseTime = responseTimeEWMA;
            this.serviceTime = serviceTimeEWMA;
        }
    }

    public static class ComputedNodeStats
    implements Writeable {
        private final double FACTOR = 1000000.0;
        private final int clientNum;
        private double cachedRank = 0.0;
        public final String nodeId;
        public final int queueSize;
        public final double responseTime;
        public final double serviceTime;

        public ComputedNodeStats(String nodeId, int clientNum, int queueSize, double responseTime, double serviceTime) {
            this.nodeId = nodeId;
            this.clientNum = clientNum;
            this.queueSize = queueSize;
            this.responseTime = responseTime;
            this.serviceTime = serviceTime;
        }

        ComputedNodeStats(int clientNum, NodeStatistics nodeStats) {
            this(nodeStats.nodeId, clientNum, (int)nodeStats.queueSize.getAverage(), nodeStats.responseTime.getAverage(), nodeStats.serviceTime);
        }

        ComputedNodeStats(StreamInput in) throws IOException {
            this.nodeId = in.readString();
            this.clientNum = in.readInt();
            this.queueSize = in.readInt();
            this.responseTime = in.readDouble();
            this.serviceTime = in.readDouble();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeInt(this.clientNum);
            out.writeInt(this.queueSize);
            out.writeDouble(this.responseTime);
            out.writeDouble(this.serviceTime);
        }

        private double innerRank(long outstandingRequests) {
            double concurrencyCompensation = outstandingRequests * (long)this.clientNum;
            int queueAdjustmentFactor = 3;
            double qBar = this.queueSize;
            double qHatS = 1.0 + concurrencyCompensation + qBar;
            double rS = this.responseTime / 1000000.0;
            double muBarS = this.serviceTime / 1000000.0;
            double rank = rS - 1.0 / muBarS + Math.pow(qHatS, queueAdjustmentFactor) / muBarS;
            return rank;
        }

        public double rank(long outstandingRequests) {
            if (this.cachedRank == 0.0) {
                this.cachedRank = this.innerRank(outstandingRequests);
            }
            return this.cachedRank;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ComputedNodeStats[");
            sb.append(this.nodeId).append("](");
            sb.append("nodes: ").append(this.clientNum);
            sb.append(", queue: ").append(this.queueSize);
            sb.append(", response time: ").append(String.format(Locale.ROOT, "%.1f", this.responseTime));
            sb.append(", service time: ").append(String.format(Locale.ROOT, "%.1f", this.serviceTime));
            sb.append(", rank: ").append(String.format(Locale.ROOT, "%.1f", this.rank(1L)));
            sb.append(")");
            return sb.toString();
        }
    }
}

