/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.lookup.SourceLookup;

public class GetResult
implements Streamable,
Iterable<DocumentField>,
ToXContentObject {
    public static final String _INDEX = "_index";
    public static final String _TYPE = "_type";
    public static final String _ID = "_id";
    private static final String _VERSION = "_version";
    private static final String FOUND = "found";
    private static final String FIELDS = "fields";
    private String index;
    private String type;
    private String id;
    private long version;
    private boolean exists;
    private Map<String, DocumentField> fields;
    private Map<String, Object> sourceAsMap;
    private BytesReference source;
    private byte[] sourceAsBytes;

    GetResult() {
    }

    public GetResult(String index, String type, String id, long version, boolean exists, BytesReference source, Map<String, DocumentField> fields) {
        this.index = index;
        this.type = type;
        this.id = id;
        this.version = version;
        this.exists = exists;
        this.source = source;
        this.fields = fields;
        if (this.fields == null) {
            this.fields = Collections.emptyMap();
        }
    }

    public boolean isExists() {
        return this.exists;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public byte[] source() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsBytes != null) {
            return this.sourceAsBytes;
        }
        this.sourceAsBytes = BytesReference.toBytes(this.sourceRef());
        return this.sourceAsBytes;
    }

    public BytesReference sourceRef() {
        if (this.source == null) {
            return null;
        }
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
        }
    }

    public BytesReference internalSourceRef() {
        return this.source;
    }

    public boolean isSourceEmpty() {
        return this.source == null;
    }

    public String sourceAsString() {
        if (this.source == null) {
            return null;
        }
        BytesReference source = this.sourceRef();
        try {
            return XContentHelper.convertToJson(source, false);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to convert source to a json string", new Object[0]);
        }
    }

    public Map<String, Object> sourceAsMap() throws ElasticsearchParseException {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source);
        return this.sourceAsMap;
    }

    public Map<String, Object> getSource() {
        return this.sourceAsMap();
    }

    public Map<String, DocumentField> getFields() {
        return this.fields;
    }

    public DocumentField field(String name) {
        return this.fields.get(name);
    }

    @Override
    public Iterator<DocumentField> iterator() {
        if (this.fields == null) {
            return Collections.emptyIterator();
        }
        return this.fields.values().iterator();
    }

    public XContentBuilder toXContentEmbedded(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ArrayList<DocumentField> metaFields = new ArrayList<DocumentField>();
        ArrayList<DocumentField> otherFields = new ArrayList<DocumentField>();
        if (this.fields != null && !this.fields.isEmpty()) {
            for (DocumentField field : this.fields.values()) {
                if (field.getValues().isEmpty()) continue;
                if (field.isMetadataField()) {
                    metaFields.add(field);
                    continue;
                }
                otherFields.add(field);
            }
        }
        for (DocumentField field : metaFields) {
            if (field.getName().equals("_ignored")) {
                builder.field(field.getName(), field.getValues());
                continue;
            }
            builder.field(field.getName(), field.getValue());
        }
        builder.field(FOUND, this.exists);
        if (this.source != null) {
            XContentHelper.writeRawField("_source", this.source, builder, params);
        }
        if (!otherFields.isEmpty()) {
            builder.startObject(FIELDS);
            for (DocumentField field : otherFields) {
                field.toXContent(builder, params);
            }
            builder.endObject();
        }
        return builder;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(_INDEX, this.index);
        builder.field(_TYPE, this.type);
        builder.field(_ID, this.id);
        if (this.isExists()) {
            if (this.version != -1L) {
                builder.field(_VERSION, this.version);
            }
            this.toXContentEmbedded(builder, params);
        } else {
            builder.field(FOUND, false);
        }
        builder.endObject();
        return builder;
    }

    public static GetResult fromXContentEmbedded(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, () -> ((XContentParser)parser).getTokenLocation());
        return GetResult.fromXContentEmbedded(parser, null, null, null);
    }

    public static GetResult fromXContentEmbedded(XContentParser parser, String index, String type, String id) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, () -> ((XContentParser)parser).getTokenLocation());
        String currentFieldName = parser.currentName();
        long version = -1L;
        Boolean found = null;
        BytesReference source = null;
        HashMap<String, DocumentField> fields = new HashMap<String, DocumentField>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (_INDEX.equals(currentFieldName)) {
                    index = parser.text();
                    continue;
                }
                if (_TYPE.equals(currentFieldName)) {
                    type = parser.text();
                    continue;
                }
                if (_ID.equals(currentFieldName)) {
                    id = parser.text();
                    continue;
                }
                if (_VERSION.equals(currentFieldName)) {
                    version = parser.longValue();
                    continue;
                }
                if (FOUND.equals(currentFieldName)) {
                    found = parser.booleanValue();
                    continue;
                }
                fields.put(currentFieldName, new DocumentField(currentFieldName, Collections.singletonList(parser.objectText())));
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("_source".equals(currentFieldName)) {
                    XContentBuilder builder = XContentBuilder.builder((XContent)parser.contentType().xContent());
                    Throwable throwable = null;
                    try {
                        builder.copyCurrentStructure(parser);
                        source = BytesReference.bytes(builder);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (builder == null) continue;
                        if (throwable != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        builder.close();
                        continue;
                    }
                }
                if (FIELDS.equals(currentFieldName)) {
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        DocumentField getField = DocumentField.fromXContent(parser);
                        fields.put(getField.getName(), getField);
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            if ("_ignored".equals(currentFieldName)) {
                fields.put(currentFieldName, new DocumentField(currentFieldName, parser.list()));
                continue;
            }
            parser.skipChildren();
        }
        return new GetResult(index, type, id, version, found, source, fields);
    }

    public static GetResult fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, () -> ((XContentParser)parser).getTokenLocation());
        return GetResult.fromXContentEmbedded(parser);
    }

    public static GetResult readGetResult(StreamInput in) throws IOException {
        GetResult result = new GetResult();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readString();
        this.type = in.readOptionalString();
        this.id = in.readString();
        this.version = in.readLong();
        this.exists = in.readBoolean();
        if (this.exists) {
            int size;
            this.source = in.readBytesReference();
            if (this.source.length() == 0) {
                this.source = null;
            }
            if ((size = in.readVInt()) == 0) {
                this.fields = Collections.emptyMap();
            } else {
                this.fields = new HashMap<String, DocumentField>(size);
                for (int i = 0; i < size; ++i) {
                    DocumentField field = DocumentField.readDocumentField(in);
                    this.fields.put(field.getName(), field);
                }
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeOptionalString(this.type);
        out.writeString(this.id);
        out.writeLong(this.version);
        out.writeBoolean(this.exists);
        if (this.exists) {
            out.writeBytesReference(this.source);
            if (this.fields == null) {
                out.writeVInt(0);
            } else {
                out.writeVInt(this.fields.size());
                for (DocumentField field : this.fields.values()) {
                    field.writeTo(out);
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetResult getResult = (GetResult)o;
        return this.version == getResult.version && this.exists == getResult.exists && Objects.equals(this.index, getResult.index) && Objects.equals(this.type, getResult.type) && Objects.equals(this.id, getResult.id) && Objects.equals(this.fields, getResult.fields) && Objects.equals(this.sourceAsMap(), getResult.sourceAsMap());
    }

    public int hashCode() {
        return Objects.hash(this.version, this.exists, this.index, this.type, this.id, this.fields, this.sourceAsMap());
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }
}

