/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;

final class PerThreadIDVersionAndSeqNoLookup {
    final String uidField;
    private final TermsEnum termsEnum;
    private PostingsEnum docsEnum;
    private final Object readerKey;

    PerThreadIDVersionAndSeqNoLookup(LeafReader reader, String uidField) throws IOException {
        this.uidField = uidField;
        Terms terms = reader.terms(uidField);
        if (terms == null) {
            throw new IllegalArgumentException("reader misses the [" + uidField + "] field");
        }
        this.termsEnum = terms.iterator();
        if (reader.getNumericDocValues("_version") == null) {
            throw new IllegalArgumentException("reader misses the [_version] field");
        }
        IndexReader.CacheKey readerKey = null;
        assert ((readerKey = reader.getCoreCacheHelper().getKey()) != null);
        this.readerKey = readerKey;
    }

    public VersionsAndSeqNoResolver.DocIdAndVersion lookupVersion(BytesRef id, LeafReaderContext context) throws IOException {
        assert (context.reader().getCoreCacheHelper().getKey().equals(this.readerKey)) : "context's reader is not the same as the reader class was initialized on.";
        int docID = this.getDocID(id, context.reader().getLiveDocs());
        if (docID != Integer.MAX_VALUE) {
            NumericDocValues versions = context.reader().getNumericDocValues("_version");
            if (versions == null) {
                throw new IllegalArgumentException("reader misses the [_version] field");
            }
            if (!versions.advanceExact(docID)) {
                throw new IllegalArgumentException("Document [" + docID + "] misses the [" + "_version" + "] field");
            }
            return new VersionsAndSeqNoResolver.DocIdAndVersion(docID, versions.longValue(), context.reader(), context.docBase);
        }
        return null;
    }

    private int getDocID(BytesRef id, Bits liveDocs) throws IOException {
        if (this.termsEnum.seekExact(id)) {
            int docID = Integer.MAX_VALUE;
            this.docsEnum = this.termsEnum.postings(this.docsEnum, 0);
            int d = this.docsEnum.nextDoc();
            while (d != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(d)) {
                    docID = d;
                }
                d = this.docsEnum.nextDoc();
            }
            return docID;
        }
        return Integer.MAX_VALUE;
    }

    VersionsAndSeqNoResolver.DocIdAndSeqNo lookupSeqNo(BytesRef id, LeafReaderContext context) throws IOException {
        assert (context.reader().getCoreCacheHelper().getKey().equals(this.readerKey)) : "context's reader is not the same as the reader class was initialized on.";
        int docID = this.getDocID(id, context.reader().getLiveDocs());
        if (docID != Integer.MAX_VALUE) {
            NumericDocValues seqNos = context.reader().getNumericDocValues("_seq_no");
            long seqNo = seqNos != null && seqNos.advanceExact(docID) ? seqNos.longValue() : -2L;
            return new VersionsAndSeqNoResolver.DocIdAndSeqNo(docID, seqNo, context);
        }
        return null;
    }
}

