/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.AbstractPlacer;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.olap.OSUtils;
import ca.sqlpower.architect.swingui.olap.VirtualCubeEditPanel;
import ca.sqlpower.architect.swingui.olap.VirtualCubePane;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class CreateVirtualCubeAction
extends AbstractArchitectAction {
    private final MondrianModel.Schema schema;

    public CreateVirtualCubeAction(ArchitectSwingSession session, MondrianModel.Schema schema, PlayPen pp) {
        super(session, pp, "New Virtual Cube...", "Create a new Virtual Cube in this schema (v)", (Icon)OSUtils.VIRTUAL_CUBE_ADD_ICON);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke('v'));
        this.schema = schema;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PlayPenContentPane pane = this.getPlaypen().getContentPane();
        pane.begin("Creating VirtualCube and VirtualCubePane");
        try {
            MondrianModel.VirtualCube vCube = new MondrianModel.VirtualCube();
            int count = 1;
            while (!OLAPUtil.isNameUnique(this.schema, MondrianModel.VirtualCube.class, "New Virtual Cube " + count)) {
                ++count;
            }
            vCube.setName("New Virtual Cube " + count);
            VirtualCubePane cp = new VirtualCubePane(vCube, this.getPlaypen().getContentPane());
            VirtualCubePlacer cubePlacer = new VirtualCubePlacer(cp);
            cubePlacer.dirtyup();
            pane.commit();
        }
        catch (Throwable ex) {
            pane.rollback("Error creating Cube: " + ex.toString());
            throw new RuntimeException(ex);
        }
    }

    private class VirtualCubePlacer
    extends AbstractPlacer {
        private final VirtualCubePane vcp;

        VirtualCubePlacer(VirtualCubePane vcp) {
            super(CreateVirtualCubeAction.this.getPlaypen());
            this.vcp = vcp;
        }

        @Override
        protected String getEditDialogTitle() {
            return "Virtual Cube Properties";
        }

        @Override
        public DataEntryPanel place(Point p) throws SQLObjectException {
            try {
                CreateVirtualCubeAction.this.getSession().getWorkspace().begin("Create a virtual cube");
                CreateVirtualCubeAction.this.schema.addVirtualCube((MondrianModel.VirtualCube)((Object)this.vcp.getModel()));
                this.playpen.selectNone();
                this.playpen.addPlayPenComponent(this.vcp, p);
                this.vcp.setSelected(true, 4);
                CreateVirtualCubeAction.this.getSession().getWorkspace().commit();
            }
            catch (Throwable e) {
                CreateVirtualCubeAction.this.getSession().getWorkspace().rollback("Error occurred: " + e.toString());
                throw new RuntimeException(e);
            }
            VirtualCubeEditPanel editPanel = new VirtualCubeEditPanel((MondrianModel.VirtualCube)((Object)this.vcp.getModel())){

                @Override
                public void discardChanges() {
                    CreateVirtualCubeAction.this.schema.removeVirtualCube((MondrianModel.VirtualCube)((Object)VirtualCubePlacer.this.vcp.getModel()));
                }

                @Override
                public boolean applyChanges() {
                    return super.applyChanges();
                }
            };
            return editPanel;
        }
    }
}

