/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.FileWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.undo.UndoManager;

public class TextPaneWidget
extends aTextWidget {
    JTextPane textPane;
    String contentType = null;
    CaretListener caretListener;
    CaretEvent lastCaretEvent = null;
    int lastCharCode = 65535;
    int lastModifiers = 0;
    int documentLength = 0;
    String undoState = "nil";
    String redoState = "nil";
    Color foreground = new Color(0, 0, 0);
    StyledDocument styledDoc;
    Vector shTopLevels;
    TextPaneWidget widget;
    static final int SYNTAX_NONE = 0;
    static final int SYNTAX_NEWLISP = 1;
    static final int SYNTAX_C = 2;
    static final int SYNTAX_CPP = 3;
    static final int SYNTAX_JAVA = 4;
    static final int SYNTAX_PHP = 5;
    int syntaxSelected = 0;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected UndoManager undo = new UndoManager();
    MyUndoableEditListener undoableEditListener;
    boolean undoEnabled = true;

    public TextPaneWidget(StringTokenizer stringTokenizer) {
        this.id = stringTokenizer.nextToken();
        this.action = stringTokenizer.nextToken();
        this.textPane = new JTextPane();
        this.textPane.setDoubleBuffered(true);
        MyCaret myCaret = new MyCaret();
        myCaret.setBlinkRate(500);
        this.textPane.setCaret(myCaret);
        if (stringTokenizer.hasMoreTokens()) {
            this.contentType = stringTokenizer.nextToken();
        }
        this.textPane.setContentType(this.contentType);
        this.areaScrollPane = new JScrollPane(this.textPane);
        this.areaScrollPane.setVerticalScrollBarPolicy(20);
        this.container = this.areaScrollPane;
        this.jcomponent = this.textPane;
        this.component = this.areaScrollPane;
        this.textcomp = this.textPane;
        this.isScrollable = true;
        this.widget = this;
        this.shTopLevels = new Vector();
        if (stringTokenizer.hasMoreTokens()) {
            this.areaScrollPane.setPreferredSize(new Dimension(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken())));
        }
        gsObject.widgets.put(this.id, this);
        this.styledDoc = this.textPane.getStyledDocument();
        AbstractDocument abstractDocument = (AbstractDocument)((Object)this.styledDoc);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Character c = new Character(keyEvent.getKeyChar());
                int n = keyEvent.getKeyCode();
                TextPaneWidget.this.lastCharCode = c.hashCode();
                TextPaneWidget.this.lastModifiers = keyEvent.getModifiersEx();
                if (TextPaneWidget.this.syntaxSelected != 0) {
                    TextPaneWidget.this.colorSyntax();
                }
                switch (TextPaneWidget.this.lastCharCode) {
                    case 40: {
                        TextPaneWidget.this.highlightClosingPar('(', ')');
                        break;
                    }
                    case 41: {
                        TextPaneWidget.this.highlightOpeningPar('(', ')');
                        break;
                    }
                    case 123: {
                        TextPaneWidget.this.highlightClosingPar('{', '}');
                        break;
                    }
                    case 125: {
                        TextPaneWidget.this.highlightOpeningPar('{', '}');
                        break;
                    }
                    case 91: {
                        TextPaneWidget.this.highlightClosingPar('[', ']');
                        break;
                    }
                    case 93: {
                        TextPaneWidget.this.highlightOpeningPar('[', ']');
                    }
                }
            }
        };
        this.caretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (caretEvent == null) {
                    return;
                }
                int n = caretEvent.getMark();
                int n2 = caretEvent.getDot();
                TextPaneWidget.this.lastCaretEvent = caretEvent;
                TextPaneWidget.this.undoAction.updateUndoState();
                TextPaneWidget.this.redoAction.updateRedoState();
                TextPaneWidget.this.undoState = TextPaneWidget.this.undoAction.isEnabled() ? "true" : "nil";
                TextPaneWidget.this.redoState = TextPaneWidget.this.redoAction.isEnabled() ? "true" : "nil";
                guiserver.out.println("(" + TextPaneWidget.this.action + " \"" + TextPaneWidget.this.id + "\" " + TextPaneWidget.this.lastCharCode + " " + TextPaneWidget.this.lastModifiers + " " + n2 + " " + n + " " + TextPaneWidget.this.documentLength + " " + TextPaneWidget.this.undoState + " " + TextPaneWidget.this.redoState + ")");
                guiserver.out.flush();
                TextPaneWidget.this.lastCharCode = 65535;
            }
        };
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.undoableEditListener = new MyUndoableEditListener();
        InputMap inputMap = this.textPane.getInputMap();
        KeyStroke keyStroke = guiserver.MAC_OS_X ? KeyStroke.getKeyStroke(90, 4) : KeyStroke.getKeyStroke(90, 2);
        inputMap.put(keyStroke, this.undoAction);
        keyStroke = guiserver.MAC_OS_X ? KeyStroke.getKeyStroke(90, 5) : KeyStroke.getKeyStroke(90, 3);
        inputMap.put(keyStroke, this.redoAction);
        this.styledDoc.addUndoableEditListener(this.undoableEditListener);
        this.styledDoc.addDocumentListener(new MyDocumentListener());
        this.textPane.addHyperlinkListener(new Hyperactive());
        this.textPane.addCaretListener(this.caretListener);
        this.textPane.addKeyListener(keyAdapter);
    }

    public void highlightOpeningPar(char c, char c2) {
        int n = -1;
        String string = this.textPane.getText();
        int n2 = this.textPane.getCaretPosition();
        int n3 = 0;
        int n4 = string.length();
        for (n3 = n2 - 1; n != 0 && n3 >= 0; --n3) {
            if (string.charAt(n3) == c) {
                ++n;
                continue;
            }
            if (string.charAt(n3) != c2) continue;
            --n;
        }
        ++n3;
        if (n == 0) {
            this.highlightPosition(n3, n2);
        }
    }

    public void highlightClosingPar(char c, char c2) {
        int n = 1;
        String string = this.textPane.getText();
        int n2 = this.textPane.getCaretPosition();
        int n3 = 0;
        int n4 = string.length();
        if (n4 == 0) {
            return;
        }
        for (n3 = n2; n != 0 && n3 < n4; ++n3) {
            if (string.charAt(n3) == c) {
                ++n;
                continue;
            }
            if (string.charAt(n3) != c2) continue;
            --n;
        }
        if (n == 0) {
            this.highlightPosition(n3, n2);
        }
    }

    public void highlightPosition(int n, int n2) {
        this.textPane.setCaretPosition(n);
        this.textPane.getCaret().paint(this.textPane.getGraphics());
        this.textPane.repaint();
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.textPane.setCaretPosition(n2);
        this.textPane.getCaret().paint(this.textPane.getGraphics());
    }

    @Override
    public void loadText(StringTokenizer stringTokenizer) {
        String string = Base64Coder.decodeString(stringTokenizer.nextToken());
        EditorKit editorKit = this.textPane.getEditorKit();
        System.setProperty("line.separator", "\n");
        try {
            if (guiserver.UTF8) {
                editorKit.read(new FilterFileReader(string, "UTF8"), (Document)this.styledDoc, 0);
            } else {
                editorKit.read(new FilterFileReader(string), (Document)this.styledDoc, 0);
            }
        }
        catch (Exception exception) {
            ErrorDialog.show("gs:load-text", "Cannot load or decode file: " + string);
        }
    }

    @Override
    public void saveText(StringTokenizer stringTokenizer) {
        String string = Base64Coder.decodeString(stringTokenizer.nextToken());
        EditorKit editorKit = this.textPane.getEditorKit();
        try {
            editorKit.write(new FileWriter(string), (Document)this.styledDoc, 0, this.styledDoc.getLength());
        }
        catch (Exception exception) {
            ErrorDialog.show("gs:save-text", "Cannot save file: " + string);
        }
    }

    @Override
    public void findText(StringTokenizer stringTokenizer) {
        int n;
        String string = stringTokenizer.nextToken();
        string = guiserver.UTF8 ? Base64Coder.decodeStringUTF8(string) : Base64Coder.decodeString(string);
        String string2 = "next";
        boolean bl = false;
        String string3 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            bl = stringTokenizer.nextToken().equals("true");
        }
        String string4 = this.textPane.getText();
        int n2 = this.textPane.getCaretPosition();
        if (string2.equals("previous")) {
            if (n2 > string.length() + 1) {
                n2 -= string.length() + 1;
            }
            n = string4.lastIndexOf(string, n2);
        } else {
            n = string4.indexOf(string, n2);
        }
        guiserver.out.println("(" + string3 + " \"" + this.id + "\" " + n + ")");
        guiserver.out.flush();
        if (n < 0) {
            this.textPane.setCaretPosition(n2);
            return;
        }
        this.textPane.setCaretPosition(n);
        this.textPane.moveCaretPosition(n + string.length());
    }

    @Override
    public void setTabSize(StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        TabSet tabSet = new TabSet(new TabStop[]{new TabStop(n), new TabStop(2 * n), new TabStop(3 * n), new TabStop(4 * n), new TabStop(5 * n), new TabStop(6 * n), new TabStop(7 * n), new TabStop(8 * n), new TabStop(9 * n)});
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setTabSet(simpleAttributeSet, tabSet);
        this.styledDoc.setParagraphAttributes(0, this.documentLength, simpleAttributeSet, false);
    }

    @Override
    public void setSyntax(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        this.syntaxSelected = string.equals("true") || string.equals("lsp") ? 1 : (string.equals("c") ? 2 : (string.equals("cpp") ? 3 : (string.equals("java") ? 4 : (string.equals("php") ? 5 : 0))));
        if (this.syntaxSelected == 0) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, this.widget.foreground);
            this.styledDoc.setCharacterAttributes(0, this.documentLength, simpleAttributeSet, true);
        } else {
            this.shTopLevels.removeAllElements();
            if (this.syntaxSelected == 1) {
                SyntaxHighlighter.color(this.widget, 0, this.documentLength);
            } else {
                SyntaxHighlighterC.setFlavor(this.syntaxSelected);
                SyntaxHighlighterC.color(this.widget, 0, this.documentLength);
            }
        }
        this.undo.discardAllEdits();
    }

    @Override
    public void setForeground(StringTokenizer stringTokenizer) {
        Float f = Float.valueOf(Float.parseFloat(stringTokenizer.nextToken()));
        Float f2 = Float.valueOf(Float.parseFloat(stringTokenizer.nextToken()));
        Float f3 = Float.valueOf(Float.parseFloat(stringTokenizer.nextToken()));
        if (stringTokenizer.hasMoreTokens()) {
            Float f4 = Float.valueOf(Float.parseFloat(stringTokenizer.nextToken()));
            this.textPane.setForeground(new Color(f.floatValue(), f2.floatValue(), f3.floatValue(), f4.floatValue()));
        } else {
            this.textPane.setForeground(new Color(f.floatValue(), f2.floatValue(), f3.floatValue()));
        }
        this.widget.foreground = this.textPane.getForeground();
    }

    @Override
    public void undoEnable(StringTokenizer stringTokenizer) {
        this.undoEnabled = stringTokenizer.nextToken().equals("true");
    }

    @Override
    public void undoText(StringTokenizer stringTokenizer) {
        this.undoAction.actionPerformed(new ActionEvent(this.textPane, 1001, "Undo"));
    }

    @Override
    public void redoText(StringTokenizer stringTokenizer) {
        this.redoAction.actionPerformed(new ActionEvent(this.textPane, 1001, "Redo"));
    }

    public void colorSyntax() {
        int n = this.textPane.getCaretPosition();
        int n2 = 0;
        int n3 = this.shTopLevels.size();
        for (int i = n3 - 1; i >= 0; --i) {
            n2 = (Integer)this.shTopLevels.elementAt(i);
            if (n <= n2) continue;
            for (int j = i; j < n3; ++j) {
                int n4 = (Integer)this.shTopLevels.elementAt(i);
                this.shTopLevels.removeElementAt(i);
            }
            break;
        }
        int n5 = this.documentLength > n + 1024 ? n + 1024 : this.documentLength;
        if (this.syntaxSelected == 1) {
            SyntaxHighlighter.color(this.widget, n2, n5);
        } else {
            SyntaxHighlighterC.color(this.widget, n2, n5);
        }
    }

    class MyCaret
    extends DefaultCaret {
        public static final long serialVersionUID = 1L;

        MyCaret() {
        }

        @Override
        public void paint(Graphics graphics) {
            if (!this.isVisible()) {
                return;
            }
            try {
                JTextComponent jTextComponent = this.getComponent();
                int n = this.getDot();
                Rectangle rectangle = jTextComponent.modelToView(n);
                graphics.setColor(jTextComponent.getCaretColor());
                graphics.fillRect(rectangle.x, rectangle.y, 2, rectangle.height);
            }
            catch (Exception exception) {
                System.err.println(".");
            }
        }

        @Override
        protected synchronized void damage(Rectangle rectangle) {
            if (rectangle == null) {
                return;
            }
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = 2;
            this.height = rectangle.height;
            this.repaint();
        }
    }

    class RedoAction
    extends AbstractAction {
        public static final long serialVersionUID = 1L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = TextPaneWidget.this.undo.getRedoPresentationName();
            try {
                TextPaneWidget.this.undo.redo();
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
            }
            String string2 = TextPaneWidget.this.undo.getRedoPresentationName();
            if (string.equals("Redo deletion") && string2.equals("Redo addition")) {
                try {
                    TextPaneWidget.this.undo.redo();
                }
                catch (Exception exception) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            this.updateRedoState();
            TextPaneWidget.this.undoAction.updateUndoState();
            TextPaneWidget.this.caretListener.caretUpdate(TextPaneWidget.this.lastCaretEvent);
        }

        protected void updateRedoState() {
            if (TextPaneWidget.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", TextPaneWidget.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public static final long serialVersionUID = 1L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = TextPaneWidget.this.undo.getUndoPresentationName();
            try {
                TextPaneWidget.this.undo.undo();
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
            }
            String string2 = TextPaneWidget.this.undo.getUndoPresentationName();
            if (string.equals("Undo addition") && string2.equals("Undo deletion")) {
                try {
                    TextPaneWidget.this.undo.undo();
                }
                catch (Exception exception) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            this.updateUndoState();
            TextPaneWidget.this.redoAction.updateRedoState();
            TextPaneWidget.this.caretListener.caretUpdate(TextPaneWidget.this.lastCaretEvent);
        }

        protected void updateUndoState() {
            if (TextPaneWidget.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", TextPaneWidget.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    protected class MyDocumentListener
    implements DocumentListener {
        protected MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateParams(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateParams(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateParams(documentEvent);
        }

        private void updateParams(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            TextPaneWidget.this.documentLength = document.getLength();
        }
    }

    protected class MyUndoableEditListener
    implements UndoableEditListener {
        protected MyUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (SyntaxHighlighter.active || !TextPaneWidget.this.undoEnabled) {
                return;
            }
            TextPaneWidget.this.undo.addEdit(undoableEditEvent.getEdit());
            TextPaneWidget.this.undoAction.updateUndoState();
            TextPaneWidget.this.redoAction.updateRedoState();
        }
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    try {
                        jEditorPane.setPage(hyperlinkEvent.getURL());
                    }
                    catch (Throwable throwable) {
                        TextPaneWidget.this.textPane.setText("The page could not be displayed.");
                    }
                }
            }
        }
    }
}

