'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

const set = Symbol('internal set');

class Collection {
  constructor() {
    // Set's have a length of 0, mimic that
    this[set] = new Set(arguments[0] || []);
  }

  /******
   ** Collection API
   ******/

  toArray() {
    return [...this.values()];
  }

  toJSON() {
    return this.toArray();
  }

  /******
   ** ES Set Api
   ******/

  static get [Symbol.species]() {
    return Collection;
  }

  get size() {
    return this[set].size;
  }

  add(value) {
    return this[set].add(value);
  }

  clear() {
    return this[set].clear();
  }

  delete(value) {
    return this[set].delete(value);
  }

  entries() {
    return this[set].entries();
  }

  forEach(callbackFn, thisArg) {
    return this[set].forEach(callbackFn, thisArg);
  }

  has(value) {
    return this[set].has(value);
  }

  keys() {
    return this[set].keys();
  }

  values() {
    return this[set].values();
  }

  [Symbol.iterator]() {
    return this[set][Symbol.iterator]();
  }
}
exports.default = Collection;
module.exports = exports['default'];