'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiLineAnnotation = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactVis = require('react-vis');

var _chart_utils = require('./utils/chart_utils');

var _axis_utils = require('./utils/axis_utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _EuiXYChartUtils$ORIE = _chart_utils.EuiXYChartUtils.ORIENTATION,
    HORIZONTAL = _EuiXYChartUtils$ORIE.HORIZONTAL,
    VERTICAL = _EuiXYChartUtils$ORIE.VERTICAL;
var _EuiXYChartAxisUtils$ = _axis_utils.EuiXYChartAxisUtils.TITLE_POSITION,
    START = _EuiXYChartAxisUtils$.START,
    MIDDLE = _EuiXYChartAxisUtils$.MIDDLE,
    END = _EuiXYChartAxisUtils$.END;

/**
 * Draw simple line annotation into the chart. Currently it's a work in progress
 * but will be extented to add text and tooltips if required.
 * The basic usage is for displaying the current time marker.
 */

var EuiLineAnnotation = exports.EuiLineAnnotation = function (_AbstractSeries) {
  _inherits(EuiLineAnnotation, _AbstractSeries);

  function EuiLineAnnotation() {
    _classCallCheck(this, EuiLineAnnotation);

    return _possibleConstructorReturn(this, (EuiLineAnnotation.__proto__ || Object.getPrototypeOf(EuiLineAnnotation)).apply(this, arguments));
  }

  _createClass(EuiLineAnnotation, [{
    key: '_getAttributeFunctor',

    /**
     * Get attribute functor.
     * @param {string} attr Attribute name
     * @returns {*} Functor.
     * @protected
     */
    value: function _getAttributeFunctor(attr) {
      return _reactVis.ScaleUtils.getAttributeFunctor(this.props, attr);
    }
    /**
     * Get the attribute value if it is available.
     * @param {string} attr Attribute name.
     * @returns {*} Attribute value if available, fallback value or undefined
     * otherwise.
     * @protected
     */

  }, {
    key: '_getAttributeValue',
    value: function _getAttributeValue(attr) {
      return _reactVis.ScaleUtils.getAttributeValue(this.props, attr);
    }
  }, {
    key: '_getTextXY',
    value: function _getTextXY(textPosition, min, max) {
      switch (textPosition) {
        case END:
          return min;
        case START:
          return max;
        case MIDDLE:
          return Math.abs((max - min) / 2);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          data = _props.data,
          orientation = _props.orientation,
          textPosition = _props.textPosition,
          innerHeight = _props.innerHeight,
          innerWidth = _props.innerWidth,
          marginLeft = _props.marginLeft,
          marginTop = _props.marginTop;

      var axis = orientation === HORIZONTAL ? 'y' : 'x';
      var scale = this._getAttributeFunctor(axis);

      return _react2.default.createElement(
        'g',
        { className: 'euiLineAnnotations', transform: 'translate(' + marginLeft + ',' + marginTop + ')' },
        _react2.default.createElement(
          'g',
          { className: 'euiLineAnnotations__linesGroup' },
          data.map(function (d, i) {
            var value = d.value;

            var position = scale(_defineProperty({}, axis, value));
            return _react2.default.createElement('line', {
              key: 'annotation-' + i,
              className: 'euiLineAnnotations__line',
              x1: orientation === VERTICAL ? position : 0,
              y1: orientation === VERTICAL ? 0 : position,
              x2: orientation === VERTICAL ? position : innerWidth,
              y2: orientation === VERTICAL ? innerHeight : position
            });
          })
        ),
        _react2.default.createElement(
          'g',
          { className: 'euiLineAnnotations__textGroup' },
          data.filter(function (d) {
            return d.text;
          }).map(function (d, i) {
            var value = d.value;

            var x = 0;
            var y = 0;
            var rotation = 0;
            if (orientation === VERTICAL) {
              x = scale(_defineProperty({}, axis, value));
              y = _this2._getTextXY(textPosition, 0, innerHeight);
              rotation = '-90';
            } else {
              x = _this2._getTextXY(textPosition, innerWidth, 0);
              y = scale(_defineProperty({}, axis, value));
            }

            return _react2.default.createElement(
              'text',
              {
                key: 'annotation-' + i,
                className: 'euiLineAnnotations__text',
                x: 0,
                y: 0,
                textAnchor: textPosition,
                transform: 'translate(' + x + ',' + y + ') rotate(' + rotation + ')'
              },
              d.text
            );
          })
        )
      );
    }
  }]);

  return EuiLineAnnotation;
}(_reactVis.AbstractSeries);

EuiLineAnnotation.displayName = 'EuiLineAnnotation';
EuiLineAnnotation.propTypes = {
  /** An annotation data Array<{value: string|number, text: string}> */
  data: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    value: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.number]),
    text: _propTypes2.default.string
  })).isRequired,
  /** The orientation of the annotation. */
  orientation: _propTypes2.default.oneOf([HORIZONTAL, VERTICAL]),
  textPosition: _propTypes2.default.oneOf([START, MIDDLE, END])
};

EuiLineAnnotation.defaultProps = {
  orientation: VERTICAL,
  textPosition: START
};
EuiLineAnnotation.__docgenInfo = [{
  'description': 'Draw simple line annotation into the chart. Currently it\'s a work in progress\nbut will be extented to add text and tooltips if required.\nThe basic usage is for displaying the current time marker.',
  'displayName': 'EuiLineAnnotation',
  'methods': [{
    'name': '_getAttributeFunctor',
    'docblock': 'Get attribute functor.\n@param {string} attr Attribute name\n@returns {*} Functor.\n@protected',
    'modifiers': [],
    'params': [{
      'name': 'attr',
      'description': 'Attribute name',
      'type': {
        'name': 'string'
      }
    }],
    'returns': {
      'description': 'Functor.',
      'type': {
        'name': 'mixed'
      }
    },
    'description': 'Get attribute functor.'
  }, {
    'name': '_getAttributeValue',
    'docblock': 'Get the attribute value if it is available.\n@param {string} attr Attribute name.\n@returns {*} Attribute value if available, fallback value or undefined\notherwise.\n@protected',
    'modifiers': [],
    'params': [{
      'name': 'attr',
      'description': 'Attribute name.',
      'type': {
        'name': 'string'
      }
    }],
    'returns': {
      'description': 'Attribute value if available, fallback value or undefined\notherwise.',
      'type': {
        'name': 'mixed'
      }
    },
    'description': 'Get the attribute value if it is available.'
  }, {
    'name': '_getTextXY',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'textPosition',
      'type': null
    }, {
      'name': 'min',
      'type': null
    }, {
      'name': 'max',
      'type': null
    }],
    'returns': null
  }],
  'props': {
    'data': {
      'type': {
        'name': 'arrayOf',
        'value': {
          'name': 'shape',
          'value': {
            'value': {
              'name': 'union',
              'value': [{
                'name': 'string'
              }, {
                'name': 'number'
              }],
              'required': false
            },
            'text': {
              'name': 'string',
              'required': false
            }
          }
        }
      },
      'required': true,
      'description': 'An annotation data Array<{value: string|number, text: string}>'
    },
    'orientation': {
      'type': {
        'name': 'enum',
        'value': [{
          'value': 'EuiXYChartUtils.ORIENTATION.HORIZONTAL',
          'computed': true
        }, {
          'value': 'EuiXYChartUtils.ORIENTATION.VERTICAL',
          'computed': true
        }]
      },
      'required': false,
      'description': 'The orientation of the annotation.',
      'defaultValue': {
        'value': 'EuiXYChartUtils.ORIENTATION.VERTICAL',
        'computed': true
      }
    },
    'textPosition': {
      'type': {
        'name': 'enum',
        'value': [{
          'value': 'EuiXYChartAxisUtils.TITLE_POSITION.START',
          'computed': true
        }, {
          'value': 'EuiXYChartAxisUtils.TITLE_POSITION.MIDDLE',
          'computed': true
        }, {
          'value': 'EuiXYChartAxisUtils.TITLE_POSITION.END',
          'computed': true
        }]
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': 'EuiXYChartAxisUtils.TITLE_POSITION.START',
        'computed': true
      }
    }
  }
}];