'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiXAxis = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactVis = require('react-vis');

var _axis_utils = require('../utils/axis_utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TITLE_POSITION = _axis_utils.EuiXYChartAxisUtils.TITLE_POSITION,
    ORIENTATION = _axis_utils.EuiXYChartAxisUtils.ORIENTATION;

var EuiXAxis = exports.EuiXAxis = function (_PureComponent) {
  _inherits(EuiXAxis, _PureComponent);

  function EuiXAxis() {
    _classCallCheck(this, EuiXAxis);

    return _possibleConstructorReturn(this, (EuiXAxis.__proto__ || Object.getPrototypeOf(EuiXAxis)).apply(this, arguments));
  }

  _createClass(EuiXAxis, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          title = _props.title,
          titlePosition = _props.titlePosition,
          orientation = _props.orientation,
          tickSize = _props.tickSize,
          tickLabelAngle = _props.tickLabelAngle,
          tickFormat = _props.tickFormat,
          tickValues = _props.tickValues,
          onZero = _props.onZero,
          rest = _objectWithoutProperties(_props, ['title', 'titlePosition', 'orientation', 'tickSize', 'tickLabelAngle', 'tickFormat', 'tickValues', 'onZero']);

      return _react2.default.createElement(_reactVis.XAxis, _extends({
        title: title,
        position: titlePosition,
        orientation: orientation,
        on0: onZero,
        tickSize: tickSize,
        tickFormat: tickFormat,
        tickValues: tickValues,
        tickLabelAngle: tickLabelAngle
      }, rest));
    }
  }]);

  return EuiXAxis;
}(_react.PureComponent);

EuiXAxis.displayName = 'EuiXAxis';

EuiXAxis.propTypes = {
  /** The axis title */
  title: _propTypes2.default.string,
  /** The axis title position */
  titlePosition: _propTypes2.default.oneOf([TITLE_POSITION.START, TITLE_POSITION.MIDDLE, TITLE_POSITION.END]),
  /** The axis orientation */
  orientation: _propTypes2.default.oneOf([ORIENTATION.TOP, ORIENTATION.BOTTOM]),
  /** Fix the axis at zero value */
  onZero: _propTypes2.default.bool,
  /** An array of ticks values */
  ticks: _propTypes2.default.array,
  /** The height of the ticks in pixels */
  tickSize: _propTypes2.default.number,
  /** TODO */
  tickValues: _propTypes2.default.array,
  /** A formatter function in the form of function(value, index, scale, tickTotal) */
  tickFormat: _propTypes2.default.func,
  /** the rotation angle in degree of the tick label */
  tickLabelAngle: _propTypes2.default.number
};

EuiXAxis.defaultProps = {
  onZero: false,
  titlePosition: TITLE_POSITION.MIDDLE,
  orientation: ORIENTATION.BOTTOM,
  tickSize: 0
};

EuiXAxis.requiresSVG = true;
EuiXAxis.__docgenInfo = [{
  'description': '',
  'displayName': 'EuiXAxis',
  'methods': [],
  'props': {
    'title': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': 'The axis title'
    },
    'titlePosition': {
      'type': {
        'name': 'enum',
        'value': [{
          'value': 'TITLE_POSITION.START',
          'computed': true
        }, {
          'value': 'TITLE_POSITION.MIDDLE',
          'computed': true
        }, {
          'value': 'TITLE_POSITION.END',
          'computed': true
        }]
      },
      'required': false,
      'description': 'The axis title position',
      'defaultValue': {
        'value': 'TITLE_POSITION.MIDDLE',
        'computed': true
      }
    },
    'orientation': {
      'type': {
        'name': 'enum',
        'value': [{
          'value': 'ORIENTATION.TOP',
          'computed': true
        }, {
          'value': 'ORIENTATION.BOTTOM',
          'computed': true
        }]
      },
      'required': false,
      'description': 'The axis orientation',
      'defaultValue': {
        'value': 'ORIENTATION.BOTTOM',
        'computed': true
      }
    },
    'onZero': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': 'Fix the axis at zero value',
      'defaultValue': {
        'value': 'false',
        'computed': false
      }
    },
    'ticks': {
      'type': {
        'name': 'array'
      },
      'required': false,
      'description': 'An array of ticks values'
    },
    'tickSize': {
      'type': {
        'name': 'number'
      },
      'required': false,
      'description': 'The height of the ticks in pixels',
      'defaultValue': {
        'value': '0',
        'computed': false
      }
    },
    'tickValues': {
      'type': {
        'name': 'array'
      },
      'required': false,
      'description': 'TODO'
    },
    'tickFormat': {
      'type': {
        'name': 'func'
      },
      'required': false,
      'description': 'A formatter function in the form of function(value, index, scale, tickTotal)'
    },
    'tickLabelAngle': {
      'type': {
        'name': 'number'
      },
      'required': false,
      'description': 'the rotation angle in degree of the tick label'
    }
  }
}];