"""Generated message classes for serverless version v1alpha1.

Deploy and manage user provided container images that scale automatically
based on HTTP traffic.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'serverless'


class ApiGroup(_messages.Message):
  r"""An API group.

  Fields:
    name: The API group name.
    preferredVersion: The preferred version for this group.
    versions: The group versions.
  """

  name = _messages.StringField(1)
  preferredVersion = _messages.MessageField('GroupVersionForDiscovery', 2)
  versions = _messages.MessageField('GroupVersionForDiscovery', 3, repeated=True)


class ApiGroupList(_messages.Message):
  r"""List of API groups.

  Fields:
    groups: API groups.
    kind: Kind of API.
  """

  groups = _messages.MessageField('ApiGroup', 1, repeated=True)
  kind = _messages.StringField(2)


class ApiResource(_messages.Message):
  r"""Holds information about a resource type in a given API.

  Fields:
    categories: The categories to which this resource belongs.
    kind: The kind of resource.
    name: The name of the resource. Should be plural, like "routes" or
      "configurations".
    namespaced: Whether or not the resource is namespaced.
    shortNames: The short names for this resource.
    singularName: The singular name for this resource.
    verbs: The verbs (create, get, update, etc) supported for this resource.
  """

  categories = _messages.StringField(1, repeated=True)
  kind = _messages.StringField(2)
  name = _messages.StringField(3)
  namespaced = _messages.BooleanField(4)
  shortNames = _messages.StringField(5, repeated=True)
  singularName = _messages.StringField(6)
  verbs = _messages.StringField(7, repeated=True)


class ApiResourceList(_messages.Message):
  r"""A list of API resources.

  Fields:
    groupVersion: The group version of the resources.
    kind: The kind of resources.
    resources: The list of API resources.
  """

  groupVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  resources = _messages.MessageField('ApiResource', 3, repeated=True)


class ApiVersions(_messages.Message):
  r"""Message to list the versions of the API which are available.

  Fields:
    kind: The kind of this message, in this case "APIVersions".
    versions: The version of the API, like "v1".
  """

  kind = _messages.StringField(1)
  versions = _messages.StringField(2, repeated=True)


class Capabilities(_messages.Message):
  r"""Adds and removes POSIX capabilities from running containers.

  Fields:
    add: Added capabilities +optional
    drop: Removed capabilities +optional
  """

  add = _messages.StringField(1, repeated=True)
  drop = _messages.StringField(2, repeated=True)


class ConfigMapEnvSource(_messages.Message):
  r"""ConfigMapEnvSource selects a ConfigMap to populate the environment
  variables with.  The contents of the target ConfigMap's Data field will
  represent the key-value pairs as environment variables.

  Fields:
    localObjectReference: The ConfigMap to select from.
    optional: Specify whether the ConfigMap must be defined +optional
  """

  localObjectReference = _messages.MessageField('LocalObjectReference', 1)
  optional = _messages.BooleanField(2)


class Configuration(_messages.Message):
  r"""Configuration represents the "floating HEAD" of a linear history of
  Revisions, and optionally how the containers those revisions reference are
  built. Users create new Revisions by updating the Configuration's spec. The
  "latest created" revision's name is available under status, as is the
  "latest ready" revision's name. See also: https://github.com/elafros/elafros
  /blob/master/docs/spec/overview.md#configuration

  Fields:
    apiVersion: The API version for this call such as "v1alpha1".
    kind: The kind of resource, in this case always "Configuration".
    metadata: Metadata associated with this Configuration, including name,
      namespace, labels, and annotations.
    spec: Spec holds the desired state of the Configuration (from the client).
    status: Status communicates the observed state of the Configuration (from
      the controller).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('ConfigurationSpec', 4)
  status = _messages.MessageField('ConfigurationStatus', 5)


class ConfigurationCondition(_messages.Message):
  r"""ConfigurationCondition defines a readiness condition for a
  Configuration. See:
  https://github.com/kubernetes/community/blob/master/contributors/devel/api-
  conventions.md#typical-status-properties

  Fields:
    lastTransitionTime: Last time the condition transitioned from one status
      to another. +optional
    message: Human-readable message indicating details about last transition.
      +optional
    reason: One-word CamelCase reason for the condition's last transition.
      +optional
    status: Status of the condition, one of True, False, Unknown.
    type: ConfigurationConditionType is used to communicate the status of the
      reconciliation process. See also:
      https://github.com/elafros/elafros/blob/master/docs/spec/errors.md
      #error-conditions-and-reporting Types include:"LatestRevisionReady"
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  status = _messages.StringField(4)
  type = _messages.StringField(5)


class ConfigurationSpec(_messages.Message):
  r"""ConfigurationSpec holds the desired state of the Configuration (from the
  client).

  Fields:
    generation: For open Knative: metadata.generation does not work yet, this
      is a stopgap way of specifying generation IGNORED BY GSE. +optional
    revisionTemplate: RevisionTemplate holds the latest specification for the
      Revision to be stamped out. If a Build specification is provided, then
      the RevisionTemplate's BuildName field will be populated with the name
      of the Build object created to produce the container for the Revision.
  """

  generation = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  revisionTemplate = _messages.MessageField('RevisionTemplate', 2)


class ConfigurationStatus(_messages.Message):
  r"""ConfigurationStatus communicates the observed state of the Configuration
  (from the controller).

  Fields:
    conditions: Conditions communicates information about ongoing/complete
      reconciliation processes that bring the "spec" inline with the observed
      state of the world.
    latestCreatedRevisionName: LatestCreatedRevisionName is the last revision
      that was created from this Configuration. It might not be ready yet, for
      that use LatestReadyRevisionName.
    latestReadyRevisionName: LatestReadyRevisionName holds the name of the
      latest Revision stamped out from this Configuration that has had its
      "Ready" condition become "True".
    observedGeneration: ObservedGeneration is the 'Generation' of the
      Configuration that was last processed by the controller. The observed
      generation is updated even if the controller failed to process the spec
      and create the Revision. The API version for this revision.
  """

  conditions = _messages.MessageField('ConfigurationCondition', 1, repeated=True)
  latestCreatedRevisionName = _messages.StringField(2)
  latestReadyRevisionName = _messages.StringField(3)
  observedGeneration = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Container(_messages.Message):
  r"""A single application container. This specifies both the container to
  run, the command to run in the container and the arguments to supply to it.
  Note that additional arguments may be supplied by the system to the
  container at runtime.

  Fields:
    args: Arguments to the entrypoint. The docker image's CMD is used if this
      is not provided. Variable references $(VAR_NAME) are expanded using the
      container's environment. If a variable cannot be resolved, the reference
      in the input string will be unchanged. The $(VAR_NAME) syntax can be
      escaped with a double $$, ie: $$(VAR_NAME). Escaped references will
      never be expanded, regardless of whether the variable exists or not.
      Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-
      data-application/define-command-argument-container/#running-a-command-
      in-a-shell +optional
    command: Entrypoint array. Not executed within a shell. The docker image's
      ENTRYPOINT is used if this is not provided. Variable references
      $(VAR_NAME) are expanded using the container's environment. If a
      variable cannot be resolved, the reference in the input string will be
      unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie:
      $$(VAR_NAME). Escaped references will never be expanded, regardless of
      whether the variable exists or not. Cannot be updated. More info:
      https://kubernetes.io/docs/tasks/inject-data-application/define-command-
      argument-container/#running-a-command-in-a-shell +optional
    env: List of environment variables to set in the container. Cannot be
      updated. +optional +patchMergeKey=name +patchStrategy=merge
    envFrom: List of sources to populate environment variables in the
      container. The keys defined within a source must be a C_IDENTIFIER. All
      invalid keys will be reported as an event when the container is
      starting. When a key exists in multiple sources, the value associated
      with the last source will take precedence. Values defined by an Env with
      a duplicate key will take precedence. Cannot be updated. +optional
    image: Docker image name. More info:
      https://kubernetes.io/docs/concepts/containers/images
    imagePullPolicy: Image pull policy. One of Always, Never, IfNotPresent.
      Defaults to Always if :latest tag is specified, or IfNotPresent
      otherwise. Cannot be updated. More info:
      https://kubernetes.io/docs/concepts/containers/images#updating-images
      +optional
    lifecycle: Actions that the management system should take in response to
      container lifecycle events. Cannot be updated. +optional
    livenessProbe: Periodic probe of container liveness. Container will be
      restarted if the probe fails. Cannot be updated. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle
      #container-probes +optional
    name: Name of the container specified as a DNS_LABEL. Each container in a
      pod must have a unique name (DNS_LABEL). Cannot be updated.
    ports: List of ports to expose from the container. Exposing a port here
      gives the system additional information about the network connections a
      container uses, but is primarily informational. Not specifying a port
      here DOES NOT prevent that port from being exposed. Any port which is
      listening on the default "0.0.0.0" address inside a container will be
      accessible from the network. Cannot be updated. +optional
      +patchMergeKey=containerPort +patchStrategy=merge
    readinessProbe: Periodic probe of container service readiness. Container
      will be removed from service endpoints if the probe fails. Cannot be
      updated. More info: https://kubernetes.io/docs/concepts/workloads/pods
      /pod-lifecycle#container-probes +optional
    resources: Compute Resources required by this container. Cannot be
      updated. More info: https://kubernetes.io/docs/concepts/storage
      /persistent-volumes#resources +optional
    securityContext: Security options the pod should run with. More info:
      https://kubernetes.io/docs/concepts/policy/security-context/ More info:
      https://kubernetes.io/docs/tasks/configure-pod-container/security-
      context/ +optional
    stdin: Whether this container should allocate a buffer for stdin in the
      container runtime. If this is not set, reads from stdin in the container
      will always result in EOF. Default is false. +optional
    stdinOnce: Whether the container runtime should close the stdin channel
      after it has been opened by a single attach. When stdin is true the
      stdin stream will remain open across multiple attach sessions. If
      stdinOnce is set to true, stdin is opened on container start, is empty
      until the first client attaches to stdin, and then remains open and
      accepts data until the client disconnects, at which time stdin is closed
      and remains closed until the container is restarted. If this flag is
      false, a container processes that reads from stdin will never receive an
      EOF. Default is false +optional
    terminationMessagePath: Optional: Path at which the file to which the
      container's termination message will be written is mounted into the
      container's filesystem. Message written is intended to be brief final
      status, such as an assertion failure message. Will be truncated by the
      node if greater than 4096 bytes. The total message length across all
      containers will be limited to 12kb. Defaults to /dev/termination-log.
      Cannot be updated. +optional
    terminationMessagePolicy: Indicate how the termination message should be
      populated. File will use the contents of terminationMessagePath to
      populate the container status message on both success and failure.
      FallbackToLogsOnError will use the last chunk of container log output if
      the termination message file is empty and the container exited with an
      error. The log output is limited to 2048 bytes or 80 lines, whichever is
      smaller. Defaults to File. Cannot be updated. +optional
    tty: Whether this container should allocate a TTY for itself, also
      requires 'stdin' to be true. Default is false. +optional
    volumeDevices: volumeDevices is the list of block devices to be used by
      the container. This is an alpha feature and may change in the future.
      +patchMergeKey=devicePath +patchStrategy=merge +optional
    volumeMounts: Pod volumes to mount into the container's filesystem. Cannot
      be updated. +optional +patchMergeKey=mountPath +patchStrategy=merge
    workingDir: Container's working directory. If not specified, the container
      runtime's default will be used, which might be configured in the
      container image. Cannot be updated. +optional
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('EnvVar', 3, repeated=True)
  envFrom = _messages.MessageField('EnvFromSource', 4, repeated=True)
  image = _messages.StringField(5)
  imagePullPolicy = _messages.StringField(6)
  lifecycle = _messages.MessageField('Lifecycle', 7)
  livenessProbe = _messages.MessageField('Probe', 8)
  name = _messages.StringField(9)
  ports = _messages.MessageField('ContainerPort', 10, repeated=True)
  readinessProbe = _messages.MessageField('Probe', 11)
  resources = _messages.MessageField('ResourceRequirements', 12)
  securityContext = _messages.MessageField('SecurityContext', 13)
  stdin = _messages.BooleanField(14)
  stdinOnce = _messages.BooleanField(15)
  terminationMessagePath = _messages.StringField(16)
  terminationMessagePolicy = _messages.StringField(17)
  tty = _messages.BooleanField(18)
  volumeDevices = _messages.MessageField('VolumeDevice', 19, repeated=True)
  volumeMounts = _messages.MessageField('VolumeMount', 20, repeated=True)
  workingDir = _messages.StringField(21)


class ContainerPort(_messages.Message):
  r"""ContainerPort represents a network port in a single container.

  Fields:
    containerPort: Number of port to expose on the pod's IP address. This must
      be a valid port number, 0 < x < 65536.
    hostIP: What host IP to bind the external port to. +optional
    hostPort: Number of port to expose on the host. If specified, this must be
      a valid port number, 0 < x < 65536. If HostNetwork is specified, this
      must match ContainerPort. Most containers do not need this. +optional
    name: If specified, this must be an IANA_SVC_NAME and unique within the
      pod. Each named port in a pod must have a unique name. Name for the port
      that can be referred to by services. +optional
    protocol: Protocol for port. Must be UDP or TCP. Defaults to "TCP".
      +optional
  """

  containerPort = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  hostIP = _messages.StringField(2)
  hostPort = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  name = _messages.StringField(4)
  protocol = _messages.StringField(5)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class EnvFromSource(_messages.Message):
  r"""EnvFromSource represents the source of a set of ConfigMaps

  Fields:
    configMapRef: The ConfigMap to select from +optional
    prefix: An optional identifier to prepend to each key in the ConfigMap.
      Must be a C_IDENTIFIER. +optional
    secretRef: The Secret to select from +optional
  """

  configMapRef = _messages.MessageField('ConfigMapEnvSource', 1)
  prefix = _messages.StringField(2)
  secretRef = _messages.MessageField('SecretEnvSource', 3)


class EnvVar(_messages.Message):
  r"""EnvVar represents an environment variable present in a Container.

  Fields:
    name: Name of the environment variable. Must be a C_IDENTIFIER.
    value: Variable references $(VAR_NAME) are expanded using the previous
      defined environment variables in the container and any route environment
      variables. If a variable cannot be resolved, the reference in the input
      string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
      double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
      regardless of whether the variable exists or not. Defaults to "".
      +optional
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class ExecAction(_messages.Message):
  r"""ExecAction describes a "run in container" action.

  Fields:
    command: Command is the command line to execute inside the container, the
      working directory for the command  is root ('/') in the container's
      filesystem. The command is simply exec'd, it is not run inside a shell,
      so traditional shell instructions ('|', etc) won't work. To use a shell,
      you need to explicitly call out to that shell. Exit status of 0 is
      treated as live/healthy and non-zero is unhealthy. +optional
  """

  command = _messages.StringField(1)


class GroupVersionForDiscovery(_messages.Message):
  r"""Group information for the discovery API.

  Fields:
    groupVersion: The group version.
    version: The version.
  """

  groupVersion = _messages.StringField(1)
  version = _messages.StringField(2)


class HTTPGetAction(_messages.Message):
  r"""HTTPGetAction describes an action based on HTTP Get requests.

  Fields:
    host: Host name to connect to, defaults to the pod IP. You probably want
      to set "Host" in httpHeaders instead. +optional
    httpHeaders: Custom headers to set in the request. HTTP allows repeated
      headers. +optional
    path: Path to access on the HTTP server. +optional
    port: Name or number of the port to access on the container. Number must
      be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    scheme: Scheme to use for connecting to the host. Defaults to HTTP.
      +optional
  """

  host = _messages.StringField(1)
  httpHeaders = _messages.MessageField('HTTPHeader', 2, repeated=True)
  path = _messages.StringField(3)
  port = _messages.MessageField('IntOrString', 4)
  scheme = _messages.StringField(5)


class HTTPHeader(_messages.Message):
  r"""HTTPHeader describes a custom header to be used in HTTP probes

  Fields:
    name: The header field name
    value: The header field value
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class Handler(_messages.Message):
  r"""Handler defines a specific action that should be taken

  Fields:
    exec_: One and only one of the following should be specified. Exec
      specifies the action to take. +optional
    httpGet: HTTPGet specifies the http request to perform. +optional
    tcpSocket: TCPSocket specifies an action involving a TCP port. TCP hooks
      not yet supported
  """

  exec_ = _messages.MessageField('ExecAction', 1)
  httpGet = _messages.MessageField('HTTPGetAction', 2)
  tcpSocket = _messages.MessageField('TCPSocketAction', 3)


class HttpBody(_messages.Message):
  r"""Message that represents an arbitrary HTTP body. It should only be used
  for payload formats that can't be represented as JSON, such as raw binary or
  an HTML page.   This message can be used both in streaming and non-streaming
  API methods in the request as well as the response.  It can be used as a
  top-level request field, which is convenient if one wants to extract
  parameters from either the URL or HTTP template into the request fields and
  also want access to the raw HTTP body.  Example:      message
  GetResourceRequest {       // A unique request id.       string request_id =
  1;        // The raw HTTP body is bound to this field.
  google.api.HttpBody http_body = 2;     }      service ResourceService {
  rpc GetResource(GetResourceRequest) returns (google.api.HttpBody);       rpc
  UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty);     }
  Example with streaming methods:      service CaldavService {       rpc
  GetCalendar(stream google.api.HttpBody)         returns (stream
  google.api.HttpBody);       rpc UpdateCalendar(stream google.api.HttpBody)
  returns (stream google.api.HttpBody);     }  Use of this type only changes
  how the request and response bodies are handled, all other features will
  continue to work unchanged.

  Messages:
    ExtensionsValueListEntry: A ExtensionsValueListEntry object.

  Fields:
    contentType: The HTTP Content-Type string representing the content type of
      the body.
    data: HTTP body binary data.
    extensions: Application specific response metadata. Must be set in the
      first response for streaming APIs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtensionsValueListEntry(_messages.Message):
    r"""A ExtensionsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        ExtensionsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExtensionsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  contentType = _messages.StringField(1)
  data = _messages.BytesField(2)
  extensions = _messages.MessageField('ExtensionsValueListEntry', 3, repeated=True)


class Initializer(_messages.Message):
  r"""Initializer is information about an initializer that has not yet
  completed.

  Fields:
    name: name of the process that is responsible for initializing this
      object.
  """

  name = _messages.StringField(1)


class Initializers(_messages.Message):
  r"""Initializers tracks the progress of initialization.

  Fields:
    pending: Pending is a list of initializers that must execute in order
      before this object is visible. When the last pending initializer is
      removed, and no failing result is set, the initializers struct will be
      set to nil and the object is considered as initialized and visible to
      all clients. +patchMergeKey=name +patchStrategy=merge
  """

  pending = _messages.MessageField('Initializer', 1, repeated=True)


class IntOrString(_messages.Message):
  r"""IntOrString is a type that can hold an int32 or a string.  When used in
  JSON or YAML marshalling and unmarshalling, it produces or consumes the
  inner type.  This allows you to have, for example, a JSON field that can
  accept a name or number.

  Fields:
    intVal: The int value.
    strVal: The string value.
    type: The type of the value.
  """

  intVal = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  strVal = _messages.StringField(2)
  type = _messages.IntegerField(3)


class Lifecycle(_messages.Message):
  r"""Lifecycle describes actions that the management system should take in
  response to container lifecycle events. For the PostStart and PreStop
  lifecycle handlers, management of the container blocks until the action is
  complete, unless the container process fails, in which case the handler is
  aborted.

  Fields:
    postStart: PostStart is called immediately after a container is created.
      If the handler fails, the container is terminated and restarted
      according to its restart policy. Other management of the container
      blocks until the hook completes. More info:
      https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks
      /#container-hooks +optional
    preStop: PreStop is called immediately before a container is terminated.
      The container is terminated after the handler completes. The reason for
      termination is passed to the handler. Regardless of the outcome of the
      handler, the container is eventually terminated. Other management of the
      container blocks until the hook completes. More info:
      https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks
      /#container-hooks +optional
  """

  postStart = _messages.MessageField('Handler', 1)
  preStop = _messages.MessageField('Handler', 2)


class ListConfigurationsResponse(_messages.Message):
  r"""ListConfigurationsResponse is a list of Configuration resources.

  Fields:
    apiVersion: The API version for this call such as "v1alpha1".
    items: List of Configurations.
    kind: The kind of this resource, in this case "ConfigurationList".
    metadata: Metadata associated with this Configuration list.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Configuration', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)


class ListMeta(_messages.Message):
  r"""ListMeta describes metadata that synthetic resources must have,
  including lists and various status objects. A resource may have only one of
  {ObjectMeta, ListMeta}.

  Fields:
    continue_: continue may be set if the user set a limit on the number of
      items returned, and indicates that the server has more data available.
      The value is opaque and may be used to issue another request to the
      endpoint that served this list to retrieve the next set of available
      objects. Continuing a list may not be possible if the server
      configuration has changed or more than a few minutes have passed. The
      resourceVersion field returned when using this continue value will be
      identical to the value in the first response.
    resourceVersion: String that identifies the server's internal version of
      this object that can be used by clients to determine when objects have
      changed. Value must be treated as opaque by clients and passed
      unmodified back to the server. Populated by the system. Read-only. More
      info: https://git.k8s.io/community/contributors/devel/api-conventions.md
      #concurrency-control-and-consistency +optional
    selfLink: SelfLink is a URL representing this object. Populated by the
      system. Read-only. +optional
  """

  continue_ = _messages.StringField(1)
  resourceVersion = _messages.StringField(2)
  selfLink = _messages.StringField(3)


class ListRevisionsResponse(_messages.Message):
  r"""ListRevisionsResponse is a list of Revision resources.

  Fields:
    apiVersion: The API version for this call such as "v1alpha1".
    items: List of Revisions.
    kind: The kind of this resource, in this case "RevisionList".
    metadata: Metadata associated with this revision list.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Revision', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)


class ListRoutesResponse(_messages.Message):
  r"""ListRoutesResponse is a list of Route resources.

  Fields:
    apiVersion: The API version for this call such as "v1alpha1".
    items: List of Routes.
    kind: The kind of this resource, in this case always "RouteList".
    metadata: Metadata associated with this Route list.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Route', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)


class ListServicesResponse(_messages.Message):
  r"""A list of Service resources.

  Fields:
    apiVersion: The API version for this call such as "v1alpha1".
    items: List of Services.
    kind: The kind of this resource, in this case "ServiceList".
    metadata: Metadata associated with this Service list.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Service', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)


class LocalObjectReference(_messages.Message):
  r"""LocalObjectReference contains enough information to let you locate the
  referenced object inside the same namespace.

  Fields:
    name: Name of the referent. More info:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/names/#names
  """

  name = _messages.StringField(1)


class ObjectMeta(_messages.Message):
  r"""ObjectMeta is metadata that all persisted resources must have, which
  includes all objects users must create.

  Messages:
    AnnotationsValue: Annotations is an unstructured key value map stored with
      a resource that may be set by external tools to store and retrieve
      arbitrary metadata. They are not queryable and should be preserved when
      modifying objects. More info: http://kubernetes.io/docs/user-
      guide/annotations +optional
    LabelsValue: Map of string keys and values that can be used to organize
      and categorize (scope and select) objects. May match selectors of
      replication controllers and routes. More info: http://kubernetes.io/docs
      /user-guide/labels +optional

  Fields:
    annotations: Annotations is an unstructured key value map stored with a
      resource that may be set by external tools to store and retrieve
      arbitrary metadata. They are not queryable and should be preserved when
      modifying objects. More info: http://kubernetes.io/docs/user-
      guide/annotations +optional
    clusterName: The name of the cluster which the object belongs to. This is
      used to distinguish resources with same name and namespace in different
      clusters. This field is not set anywhere right now and apiserver is
      going to ignore it if set in create or update request. +optional
    creationTimestamp: CreationTimestamp is a timestamp representing the
      server time when this object was created. It is not guaranteed to be set
      in happens-before order across separate operations. Clients may not set
      this value. It is represented in RFC3339 form and is in UTC.  Populated
      by the system. Read-only. Null for lists. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata +optional
    deletionGracePeriodSeconds: Number of seconds allowed for this object to
      gracefully terminate before it will be removed from the system. Only set
      when deletionTimestamp is also set. May only be shortened. Read-only.
      +optional
    deletionTimestamp: DeletionTimestamp is RFC 3339 date and time at which
      this resource will be deleted. This field is set by the server when a
      graceful deletion is requested by the user, and is not directly settable
      by a client. The resource is expected to be deleted (no longer visible
      from resource lists, and not reachable by name) after the time in this
      field, once the finalizers list is empty. As long as the finalizers list
      contains items, deletion is blocked. Once the deletionTimestamp is set,
      this value may not be unset or be set further into the future, although
      it may be shortened or the resource may be deleted prior to this time.
      For example, a user may request that a pod is deleted in 30 seconds. The
      Kubelet will react by sending a graceful termination signal to the
      containers in the pod. After that 30 seconds, the Kubelet will send a
      hard termination signal (SIGKILL) to the container and after cleanup,
      remove the pod from the API. In the presence of network partitions, this
      object may still exist after this timestamp, until an administrator or
      automated process can determine the resource is fully terminated. If not
      set, graceful deletion of the object has not been requested.  Populated
      by the system when a graceful deletion is requested. Read-only. More
      info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata +optional
    finalizers: Must be empty before the object is deleted from the registry.
      Each entry is an identifier for the responsible component that will
      remove the entry from the list. If the deletionTimestamp of the object
      is non-nil, entries in this list can only be removed. +optional
      +patchStrategy=merge
    generateName: GenerateName is an optional prefix, used by the server, to
      generate a unique name ONLY IF the Name field has not been provided. If
      this field is used, the name returned to the client will be different
      than the name passed. This value will also be combined with a unique
      suffix. The provided value has the same validation rules as the Name
      field, and may be truncated by the length of the suffix required to make
      the value unique on the server.  If this field is specified and the
      generated name exists, the server will NOT return a 409 - instead, it
      will either return 201 Created or 500 with Reason ServerTimeout
      indicating a unique name could not be found in the time allotted, and
      the client should retry (optionally after the time indicated in the
      Retry-After header).  Applied only if Name is not specified. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#idempotency +optional  string generateName = 2;
    generation: A sequence number representing a specific generation of the
      desired state. Populated by the system. Read-only. +optional
    initializers: An initializer is a controller which enforces some system
      invariant at object creation time. This field is a list of initializers
      that have not yet acted on this object. If nil or empty, this object has
      been completely initialized. Otherwise, the object is considered
      uninitialized and is hidden (in list/watch and get calls) from clients
      that haven't explicitly asked to observe uninitialized objects.  When an
      object is created, the system will populate this list with the current
      set of initializers. Only privileged users may set or modify this list.
      Once it is empty, it may not be modified further by any user.
    labels: Map of string keys and values that can be used to organize and
      categorize (scope and select) objects. May match selectors of
      replication controllers and routes. More info: http://kubernetes.io/docs
      /user-guide/labels +optional
    name: Name must be unique within a namespace. Is required when creating
      resources, although some resources may allow a client to request the
      generation of an appropriate name automatically. Name is primarily
      intended for creation idempotence and configuration definition. Cannot
      be updated. More info: http://kubernetes.io/docs/user-
      guide/identifiers#names +optional
    namespace: Namespace defines the space within each name must be unique. An
      empty namespace is equivalent to the "default" namespace, but "default"
      is the canonical representation. Not all objects are required to be
      scoped to a namespace - the value of this field for those objects will
      be empty.  Must be a DNS_LABEL. Cannot be updated. More info:
      http://kubernetes.io/docs/user-guide/namespaces +optional
    ownerReferences: List of objects that own this object. If ALL objects in
      the list have been deleted, this object will be garbage collected.
      +optional
    resourceVersion: An opaque value that represents the internal version of
      this object that can be used by clients to determine when objects have
      changed. May be used for optimistic concurrency, change detection, and
      the watch operation on a resource or set of resources. Clients must
      treat these values as opaque and passed unmodified back to the server.
      They may only be valid for a particular resource or set of resources.
      Populated by the system. Read-only. Value must be treated as opaque by
      clients and . More info: https://git.k8s.io/community/contributors/devel
      /api-conventions.md#concurrency-control-and-consistency +optional
    selfLink: SelfLink is a URL representing this object. Populated by the
      system. Read-only. +optional  string selfLink = 4;
    uid: UID is the unique in time and space value for this object. It is
      typically generated by the server on successful creation of a resource
      and is not allowed to change on PUT operations.  Populated by the
      system. Read-only. More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids +optional
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations is an unstructured key value map stored with a resource
    that may be set by external tools to store and retrieve arbitrary
    metadata. They are not queryable and should be preserved when modifying
    objects. More info: http://kubernetes.io/docs/user-guide/annotations
    +optional

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Map of string keys and values that can be used to organize and
    categorize (scope and select) objects. May match selectors of replication
    controllers and routes. More info: http://kubernetes.io/docs/user-
    guide/labels +optional

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  clusterName = _messages.StringField(2)
  creationTimestamp = _messages.StringField(3)
  deletionGracePeriodSeconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  deletionTimestamp = _messages.StringField(5)
  finalizers = _messages.StringField(6, repeated=True)
  generateName = _messages.StringField(7)
  generation = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  initializers = _messages.MessageField('Initializers', 9)
  labels = _messages.MessageField('LabelsValue', 10)
  name = _messages.StringField(11)
  namespace = _messages.StringField(12)
  ownerReferences = _messages.MessageField('OwnerReference', 13, repeated=True)
  resourceVersion = _messages.StringField(14)
  selfLink = _messages.StringField(15)
  uid = _messages.StringField(16)


class OwnerReference(_messages.Message):
  r"""OwnerReference contains enough information to let you identify an owning
  object. Currently, an owning object must be in the same namespace, so there
  is no namespace field.

  Fields:
    apiVersion: API version of the referent.
    blockOwnerDeletion: If true, AND if the owner has the "foregroundDeletion"
      finalizer, then the owner cannot be deleted from the key-value store
      until this reference is removed. Defaults to false. To set this field, a
      user needs "delete" permission of the owner, otherwise 422
      (Unprocessable Entity) will be returned. +optional
    controller: If true, this reference points to the managing controller.
      +optional
    kind: Kind of the referent. More info:
      https://git.k8s.io/community/contributors/devel/api-conventions.md
      #types-kinds
    name: Name of the referent. More info: http://kubernetes.io/docs/user-
      guide/identifiers#names
    uid: UID of the referent. More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids
  """

  apiVersion = _messages.StringField(1)
  blockOwnerDeletion = _messages.BooleanField(2)
  controller = _messages.BooleanField(3)
  kind = _messages.StringField(4)
  name = _messages.StringField(5)
  uid = _messages.StringField(6)


class Probe(_messages.Message):
  r"""Probe describes a health check to be performed against a container to
  determine whether it is alive or ready to receive traffic.

  Fields:
    failureThreshold: Minimum consecutive failures for the probe to be
      considered failed after having succeeded. Defaults to 3. Minimum value
      is 1. +optional
    handler: The action taken to determine the health of a container
    initialDelaySeconds: Number of seconds after the container has started
      before liveness probes are initiated. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle
      #container-probes +optional
    periodSeconds: How often (in seconds) to perform the probe. Default to 10
      seconds. Minimum value is 1. +optional
    successThreshold: Minimum consecutive successes for the probe to be
      considered successful after having failed. Defaults to 1. Must be 1 for
      liveness. Minimum value is 1. +optional
    timeoutSeconds: Number of seconds after which the probe times out.
      Defaults to 1 second. Minimum value is 1. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle
      #container-probes +optional
  """

  failureThreshold = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  handler = _messages.MessageField('Handler', 2)
  initialDelaySeconds = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  periodSeconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  successThreshold = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  timeoutSeconds = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class Quantity(_messages.Message):
  r"""The view model of a single quantity, e.g. "800 MiB". Corresponds to http
  s://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachi
  nery/pkg/api/resource/generated.proto

  Fields:
    string: Stringified version of the quantity, e.g., "800 MiB".
  """

  string = _messages.StringField(1)


class ResourceRequirements(_messages.Message):
  r"""ResourceRequirements describes the compute resource requirements.

  Messages:
    LimitsValue: Limits describes the maximum amount of compute resources
      allowed.
    RequestsValue: Requests describes the minimum amount of compute resources
      required. If Requests is omitted for a container, it defaults to Limits
      if that is explicitly specified, otherwise to an implementation-defined
      value.

  Fields:
    limits: Limits describes the maximum amount of compute resources allowed.
    requests: Requests describes the minimum amount of compute resources
      required. If Requests is omitted for a container, it defaults to Limits
      if that is explicitly specified, otherwise to an implementation-defined
      value.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LimitsValue(_messages.Message):
    r"""Limits describes the maximum amount of compute resources allowed.

    Messages:
      AdditionalProperty: An additional property for a LimitsValue object.

    Fields:
      additionalProperties: Additional properties of type LimitsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LimitsValue object.

      Fields:
        key: Name of the additional property.
        value: A Quantity attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Quantity', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestsValue(_messages.Message):
    r"""Requests describes the minimum amount of compute resources required.
    If Requests is omitted for a container, it defaults to Limits if that is
    explicitly specified, otherwise to an implementation-defined value.

    Messages:
      AdditionalProperty: An additional property for a RequestsValue object.

    Fields:
      additionalProperties: Additional properties of type RequestsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RequestsValue object.

      Fields:
        key: Name of the additional property.
        value: A Quantity attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Quantity', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  limits = _messages.MessageField('LimitsValue', 1)
  requests = _messages.MessageField('RequestsValue', 2)


class Revision(_messages.Message):
  r"""Revision is an immutable snapshot of code and configuration. See also: h
  ttps://github.com/elafros/elafros/blob/master/docs/spec/overview.md#revision

  Fields:
    apiVersion: The API version for this call such as "v1alpha1".
    kind: The kind of this resource, in this case "Revision".
    metadata: Metadata associated with this Revision, including name,
      namespace, labels, and annotations.
    spec: Spec holds the desired state of the Revision (from the client).
    status: Status communicates the observed state of the Revision (from the
      controller).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('RevisionSpec', 4)
  status = _messages.MessageField('RevisionStatus', 5)


class RevisionCondition(_messages.Message):
  r"""RevisionCondition defines a readiness condition for a Revision. See:
  https://github.com/kubernetes/community/blob/master/contributors/devel/api-
  conventions.md#typical-status-properties

  Fields:
    lastTransitionTime: Last time the condition transitioned from one status
      to another. +optional
    message: Human readable message indicating details about the current
      status. +optional
    reason: One-word CamelCase reason for the condition's last transition
      +optional
    status: Status of the condition, one of True, False, Unknown.
    type: RevisionConditionType is used to communicate the status of the
      reconciliation process. See also:
      https://github.com/elafros/elafros/blob/master/docs/spec/errors.md
      #error-conditions-and-reporting Types include: "Ready", "Failed",
      "BuildComplete", "BuildFailed"
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  status = _messages.StringField(4)
  type = _messages.StringField(5)


class RevisionSpec(_messages.Message):
  r"""RevisionSpec holds the desired state of the Revision (from the client).

  Enums:
    ServingStateValueValuesEnum: ServingState holds a value describing the
      desired state the Kubernetes resources should be in for this Revision.
      Users must not specify this when creating a revision. It is expected
      that the system will manipulate this based on routability and load.

  Fields:
    buildName: BuildName optionally holds the name of the Build responsible
      for producing the container image for its Revision.
    concurrencyModel: ConcurrencyModel specifies the desired concurrency model
      (Single or Multi) for the Revision. Defaults to Multi. +optional
    container: Container defines the unit of execution for this Revision. In
      the context of a Revision, we disallow a number of the fields of this
      Container, including: name, resources, ports, and volumeMounts.
    generation: For open Knative: metadata.generation does not work yet, this
      is a stopgap way of specifying generation IGNORED BY GSE. +optional
    serviceAccountName: ServiceAccountName holds the name of the Kubernetes
      service account as which the underlying K8s resources should be run. If
      unspecified this will default to the "default" service account for the
      namespace in which the Revision exists. This may be used to provide
      access to private container images by following:
      https://kubernetes.io/docs/tasks/configure-pod-container/configure-
      service-account/#add-imagepullsecrets-to-a-service-account
    servingState: ServingState holds a value describing the desired state the
      Kubernetes resources should be in for this Revision. Users must not
      specify this when creating a revision. It is expected that the system
      will manipulate this based on routability and load.
  """

  class ServingStateValueValuesEnum(_messages.Enum):
    r"""ServingState holds a value describing the desired state the Kubernetes
    resources should be in for this Revision. Users must not specify this when
    creating a revision. It is expected that the system will manipulate this
    based on routability and load.

    Values:
      REVISION_SERVING_STATE_UNSPECIFIED: The revision serving state hasn't
        been specified.
      ACTIVE: The revision is ready to serve traffic. It should have
        Kubernetes resources, and the Istio route should be pointed to the
        given resources.
      RESERVE: The revision is not currently serving traffic, but could be
        made to serve traffic quickly. It should have Kubernetes resources,
        but the Istio route should be pointed to the activator.
      RETIRED: The revision has been decommissioned and is not needed to serve
        traffic anymore. It should not have any Istio routes or Kubernetes
        resources. A Revision may be brought out of retirement, but it may
        take longer than it would from a "Reserve" state.
    """
    REVISION_SERVING_STATE_UNSPECIFIED = 0
    ACTIVE = 1
    RESERVE = 2
    RETIRED = 3

  buildName = _messages.StringField(1)
  concurrencyModel = _messages.StringField(2)
  container = _messages.MessageField('Container', 3)
  generation = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  serviceAccountName = _messages.StringField(5)
  servingState = _messages.EnumField('ServingStateValueValuesEnum', 6)


class RevisionStatus(_messages.Message):
  r"""RevisionStatus communicates the observed state of the Revision (from the
  controller).

  Fields:
    conditions: List of observed RevisionConditions, indicating the current
      state of the Revision.
    logUrl: URL to access logs generated by this revision.
    observedGeneration: ObservedGeneration is the 'Generation' of the
      Configuration that was last processed by the controller. The observed
      generation is updated even if the controller failed to process the spec
      and create the Revision.
    serviceName: ServiceName holds the name of a core Kubernetes Service
      resource that load balances over the pods backing this Revision. When
      the Revision is Active, this service would be an appropriate ingress
      target for targeting the revision.
  """

  conditions = _messages.MessageField('RevisionCondition', 1, repeated=True)
  logUrl = _messages.StringField(2)
  observedGeneration = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  serviceName = _messages.StringField(4)


class RevisionTemplate(_messages.Message):
  r"""RevisionTemplateSpec describes the data a revision should have when
  created from a template. Based on:
  https://github.com/kubernetes/api/blob/e771f807/core/v1/types.go#L3179-L3190

  Fields:
    metadata: Optional metadata for this Revision, including labels and
      annotations. Name will be generated by the Configuration.
    spec: RevisionSpec holds the desired state of the Revision (from the
      client).
  """

  metadata = _messages.MessageField('ObjectMeta', 1)
  spec = _messages.MessageField('RevisionSpec', 2)


class Route(_messages.Message):
  r"""Route is responsible for configuring ingress over a collection of
  Revisions. Some of the Revisions a Route distributes traffic over may be
  specified by referencing the Configuration responsible for creating them; in
  these cases the Route is additionally responsible for monitoring the
  Configuration for "latest ready" revision changes, and smoothly rolling out
  latest revisions. See also:
  https://github.com/elafros/elafros/blob/master/docs/spec/overview.md#route

  Fields:
    apiVersion: The API version for this call such as "v1alpha1".
    kind: The kind of this resource, in this case always "Route".
    metadata: Metadata associated with this Route, including name, namespace,
      labels, and annotations.
    spec: Spec holds the desired state of the Route (from the client).
    status: Status communicates the observed state of the Route (from the
      controller).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('RouteSpec', 4)
  status = _messages.MessageField('RouteStatus', 5)


class RouteCondition(_messages.Message):
  r"""RouteCondition defines a readiness condition. See:
  https://github.com/kubernetes/community/blob/master/contributors/devel/api-
  conventions.md#typical-status-properties

  Fields:
    lastTransitionTime: Last time the condition transitioned from one status
      to another. +optional
    message: Human-readable message indicating details about last transition.
      +optional
    reason: One-word CamelCase reason for the condition's last transition.
      +optional
    status: Status of the condition, one of "True", "False", "Unknown".
    type: RouteConditionType is used to communicate the status of the
      reconciliation process. See also:
      https://github.com/elafros/elafros/blob/master/docs/spec/errors.md
      #error-conditions-and-reporting Types include: "RolloutInProgress",
      "TrafficDropped".
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  status = _messages.StringField(4)
  type = _messages.StringField(5)


class RouteSpec(_messages.Message):
  r"""RouteSpec holds the desired state of the Route (from the client).

  Fields:
    generation: For open Knative: metadata.generation does not work yet, this
      is a stopgap way of specifying generation IGNORED BY GSE. +optional
    traffic: Traffic specifies how to distribute traffic over a collection of
      Elafros Revisions and Configurations.
  """

  generation = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  traffic = _messages.MessageField('TrafficTarget', 2, repeated=True)


class RouteStatus(_messages.Message):
  r"""RouteStatus communicates the observed state of the Route (from the
  controller).

  Fields:
    conditions: Conditions communicates information about ongoing/complete
      reconciliation processes that bring the "spec" inline with the observed
      state of the world.
    domain: Domain holds the top-level domain that will distribute traffic
      over the provided targets. It generally has the form {route-name
      }.{route-namespace}.{cluster-level-suffix}
    domainInternal: DomainInternal holds the top-level domain that will
      distribute traffic over the provided targets from inside the cluster. It
      generally has the form {route-name}.{route-namespace}.svc.cluster.local
    observedGeneration: ObservedGeneration is the 'Generation' of the
      Configuration that was last processed by the controller. The observed
      generation is updated even if the controller failed to process the spec
      and create the Revision.
    traffic: Traffic holds the configured traffic distribution. These entries
      will always contain RevisionName references. When ConfigurationName
      appears in the spec, this will hold the LatestReadyRevisionName that we
      last observed.
  """

  conditions = _messages.MessageField('RouteCondition', 1, repeated=True)
  domain = _messages.StringField(2)
  domainInternal = _messages.StringField(3)
  observedGeneration = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  traffic = _messages.MessageField('TrafficTarget', 5, repeated=True)


class SELinuxOptions(_messages.Message):
  r"""SELinuxOptions are the labels to be applied to the container

  Fields:
    level: Level is SELinux level label that applies to the container.
      +optional
    role: Role is a SELinux role label that applies to the container.
      +optional
    type: Type is a SELinux type label that applies to the container.
      +optional
    user: User is a SELinux user label that applies to the container.
      +optional
  """

  level = _messages.StringField(1)
  role = _messages.StringField(2)
  type = _messages.StringField(3)
  user = _messages.StringField(4)


class SecretEnvSource(_messages.Message):
  r"""SecretEnvSource selects a Secret to populate the environment variables
  with.  The contents of the target Secret's Data field will represent the
  key-value pairs as environment variables.

  Fields:
    localObjectReference: The Secret to select from.
    optional: Specify whether the Secret must be defined +optional
  """

  localObjectReference = _messages.MessageField('LocalObjectReference', 1)
  optional = _messages.BooleanField(2)


class SecurityContext(_messages.Message):
  r"""SecurityContext holds security configuration that will be applied to a
  container. Some fields are present in both SecurityContext and
  PodSecurityContext.  When both are set, the values in SecurityContext take
  precedence.

  Fields:
    allowPrivilegeEscalation: AllowPrivilegeEscalation controls whether a
      process can gain more privileges than its parent process. This bool
      directly controls if the no_new_privs flag will be set on the container
      process. AllowPrivilegeEscalation is true always when the container is:
      1) run as Privileged 2) has CAP_SYS_ADMIN +optional
    capabilities: The capabilities to add/drop when running containers.
      Defaults to the default set of capabilities granted by the container
      runtime. +optional
    privileged: Run container in privileged mode. Processes in privileged
      containers are essentially equivalent to root on the host. Defaults to
      false. +optional
    readOnlyRootFilesystem: Whether this container has a read-only root
      filesystem. Default is false. +optional
    runAsGroup: The GID to run the entrypoint of the container process. Uses
      runtime default if unset. May also be set in PodSecurityContext.  If set
      in both SecurityContext and PodSecurityContext, the value specified in
      SecurityContext takes precedence. +optional
    runAsNonRoot: Indicates that the container must run as a non-root user. If
      true, the Kubelet will validate the image at runtime to ensure that it
      does not run as UID 0 (root) and fail to start the container if it does.
      If unset or false, no such validation will be performed. May also be set
      in PodSecurityContext.  If set in both SecurityContext and
      PodSecurityContext, the value specified in SecurityContext takes
      precedence. +optional
    runAsUser: The UID to run the entrypoint of the container process.
      Defaults to user specified in image metadata if unspecified. May also be
      set in PodSecurityContext.  If set in both SecurityContext and
      PodSecurityContext, the value specified in SecurityContext takes
      precedence. +optional
    seLinuxOptions: The SELinux context to be applied to the container. If
      unspecified, the container runtime will allocate a random SELinux
      context for each container.  May also be set in PodSecurityContext.  If
      set in both SecurityContext and PodSecurityContext, the value specified
      in SecurityContext takes precedence. +optional
  """

  allowPrivilegeEscalation = _messages.BooleanField(1)
  capabilities = _messages.MessageField('Capabilities', 2)
  privileged = _messages.BooleanField(3)
  readOnlyRootFilesystem = _messages.BooleanField(4)
  runAsGroup = _messages.IntegerField(5)
  runAsNonRoot = _messages.BooleanField(6)
  runAsUser = _messages.IntegerField(7)
  seLinuxOptions = _messages.MessageField('SELinuxOptions', 8)


class ServerlessExtensionsK8sApiListRequest(_messages.Message):
  r"""A ServerlessExtensionsK8sApiListRequest object.

  Fields:
    timeout: A string attribute.
  """

  timeout = _messages.StringField(1)


class ServerlessExtensionsK8sApiVersionsV1ListRequest(_messages.Message):
  r"""A ServerlessExtensionsK8sApiVersionsV1ListRequest object.

  Fields:
    timeout: A string attribute.
  """

  timeout = _messages.StringField(1)


class ServerlessExtensionsK8sApisListRequest(_messages.Message):
  r"""A ServerlessExtensionsK8sApisListRequest object.

  Fields:
    timeout: A string attribute.
  """

  timeout = _messages.StringField(1)


class ServerlessExtensionsK8sGroupsServingKnativeDevListRequest(_messages.Message):
  r"""A ServerlessExtensionsK8sGroupsServingKnativeDevListRequest object.

  Fields:
    labelSelector: A string attribute.
    timeout: A string attribute.
  """

  labelSelector = _messages.StringField(1)
  timeout = _messages.StringField(2)


class ServerlessListRequest(_messages.Message):
  r"""A ServerlessListRequest object.

  Fields:
    labelSelector: A string attribute.
    timeout: A string attribute.
  """

  labelSelector = _messages.StringField(1)
  timeout = _messages.StringField(2)


class ServerlessNamespacesConfigurationsGetRequest(_messages.Message):
  r"""A ServerlessNamespacesConfigurationsGetRequest object.

  Fields:
    name: The name of the configuration being retrieved.
  """

  name = _messages.StringField(1, required=True)


class ServerlessNamespacesConfigurationsListRequest(_messages.Message):
  r"""A ServerlessNamespacesConfigurationsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. k8s will send this in a query string format. i.e.
      'metadata.name%3Dlorem'
    includeUninitialized: Kubernetes-compatible parameter. Not used by GSE.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project and location from which the configurations should be
      listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start.
    watch: Flag that indicates that kubectl expects to watch this resource as
      well.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class ServerlessNamespacesKubeSystemServicesListRequest(_messages.Message):
  r"""A ServerlessNamespacesKubeSystemServicesListRequest object.

  Fields:
    labelSelector: A string attribute.
    timeout: A string attribute.
  """

  labelSelector = _messages.StringField(1)
  timeout = _messages.StringField(2)


class ServerlessNamespacesRevisionsDeleteRequest(_messages.Message):
  r"""A ServerlessNamespacesRevisionsDeleteRequest object.

  Fields:
    name: The name of the revision being deleted.
    orphanDependents: Kubernetes-compatible attribute that specifies the
      cascade behavior on delete. GSE only supports cascading behavior, so
      this must be false. This attribute is deprecated, and might be replaced
      with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
  """

  name = _messages.StringField(1, required=True)
  orphanDependents = _messages.BooleanField(2)


class ServerlessNamespacesRevisionsGetRequest(_messages.Message):
  r"""A ServerlessNamespacesRevisionsGetRequest object.

  Fields:
    name: The name of the revision being retrieved.
  """

  name = _messages.StringField(1, required=True)


class ServerlessNamespacesRevisionsListRequest(_messages.Message):
  r"""A ServerlessNamespacesRevisionsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. k8s will send this in a query string format. i.e.
      'metadata.name%3Dlorem'
    includeUninitialized: Kubernetes-compatible parameter. Not used by GSE.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project and location from which the revisions should be
      listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start.
    watch: Flag that indicates that kubectl expects to watch this resource as
      well.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class ServerlessNamespacesRoutesGetRequest(_messages.Message):
  r"""A ServerlessNamespacesRoutesGetRequest object.

  Fields:
    name: The name of the route being retrieved.
  """

  name = _messages.StringField(1, required=True)


class ServerlessNamespacesRoutesListRequest(_messages.Message):
  r"""A ServerlessNamespacesRoutesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. k8s will send this in a query string format. i.e.
      'metadata.name%3Dlorem'
    includeUninitialized: Kubernetes-compatible parameter. Not used by GSE.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project and location from which the routes should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start.
    watch: Flag that indicates that kubectl expects to watch this resource as
      well.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class ServerlessNamespacesServicesCreateRequest(_messages.Message):
  r"""A ServerlessNamespacesServicesCreateRequest object.

  Fields:
    parent: The project and location in which the service should be created,
      specified in the format `projects/*/locations/*`.
    service: A Service resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  service = _messages.MessageField('Service', 2)


class ServerlessNamespacesServicesDeleteRequest(_messages.Message):
  r"""A ServerlessNamespacesServicesDeleteRequest object.

  Fields:
    name: The name of the service being deleted.
    orphanDependents: Deprecated. Kubernetes-compatible attribute that
      specifies the cascade behavior on delete. GSE only supports cascading
      behavior, so this must be false. This attribute is deprecated, and might
      be replaced with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
  """

  name = _messages.StringField(1, required=True)
  orphanDependents = _messages.BooleanField(2)


class ServerlessNamespacesServicesGetRequest(_messages.Message):
  r"""A ServerlessNamespacesServicesGetRequest object.

  Fields:
    name: The name of the service being retrieved.
  """

  name = _messages.StringField(1, required=True)


class ServerlessNamespacesServicesListRequest(_messages.Message):
  r"""A ServerlessNamespacesServicesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. k8s will send this in a query string format. i.e.
      'metadata.name%3Dlorem'
    includeUninitialized: Kubernetes-compatible parameter. Not used by GSE.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project and location from which the services should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start.
    watch: Flag that indicates that kubectl expects to watch this resource as
      well.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class ServerlessNamespacesServicesPatchRequest(_messages.Message):
  r"""A ServerlessNamespacesServicesPatchRequest object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    name: The name of the service being patched.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  name = _messages.StringField(2, required=True)


class ServerlessNamespacesServicesReplaceServiceRequest(_messages.Message):
  r"""A ServerlessNamespacesServicesReplaceServiceRequest object.

  Fields:
    name: The name of the service being replaced.
    service: A Service resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  service = _messages.MessageField('Service', 2)


class ServerlessProjectsLocationsConfigurationsGetRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsConfigurationsGetRequest object.

  Fields:
    name: The name of the configuration being retrieved.
  """

  name = _messages.StringField(1, required=True)


class ServerlessProjectsLocationsConfigurationsListRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsConfigurationsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. k8s will send this in a query string format. i.e.
      'metadata.name%3Dlorem'
    includeUninitialized: Kubernetes-compatible parameter. Not used by GSE.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project and location from which the configurations should be
      listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start.
    watch: Flag that indicates that kubectl expects to watch this resource as
      well.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class ServerlessProjectsLocationsRevisionsDeleteRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsRevisionsDeleteRequest object.

  Fields:
    name: The name of the revision being deleted.
    orphanDependents: Kubernetes-compatible attribute that specifies the
      cascade behavior on delete. GSE only supports cascading behavior, so
      this must be false. This attribute is deprecated, and might be replaced
      with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
  """

  name = _messages.StringField(1, required=True)
  orphanDependents = _messages.BooleanField(2)


class ServerlessProjectsLocationsRevisionsGetRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsRevisionsGetRequest object.

  Fields:
    name: The name of the revision being retrieved.
  """

  name = _messages.StringField(1, required=True)


class ServerlessProjectsLocationsRevisionsListRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsRevisionsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. k8s will send this in a query string format. i.e.
      'metadata.name%3Dlorem'
    includeUninitialized: Kubernetes-compatible parameter. Not used by GSE.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project and location from which the revisions should be
      listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start.
    watch: Flag that indicates that kubectl expects to watch this resource as
      well.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class ServerlessProjectsLocationsRoutesGetRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsRoutesGetRequest object.

  Fields:
    name: The name of the route being retrieved.
  """

  name = _messages.StringField(1, required=True)


class ServerlessProjectsLocationsRoutesListRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsRoutesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. k8s will send this in a query string format. i.e.
      'metadata.name%3Dlorem'
    includeUninitialized: Kubernetes-compatible parameter. Not used by GSE.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project and location from which the routes should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start.
    watch: Flag that indicates that kubectl expects to watch this resource as
      well.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class ServerlessProjectsLocationsServicesCreateRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsServicesCreateRequest object.

  Fields:
    parent: The project and location in which the service should be created,
      specified in the format `projects/*/locations/*`.
    service: A Service resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  service = _messages.MessageField('Service', 2)


class ServerlessProjectsLocationsServicesDeleteRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsServicesDeleteRequest object.

  Fields:
    name: The name of the service being deleted.
    orphanDependents: Deprecated. Kubernetes-compatible attribute that
      specifies the cascade behavior on delete. GSE only supports cascading
      behavior, so this must be false. This attribute is deprecated, and might
      be replaced with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
  """

  name = _messages.StringField(1, required=True)
  orphanDependents = _messages.BooleanField(2)


class ServerlessProjectsLocationsServicesGetRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsServicesGetRequest object.

  Fields:
    name: The name of the service being retrieved.
  """

  name = _messages.StringField(1, required=True)


class ServerlessProjectsLocationsServicesListRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsServicesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. k8s will send this in a query string format. i.e.
      'metadata.name%3Dlorem'
    includeUninitialized: Kubernetes-compatible parameter. Not used by GSE.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project and location from which the services should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start.
    watch: Flag that indicates that kubectl expects to watch this resource as
      well.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class ServerlessProjectsLocationsServicesPatchRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsServicesPatchRequest object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    name: The name of the service being patched.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  name = _messages.StringField(2, required=True)


class ServerlessProjectsLocationsServicesReplaceServiceRequest(_messages.Message):
  r"""A ServerlessProjectsLocationsServicesReplaceServiceRequest object.

  Fields:
    name: The name of the service being replaced.
    service: A Service resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  service = _messages.MessageField('Service', 2)


class Service(_messages.Message):
  r"""Service is a convenience resource to create, group and manipulate a
  Route, Configuration(s), and Revision(s) that represent a single function,
  application, or microservice. The Service spec has several modes/types that
  represent different patterns for interacting the underlying Elafros
  resources, from always deploying the latest Revision, pinning specific
  revisions, to canarying gradual rollouts.

  Fields:
    apiVersion: The API version for this call such as "v1alpha1".
    kind: The kind of resource, in this case "Service".
    metadata: Metadata associated with this Service, including name,
      namespace, labels, and annotations.
    spec: Spec holds the desired state of the Service (from the client).
    status: Status communicates the observed state of the Service (from the
      controller).
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('ServiceSpec', 4)
  status = _messages.MessageField('ServiceStatus', 5)


class ServiceCondition(_messages.Message):
  r"""ServiceCondition defines a readiness condition. See:
  https://github.com/kubernetes/community/blob/master/contributors/devel/api-
  conventions.md#typical-status-properties

  Fields:
    lastTransitionTime: Last time the condition transitioned from one status
      to another. +optional
    message: Human-readable message indicating details about last transition.
      +optional
    reason: One-word CamelCase reason for the condition's last transition.
      +optional
    status: Status of the condition, one of True, False, Unknown.
    type: ServiceConditionType is used to communicate the status of the
      reconciliation process. See also:
      https://github.com/elafros/elafros/blob/master/docs/spec/errors.md
      #error-conditions-and-reporting Types include: "Ready", "Failed".
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  status = _messages.StringField(4)
  type = _messages.StringField(5)


class ServiceSpec(_messages.Message):
  r"""ServiceSpec holds the desired state of the Route (from the client),
  which is used to manipulate the underlying Route and Configuration(s).

  Fields:
    generation: For open Knative: metadata.generation does not work yet, this
      is a stopgap way of specifying generation IGNORED BY GSE. +optional
    pinned: Pins this service to a specific revision name. The revision must
      be owned by the configuration provided. +optional
    runLatest: RunLatest defines a simple Service. It will automatically
      configure a route that keeps the latest ready revision from the supplied
      configuration running. +optional
  """

  generation = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pinned = _messages.MessageField('ServiceSpecPinnedType', 2)
  runLatest = _messages.MessageField('ServiceSpecRunLatest', 3)


class ServiceSpecPinnedType(_messages.Message):
  r"""Pins this service to a specific revision name. The revision must be
  owned by the configuration provided.

  Fields:
    configuration: The configuration for this service.
    revisionName: The revision name to pin this service to until changed to a
      different service type.
  """

  configuration = _messages.MessageField('ConfigurationSpec', 1)
  revisionName = _messages.StringField(2)


class ServiceSpecRunLatest(_messages.Message):
  r"""RunLatest defines a simple Service. It will automatically configure a
  route that keeps the latest ready revision from the supplied configuration
  running.

  Fields:
    configuration: The configuration for this service.
  """

  configuration = _messages.MessageField('ConfigurationSpec', 1)


class ServiceStatus(_messages.Message):
  r"""The current state of the Service. Output only.

  Fields:
    conditions: Array of observed ServiceCondition, indicating the current
      state of the Service.
    domain: The top-level domain from the underlying Route.
    observedGeneration: Generation of the service that was last processed by
      the controller.
  """

  conditions = _messages.MessageField('ServiceCondition', 1, repeated=True)
  domain = _messages.StringField(2)
  observedGeneration = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class TCPSocketAction(_messages.Message):
  r"""TCPSocketAction describes an action based on opening a socket

  Fields:
    host: Optional: Host name to connect to, defaults to the pod IP. +optional
    port: Number or name of the port to access on the container. Number must
      be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
  """

  host = _messages.StringField(1)
  port = _messages.MessageField('IntOrString', 2)


class TrafficTarget(_messages.Message):
  r"""TrafficTarget holds a single entry of the routing table for a Route.

  Fields:
    configurationName: ConfigurationName of a configuration to whose latest
      revision we will send this portion of traffic. When the
      "status.latestReadyRevisionName" of the referenced configuration
      changes, we will automatically migrate traffic from the prior "latest
      ready" revision to the new one. This field is never set in Route's
      status, only its spec. This is mutually exclusive with RevisionName.
    name: Name is optionally used to expose a dedicated hostname for
      referencing this target exclusively. It has the form:
      {name}.${route.status.domain} +optional
    percent: Percent specifies percent of the traffic to this Revision or
      Configuration. This defaults to zero if unspecified.
    revisionName: RevisionName of a specific revision to which to send this
      portion of traffic. This is mutually exclusive with ConfigurationName.
  """

  configurationName = _messages.StringField(1)
  name = _messages.StringField(2)
  percent = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  revisionName = _messages.StringField(4)


class VolumeDevice(_messages.Message):
  r"""volumeDevice describes a mapping of a raw block device within a
  container.

  Fields:
    devicePath: devicePath is the path inside of the container that the device
      will be mapped to.
    name: name must match the name of a persistentVolumeClaim in the pod
  """

  devicePath = _messages.StringField(1)
  name = _messages.StringField(2)


class VolumeMount(_messages.Message):
  r"""VolumeMount describes a mounting of a Volume within a container.

  Fields:
    mountPath: Path within the container at which the volume should be
      mounted.  Must not contain ':'.
    mountPropagation: mountPropagation determines how mounts are propagated
      from the host to container and the other way around. When not set,
      MountPropagationHostToContainer is used. This field is beta in 1.10.
      +optional
    name: This must match the Name of a Volume.
    readOnly: Mounted read-only if true, read-write otherwise (false or
      unspecified). Defaults to false. +optional
    subPath: Path within the volume from which the container's volume should
      be mounted. Defaults to "" (volume's root). +optional
  """

  mountPath = _messages.StringField(1)
  mountPropagation = _messages.StringField(2)
  name = _messages.StringField(3)
  readOnly = _messages.BooleanField(4)
  subPath = _messages.StringField(5)


encoding.AddCustomJsonFieldMapping(
    Handler, 'exec_', 'exec')
encoding.AddCustomJsonFieldMapping(
    ListMeta, 'continue_', 'continue')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
