<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_proxy_fcgi - Serveur HTTP Apache Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_proxy_fcgi</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_proxy_fcgi.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_proxy_fcgi.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Module fournissant le support de FastCGI 
<code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code></td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>proxy_fcgi_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_proxy_fcgi.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3 d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Pour fonctionner, ce module <em>ncessite</em> le chargement de
    <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>. Il fournit le support du protocole <a href="http://www.fastcgi.com/">FastCGI</a>.</p>

    <p>Ainsi, pour pouvoir traiter le protocole <code>FastCGI</code>,
    <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code> et <code class="module"><a href="../mod/mod_proxy_fcgi.html">mod_proxy_fcgi</a></code>
    doivent tre chargs dans le serveur.</p>

    <p>A la diffrence de <a href="http://httpd.apache.org/mod_fcgid/">mod_fcgid</a> et <a href="http://www.fastcgi.com/">mod_fastcgi</a>,
    <code class="module"><a href="../mod/mod_proxy_fcgi.html">mod_proxy_fcgi</a></code> n'est pas en mesure de dmarrer le
    processus de l'application ; <code class="program"><a href="../programs/fcgistarter.html">fcgistarter</a></code> est
    fourni  cet effet sur certaines plateformes. Le framework
    applicatif FastCGI utilis peut aussi fournir la gestion des
    processus ou des lancements de programmes externes.</p>

    <div class="warning"><h3>Avertissement</h3>
      <p>N'activez pas la fonctionnalit de mandataire avant d'avoir <a href="mod_proxy.html#access">scuris votre serveur</a>. Les
      serveurs mandataires ouverts sont dangereux non seulement pour
      votre rseau, mais aussi pour l'Internet au sens large.</p>
    </div>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#examples">Exemples</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#env">Variables d'environnement</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#proxyfcgibackendtype">ProxyFCGIBackendType</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyfcgisetenvif">ProxyFCGISetEnvIf</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_proxy_fcgi">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_proxy_fcgi">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="program"><a href="../programs/fcgistarter.html">fcgistarter</a></code></li>
<li><code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code></li>
<li><code class="module"><a href="../mod/mod_authnz_fcgi.html">mod_authnz_fcgi</a></code></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples</a></h2>
    <p>Pour que ces exemples fonctionnent, vous ne devez pas oublier
    d'activer <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code> et
    <code class="module"><a href="../mod/mod_proxy_fcgi.html">mod_proxy_fcgi</a></code>.</p>

    <div class="example"><h3>Instance d'application unique</h3><pre class="prettyprint lang-config">ProxyPass "/mon_appli/" "fcgi://localhost:4000/"</pre>
</div>

    
    <p><code class="module"><a href="../mod/mod_proxy_fcgi.html">mod_proxy_fcgi</a></code> interdisant par dfaut la
    rutilisation des connexions, lorsqu'une requte a t traite, la
    connexion ne sera pas maintenue ouverte par le processus enfant
    httpd, et ne sera donc pas rutilise. Cependant, si l'application
    FastCGI supporte les connexions httpd simultanes, vous pouvez opter
    pour la rutilisation des connexions comme dans l'exemple suivant :</p>

    <div class="example"><h3>Instance d'application unique, rutilisation
    des connexions (versions 2.4.11 et suprieures)</h3><pre class="prettyprint lang-config">ProxyPass "/myapp/" "fcgi://localhost:4000/" enablereuse=on</pre>
</div>

    <div class="note"><h3>Active la rutilisation des connexions vers un serveur FCGI
    d'arrire-plan tel que PHP-FPM</h3>
    <p>Il faut garder  l'esprit que PHP-FPM (en fvrier 2018) utilise un modle
    du style prefork ; autrement dit, chacun de ses processus de travail ne peut
    grer qu'une connexion  la fois.<br /> Par dfaut et lorsqu'il est
    configur avec <code>enablereuse=on</code> et lorsqu'un MPM  base de
    threads est utilis (comme <code class="module"><a href="../mod/worker.html">worker</a></code> ou
    <code class="module"><a href="../mod/event.html">event</a></code>), mod_proxy autorise un jeu de <code class="directive"><a href="../mod/mpm_common.html#threadsperchild">ThreadsPerChild</a></code> connexions vers le serveur
    d'arrire-plan pour chaque processus httpd, et par consquent, il faut
    prter une attention particulire aux situations suivantes :</p>
    <ul>
      <li>Avec une charge en HTTP/1, il est fort probable que le nombre de
      connexions vers le serveur FCGI d'arrire-plan augmente jusqu' atteindre
      <code class="directive"><a href="../mod/mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></code>.</li>
      <li>Avec une charge en HTTP/2, et vue la manire dont
      <code class="module"><a href="../mod/mod_http2.html">mod_http2</a></code> est implment, il y a des threads de travail
      h2 additionnels qui peuvent forcer la cration de connexions
      supplmentaires vers le serveur d'arrire-plan. Le nombre total de
      connexions que contiennent les jeux de connexions peut alors dpasser
      <code class="directive"><a href="../mod/mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></code>.</li>
    </ul>
    <p>Le nombre maximum de processus de travail PHP-FPM doit tre dfini
    judicieusement car il est possible qu'ils finissent par rester dans l'tat
    occup ("busy") pour ne grer que des connexions persistantes inactives,
    sans avoir la possibilit d'en tablir de nouvelles ; ce qui se traduira
    pour l'utilisateur final par une pile de "HTTP request timeouts".</p>
    </div>

    <p>Dans l'exemple suivant, l'URI de la requte est transmis en tant
    que chemin du systme de fichiers pour l'excution du dmon PHP-FPM.
    L'URL de la requte est implicitement ajoute au second paramtre.
    PHP-FPM est  l'coute de l'hte et du port qui
    suivent fcgi://. La conservation/rutilisation des connexions est active.</p>
    <div class="example"><h3>PHP-FPM</h3><pre class="prettyprint lang-config">ProxyPassMatch "^/myapp/.*\.php(/.*)?$" "fcgi://localhost:9000/var/www/" enablereuse=on</pre>
</div>

    <p>Dans l'exemple suivant, l'URI de la requte est transmis en tant
    que chemin du systme de fichiers pour l'excution du dmon PHP-FPM.
    Dans ce cas cependant, PHP-FPM est  l'coute d'un socket de domaine
    unix (UDS). Cette fonctionnalit est disponible  partir de la
    version 2.4.9. Avec cette syntaxe, si un nom d'hte et un port sont
    ajouts aprs fcgi://, ils seront ignors.</p>
    <div class="example"><h3>PHP-FPM with UDS</h3><pre class="prettyprint lang-config">ProxyPassMatch "^/(.*\.php(/.*)?)$" "unix:/var/run/php5-fpm.sock|fcgi://localhost/var/www/"</pre>
</div>

    <p>La passerelle  rpartition de charge ncessite le chargement du
    module <code class="module"><a href="../mod/mod_proxy_balancer.html">mod_proxy_balancer</a></code> et d'au moins un module
    fournissant un algorithme de rpartition de charge, comme
    <code class="module"><a href="../mod/mod_lbmethod_byrequests.html">mod_lbmethod_byrequests</a></code> en plus des modules
    dj cits. <code class="module"><a href="../mod/mod_lbmethod_byrequests.html">mod_lbmethod_byrequests</a></code> est le module
    par dfaut et sera utilis dans cet exemple de configuration.</p>

    <div class="example"><h3>Passerelle  rpartition de charge vers plusieurs
    instances de l'application</h3><pre class="prettyprint lang-config">ProxyPass "/myapp/" "balancer://myappcluster/"
&lt;Proxy "balancer://myappcluster/"&gt;
    BalancerMember "fcgi://localhost:4000"
    BalancerMember "fcgi://localhost:4001"
&lt;/Proxy&gt;</pre>
</div>

    <p>Vous pouvez aussi forcer le traitement d'une requte en tant que
    requte de mandataire inverse en crant un court-circuiteur de
    gestionnaire appropri. Dans l'exemple ci-dessous, toutes les
    requtes pour des scripts PHP seront transmises au serveur FastCGI
    spcifi par mandat inverse. Cette fonctionnalit est disponible 
    partir de la version 2.4.10 du serveur HTTP Apache. Pour des raisons
    de performances, il est recommand de dfinir un <a href="mod_proxy.html#workers">worker (configuration d'un
    mandataire)</a> reprsentant le mme serveur fcgi:// d'arrire-plan.
    Avec cette configuration, il est possible d'effectuer une
    correspondance directe entre l'URI et le chemin du fichier sur le
    serveur, et le chemin local du fichier sera alors transmis au serveur
    d'arrire-plan. Lorsque FastCGI est configur ainsi, le serveur est
    en mesure de calculer le PATH_INFO le plus appropri.
      </p>
	<div class="example"><h3>Mandataire via un gestionnaire</h3><pre class="prettyprint lang-config">&lt;FilesMatch "\.php$"&gt;
    # Note : la seule partie variable est /path/to/app.sock
    SetHandler  "proxy:unix:/path/to/app.sock|fcgi://localhost/"
&lt;/FilesMatch&gt;
   # Dfinition d'une configuration de mandataire qui convient.
   # La partie qui est mise en correspondance avec la valeur de
   # SetHandler est la partie qui suit le "pipe". Si vous devez faire
   # une distinction, "localhost" peut tre chang en un nom de serveur
   # unique.
   &lt;Proxy "fcgi://localhost/" enablereuse=on max=10&gt;
   &lt;/Proxy&gt;

&lt;FilesMatch ...&gt;
    SetHandler  "proxy:fcgi://localhost:9000"
&lt;/FilesMatch&gt;

&lt;FilesMatch ...&gt;
    SetHandler  "proxy:balancer://myappcluster/"
&lt;/FilesMatch&gt;</pre>
</div>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="env" id="env">Variables d'environnement</a></h2>
    <p>En plus des directives de configuration qui contrlent le
    comportement de <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>, de nombreuses
    <dfn>variables d'environnement</dfn> permettent de piloter le
    fournisseur du protocole FCGI :</p>
    <dl>
        <dt>proxy-fcgi-pathinfo</dt>
        <dd>Lorsqu'il est configur via les directives <code class="directive"><a href="../mod/mod_proxy.html#proxypass">ProxyPass</a></code> ou <code class="directive"><a href="../mod/mod_proxy.html#proxypassmatch">ProxyPassMatch</a></code>,
	<code class="module"><a href="../mod/mod_proxy_fcgi.html">mod_proxy_fcgi</a></code> ne dfinit
	pas la variable d'environnement <var>PATH_INFO</var>,
	ce qui permet au serveur FCGI d'arrire-plan de dterminer
	correctement <var>SCRIPT_NAME</var> et <var>Script-URI</var>, et
	de se conformer  la section 3.3 de la RFC 3875. Si au contraire
	vous avez souhaitez que <code class="module"><a href="../mod/mod_proxy_fcgi.html">mod_proxy_fcgi</a></code> gnre une
	"estimation la plus exacte possible" de <var>PATH_INFO</var>,
	dfinissez la variable d'environnement
	<var>proxy-fcgi-pathinfo</var>. Ceci peut servir de
	contournement pour une bogue prsente dans certaines
	implmentations de FCGI. Cette variable peut tre
	multivalue afin de pouvoir choisir la valeur la plus approprie
	(versions 2.4.11 et suprieures) :
	<dl>
          <dt>first-dot</dt>
          <dd>PATH_INFO est extrait  partir du slash qui suit le
	  <em>premier</em> "." de l'URL.</dd>
          <dt>last-dot</dt>
          <dd>PATH_INFO est extrait  partir du slash qui suit le
	  <em>dernier</em> "." de l'URL.</dd>
          <dt>full</dt> 
          <dd>PATH_INFO est calcul en supposant que l'URL correspond au
	  chemin du systme de fichiers.</dd>
          <dt>unescape</dt>
          <dd>PATH_INFO correspond  la partie chemin de l'URL avec ses
	  squences d'chappement dcodes.</dd>
          <dt>toute autre valeur</dt>
          <dd>PATH_INFO correspond  la partie chemin de l'URL.  
              Auparavant, c'tait la seule option pour proxy-fcgi-pathinfo.</dd>
         </dl>
	</dd>
    </dl>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="proxyfcgibackendtype" id="proxyfcgibackendtype">Directive</a> <a name="ProxyFCGIBackendType" id="ProxyFCGIBackendType">ProxyFCGIBackendType</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie le type de l'application FastCGI d'arrire-plan</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyFCGIBackendType FPM|GENERIC</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyFCGIBackendType FPM</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy_fcgi</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.26 du serveur HTTP Apache</td></tr>
</table>
<p>Cette directive permet de spcifier le type de l'application FastCGI
d'arrire-plan. Certains serveurs FastCGI, comme PHP-FPM, utilisent de manire
historique des variables d'environnement exotiques pour identifier le type du
serveur mandataire utilis. Dfinissez cette directive  "GENERIC" si votre
application n'est pas de type PHP-FPM et n'interprter pas correctement des
variables d'environnement comme SCRIPT_FILENAME ou PATH_TRANSLATED telles
qu'elles sont dfinies par le serveur.</p>

<p>SCRIPT_FILENAME est un exemple de valeur modifie par la dfinition de cette
directive. Historiquement, lorsqu'on utilisait le module
<code class="module"><a href="../mod/mod_proxy_fcgi.html">mod_proxy_fcgi</a></code>, SCRIPT_FILENAME tait prfix par la chane
"proxy:fcgi://". C'est cette variable que lisent certaines applications FastCGI
gnriques en tant que valeur en entre pour leur script ; cependant, PHP-FPM
peut supprimer le prfixe, puis garder en mmoire qu'il communique avec Apache.
Avec les versions 2.4.21  2.4.25, ce prfixe tait automatiquement supprim par
le serveur, empchant ainsi PHP-FPM de dtecter et interoprer avec Apache dans
certains scnarios.</p> 

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="proxyfcgisetenvif" id="proxyfcgisetenvif">Directive</a> <a name="ProxyFCGISetEnvIf" id="ProxyFCGISetEnvIf">ProxyFCGISetEnvIf</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Permet d'adapter la valeur des variables envoyes aux serveurs
FastCGI</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyFCGISetEnvIf <var>conditional-expression</var>
    [!]<var>environment-variable-name</var>
    [<var>value-expression</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy_fcgi</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.26 du serveur HTTP Apache.</td></tr>
</table>
<p>Juste avant la transmission d'une requte au serveur FastCGI configur, le
coeur du programme du serveur web dfinit un certain nombre de variables
d'environnement en fonction de certains dtails de la requte considre. Les
programmes FastCGI utilisent souvent ces variables comme donnes en entre afin
de dterminer quels scripts sous-jacents ils vont excuter, ou quelles donnes
en sortie doivent tre produites.</p>
<p>Voici quelques exemples de variables d'environnement importantes :</p>
<ul>
  <li>SCRIPT_NAME</li>
  <li>SCRIPT_FILENAME</li>
  <li>REQUEST_URI</li>
  <li>PATH_INFO</li>
  <li>PATH_TRANSLATED</li>
</ul>

<p>Cette directive permet de passer outre les variables d'environnement
ci-dessus, entre autres. Elle est value aprs la dfinition de la valeur
initiale de ces variables ; elle peuvent donc tre utilises comme entres dans
les expressions dfinissants les conditions et les valeurs.</p>
<p>Syntaxe des paramtres :</p>
<dl>
<dt>conditional-expression</dt> 
<dd>Dfinit une condition en fonction de laquelle la
variable d'environnement qui suit sera modifie ou non. Pour la syntaxe de cette
expression, reportez-vous aux exemples qui suivent ou  la spcification
dtaille dans le document <a href="../expr.html">ap_expr</a>.
   </dd>
<dt>environment-variable-name</dt> 
<dd>Spcifie le nom de la variable d'environnement  modifier, par exemple
PATH_INFO. Si elle est prcde d'un point d'exclamation, la dfinition de la
variable sera annule.</dd>
<dt>value-expression</dt>
<dd>Spcifie la nouvelle valeur de la variable "environment-variable-name". On
peut inclure des
rfrences arrires, comme "$1", issues de captures en provenance de
l'expression rationnelle <var>conditional-expression</var>. Si cette valeur est
omise, la variable est dfinie (ou sa valeur est crase) par une chane vide
&#8212; voir cependant la note ci-aprs.</dd>
</dl>
  
<div class="example"><pre class="prettyprint lang-config"># Une modification basique, inconditionnelle
ProxyFCGISetEnvIf "true" PATH_INFO "/example"

# Utilisation d'une variable d'environnement pour spcifier la nouvelle valeur
ProxyFCGISetEnvIf "true" PATH_INFO "%{reqenv:SCRIPT_NAME}"
<br />
# Utilisation de captures dans la condition et de rfrences arrires dans la
# nouvelle valeur
ProxyFCGISetEnvIf "reqenv('PATH_TRANSLATED') =~ m#(/.*prefix)(\d+)(.*)#" PATH_TRANSLATED "$1$3"</pre>
</div>

<div class="note"><h3>Note : Annulation dfinition ou valeur vide</h3>
  La ligne suivante annule la dfinition de la variable <code>VARIABLE</code>,
  ce qui l'empche d'tre envoye au serveur FastCGI :

    <pre class="prettyprint lang-config">ProxyFCGISetEnvIf true !VARIABLE</pre>


  La ligne suivante, quant  elle, efface la <em>valeur</em> de la variable
  <code>VARIABLE</code> en lui affectant la chane vide ; cette variable
  <code>VARIABLE</code> sera alors tout de mme envoye au serveur FastCGI :

    <pre class="prettyprint lang-config">ProxyFCGISetEnvIf true VARIABLE</pre>


  La spcification CGI/1.1 <a href="https://tools.ietf.org/html/rfc3875#section-4.1">ne fait pas de
  distinction</a> entre une variable contenant une chane vide et une variable qui
  n'existe pas. De nombreuses implmentations CGI et FastCGI font cependant
  cette distinction (ou permettent aux scripts de la faire). Le choix de celle
  que vous allez utiliser dpend de votre implmentation et de la raison qui
  vous pousse  modifier cette variable.
</div>


</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_proxy_fcgi.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_proxy_fcgi.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_proxy_fcgi.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>